"""
Webhook Sender schemas
"""

from typing import Optional, Dict, Any
from pydantic import BaseModel, Field, ConfigDict


class WebhookSendRequest(BaseModel):
    """Request schema for manually sending webhook"""
    service_code: str = Field(..., min_length=1, max_length=100, description="Service code (e.g., 'payout', 'payin', 'wallet')")
    txnid: str = Field(..., min_length=1, max_length=100, description="Transaction ID")


class WebhookSendResponse(BaseModel):
    """Response schema for webhook send result"""
    success: bool
    webhook_url: Optional[str] = None
    message: str
    response: Optional[Dict[str, Any]] = None
    error: Optional[str] = None

    model_config = ConfigDict(from_attributes=True)

