"""
Webhook URL schemas
"""

from typing import Optional
from pydantic import BaseModel, Field, ConfigDict, HttpUrl
from uuid import UUID
from datetime import datetime


class WebhookURLCreate(BaseModel):
    """Webhook URL creation schema"""
    url: str = Field(..., min_length=1, max_length=500, description="Webhook URL")


class WebhookURLUpdate(BaseModel):
    """Webhook URL update schema"""
    url: str = Field(..., min_length=1, max_length=500, description="Webhook URL")


class WebhookURLResponse(BaseModel):
    """Webhook URL response schema"""
    id: int
    user_id: UUID
    url: str
    created_at: datetime
    updated_at: datetime

    model_config = ConfigDict(from_attributes=True)

