--
-- PostgreSQL database dump
--

\restrict P50cpsOgABaxE5BbwIBf8ijYz7WBDiz27BC5zNETZroSn5Gahin4Ujwp0uvkxME

-- Dumped from database version 15.15
-- Dumped by pg_dump version 15.15

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: admins; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.admins (
    email character varying(255) NOT NULL,
    password_hash character varying(255) NOT NULL,
    full_name character varying(255) NOT NULL,
    is_active boolean NOT NULL,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


ALTER TABLE public.admins OWNER TO fintech_user;

--
-- Name: alembic_version; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.alembic_version (
    version_num character varying(100) NOT NULL
);


ALTER TABLE public.alembic_version OWNER TO fintech_user;

--
-- Name: api_keys; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.api_keys (
    user_id uuid NOT NULL,
    api_key character varying(255) NOT NULL,
    api_secret character varying(500) NOT NULL,
    active boolean NOT NULL,
    ips json,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


ALTER TABLE public.api_keys OWNER TO fintech_user;

--
-- Name: charges; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.charges (
    id integer NOT NULL,
    user_id uuid,
    service_id uuid NOT NULL,
    from_amount numeric(15,2) NOT NULL,
    to_amount numeric(15,2) NOT NULL,
    type character varying(50) NOT NULL,
    is_percent boolean NOT NULL,
    amount numeric(15,2) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    gst numeric(5,2)
);


ALTER TABLE public.charges OWNER TO fintech_user;

--
-- Name: charges_id_seq; Type: SEQUENCE; Schema: public; Owner: fintech_user
--

CREATE SEQUENCE public.charges_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.charges_id_seq OWNER TO fintech_user;

--
-- Name: charges_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: fintech_user
--

ALTER SEQUENCE public.charges_id_seq OWNED BY public.charges.id;


--
-- Name: kyc_docs; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.kyc_docs (
    user_id uuid NOT NULL,
    kyc_id uuid NOT NULL,
    document_type character varying(100) NOT NULL,
    file_size character varying(50),
    mime_type character varying(100),
    description text,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    status character varying(50) DEFAULT 'submitted'::character varying NOT NULL,
    document_number character varying(255) NOT NULL,
    front_file_path character varying(500) NOT NULL,
    front_file_name character varying(255) NOT NULL,
    back_file_path character varying(500),
    back_file_name character varying(255)
);


ALTER TABLE public.kyc_docs OWNER TO fintech_user;

--
-- Name: kycs; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.kycs (
    user_id uuid NOT NULL,
    document_type character varying(100),
    document_number character varying(255),
    date_of_birth character varying(50),
    address text,
    city character varying(100),
    state character varying(100),
    country character varying(100),
    postal_code character varying(20),
    notes text,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    status character varying(50) NOT NULL,
    company_name character varying(255) NOT NULL,
    ownership_type character varying(50) NOT NULL,
    pan_number character varying(10),
    aadhaar_number character varying(12)
);


ALTER TABLE public.kycs OWNER TO fintech_user;

--
-- Name: payin_transactions; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.payin_transactions (
    id integer NOT NULL,
    user_id uuid NOT NULL,
    txnid character varying(100) NOT NULL,
    user_reference_id character varying(255),
    amount numeric(15,2) NOT NULL,
    charge numeric(15,2) NOT NULL,
    payee_vpa character varying(255),
    payee_name character varying(255),
    status character varying(50) NOT NULL,
    api_response json,
    qr_text character varying(500),
    payment_url character varying(500),
    api_provider character varying(100),
    provider_reference_id character varying(255),
    refunded boolean NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    rrn character varying(20),
    settled boolean DEFAULT false NOT NULL,
    scheduled_credit_at timestamp with time zone
);


ALTER TABLE public.payin_transactions OWNER TO fintech_user;

--
-- Name: payin_transactions_id_seq; Type: SEQUENCE; Schema: public; Owner: fintech_user
--

CREATE SEQUENCE public.payin_transactions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.payin_transactions_id_seq OWNER TO fintech_user;

--
-- Name: payin_transactions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: fintech_user
--

ALTER SEQUENCE public.payin_transactions_id_seq OWNED BY public.payin_transactions.id;


--
-- Name: pyttxns; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.pyttxns (
    user_id uuid NOT NULL,
    txnid character varying(100) NOT NULL,
    amount numeric(15,2) NOT NULL,
    charge numeric(15,2) NOT NULL,
    bene_name character varying(255) NOT NULL,
    bene_ifsc character varying(20) NOT NULL,
    bene_acc_no character varying(50) NOT NULL,
    status character varying(50) NOT NULL,
    api_response json,
    api_provider character varying(100),
    provider_reference_id character varying(255),
    refunded boolean NOT NULL,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    user_reference_id character varying(255),
    rrn character varying(20)
);


ALTER TABLE public.pyttxns OWNER TO fintech_user;

--
-- Name: services; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.services (
    name character varying(255) NOT NULL,
    description text,
    code character varying(100) NOT NULL,
    price numeric(10,2) NOT NULL,
    currency character varying(10) NOT NULL,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    status character varying(50) NOT NULL
);


ALTER TABLE public.services OWNER TO fintech_user;

--
-- Name: user_services; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.user_services (
    user_id uuid NOT NULL,
    service_id uuid NOT NULL,
    notes text,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    status character varying(50) NOT NULL
);


ALTER TABLE public.user_services OWNER TO fintech_user;

--
-- Name: users; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.users (
    email character varying(255) NOT NULL,
    password_hash character varying(255) NOT NULL,
    full_name character varying(255) NOT NULL,
    phone character varying(20),
    is_active boolean NOT NULL,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    deleted_at timestamp without time zone,
    is_deleted boolean NOT NULL
);


ALTER TABLE public.users OWNER TO fintech_user;

--
-- Name: wallet_transactions; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.wallet_transactions (
    user_id uuid NOT NULL,
    wallet_id uuid NOT NULL,
    txn_type character varying(100) NOT NULL,
    type character varying(20) NOT NULL,
    amount numeric(15,2) NOT NULL,
    opening numeric(15,2) NOT NULL,
    closing numeric(15,2) NOT NULL,
    txnid character varying(100) NOT NULL,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL,
    refunded boolean DEFAULT false NOT NULL,
    is_refund boolean DEFAULT false NOT NULL
);


ALTER TABLE public.wallet_transactions OWNER TO fintech_user;

--
-- Name: wallets; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.wallets (
    user_id uuid NOT NULL,
    main numeric(15,2) NOT NULL,
    reserve numeric(15,2) NOT NULL,
    status character varying(50) NOT NULL,
    id uuid NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


ALTER TABLE public.wallets OWNER TO fintech_user;

--
-- Name: webhook_logs; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.webhook_logs (
    id integer NOT NULL,
    user_id uuid NOT NULL,
    service_id uuid NOT NULL,
    txnid character varying(100) NOT NULL,
    payload json NOT NULL,
    response json,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


ALTER TABLE public.webhook_logs OWNER TO fintech_user;

--
-- Name: webhook_logs_id_seq; Type: SEQUENCE; Schema: public; Owner: fintech_user
--

CREATE SEQUENCE public.webhook_logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.webhook_logs_id_seq OWNER TO fintech_user;

--
-- Name: webhook_logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: fintech_user
--

ALTER SEQUENCE public.webhook_logs_id_seq OWNED BY public.webhook_logs.id;


--
-- Name: webhook_urls; Type: TABLE; Schema: public; Owner: fintech_user
--

CREATE TABLE public.webhook_urls (
    id integer NOT NULL,
    user_id uuid NOT NULL,
    url character varying(500) NOT NULL,
    created_at timestamp without time zone NOT NULL,
    updated_at timestamp without time zone NOT NULL
);


ALTER TABLE public.webhook_urls OWNER TO fintech_user;

--
-- Name: webhook_urls_id_seq; Type: SEQUENCE; Schema: public; Owner: fintech_user
--

CREATE SEQUENCE public.webhook_urls_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.webhook_urls_id_seq OWNER TO fintech_user;

--
-- Name: webhook_urls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: fintech_user
--

ALTER SEQUENCE public.webhook_urls_id_seq OWNED BY public.webhook_urls.id;


--
-- Name: charges id; Type: DEFAULT; Schema: public; Owner: fintech_user
--

ALTER TABLE ONLY public.charges ALTER COLUMN id SET DEFAULT nextval('public.charges_id_seq'::regclass);


--
-- Name: payin_transactions id; Type: DEFAULT; Schema: public; Owner: fintech_user
--

ALTER TABLE ONLY public.payin_transactions ALTER COLUMN id SET DEFAULT nextval('public.payin_transactions_id_seq'::regclass);


--
-- Name: webhook_logs id; Type: DEFAULT; Schema: public; Owner: fintech_user
--

ALTER TABLE ONLY public.webhook_logs ALTER COLUMN id SET DEFAULT nextval('public.webhook_logs_id_seq'::regclass);


--
-- Name: webhook_urls id; Type: DEFAULT; Schema: public; Owner: fintech_user
--

ALTER TABLE ONLY public.webhook_urls ALTER COLUMN id SET DEFAULT nextval('public.webhook_urls_id_seq'::regclass);


--
-- Data for Name: admins; Type: TABLE DATA; Schema: public; Owner: fintech_user
--

COPY public.admins (email, password_hash, full_name, is_active, id, created_at, updated_at) FROM stdin;
admin@fintech.com	$2b$12$5v8HauDljvQzzsofByGjv.I34WM1NiTXAlxajcyjGHHBYBCy6kH26	Ravindra	t	6814a0de-3c9d-4c6c-a0fe-5ff044e1378e	2025-12-21 14:46:04.675476	2025-12-25 13:16:50.856842
\.


--
-- Data for Name: alembic_version; Type: TABLE DATA; Schema: public; Owner: fintech_user
--

COPY public.alembic_version (version_num) FROM stdin;
add_settled_to_payin
\.


--
-- Data for Name: api_keys; Type: TABLE DATA; Schema: public; Owner: fintech_user
--

COPY public.api_keys (user_id, api_key, api_secret, active, ips, id, created_at, updated_at) FROM stdin;
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	K8qT0uaJ86Vrd2bBvzzy7hkemeFSvvvP	gAAAAABpThHnYDbuN_wk8bNv7YVtTBpdr9esz9sbe4iylD8Bg8vHptS-gcwyLv8TnO-fn6CMcBtW2v6oG9kFrFE-OGz-7S8AyTGp8oQnxEJ1WaqeZbJBCwsvoS5lv9dV_dmhz4L3mTYwRLtg44YDdx31ozH_TeH6w9ZlObcTUuOrl37zLlNj11Q=	t	["72.61.235.197"]	c769cef0-535b-4dfc-a3e0-520ab1175f9e	2025-12-26 04:41:11.770708	2025-12-26 04:52:06.271605
3c70dd22-df28-4a50-a034-4a378507c5bf	23j7pZJ0R0ORWhHiu8K9HLIrtpkJ3mfW	gAAAAABpUiyXBaCr0ipyX3mYZfTlJq5ABzOJ8YmrcFS2zHkP5xX4ORoZzLw5bxZ9JLADQDsJoCtAJZC7LF6-BfrXirZ3ZFRkVyG6jcT5GMvgu4O7CMAuAA83zS46JX8-WXfGBEdO7jG78aUIwpq38ENWEskT5kMk_AXGL0mqYSWJFbHod3Smp7E=	t	[]	703b1d28-870b-4c17-8a72-d89b2f4c5ca7	2025-12-29 06:21:40.37098	2025-12-29 07:24:07.863534
2ce36d1e-5818-415f-b875-b357c8297e9d	TaxUA2zEg9tVvFqftVaQjFdaA5OV2bk0	gAAAAABpXhkE9EVSpxNp3rBJwAZn95gPK8gU6aeSmV8-DC_WcCpjAUjCbNrDw-i_f3be4lPE8AYxTKhYiUNUQZuvnlphQPpBA-ThOoaqeQC_AVwz5j21J0TlpJoZ6qlgvfPqgAxWT6nnRNZupOWIEBQLoOEHA3egBZd8R6qnCEZjYDPOWVTNpJ8=	t	["192.168.1.2", "192.168.1.3"]	27ae3d29-d31c-4a9d-8886-ef4ea175025d	2025-12-22 02:03:13.87396	2026-01-07 08:27:48.327552
350c1879-98e4-44b1-8b39-b39e5ffd9836	Lyx7c5uclCMw1NNwnWyOlvfz0vgKE35s	gAAAAABpXgE6Tx1onbaQWj_mMv-1aTuaqzc-oDnY44O8VjK8GB0R3jCxNwA72ndLpSJQy3CHgnwPBm7B-JDbWo5DlYN93peBB5ccuGxOVg8iYYY982nhyUi-lZ0LYARVpC3MCy9jIu0wUZglWttJTRf40a9eeM5zpuY_6fEd0ALQTYO4Ij7KvAY=	t	["13.127.187.82", "13.232.167.96"]	949c2455-8cc0-4e79-bcb8-1568b8062b4a	2026-01-07 06:46:18.819488	2026-01-07 15:13:47.988508
ce49328b-23f5-4950-a9b4-b723fbe290c4	53dlAJYt6NkFxy71xGIePgfwIrV7WJqh	gAAAAABpYGrkwyH-2wYXlY2h1HYcdk1B9i_dD6w20LBzidkJoFWsc9r9keV659nYKeIUNDWrrgwjOo4nGhvu3dGWNQwnBoUehtRQdCW5UkEfhdTvpjrwNBzDP9Y56uehI-YSYtocfZf7g1SrU-UwZUDvww87fCfP4CHaKavmGy4-_IkmVv8vh_A=	t	["15.207.152.243"]	fce3aae9-1c9a-4867-ac9f-1135eec04fe7	2026-01-09 02:41:41.026001	2026-01-09 07:17:32.262571
0ccb76fc-6666-4a61-8498-63864856131e	cu2WqGA7agOfHkaOHFBU9rshILWVNNrz	gAAAAABpZgSgbDBNQ6ojLqvkxGFPJOvveQ0uBAIA7KT783YrU8u2RXWSIWRPmUr86iA2uPZ8TLD5E-aQyvPETWAgysX3jRdlstxbCd-kpM_K1vuokigj5t0cf3s_Luo9QQr5SWpZ1LZgqsuJ_98StGvFsgFmKEccLNcvl0qNtmMIQNOicuA5lTk=	t	[]	f232c24c-3bda-4f7f-93b3-7f04f966ecc3	2026-01-13 08:38:56.523503	2026-01-13 08:38:56.523506
505fcc01-2c6d-435c-a3b4-2b6674c326e9	vGIcD9vQvtnL9pBitdFRfEffpHquZMHb	gAAAAABpZhpjakpScFkuibC7y1NirrIXJHxjPJ7B52mMSs1rjydNHlowt_Ij4pA4XWigDb9oS41mNeAFQkMRo13BlfJJw3B01M2QXDfpKsx3xIDb2ckD-El5E6tGHLWuTNMDyb7rZ7kbpNT4RYOpy1LLWcyDFULn7OtPr9dsiSm3okHI5FtGtbM=	t	["160.25.62.113"]	c73d95f4-7457-4cbe-ae67-5d1a9b9927c4	2026-01-13 10:11:47.421638	2026-01-13 10:12:37.506447
3d9aa4bc-1535-4017-a168-5a19f65c14d7	ppAzF8SgiNOvOnJTkejYc11IQ4qbGXf5	gAAAAABpZgXcxlIe9H8q1v6nW1dehdViVhOj2SnphugbsR8JJdFxsG7kH-5F4gyGfp6Usaac13_9PtHyYbPkblEX9GC4HbcaS4G6kdPxzQwCQoyCLjAiKJc1DzvQE-qAEBsG1v4KfYRk_zfg9tMuy5hc4vov0ugqy1YA_LqqQAn64ljf3xuROmQ=	t	["15.207.152.243"]	84fd2a71-2d6b-414e-a8c9-107292428888	2026-01-13 08:44:12.583295	2026-01-14 03:36:31.088129
aee00114-b63d-449d-8021-6b27bdb251bd	KxhNOAwPRaZXOTZX1p2JCstzP8HkqXzW	gAAAAABpZ1LnPmfTMNc7hc6-8rS_a54aKG-6Nw6NXFBoLTBYXba5OknSI9O6NVKX9jeKEinxqRnoX8PfIQWwMci6GU0kjLh_tQDPxwQUralCBNfhl5udDRIgrqhQNhRX9hPlzkWsobemyr8o39m7eyrEWjkx2BO1ATHkboOtT5kg4yv5RXiJzeg=	t	["13.203.91.186"]	b13b5b0e-9bc3-448f-8c88-1431cc271e0f	2026-01-06 09:00:37.611152	2026-01-14 08:25:11.790578
\.


--
-- Data for Name: charges; Type: TABLE DATA; Schema: public; Owner: fintech_user
--

COPY public.charges (id, user_id, service_id, from_amount, to_amount, type, is_percent, amount, created_at, updated_at, gst) FROM stdin;
1	2ce36d1e-5818-415f-b875-b357c8297e9d	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	100.00	surcharge	t	1.00	2025-12-22 15:37:02.482494	2025-12-22 15:37:02.482498	\N
2	2ce36d1e-5818-415f-b875-b357c8297e9d	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	100.00	200.00	surcharge	t	1.00	2025-12-22 15:40:26.391278	2025-12-22 15:44:27.259297	\N
3	2ce36d1e-5818-415f-b875-b357c8297e9d	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	200.00	0.00	surcharge	f	2.00	2025-12-22 15:44:41.42152	2025-12-22 16:06:03.475992	\N
5	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	surcharge	t	3.50	2025-12-24 03:31:40.756035	2025-12-24 10:18:02.569508	\N
6	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	0.00	surcharge	t	1.50	2025-12-24 09:32:17.650773	2025-12-24 10:18:28.09443	\N
11	4d9c5484-b612-477e-8ac9-ef8b2824db0d	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	surcharge	t	4.00	2025-12-29 10:43:44.532962	2025-12-29 10:43:44.532966	\N
12	4d9c5484-b612-477e-8ac9-ef8b2824db0d	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	0.00	surcharge	t	1.50	2025-12-29 10:44:28.841884	2025-12-29 10:44:28.841887	\N
13	2ce36d1e-5818-415f-b875-b357c8297e9d	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	surcharge	t	1.00	2026-01-05 15:28:55.931724	2026-01-05 15:28:55.931727	\N
14	aee00114-b63d-449d-8021-6b27bdb251bd	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	commission	t	4.47	2026-01-06 07:51:10.634782	2026-01-06 07:51:10.634787	\N
15	aee00114-b63d-449d-8021-6b27bdb251bd	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	0.00	surcharge	t	2.00	2026-01-06 07:51:52.398944	2026-01-06 07:51:52.398947	\N
16	ce49328b-23f5-4950-a9b4-b723fbe290c4	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	0.00	surcharge	t	2.00	2026-01-06 10:11:32.597122	2026-01-06 10:11:32.597125	\N
17	ce49328b-23f5-4950-a9b4-b723fbe290c4	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	commission	t	4.50	2026-01-06 10:12:18.972938	2026-01-06 10:12:18.972941	\N
20	3c70dd22-df28-4a50-a034-4a378507c5bf	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	500.00	0.00	surcharge	t	2.00	2026-01-06 13:02:54.411074	2026-01-06 13:02:54.411077	0.00
9	3c70dd22-df28-4a50-a034-4a378507c5bf	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	500.00	surcharge	f	12.00	2025-12-26 08:01:18.475056	2026-01-07 04:18:04.46431	0.00
21	350c1879-98e4-44b1-8b39-b39e5ffd9836	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	500.00	surcharge	f	13.00	2026-01-07 06:18:13.704154	2026-01-07 06:18:13.704157	\N
22	350c1879-98e4-44b1-8b39-b39e5ffd9836	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	500.00	0.00	surcharge	t	2.00	2026-01-07 06:19:41.916382	2026-01-07 06:19:41.916386	\N
23	350c1879-98e4-44b1-8b39-b39e5ffd9836	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	commission	t	5.00	2026-01-07 06:21:05.170142	2026-01-07 06:21:05.170144	\N
18	e2847664-c5bd-4bca-8228-3b75530b2930	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	500.00	surcharge	f	13.00	2026-01-06 10:41:47.260502	2026-01-07 13:10:18.614649	\N
24	e2847664-c5bd-4bca-8228-3b75530b2930	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	500.00	0.00	surcharge	t	2.00	2026-01-07 13:10:54.620568	2026-01-07 13:10:54.620571	\N
10	3c70dd22-df28-4a50-a034-4a378507c5bf	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	surcharge	t	6.00	2025-12-26 08:04:08.32372	2026-01-08 08:25:48.417395	0.00
25	505fcc01-2c6d-435c-a3b4-2b6674c326e9	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	500.00	surcharge	f	13.00	2026-01-13 04:04:55.55711	2026-01-13 04:04:55.557113	\N
26	505fcc01-2c6d-435c-a3b4-2b6674c326e9	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	500.00	0.00	surcharge	t	2.00	2026-01-13 04:05:32.238971	2026-01-13 04:05:32.238973	\N
28	3d9aa4bc-1535-4017-a168-5a19f65c14d7	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	500.00	surcharge	f	13.00	2026-01-13 06:25:12.936619	2026-01-13 06:25:12.936622	\N
29	3d9aa4bc-1535-4017-a168-5a19f65c14d7	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	500.00	0.00	surcharge	t	2.00	2026-01-13 06:25:42.083022	2026-01-13 06:25:53.133922	\N
30	3d9aa4bc-1535-4017-a168-5a19f65c14d7	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	commission	t	4.50	2026-01-13 06:27:42.242397	2026-01-13 06:27:42.242399	\N
19	e2847664-c5bd-4bca-8228-3b75530b2930	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	commission	t	4.00	2026-01-06 10:42:41.600727	2026-01-13 07:48:16.089358	\N
7	0ccb76fc-6666-4a61-8498-63864856131e	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	surcharge	t	5.00	2025-12-25 08:49:26.992039	2026-01-13 09:47:02.101114	\N
8	0ccb76fc-6666-4a61-8498-63864856131e	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	0.00	500.00	surcharge	f	13.00	2025-12-25 08:50:40.037087	2026-01-13 09:47:31.581826	\N
31	0ccb76fc-6666-4a61-8498-63864856131e	0af4badc-45cd-4b3f-9f36-814b70cfeb1a	500.00	0.00	surcharge	f	13.00	2026-01-13 09:47:58.714264	2026-01-13 09:47:58.714267	\N
27	505fcc01-2c6d-435c-a3b4-2b6674c326e9	cf7e4b2f-40e8-426f-a2b7-a17e5421d701	0.00	0.00	commission	t	4.50	2026-01-13 04:06:12.013129	2026-01-16 06:08:44.352115	\N
\.


--
-- Data for Name: kyc_docs; Type: TABLE DATA; Schema: public; Owner: fintech_user
--

COPY public.kyc_docs (user_id, kyc_id, document_type, file_size, mime_type, description, id, created_at, updated_at, status, document_number, front_file_path, front_file_name, back_file_path, back_file_name) FROM stdin;
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	aadhaar_card	34162	image/webp	not clear	1ca7dfa8-d77a-4c5f-881a-36baf198b890	2025-12-21 16:50:01.050155	2025-12-26 15:45:54.760549	rejected	794809787676	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766335801_front_3.webp	3.jpg	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	photo	34162	image/webp	\N	aad93052-b6bb-4aa9-8c6a-ec4f7e3bb50a	2025-12-21 16:51:21.053455	2025-12-26 15:45:54.854694	approved	photo	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766335881_front_3.webp	3.jpg	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	board_resolution	34162	image/webp	\N	c002b281-1942-4603-9a94-abb19e683f59	2025-12-21 16:54:18.394743	2025-12-26 15:45:54.932118	approved	nsbnmdemner	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766336058_front_3.webp	3.jpg	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	articles_of_association	34162	image/webp	\N	2e4bb1b5-2820-40c0-ae3a-b1d652eb24eb	2025-12-21 16:54:09.494517	2025-12-26 15:45:55.0146	approved	JSBJH#VHGEVH@VE	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766336049_front_3.webp	3.jpg	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	memorandum_of_association	34162	image/webp	\N	c6024276-bf88-4e60-9ed9-fafdfce9087d	2025-12-21 16:53:10.523138	2025-12-26 15:45:55.098132	approved	NJWJWJBWHVWH	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766335990_front_3.webp	3.jpg	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	company_pan	34162	image/webp	\N	51337f83-0e7a-4fe6-8e27-189c6f537c84	2025-12-21 16:52:16.309933	2025-12-26 15:45:55.169172	approved	HLLPK6767B	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766335936_front_3.webp	3.jpg	\N	\N
1d7195b9-7556-4906-afdb-0cce6d525ea8	3cccd587-987a-485f-bea1-cad291cb6636	pan_card	34162	image/webp	\N	410bdc77-5ea0-4b07-a2fc-b30c3354e9e7	2025-12-22 06:08:39.878498	2025-12-26 15:45:55.237635	rejected	bnadbdnfbdnf	static/kyc_docs/1d7195b9-7556-4906-afdb-0cce6d525ea8_1766383719_front_3.webp	3.jpg	\N	\N
1d7195b9-7556-4906-afdb-0cce6d525ea8	3cccd587-987a-485f-bea1-cad291cb6636	photo	34162	image/webp	\N	ec437a2f-95d4-4172-b322-954db9b99b49	2025-12-22 06:09:05.952481	2025-12-26 15:45:55.304603	approved	photo	static/kyc_docs/1d7195b9-7556-4906-afdb-0cce6d525ea8_1766383745_front_3.webp	3.jpg	\N	\N
1d7195b9-7556-4906-afdb-0cce6d525ea8	3cccd587-987a-485f-bea1-cad291cb6636	pan_card	26618	image/webp	\N	7049521f-2c2c-43cb-bad5-338e4d0134ed	2025-12-22 06:11:09.649438	2025-12-26 15:45:55.35961	approved	bnadbdnfbdnf	static/kyc_docs/1d7195b9-7556-4906-afdb-0cce6d525ea8_1766383869_front_34847937842687_34847981351906.webp	34847937842687_34847981351906.jpg	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	photo	3048	image/webp	\N	a31281c7-c24b-4dd0-aa0a-6e87d6822ab5	2025-12-25 09:06:05.54641	2025-12-26 15:45:55.378193	approved	Photo	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766653565_front_WhatsApp_Image_2025-12-25_at_17.05.23.webp	WhatsApp Image 2025-12-25 at 17.05.23.jpeg	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	pan_card	34162	image/webp	\N	cc570da2-df78-416d-9508-366279d3a31f	2025-12-21 16:49:14.668506	2025-12-26 15:45:55.439934	approved	HLLPK4783F	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766335754_front_3.webp	3.jpg	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	pan_card	435874	image/jpeg	\N	c8abe5f8-b760-4bd5-adc9-c83c5d12fe6d	2025-12-21 16:34:28.936223	2025-12-21 17:20:38.274648	approved	MIGRATED_c8abe5f8-b760-4bd5-adc9-c83c5d12fe6d	/uploads/34847937842687_34847943231958.jpg	34847937842687_34847943231958.jpg	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	aadhaar_card	81550	application/pdf	\N	64bf25e1-ec43-4ab7-9825-6da5101de9ce	2025-12-21 17:34:44.026189	2025-12-21 17:37:17.375478	approved	794809787676	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766338484_front_76664767-wasender-whatsapp-server-and-bulk-sender-saas-license.pdf	76664767-wasender-whatsapp-server-and-bulk-sender-saas-license.pdf	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	authorized_signatory_aadhaar	2978	application/pdf	\N	18f07de0-aa6c-4004-b343-de476a451ec4	2025-12-21 16:54:53.020729	2025-12-21 17:37:22.822134	approved	ndfnseefewmnr	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766336093_front_admin_bbps_transactions_2025-10-18_to_2025-11-17.pdf	admin_bbps_transactions_2025-10-18_to_2025-11-17.pdf	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	authorized_signatory_pan	2978	application/pdf	\N	1092184d-1281-463e-b965-8bd59b174a67	2025-12-21 16:54:30.578356	2025-12-21 17:37:27.579248	approved	sd fnmdsfmnsdfms	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766336070_front_admin_bbps_transactions_2025-10-18_to_2025-11-17.pdf	admin_bbps_transactions_2025-10-18_to_2025-11-17.pdf	\N	\N
2ce36d1e-5818-415f-b875-b357c8297e9d	e236705c-d275-4dde-b14b-f8b59a742888	certificate_of_incorporation	267204	application/pdf	\N	34f931fc-c6d9-4d18-a0e5-922e55bd6455	2025-12-21 16:52:44.953606	2025-12-21 17:38:10.325703	approved	JSJSSBHGSHG	static/kyc_docs/2ce36d1e-5818-415f-b875-b357c8297e9d_1766335964_front__Serial_Number___State___District___Location___Type_of_Farm__DTS.pdf	_Serial Number___State___District___Location___Type of Farm__DTS.pdf	\N	\N
1d7195b9-7556-4906-afdb-0cce6d525ea8	3cccd587-987a-485f-bea1-cad291cb6636	aadhaar_card	81853	application/pdf	\N	046415de-b83c-440a-97d5-cd2244c7bd4d	2025-12-22 06:08:55.445802	2025-12-22 06:10:12.975477	approved	787878787878	static/kyc_docs/1d7195b9-7556-4906-afdb-0cce6d525ea8_1766383735_front_76929697-ishop-multivendor-laravel-vue-ecommerce-cms-license.pdf	76929697-ishop-multivendor-laravel-vue-ecommerce-cms-license.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	pan_card	7005564	application/pdf	\N	b958508f-a3eb-41cc-85f8-5ad33e4e1bde	2025-12-25 09:03:09.086051	2025-12-25 09:33:43.080326	approved	PAN	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766653389_front_KYC-Gaya-2.pdf	KYC-Gaya-2.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	aadhaar_card	7005564	application/pdf	\N	10e3cf95-edc0-4d7c-aff6-c775dba13cfb	2025-12-25 09:03:51.649618	2025-12-25 09:33:46.914498	approved	Aadhaar	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766653431_front_KYC-Gaya-2.pdf	KYC-Gaya-2.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	company_pan	2680856	application/pdf	\N	4874d4a2-064c-4678-9903-a3aca7b92eaf	2025-12-25 09:07:26.955127	2025-12-25 09:33:55.90658	approved	Company pan	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766653646_front_PAN-26.pdf	PAN-26.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	certificate_of_incorporation	2075660	application/pdf	\N	9b6cdca6-e9d4-4605-ae32-c8f7ceb28db7	2025-12-25 09:08:07.572834	2025-12-25 09:34:00.905372	approved	COI	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766653687_front_COI-26.pdf	COI-26.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	memorandum_of_association	4050519	application/pdf	\N	fc485cf4-1cad-4db1-9b39-4a8cf5a4329b	2025-12-25 09:15:14.502079	2025-12-25 09:34:06.080295	approved	MOA	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766654114_front_MOA26.pdf	MOA26.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	articles_of_association	3887166	application/pdf	\N	bc7b1b68-3f60-4a9a-995d-4260e81623ed	2025-12-25 09:18:49.415867	2025-12-25 09:34:10.336206	approved	AOA	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766654329_front_AOA-26-1.pdf	AOA-26-1.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	board_resolution	541939	application/pdf	\N	37fb5be6-6e1c-40b7-a675-0dc836a01912	2025-12-25 09:29:13.164924	2025-12-25 09:34:15.094194	approved	BR	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766654953_front_BR.pdf	BR.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	authorized_signatory_pan	7005564	application/pdf	\N	6ff70987-ce99-48ba-bb17-3270b3cd6e64	2025-12-25 09:29:34.487391	2025-12-25 09:34:19.864291	approved	PAN	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766654974_front_KYC-Gaya-2.pdf	KYC-Gaya-2.pdf	\N	\N
0ccb76fc-6666-4a61-8498-63864856131e	bd340c52-d08e-4941-bdcd-496332e84f11	authorized_signatory_aadhaar	7005564	application/pdf	\N	39bf0bd9-ce82-4549-981e-7ab227689cc9	2025-12-25 09:29:55.816187	2025-12-25 09:34:25.503744	approved	 Authorized Signatory Aadhaar	static/kyc_docs/0ccb76fc-6666-4a61-8498-63864856131e_1766654995_front_KYC-Gaya-2.pdf	KYC-Gaya-2.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	aadhaar_card	1338787	application/pdf	\N	3324f036-fd9a-4214-ab1f-45eb87ace968	2025-12-26 04:16:52.452956	2025-12-26 04:28:13.918354	approved	272233391676	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722612_front_Adharcard_Nishant_Moorthy_NISH1981.pdf	Adharcard_Nishant_Moorthy_NISH1981.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	photo	5610	image/webp	\N	be6474fc-0b4b-44d1-a224-a482a5f4efc3	2025-12-26 04:19:20.793819	2025-12-26 15:45:55.496889	approved	Nishant	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722760_front_Nishant.webp	Nishant.jpeg	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	authorized_signatory_pan	31902	image/webp	\N	45e4dd25-c1f8-4318-bab7-19585528604c	2025-12-26 04:21:30.145976	2025-12-26 15:45:55.550173	approved	nishant	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722890_front_PAN_Nishant_Moorthy.webp	PAN_Nishant Moorthy.jpeg	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	voter_id	31902	image/webp	\N	9f65635a-962d-4c82-9a26-c6b8c052a8a5	2025-12-26 04:21:55.349514	2025-12-26 15:45:55.602188	approved	CARD	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722915_front_PAN_Nishant_Moorthy.webp	PAN_Nishant Moorthy.jpeg	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	passport	31902	image/webp	\N	8ac253a8-bc71-42df-8f72-9c6eb2b0548f	2025-12-26 04:22:14.621541	2025-12-26 15:45:55.65904	approved	ok	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722934_front_PAN_Nishant_Moorthy.webp	PAN_Nishant Moorthy.jpeg	\N	\N
aee00114-b63d-449d-8021-6b27bdb251bd	c26f8894-d1ef-4dda-9d3c-8e93d1e469e0	bank_statement	34550	image/jpeg	\N	552d9259-6d3c-4382-abb4-452299d0af91	2026-01-06 08:50:36.290215	2026-01-06 08:58:41.342529	approved	1	static/kyc_docs/aee00114-b63d-449d-8021-6b27bdb251bd_1767689436_front_AXIS_cancelled_check.jpeg	AXIS cancelled check.jpeg	static/kyc_docs/aee00114-b63d-449d-8021-6b27bdb251bd_1767689436_back_AXIS_cancelled_check.jpeg	AXIS cancelled check.jpeg
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	certificate_of_incorporation	327672	application/pdf	\N	93d929f7-f468-4ea6-bb36-2a05a5dfb69a	2025-12-26 04:20:22.678948	2025-12-26 04:28:22.838231	approved	COI	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722822_front_COI.pdf	COI.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	articles_of_association	7032377	application/pdf	\N	9eb677c9-d437-486f-8714-34c3c022d8b6	2025-12-26 04:20:47.647897	2025-12-26 04:28:27.519307	approved	AOA	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722847_front_AOA.pdf	AOA.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	audited_financial_statements	573117	application/pdf	\N	fe65b89b-4bbe-4483-98c3-bca6d7ae9f1b	2025-12-26 04:22:40.595274	2025-12-26 04:28:44.510796	approved	audit	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722960_front_GST.pdf	GST.pdf	\N	\N
350c1879-98e4-44b1-8b39-b39e5ffd9836	cce5bc49-1b68-483f-aa7c-18bd7db10dca	aadhaar_card	101023	image/jpeg	\N	45272949-f3ee-4d4e-994f-5c6166f70c5f	2026-01-07 06:27:24.599341	2026-01-07 06:33:14.525476	approved	907203144686	static/kyc_docs/350c1879-98e4-44b1-8b39-b39e5ffd9836_1767767244_front_IMG-20231225-WA0001.jpg	IMG-20231225-WA0001.jpg	\N	\N
350c1879-98e4-44b1-8b39-b39e5ffd9836	cce5bc49-1b68-483f-aa7c-18bd7db10dca	gst_certificate	133350	application/pdf	\N	146ef278-7f83-4b54-b818-f17ee6e4a2d2	2026-01-07 06:29:26.94392	2026-01-07 06:33:19.777721	approved	09GOLPR9502B1ZN	static/kyc_docs/350c1879-98e4-44b1-8b39-b39e5ffd9836_1767767366_front_Mam_gst_updated.pdf	Mam gst updated.pdf	\N	\N
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	photo	20382	image/webp	\N	683c898b-fe1d-437c-97da-d5811824ffd6	2025-12-26 08:41:20.740317	2025-12-26 15:45:56.723736	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738480_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738480_back_22222.webp	22222.png
350c1879-98e4-44b1-8b39-b39e5ffd9836	cce5bc49-1b68-483f-aa7c-18bd7db10dca	pan_card	48570	image/jpeg	\N	c8f023b2-b0d1-430e-9fae-0ff265c57f0d	2026-01-07 06:26:15.131718	2026-01-07 06:33:23.572575	approved	GOLPR9502B	static/kyc_docs/350c1879-98e4-44b1-8b39-b39e5ffd9836_1767767175_front_IMG-20240202-WA0000.jpg	IMG-20240202-WA0000.jpg	static/kyc_docs/350c1879-98e4-44b1-8b39-b39e5ffd9836_1767767175_back_IMG-20240510-WA0005.jpg	IMG-20240510-WA0005.jpg
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	board_resolution	20382	image/webp	\N	ebdcc12c-bbda-4f90-af80-71de93644111	2025-12-26 08:41:30.983409	2025-12-26 15:45:56.12635	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738490_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738490_back_22222.webp	22222.png
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	authorized_signatory_pan	20382	image/webp	\N	fa75d529-4f04-4372-8185-1cbd78e3a9f2	2025-12-26 08:41:32.654945	2025-12-26 15:45:56.025639	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738492_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738492_back_22222.webp	22222.png
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	bank_statement	20382	image/webp	\N	3de9bb87-44d4-40b7-a9ed-04d2ae5b894b	2025-12-26 08:40:46.406622	2025-12-26 15:45:56.344179	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738446_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738446_back_22222.webp	22222.png
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	authorized_signatory_aadhaar	20382	image/webp	\N	b7ba64a1-ece0-43b7-87f8-9002f13ae1fd	2025-12-26 08:41:34.886731	2025-12-26 15:45:56.234123	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738494_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738494_back_22222.webp	22222.png
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	aadhaar_card	20382	image/webp	\N	ecd5eb10-3135-498c-8547-a14924345ed5	2025-12-26 08:41:18.330672	2025-12-26 15:45:56.563573	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738478_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738478_back_22222.webp	22222.png
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	pan_card	1357290	application/pdf	\N	bac0495e-0311-449e-b0b0-951211fa1aae	2025-12-26 04:16:23.206264	2025-12-26 04:28:10.078611	approved	AACCZ5415B	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722583_front_PAN_Card.pdf	PAN Card.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	company_pan	1357290	application/pdf	\N	49281f5e-ff7e-4506-aaa6-a120e36f8d7b	2025-12-26 04:19:46.630558	2025-12-26 04:28:49.751685	approved	AACCZ5415B	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722786_front_PAN_Card.pdf	PAN Card.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	memorandum_of_association	4215938	application/pdf	\N	d3421595-7a4b-4331-9f92-b4dc99fb97b7	2025-12-26 04:20:34.100157	2025-12-26 04:28:54.338151	approved	MOA	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722833_front_MOA.pdf	MOA.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	board_resolution	4215938	application/pdf	\N	60e62552-7d6e-48f7-966b-e9cb4296e72b	2025-12-26 04:21:04.659628	2025-12-26 04:28:57.500088	approved	BOR	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722864_front_MOA.pdf	MOA.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	authorized_signatory_aadhaar	1338787	application/pdf	\N	fc98488d-febc-4b25-a1d1-498265f165cb	2025-12-26 04:21:41.561904	2025-12-26 04:29:01.718856	approved	Ashar Card	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722901_front_Adharcard_Nishant_Moorthy_NISH1981.pdf	Adharcard_Nishant_Moorthy_NISH1981.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	gst_certificate	573117	application/pdf	\N	47f339d6-53b4-4fe1-a699-6d4e8d2d5812	2025-12-26 04:22:23.487524	2025-12-26 04:29:11.741213	approved	GST	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722943_front_GST.pdf	GST.pdf	\N	\N
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	bank_statement	1357290	application/pdf	\N	52aea90a-ea08-42fa-8896-965b76bcadcb	2025-12-26 04:22:50.470996	2025-12-26 04:29:16.032154	approved	Statement	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722970_front_PAN_Card.pdf	PAN Card.pdf	\N	\N
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	company_pan	20382	image/webp	\N	0a0810d2-8da0-4216-95a1-bd1b41180192	2025-12-26 08:41:24.099936	2025-12-26 15:45:56.453593	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738484_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738484_back_22222.webp	22222.png
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	3a1ac88d-1c14-403d-b225-73a5941090e1	driving_license	31902	image/webp	\N	17e81f09-c7f0-4e0d-91ad-1de4bba42d75	2025-12-26 04:22:05.681941	2025-12-26 15:45:56.622673	approved	Licence	static/kyc_docs/6b9b4e3b-3485-4467-8c23-2b7d21d4aeae_1766722925_front_PAN_Nishant_Moorthy.webp	PAN_Nishant Moorthy.jpeg	\N	\N
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	memorandum_of_association	20382	image/webp	\N	917e51c0-7f93-42fc-9ba4-b2f4b930a209	2025-12-26 08:41:27.490171	2025-12-26 15:45:56.966501	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738487_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738487_back_22222.webp	22222.png
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	articles_of_association	30528	image/webp	\N	e9ebefd3-9f73-46de-b9cf-4cd6dbf67d02	2025-12-26 08:41:29.174843	2025-12-26 16:02:59.522941	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738489_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738489_back_22222.webp	22222.png
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	pan_card	20382	image/webp	\N	ed5623de-1e86-44f0-a49f-3607ae561ff2	2025-12-26 08:41:12.700788	2025-12-26 15:45:56.847522	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738472_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738472_back_22222.webp	22222.png
3c70dd22-df28-4a50-a034-4a378507c5bf	941db012-55b6-4867-be2f-a591c7ed7b1b	certificate_of_incorporation	20382	image/webp	\N	6a61182e-d8d0-4ec7-9c03-3246fb7474ee	2025-12-26 08:41:25.855977	2025-12-26 15:45:57.084101	approved	ABOCS5476J	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738485_front_11111.webp	11111.png	static/kyc_docs/3c70dd22-df28-4a50-a034-4a378507c5bf_1766738485_back_22222.webp	22222.png
350c1879-98e4-44b1-8b39-b39e5ffd9836	cce5bc49-1b68-483f-aa7c-18bd7db10dca	photo	14212	image/webp	\N	117a60fb-9e6c-49b8-9e82-2507f0d51af9	2026-01-07 06:28:37.003177	2026-01-07 06:33:29.079676	approved	907203144686	static/kyc_docs/350c1879-98e4-44b1-8b39-b39e5ffd9836_1767767317_front_20250503_014639.jpg	20250503_014639.jpg	\N	\N
ce49328b-23f5-4950-a9b4-b723fbe290c4	e8508602-ed9d-45e1-8891-930ba3aff391	pan_card	125995	image/jpeg	\N	db382c21-b8ce-48ae-88d4-5cd560e48122	2026-01-08 11:57:33.498574	2026-01-08 13:23:47.112021	approved	12345678	static/kyc_docs/ce49328b-23f5-4950-a9b4-b723fbe290c4_1767873453_front_IMG-20260108-WA0089.jpg	IMG-20260108-WA0089.jpg	\N	\N
ce49328b-23f5-4950-a9b4-b723fbe290c4	e8508602-ed9d-45e1-8891-930ba3aff391	aadhaar_card	125995	image/jpeg	\N	6f866d70-9279-4941-b120-e2acfcfdb130	2026-01-08 11:57:47.214368	2026-01-08 13:23:52.338512	approved	47473838383	static/kyc_docs/ce49328b-23f5-4950-a9b4-b723fbe290c4_1767873467_front_IMG-20260108-WA0089.jpg	IMG-20260108-WA0089.jpg	\N	\N
ce49328b-23f5-4950-a9b4-b723fbe290c4	e8508602-ed9d-45e1-8891-930ba3aff391	photo	125995	image/jpeg	\N	32b6bc6e-afea-4b7f-9254-d25366ef8f7f	2026-01-08 11:58:22.701931	2026-01-08 13:23:57.552392	approved	556777	static/kyc_docs/ce49328b-23f5-4950-a9b4-b723fbe290c4_1767873502_front_IMG-20260108-WA0089.jpg	IMG-20260108-WA0089.jpg	\N	\N
ce49328b-23f5-4950-a9b4-b723fbe290c4	e8508602-ed9d-45e1-8891-930ba3aff391	voter_id	125995	image/jpeg	\N	468cd842-1d12-4e4d-9641-3a0579269183	2026-01-08 11:58:46.207356	2026-01-08 13:24:02.05873	approved	647474	static/kyc_docs/ce49328b-23f5-4950-a9b4-b723fbe290c4_1767873526_front_IMG-20260108-WA0089.jpg	IMG-20260108-WA0089.jpg	\N	\N
ce49328b-23f5-4950-a9b4-b723fbe290c4	e8508602-ed9d-45e1-8891-930ba3aff391	driving_license	125995	image/jpeg	\N	9fccba09-c480-406e-a167-592c3db84e28	2026-01-08 11:58:54.751854	2026-01-08 13:24:06.562378	approved	55555	static/kyc_docs/ce49328b-23f5-4950-a9b4-b723fbe290c4_1767873534_front_IMG-20260108-WA0089.jpg	IMG-20260108-WA0089.jpg	\N	\N
ce49328b-23f5-4950-a9b4-b723fbe290c4	e8508602-ed9d-45e1-8891-930ba3aff391	passport	125995	image/jpeg	\N	1b36d917-fb94-4c6a-8d7b-e1257c18ac02	2026-01-08 11:59:13.70589	2026-01-08 13:24:12.907196	approved	55555	static/kyc_docs/ce49328b-23f5-4950-a9b4-b723fbe290c4_1767873553_front_IMG-20260108-WA0089.jpg	IMG-20260108-WA0089.jpg	\N	\N
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	aadhaar_card	30038	image/jpeg	\N	b7a0c210-c6c1-40c0-81c8-6f60c61e9d5a	2026-01-13 07:20:47.576805	2026-01-13 07:21:05.353379	approved	301358898910	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768288847_front_adr1.png	adr1.png	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768288847_back_adr2.png	adr2.png
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	pan_card	527815	application/pdf	\N	7361283e-97b3-44c9-93b7-494193025876	2026-01-13 06:29:54.25394	2026-01-13 07:21:55.39906	approved	ABDCS0643L	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768285794_front_NEW_PAN_ADDPAY__unlocked.pdf	NEW PAN ADDPAY _unlocked.pdf	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	aadhaar_card	891580	application/pdf	\N	7f730197-746e-4ae8-b2c2-08cdf20740f0	2026-01-13 06:31:04.533579	2026-01-13 07:21:58.919794	approved	713392634686	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768285864_front_Director_aadhar_Pawan_kr._Jaiswal.pdf	Director aadhar_Pawan kr. Jaiswal.pdf	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	photo	53812	image/jpeg	\N	d8161c39-d094-43e9-b584-090ef962d3fd	2026-01-13 06:31:25.412827	2026-01-13 07:22:04.025094	approved	photo	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768285885_front_Director_Photo_Pawan_Kumar_Jaiswal.jpeg	Director Photo_Pawan Kumar Jaiswal.jpeg	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	company_pan	527815	application/pdf	\N	21bfac40-25a9-4227-8ab8-2c0f196e7c7a	2026-01-13 06:31:53.497649	2026-01-13 07:22:08.698843	approved	ABDCS0643L	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768285913_front_NEW_PAN_ADDPAY__unlocked.pdf	NEW PAN ADDPAY _unlocked.pdf	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	certificate_of_incorporation	515100	application/pdf	\N	8b3d9787-2609-42ec-bc0a-374aee6ec1de	2026-01-13 06:32:51.561335	2026-01-13 07:22:15.044076	approved	U74999MH2019PTC334381	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768285971_front_Certificate_of_Incorporation.PDF	Certificate of Incorporation.PDF	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	memorandum_of_association	739172	application/pdf	\N	f504479f-9183-42ab-a956-063f07b69ab9	2026-01-13 06:33:10.338312	2026-01-13 07:22:19.245564	approved	MOA	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768285990_front_MOA.pdf	MOA.pdf	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	articles_of_association	320230	application/pdf	\N	638017b4-25d6-40f4-910d-16dfa691175c	2026-01-13 06:33:23.686389	2026-01-13 07:22:24.465655	approved	AOA	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768286003_front_AOA.pdf	AOA.pdf	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	authorized_signatory_pan	72018	application/pdf	\N	a2b0a6aa-cd1f-4b4a-afe5-6d53c578d0d8	2026-01-13 06:35:02.045468	2026-01-13 07:22:29.227023	approved	ALFPJ5115K	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768286102_front_Director_Pan_Card_Pawan_Kr._Jaiswal.pdf	Director Pan Card_Pawan Kr. Jaiswal.pdf	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	authorized_signatory_aadhaar	891580	application/pdf	\N	2a4d8136-3ecb-4329-b10a-a72bae3a8fe7	2026-01-13 06:35:39.451981	2026-01-13 07:22:33.44103	approved	713392634686	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768286139_front_Director_aadhar_Pawan_kr._Jaiswal.pdf	Director aadhar_Pawan kr. Jaiswal.pdf	\N	\N
505fcc01-2c6d-435c-a3b4-2b6674c326e9	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	board_resolution	10902	image/jpeg	\N	1a0c4dbe-6747-4db9-9a83-a3247eccee22	2026-01-13 07:05:26.816054	2026-01-13 07:22:37.775735	approved	BR	static/kyc_docs/505fcc01-2c6d-435c-a3b4-2b6674c326e9_1768287926_front_addpay_logo.jpg	addpay logo.jpg	\N	\N
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	company_pan	44740	image/jpeg	\N	72558432-8537-4d8e-9b68-3ea72a0e7c45	2026-01-13 07:25:16.041302	2026-01-13 07:49:23.968472	approved	AAACX5555A	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289116_front_1.png	1.png	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289116_back_2.png	2.png
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	photo	3163	image/jpeg	\N	a0c67f10-13fc-4d2d-983e-7ca9b6edebcf	2026-01-13 07:26:48.370924	2026-01-13 07:49:28.018376	approved	301358898910	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289208_front_PROFILE.png	PROFILE.png	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289208_back_PROFILE.png	PROFILE.png
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	memorandum_of_association	2164796	application/pdf	\N	d925e8cb-9fdf-40a8-bd3b-46a81c234060	2026-01-13 07:35:25.461014	2026-01-13 07:49:36.010423	approved	U47599UP2025PTC220673	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289725_front_MOA_-signed.pdf	MOA -signed.pdf	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289725_back_MOA_-signed.pdf	MOA -signed.pdf
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	articles_of_association	277574	application/pdf	\N	63c985c8-dd1a-4918-8903-630cb285c67c	2026-01-13 07:36:34.697655	2026-01-13 07:49:39.899335	approved	U47599UP2025PTC220673	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289794_front_AOA.pdf	AOA.pdf	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289794_back_AOA.pdf	AOA.pdf
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	authorized_signatory_pan	405361	application/pdf	\N	c6600341-d7b6-4a27-907a-a8eaf0d72c14	2026-01-13 07:40:29.25842	2026-01-13 07:49:43.926265	approved	301358898910	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768290029_front_New_Doc_03-27-2025_18.43.pdf	New Doc 03-27-2025 18.43.pdf	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768290029_back_New_Doc_03-27-2025_18.43.pdf	New Doc 03-27-2025 18.43.pdf
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	board_resolution	2164796	application/pdf	\N	8f61f4cf-16c7-47ab-bafd-83795bc737ca	2026-01-13 07:45:32.725662	2026-01-13 07:49:47.786299	approved	301358898910	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768290332_front_MOA_-signed.pdf	MOA -signed.pdf	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768290332_back_MOA_-signed.pdf	MOA -signed.pdf
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	pan_card	27659	image/jpeg	\N	1ad9bc72-da38-4b32-b475-79358cfe3c53	2026-01-13 07:20:57.562606	2026-01-13 07:49:15.759629	approved	GYCPR9158G	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768288857_front_PAN_1.jpg	PAN 1.jpg	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768288857_back_PAN_1.jpg	PAN 1.jpg
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	certificate_of_incorporation	72687	application/pdf	\N	dbc7b0d6-4832-42d3-a29a-cace52c6b5b4	2026-01-13 07:28:55.575135	2026-01-13 07:49:31.912986	approved	U47599UP2025PTC220673	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289335_front_CERTIFICATE_OF_INCORPORATION.pdf	CERTIFICATE OF INCORPORATION.pdf	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768289335_back_CERTIFICATE_OF_INCORPORATION.pdf	CERTIFICATE OF INCORPORATION.pdf
3d9aa4bc-1535-4017-a168-5a19f65c14d7	8e18e831-8efe-4cf2-97c6-3e976251d9a3	authorized_signatory_aadhaar	407420	application/pdf	\N	b83ca88a-1116-45b9-9e0e-68cd2c2db894	2026-01-13 07:42:27.66251	2026-01-13 07:49:51.629379	approved	301358898910	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768290147_front_ad.pdf	ad.pdf	static/kyc_docs/3d9aa4bc-1535-4017-a168-5a19f65c14d7_1768290147_back_ad.pdf	ad.pdf
\.


--
-- Data for Name: kycs; Type: TABLE DATA; Schema: public; Owner: fintech_user
--

COPY public.kycs (user_id, document_type, document_number, date_of_birth, address, city, state, country, postal_code, notes, id, created_at, updated_at, status, company_name, ownership_type, pan_number, aadhaar_number) FROM stdin;
2ce36d1e-5818-415f-b875-b357c8297e9d	\N	\N	\N	84/164, dhawalgiri marg, sector 8 mansarovar, Jaipur	Mumbai	Rajasthan	India	302020	\N	e236705c-d275-4dde-b14b-f8b59a742888	2025-12-21 16:18:31.573069	2025-12-21 17:38:21.226084	approved	Mk pvt ltd	private_limited	HLLPK4678B	789878787656
1d7195b9-7556-4906-afdb-0cce6d525ea8	\N	\N	2025-12-03	84/164, dhawalgiri marg, sector 8 mansarovar, Jaipur	Mumbai	Rajasthan	India	302020	\N	3cccd587-987a-485f-bea1-cad291cb6636	2025-12-22 06:07:59.230003	2025-12-22 06:11:35.246119	approved	Mk pvt ltd	individual	HLLPK4678N	789878787655
0ccb76fc-6666-4a61-8498-63864856131e	\N	\N	\N	FIoor No.: SHOP NO 9Building No./Flat No.: BUILDING 5Name Of Premises/Building: KISHOR KUNJRoad/Street: OPP VIVA COLLAGENearby Landmark: VIRAR WESTLocalitySub Locality: Virar WestCity/Town/Village: Vasai VirarDistrict: PalgharState: MaharashtraPIN Code: 401303	Vasai Virar	Maharashtra	India	401003	\N	bd340c52-d08e-4941-bdcd-496332e84f11	2025-12-25 09:01:44.323065	2025-12-25 09:37:40.897393	approved	IKIBLAZE TECHNO SOLUTIONS PRIVATE LIMITED	private_limited	BBEPM0091H	707062812950
6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	\N	\N	\N	102 1st Floor House of Lords, 	Banglore North	Karnataka	India	560001	\N	3a1ac88d-1c14-403d-b225-73a5941090e1	2025-12-26 04:14:57.007085	2025-12-26 04:37:45.214565	approved	Zohan Infotech Private Limited	private_limited	AACCZ5415B	272233391676
3c70dd22-df28-4a50-a034-4a378507c5bf	\N	\N	\N	Floor No.： First Floor, Shop No. 2\nBuilding No./Flat No.： Plot No. 29\nRoad/Street: Varadharajapuram Main Road	Chennai	Tamil Nadu	India	600100	\N	941db012-55b6-4867-be2f-a591c7ed7b1b	2025-12-26 08:22:30.264122	2025-12-26 09:58:20.036792	approved	SEYON BUZHUB PRIVATE LIMITED	private_limited	ABOCS5476J	669623910265
aee00114-b63d-449d-8021-6b27bdb251bd	\N	\N	\N	GROUND FLOOR, 699, Lake Town Road	Kolkata	 North Twenty Four Parganas, West Bengal	India	700089	\N	c26f8894-d1ef-4dda-9d3c-8e93d1e469e0	2026-01-06 08:11:07.595997	2026-01-06 08:58:50.331907	approved	Sunilbiswas Technology Private Limited	private_limited	BRAPB5119H	624819838410
350c1879-98e4-44b1-8b39-b39e5ffd9836	\N	\N	\N	t04 , A88 , sector 4 , noida	noida	UTTAR PRADESH	india	201301	\N	cce5bc49-1b68-483f-aa7c-18bd7db10dca	2026-01-07 06:25:38.13481	2026-01-07 06:33:38.54578	approved	Planet Clothing	sole_proprietorship	GOLPR9502B	907203144686
ce49328b-23f5-4950-a9b4-b723fbe290c4	\N	\N	2026-01-08						\N	e8508602-ed9d-45e1-8891-930ba3aff391	2026-01-08 11:57:04.798767	2026-01-08 13:24:21.325641	approved	Sarthak	individual	Ggepm3856d	123456789125
505fcc01-2c6d-435c-a3b4-2b6674c326e9	\N	\N	\N	Floor No.: Floor 10\nBuilding No./Flat No.: Building 4\nName Of Premises/Building: WeWork NESCO IT Park\nRoad/Street: Jaicoach Road\nNearby Landmark: Economic Times Acetech - Mumbai\nLocality/Sub Locality: Goregaon Eas	Mumbai	Maharashtra	India	400063	\N	f4b693c2-c3a6-4504-b7a8-e47abb7bbe9b	2026-01-13 06:29:08.009693	2026-01-13 07:22:44.12746	approved	ADDPAY SERVICES PRIVATE LIMITED	private_limited	ABDCS0643L	713392634686
3d9aa4bc-1535-4017-a168-5a19f65c14d7	\N	\N	\N	UTC UNIT NO. 626, TOWER C,SIXTH FLOOR, PLOT NO B-35, SECTOR-132,\nNoida, Gautam Buddha Nagar, Noida, Uttar Pradesh, India, 201301	Noida	Uttar Pradesh	India	201301	\N	8e18e831-8efe-4cf2-97c6-3e976251d9a3	2026-01-13 07:06:34.376098	2026-01-13 07:49:57.823093	approved	XPRESSBUY TECHNOLOGY PRIVATE LIMITED	private_limited	GYCPR9158G	301358898910
\.


--
-- Data for Name: payin_transactions; Type: TABLE DATA; Schema: public; Owner: fintech_user
--

COPY public.payin_transactions (id, user_id, txnid, user_reference_id, amount, charge, payee_vpa, payee_name, status, api_response, qr_text, payment_url, api_provider, provider_reference_id, refunded, created_at, updated_at, rrn, settled, scheduled_credit_at) FROM stdin;
1	2ce36d1e-5818-415f-b875-b357c8297e9d	PINHBWSHMPJJZ4H	string	1.00	0.00	mewaram@vpz	string	error	{"status": "error", "message": "Rupeeflow API error: ['email must be an email', 'mobile must be a number string']", "reference_id": null, "txnid": "PINHBWSHMPJJZ4H", "amount": "1", "payment_url": null, "qr_text": null, "raw_response": {"message": ["email must be an email", "mobile must be a number string"], "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-22 11:35:10.23817	2025-12-22 11:35:10.238174	\N	f	\N
2	2ce36d1e-5818-415f-b875-b357c8297e9d	PINXY94RJJJN30T	nmsbdmhsbdshjd	1.00	0.00	mewaram@vpz	string	error	{"status": "error", "message": "Rupeeflow API error: Failed to generate payment link", "reference_id": null, "txnid": "PINXY94RJJJN30T", "amount": "1", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-22 11:36:07.435982	2025-12-22 11:36:07.435986	\N	f	\N
102	3c70dd22-df28-4a50-a034-4a378507c5bf	PINXJBQSD69ULCD	HC1767690610318J61	100.00	5.90	\N	Sunita Mathurlal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3589165894", "txnid": "PINXJBQSD69ULCD", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695CD1734D633&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695CD1734D633&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695CD1734D633&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695CD1734D633&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5F695CD1734D633", "upi_tr": "pt_5F695CD1734D633", "txnid": "ORDID3589165894", "orderid": "ORDID3589165894", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695CD1734D633&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695CD1734D633&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3589165894	f	2026-01-06 09:10:11.598106	2026-01-06 09:10:11.598112	\N	f	\N
4	2ce36d1e-5818-415f-b875-b357c8297e9d	PINH76NFCUK2Y42	dfjnbdfnbdjf	1.00	0.00	mewaram@icici	string	error	{"status": "error", "message": "Rupeeflow API error: Failed to generate payment link", "reference_id": null, "txnid": "PINH76NFCUK2Y42", "amount": "1", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-22 11:44:13.010172	2025-12-22 11:44:13.010176	\N	f	\N
2363	3c70dd22-df28-4a50-a034-4a378507c5bf	PINUAT0P4KZNBF5	HC17677728438917XQ	100.00	5.00	\N	Rekha Duttanath	error	{"status": "error", "message": "Unitpay API error: HTTPSConnectionPool(host='unitpaygo.com', port=443): Read timed out. (read timeout=30)", "reference_id": null, "txnid": "PINUAT0P4KZNBF5", "amount": "100.00", "payment_url": null, "qr_text": null, "raw_response": {}}	\N	\N	unitpay	\N	f	2026-01-07 08:01:14.105046	2026-01-07 08:01:14.105049	\N	f	\N
7	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINZ2GQZ28EUO5Q	skjjt45568	100.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINZ2GQZ28EUO5Q", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:15:44.559365	2025-12-26 05:15:44.559369	\N	f	\N
8	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINDCPJGF0PFOSF	sndwsndmsdm	100.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINDCPJGF0PFOSF", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:15:57.158665	2025-12-26 05:15:57.158669	\N	f	\N
9	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINKCB8IM04UT8A	nfndfndmfdmf	100.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINKCB8IM04UT8A", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:16:07.742262	2025-12-26 05:16:07.742266	\N	f	\N
10	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINF3I6T0X58BE8	skjjt455654	100.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINF3I6T0X58BE8", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:18:45.287113	2025-12-26 05:18:45.287117	\N	f	\N
11	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINUDN6I7GDW1ZG	sndmsndfmsndf	1000.00	0.00	jatingshk@ybl	Jatin Shukla	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "sndmsndfmsndf", "txnid": "PINUDN6I7GDW1ZG", "amount": "1000", "payment_url": "upi://pay?tr=2536010587538812128&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06", "qr_text": "upi://pay?tr=2536010587538812128&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "sndmsndfmsndf", "intent": "upi://pay?tr=2536010587538812128&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06", "message": "Payment Link Generated successfully"}}}	upi://pay?tr=2536010587538812128&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06	upi://pay?tr=2536010587538812128&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06	rupeeflow	sndmsndfmsndf	f	2025-12-26 05:23:57.844206	2025-12-26 05:23:57.84421	\N	f	\N
3	2ce36d1e-5818-415f-b875-b357c8297e9d	PINTY5IDWU0TZOS	dnjfdnfdjfndjf	1.00	0.00	mewaram@vpz	string	failed	{"status": "error", "message": "Rupeeflow API error: Failed to generate payment link", "reference_id": null, "txnid": "PINTY5IDWU0TZOS", "amount": "1", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-22 11:41:35.814904	2025-12-26 15:02:39.480492	\N	f	\N
12	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINGFGFUCM8F89S	sdnbsndsnbdf	100.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINGFGFUCM8F89S", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:24:07.091619	2025-12-26 05:24:07.091623	\N	f	\N
15	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINY4GZUL126DV8	nsdjnsfjdbf	150.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINY4GZUL126DV8", "amount": "150", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:25:26.45446	2025-12-26 05:25:26.454463	\N	f	\N
150	3c70dd22-df28-4a50-a034-4a378507c5bf	PINVQHXFP9KQL30	HC176769351558474K	100.00	5.00	\N	Savita Bhatiarao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3916050309", "txnid": "PINVQHXFP9KQL30", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F1695cDcCC4c610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F1695cDcCC4c610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F1695cDcCC4c610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F1695cDcCC4c610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F1695cDcCC4c610", "upi_tr": "pt_F1695cDcCC4c610", "txnid": "ORDID3916050309", "orderid": "ORDID3916050309", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F1695cDcCC4c610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F1695cDcCC4c610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3916050309	f	2026-01-06 09:58:36.568066	2026-01-06 09:58:36.568069	\N	f	\N
104	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCGO0631Z1X0V	HC1767690682255L9W	100.00	5.90	\N	Neha Menonish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3357169053", "txnid": "PINCGO0631Z1X0V", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd1Bb02d4F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd1Bb02d4F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd1Bb02d4F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd1Bb02d4F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_11695cd1Bb02d4F", "upi_tr": "pt_11695cd1Bb02d4F", "txnid": "ORDID3357169053", "orderid": "ORDID3357169053", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd1Bb02d4F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd1Bb02d4F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3357169053	f	2026-01-06 09:11:23.272032	2026-01-06 09:11:23.272037	\N	f	\N
107	3c70dd22-df28-4a50-a034-4a378507c5bf	PINROTV0U15IU8N	HC1767690863361TNE	100.00	5.90	\N	Vivek Jainrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3940867183", "txnid": "PINROTV0U15IU8N", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6f695Cd270b6d3E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6f695Cd270b6d3E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6f695Cd270b6d3E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6f695Cd270b6d3E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6f695Cd270b6d3E", "upi_tr": "pt_6f695Cd270b6d3E", "txnid": "ORDID3940867183", "orderid": "ORDID3940867183", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6f695Cd270b6d3E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6f695Cd270b6d3E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3940867183	f	2026-01-06 09:14:25.003222	2026-01-06 09:14:25.003226	\N	f	\N
109	3c70dd22-df28-4a50-a034-4a378507c5bf	PINS7D61OCVCSMF	HC1767690962228E3C	100.00	5.90	\N	Ankita Bhatiaananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6329819569", "txnid": "PINS7D61OCVCSMF", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ca695Cd2d34cACb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ca695Cd2d34cACb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ca695Cd2d34cACb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ca695Cd2d34cACb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_ca695Cd2d34cACb", "upi_tr": "pt_ca695Cd2d34cACb", "txnid": "ORDID6329819569", "orderid": "ORDID6329819569", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ca695Cd2d34cACb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ca695Cd2d34cACb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6329819569	f	2026-01-06 09:16:03.67152	2026-01-06 09:16:03.671525	\N	f	\N
13	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINOAXDC3T10AL5	sdmsndsndf	101.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINOAXDC3T10AL5", "amount": "101", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:24:17.954556	2025-12-26 05:24:17.95456	\N	f	\N
25	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINIHDPBAQTAM0A	sndsndjsbdjb	500.00	17.50	jatingshk@ybl	Jatin Shukla	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "sndsndjsbdjb", "txnid": "PINIHDPBAQTAM0A", "amount": "500", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290414882", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290414882", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "sndsndjsbdjb", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290414882", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290414882	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290414882	rupeeflow	sndsndjsbdjb	f	2025-12-26 05:59:48.054524	2025-12-26 05:59:48.054529	\N	f	\N
16	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINV5CZ2RNM9XBL	sdjdfbkjfbjdf	1000.00	0.00	jatingshk@ybl	Jatin Shukla	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "sdjdfbkjfbjdf", "txnid": "PINV5CZ2RNM9XBL", "amount": "1000", "payment_url": "upi://pay?tr=2536010340972243821&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06", "qr_text": "upi://pay?tr=2536010340972243821&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "sdjdfbkjfbjdf", "intent": "upi://pay?tr=2536010340972243821&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06", "message": "Payment Link Generated successfully"}}}	upi://pay?tr=2536010340972243821&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06	upi://pay?tr=2536010340972243821&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1000.00&mam=1000.00&cu=INR&qrMedium=06	rupeeflow	sdjdfbkjfbjdf	f	2025-12-26 05:25:46.305076	2025-12-26 05:25:46.305079	\N	f	\N
19	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINJ30Y6WNM5KZ2	ndejwbwbre	500.00	0.00	jatingshk@ybl	Jatin Shukla	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ndejwbwbre", "txnid": "PINJ30Y6WNM5KZ2", "amount": "500", "payment_url": "upi://pay?tr=2536010651834428931&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "qr_text": "upi://pay?tr=2536010651834428931&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ndejwbwbre", "intent": "upi://pay?tr=2536010651834428931&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "message": "Payment Link Generated successfully"}}}	upi://pay?tr=2536010651834428931&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06	upi://pay?tr=2536010651834428931&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06	rupeeflow	ndejwbwbre	f	2025-12-26 05:27:12.847809	2025-12-26 05:27:12.847812	\N	f	\N
21	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PIN234QZI415VJJ	dsrjewrbehr	450.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PIN234QZI415VJJ", "amount": "450", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:27:29.413194	2025-12-26 05:27:29.413197	\N	f	\N
103	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1FKC2NUFIP95	HC1767690656251GHL	100.00	5.90	\N	Mohan Sharmaappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9636373508", "txnid": "PIN1FKC2NUFIP95", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695Cd1A100338&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695Cd1A100338&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695Cd1A100338&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695Cd1A100338&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_03695Cd1A100338", "upi_tr": "pt_03695Cd1A100338", "txnid": "ORDID9636373508", "orderid": "ORDID9636373508", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9636373508", "rrn": "116766503883"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695Cd1A100338&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695Cd1A100338&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9636373508	f	2026-01-06 09:10:57.239166	2026-01-06 09:11:31.277229	116766503883	t	2026-01-06 09:11:26.588955+00
23	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PIN51XCSH74XM69	sjbdfebrerbe	500.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "sjbdfebrerbe", "txnid": "PIN51XCSH74XM69", "amount": "500", "payment_url": "upi://pay?tr=2536010592687912997&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "qr_text": "upi://pay?tr=2536010592687912997&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "sjbdfebrerbe", "intent": "upi://pay?tr=2536010592687912997&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "message": "Payment Link Generated successfully"}}}	upi://pay?tr=2536010592687912997&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06	upi://pay?tr=2536010592687912997&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06	rupeeflow	sjbdfebrerbe	f	2025-12-26 05:27:49.424429	2025-12-26 14:58:11.271894	\N	f	\N
26	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINYSL0DFX0HGY8	45787893s4	1000.00	35.00	778@s54d	John Doe	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "45787893s4", "txnid": "PINYSL0DFX0HGY8", "amount": "1000", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=1000&cu=INR&tn=Payment+for+Order+100290395176", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=1000&cu=INR&tn=Payment+for+Order+100290395176", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "45787893s4", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=1000&cu=INR&tn=Payment+for+Order+100290395176", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=1000&cu=INR&tn=Payment+for+Order+100290395176	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=1000&cu=INR&tn=Payment+for+Order+100290395176	rupeeflow	45787893s4	f	2025-12-26 06:52:18.637412	2025-12-26 06:52:18.637417	\N	f	\N
14	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINKW4Y6YBNL7DR	nsjdnsjdnsdb	1010.00	0.00	jatingshk@ybl	Jatin Shukla	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "nsjdnsjdnsdb", "txnid": "PINKW4Y6YBNL7DR", "amount": "1010", "payment_url": "upi://pay?tr=2536010347003715537&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1010.00&mam=1010.00&cu=INR&qrMedium=06", "qr_text": "upi://pay?tr=2536010347003715537&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1010.00&mam=1010.00&cu=INR&qrMedium=06", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "nsjdnsjdnsdb", "intent": "upi://pay?tr=2536010347003715537&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1010.00&mam=1010.00&cu=INR&qrMedium=06", "message": "Payment Link Generated successfully"}}}	upi://pay?tr=2536010347003715537&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1010.00&mam=1010.00&cu=INR&qrMedium=06	upi://pay?tr=2536010347003715537&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=1010.00&mam=1010.00&cu=INR&qrMedium=06	rupeeflow	nsjdnsjdnsdb	f	2025-12-26 05:24:42.973278	2025-12-26 05:24:42.973281	\N	f	\N
18	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PIN4WSAOFBP0Z03	sdndsnndfbsmndfbs	999.00	0.00	jatingshk@ybl	Jatin Shukla	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "sdndsnndfbsmndfbs", "txnid": "PIN4WSAOFBP0Z03", "amount": "999", "payment_url": "upi://pay?tr=2536010467690914403&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=999.00&mam=999.00&cu=INR&qrMedium=06", "qr_text": "upi://pay?tr=2536010467690914403&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=999.00&mam=999.00&cu=INR&qrMedium=06", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "sdndsnndfbsmndfbs", "intent": "upi://pay?tr=2536010467690914403&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=999.00&mam=999.00&cu=INR&qrMedium=06", "message": "Payment Link Generated successfully"}}}	upi://pay?tr=2536010467690914403&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=999.00&mam=999.00&cu=INR&qrMedium=06	upi://pay?tr=2536010467690914403&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=999.00&mam=999.00&cu=INR&qrMedium=06	rupeeflow	sdndsnndfbsmndfbs	f	2025-12-26 05:27:01.83897	2025-12-26 05:27:01.838973	\N	f	\N
20	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINOX724RG9NNWB	sndfsjfnjfb	400.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINOX724RG9NNWB", "amount": "400", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:27:20.95255	2025-12-26 05:27:20.952553	\N	f	\N
22	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PIN30SRXXWLG5H8	sdfdsjfbjherbe	499.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PIN30SRXXWLG5H8", "amount": "499", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:27:37.759782	2025-12-26 05:27:37.759786	\N	f	\N
105	3c70dd22-df28-4a50-a034-4a378507c5bf	PINX7811JVDLSVX	HC1767690700692MCB	100.00	5.90	\N	Harish Jainlal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6240286351", "txnid": "PINX7811JVDLSVX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cd1cD65a67&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cd1cD65a67&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cd1cD65a67&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cd1cD65a67&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D7695cd1cD65a67", "upi_tr": "pt_D7695cd1cD65a67", "txnid": "ORDID6240286351", "orderid": "ORDID6240286351", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cd1cD65a67&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cd1cD65a67&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6240286351	f	2026-01-06 09:11:41.683162	2026-01-06 09:11:41.683166	\N	f	\N
24	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINK483E59BPW77	skjjt4557554	500.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "skjjt4557554", "txnid": "PINK483E59BPW77", "amount": "500", "payment_url": "upi://pay?tr=2536010673028702234&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "qr_text": "upi://pay?tr=2536010673028702234&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "skjjt4557554", "intent": "upi://pay?tr=2536010673028702234&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06", "message": "Payment Link Generated successfully"}}}	upi://pay?tr=2536010673028702234&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06	upi://pay?tr=2536010673028702234&ver=01&mode=04&orgId=CONCERTO&Purpose=00&tn=intent&pa=vegaaH.GROOTS%40kotak&pn=GROOTSTECHNOEDGEPRIVATELIMITED&mc=4784&am=500.00&mam=500.00&cu=INR&qrMedium=06	rupeeflow	skjjt4557554	f	2025-12-26 05:28:35.037484	2025-12-26 14:58:27.216623	\N	f	\N
17	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINXACV1T88PQXH	sdnsdbfnsbfds	200.00	0.00	jatingshk@ybl	Jatin Shukla	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PINXACV1T88PQXH", "amount": "200", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2025-12-26 05:26:03.751162	2025-12-26 05:26:03.751166	\N	f	\N
2306	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN95G7NWYG37GW	HC1767772813859SKP	100.00	5.00	\N	Nikhil Kapoorkar	error	{"status": "error", "message": "Unitpay API error: HTTPSConnectionPool(host='unitpaygo.com', port=443): Read timed out. (read timeout=30)", "reference_id": null, "txnid": "PIN95G7NWYG37GW", "amount": "100.00", "payment_url": null, "qr_text": null, "raw_response": {}}	\N	\N	unitpay	\N	f	2026-01-07 08:00:44.283476	2026-01-07 08:00:44.283481	\N	f	\N
27	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINNPKZRXOV7EL4	ORDID3749332758	100.00	3.50	\N	Demo Testing	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID3749332758", "txnid": "PINNPKZRXOV7EL4", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290188787", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290188787", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID3749332758", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290188787", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290188787	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290188787	rupeeflow	ORDID3749332758	f	2025-12-26 06:58:06.231499	2025-12-26 06:58:06.231502	\N	f	\N
28	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINH758D3PZEC79	ORDID4381944773	100.00	3.50	\N	Demo Testing	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID4381944773", "txnid": "PINH758D3PZEC79", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290369803", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290369803", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID4381944773", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290369803", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290369803	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290369803	rupeeflow	ORDID4381944773	f	2025-12-26 07:02:34.236064	2025-12-26 07:02:34.236068	\N	f	\N
29	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PIN5ZA3XOLXDNNS	ORDID9800784658	100.00	3.50	\N	Demo Testing	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID9800784658", "txnid": "PIN5ZA3XOLXDNNS", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290443213", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290443213", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID9800784658", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290443213", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290443213	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290443213	rupeeflow	ORDID9800784658	f	2025-12-26 07:03:21.819308	2025-12-26 07:03:21.819313	\N	f	\N
30	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINSN4Q7YHPL9B0	ORDID6011162575	100.00	3.50	\N	Demo Testing	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID6011162575", "txnid": "PINSN4Q7YHPL9B0", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290749388", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290749388", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID6011162575", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290749388", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290749388	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290749388	rupeeflow	ORDID6011162575	f	2025-12-26 07:03:56.399497	2025-12-26 07:03:56.3995	\N	f	\N
31	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINTBXC3B7NOVZK	ORDID4863837035	100.00	3.50	\N	Demo Testing	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID4863837035", "txnid": "PINTBXC3B7NOVZK", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290305263", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290305263", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID4863837035", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290305263", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290305263	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290305263	rupeeflow	ORDID4863837035	f	2025-12-26 07:05:08.558608	2025-12-26 07:05:08.558612	\N	f	\N
32	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINJYLYVJY05XJV	ORDID7637664170	100.00	3.50	\N	Demo Testing	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID7637664170", "txnid": "PINJYLYVJY05XJV", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290373856", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290373856", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID7637664170", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290373856", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290373856	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290373856	rupeeflow	ORDID7637664170	f	2025-12-26 07:05:55.799757	2025-12-26 07:05:55.799761	\N	f	\N
33	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINLC5OB93PWO7N	ORDID5322491743	100.00	3.50	\N	Demo Testing	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID5322491743", "txnid": "PINLC5OB93PWO7N", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290759841", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290759841", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID5322491743", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290759841", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290759841	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290759841	rupeeflow	ORDID5322491743	f	2025-12-26 07:07:26.841385	2025-12-26 07:07:26.841388	\N	f	\N
34	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINGM4SCW8UCY1I	ORDID2186300410	100.00	3.50	\N	Demo Testing	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID2186300410", "txnid": "PINGM4SCW8UCY1I", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290425526", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290425526", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID2186300410", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290425526", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290425526	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290425526	rupeeflow	ORDID2186300410	f	2025-12-26 07:08:26.095388	2025-12-26 07:08:26.095392	\N	f	\N
106	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2JLKY4X5TOWN	HC1767690718543U85	100.00	5.90	\N	Jaya Mishrarao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5511809200", "txnid": "PIN2JLKY4X5TOWN", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695Cd1df3524A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695Cd1df3524A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695Cd1df3524A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695Cd1df3524A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D2695Cd1df3524A", "upi_tr": "pt_D2695Cd1df3524A", "txnid": "ORDID5511809200", "orderid": "ORDID5511809200", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695Cd1df3524A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695Cd1df3524A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5511809200	f	2026-01-06 09:11:59.468942	2026-01-06 09:11:59.468946	\N	f	\N
36	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINKONAYU6WRZOJ	ORDID5467485773	200.00	7.00	\N	Demo Testing	failed	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID5467485773", "txnid": "PINKONAYU6WRZOJ", "amount": "200", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=200&cu=INR&tn=Payment+for+Order+100290808253", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=200&cu=INR&tn=Payment+for+Order+100290808253", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID5467485773", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=200&cu=INR&tn=Payment+for+Order+100290808253", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=200&cu=INR&tn=Payment+for+Order+100290808253	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=200&cu=INR&tn=Payment+for+Order+100290808253	rupeeflow	ORDID5467485773	f	2025-12-26 07:09:14.017355	2025-12-26 14:58:55.468101	\N	f	\N
6	2ce36d1e-5818-415f-b875-b357c8297e9d	PINOHF6SY6UA103	ndrjenrjertn	100.00	0.00	mewaram@icici	string	success	{"status": "SUCCESS", "message": "Payment Link Generated successfully", "reference_id": "ndrjenrjertn", "txnid": "PINOHF6SY6UA103", "amount": "500.0", "payment_url": "upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290583744&tn=Paymentfororder100290583744&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=", "qr_text": "upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290583744&tn=Paymentfororder100290583744&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ndrjenrjertn", "intent": "upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290583744&tn=Paymentfororder100290583744&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=", "message": "Payment Link Generated successfully"}}, "webhook_received": true, "orderId": "ndrjenrjertn"}	upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290583744&tn=Paymentfororder100290583744&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=	upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290583744&tn=Paymentfororder100290583744&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=	rupeeflow	ndrjenrjertn	f	2025-12-22 11:49:38.576469	2025-12-26 07:37:36.359038	\N	f	\N
110	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJ0JXV8807MTN	HC17676909871536EM	100.00	5.90	\N	Yogesh Chauhanji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8764246987", "txnid": "PINJ0JXV8807MTN", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6c695cd2EbD2C36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6c695cd2EbD2C36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6c695cd2EbD2C36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6c695cd2EbD2C36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6c695cd2EbD2C36", "upi_tr": "pt_6c695cd2EbD2C36", "txnid": "ORDID8764246987", "orderid": "ORDID8764246987", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8764246987", "rrn": "637235123754"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6c695cd2EbD2C36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6c695cd2EbD2C36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8764246987	f	2026-01-06 09:16:28.119607	2026-01-06 09:17:06.534253	637235123754	t	2026-01-06 09:17:03.838629+00
2377	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8GG9VI68C66L	HC1767772855357VME	100.00	5.00	\N	Arun Chauhanesh	error	{"status": "error", "message": "Unitpay API error: HTTPSConnectionPool(host='unitpaygo.com', port=443): Read timed out. (read timeout=30)", "reference_id": null, "txnid": "PIN8GG9VI68C66L", "amount": "100.00", "payment_url": null, "qr_text": null, "raw_response": {}}	\N	\N	unitpay	\N	f	2026-01-07 08:01:25.584651	2026-01-07 08:01:25.584656	\N	f	\N
11265	2ce36d1e-5818-415f-b875-b357c8297e9d	PINEY3GKQXRAPV5	HWHEGWEFHWEVWNHE	100.00	1.18	string	Mwkhejw	failed	{"status": "failed", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}", "reference_id": null, "txnid": "PINEY3GKQXRAPV5", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "TXF", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}"}}	\N	\N	unitpay	\N	f	2026-01-08 08:17:45.003417	2026-01-08 08:17:45.00342	\N	f	\N
117	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9BY298QH8Y0Q	HC1767691243339S53	100.00	5.90	\N	Suresh Shahananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1795638296", "txnid": "PIN9BY298QH8Y0Q", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695cd3ec189ED&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695cd3ec189ED&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695cd3ec189ED&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695cd3ec189ED&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_49695cd3ec189ED", "upi_tr": "pt_49695cd3ec189ED", "txnid": "ORDID1795638296", "orderid": "ORDID1795638296", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695cd3ec189ED&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695cd3ec189ED&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1795638296	f	2026-01-06 09:20:44.37995	2026-01-06 09:20:44.379955	\N	f	\N
40	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINKI8G4DQCCPMI	ORDID3890454045	500.00	17.50	\N	Demo Testing	success	{"status": "SUCCESS", "message": "Payment Link Generated successfully", "reference_id": "ORDID3890454045", "txnid": "PINKI8G4DQCCPMI", "amount": "500.0", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290594917", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290594917", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID3890454045", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290594917", "message": "Payment Link Generated successfully"}}, "webhook_received": true, "orderId": "ORDID3890454045", "rrn": "592504223991"}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290594917	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290594917	rupeeflow	ORDID3890454045	f	2025-12-26 10:47:40.459631	2025-12-27 09:14:02.577938	592504223991	f	\N
39	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINI907HN6DNFRT	ORDID6561386201	500.00	17.50	\N	Demo Testing	success	{"status": "SUCCESS", "message": "Payment Link Generated successfully", "reference_id": "ORDID6561386201", "txnid": "PINI907HN6DNFRT", "amount": "500.0", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290547327", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290547327", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID6561386201", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290547327", "message": "Payment Link Generated successfully"}}, "webhook_received": true, "orderId": "ORDID6561386201", "rrn": "499916556334"}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290547327	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=500&cu=INR&tn=Payment+for+Order+100290547327	rupeeflow	ORDID6561386201	f	2025-12-26 07:20:37.701615	2025-12-27 09:15:24.963676	499916556334	f	\N
38	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINBK4UXX44DVM1	ORDID8494212383	100.00	3.50	\N	Demo Testing	failed	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID8494212383", "txnid": "PINBK4UXX44DVM1", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290491830", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290491830", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID8494212383", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290491830", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290491830	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290491830	rupeeflow	ORDID8494212383	f	2025-12-26 07:11:01.155587	2025-12-26 14:57:20.102711	\N	f	\N
37	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINBXTU8IMTC3DU	ORDID2894736373	100.00	3.50	\N	Demo Testing	failed	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID2894736373", "txnid": "PINBXTU8IMTC3DU", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290470509", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290470509", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID2894736373", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290470509", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290470509	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290470509	rupeeflow	ORDID2894736373	f	2025-12-26 07:10:25.211366	2025-12-26 14:58:47.719303	\N	f	\N
5	2ce36d1e-5818-415f-b875-b357c8297e9d	PIN5AEKK49ZJGLL	nsdnsdsnfdbns	100.00	0.00	mewaram@icici	string	failed	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "nsdnsdsnfdbns", "txnid": "PIN5AEKK49ZJGLL", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290763843&tn=Paymentfororder100290763843&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=", "qr_text": "upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290763843&tn=Paymentfororder100290763843&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "nsdnsdsnfdbns", "intent": "upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290763843&tn=Paymentfororder100290763843&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290763843&tn=Paymentfororder100290763843&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=	upi://pay?pa=merchant.lara800ware@digikhata&pn=LarawarePrivateLimited&mc=4900&tid=&tr=100290763843&tn=Paymentfororder100290763843&am=100&mam=100&cu=INR&url=&mode=00&sign=&orgid=&mid=&msid=&mtid=	rupeeflow	nsdnsdsnfdbns	f	2025-12-22 11:47:49.949078	2025-12-26 15:01:15.60484	\N	f	\N
35	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINH7DGUR80PTYR	ORDID5924155282	100.00	3.50	\N	Demo Testing	failed	{"status": "failed", "message": "Payment Link Generated successfully", "reference_id": "ORDID5924155282", "txnid": "PINH7DGUR80PTYR", "amount": "100.0", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290721151", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290721151", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID5924155282", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290721151", "message": "Payment Link Generated successfully"}}, "webhook_received": true, "orderId": "ORDID5924155282", "rrn": "788767576"}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290721151	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290721151	rupeeflow	ORDID5924155282	f	2025-12-26 07:08:46.937177	2025-12-27 05:19:16.959466	788767576	f	\N
41	2ce36d1e-5818-415f-b875-b357c8297e9d	PINXNF4VF77GF55	jshdjsgdhsjdhjsgdv	100.00	0.00	string@vpa	Mewaram jat	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "jshdjsgdhsjdhjsgdv", "txnid": "PINXNF4VF77GF55", "amount": "100", "payment_url": "upi://pay?&pa=getepay.usfbqrap244406@utkarshbank&pn=KOPYSYNKTECHNOLOGIESPRIVATELIMITED&am=100&tr=jshdjsgdhsjdhjsgdv&tn=Paymentforjshdjsgdhsjdhjsgdv&cu=INR&exp=1766909887476", "qr_text": "upi://pay?&pa=getepay.usfbqrap244406@utkarshbank&pn=KOPYSYNKTECHNOLOGIESPRIVATELIMITED&am=100&tr=jshdjsgdhsjdhjsgdv&tn=Paymentforjshdjsgdhsjdhjsgdv&cu=INR&exp=1766909887476", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "jshdjsgdhsjdhjsgdv", "intent": "upi://pay?&pa=getepay.usfbqrap244406@utkarshbank&pn=KOPYSYNKTECHNOLOGIESPRIVATELIMITED&am=100&tr=jshdjsgdhsjdhjsgdv&tn=Paymentforjshdjsgdhsjdhjsgdv&cu=INR&exp=1766909887476", "message": "Payment Link Generated successfully"}}}	upi://pay?&pa=getepay.usfbqrap244406@utkarshbank&pn=KOPYSYNKTECHNOLOGIESPRIVATELIMITED&am=100&tr=jshdjsgdhsjdhjsgdv&tn=Paymentforjshdjsgdhsjdhjsgdv&cu=INR&exp=1766909887476	upi://pay?&pa=getepay.usfbqrap244406@utkarshbank&pn=KOPYSYNKTECHNOLOGIESPRIVATELIMITED&am=100&tr=jshdjsgdhsjdhjsgdv&tn=Paymentforjshdjsgdhsjdhjsgdv&cu=INR&exp=1766909887476	rupeeflow	jshdjsgdhsjdhjsgdv	f	2025-12-28 08:17:07.489427	2025-12-28 08:17:07.48943	\N	f	\N
42	2ce36d1e-5818-415f-b875-b357c8297e9d	PIN592F2AZHA43P	hwjehwjehwjewjew	100.00	0.00	string@vpa	Mewaram jat	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "hwjehwjehwjewjew", "txnid": "PIN592F2AZHA43P", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290360014", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290360014", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "hwjehwjehwjewjew", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290360014", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290360014	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290360014	rupeeflow	hwjehwjehwjewjew	f	2025-12-28 08:18:12.014627	2025-12-28 08:18:12.014631	\N	f	\N
43	2ce36d1e-5818-415f-b875-b357c8297e9d	PINXTXXZI5NH4MW	whejwgewgehgwfe	100.00	0.00	string@vpa	Mewaram jat	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "whejwgewgehgwfe", "txnid": "PINXTXXZI5NH4MW", "amount": "100", "payment_url": "upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY2744851766910326&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "qr_text": "upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY2744851766910326&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "whejwgewgehgwfe", "intent": "upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY2744851766910326&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY2744851766910326&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01	upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY2744851766910326&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01	rupeeflow	whejwgewgehgwfe	f	2025-12-28 08:25:26.695603	2025-12-28 08:25:26.695605	\N	f	\N
44	2ce36d1e-5818-415f-b875-b357c8297e9d	PIN5MQ2NWP98E6L	hsdshdshgdvhsgdcvsd	100.00	0.00	string@vpa	Mewaram jat	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "hsdshdshgdvhsgdcvsd", "txnid": "PIN5MQ2NWP98E6L", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290402772", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290402772", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "hsdshdshgdvhsgdcvsd", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290402772", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290402772	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290402772	rupeeflow	hsdshdshgdvhsgdcvsd	f	2025-12-28 08:32:06.481193	2025-12-28 08:32:06.481197	\N	f	\N
45	2ce36d1e-5818-415f-b875-b357c8297e9d	PINYWJ62W60JYYR	sjdhsghjgsh	100.00	0.00	string@vpa	Mewaram jat	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "sjdhsghjgsh", "txnid": "PINYWJ62W60JYYR", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290439279", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290439279", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "sjdhsghjgsh", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290439279", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290439279	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290439279	rupeeflow	sjdhsghjgsh	f	2025-12-28 14:52:45.540248	2025-12-28 14:52:45.540254	\N	f	\N
11266	2ce36d1e-5818-415f-b875-b357c8297e9d	PIN235EVISHU33T	jhgjhgjhg	100.00	1.18	string	Mwkhejw	failed	{"status": "failed", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}", "reference_id": null, "txnid": "PIN235EVISHU33T", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "TXF", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}"}}	\N	\N	unitpay	\N	f	2026-01-08 08:26:57.23802	2026-01-08 08:26:57.238024	\N	f	\N
46	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINR2GIH1PMWTMI	ORDID3022705466	100.00	3.50	\N	Bulk ge	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID3022705466", "txnid": "PINR2GIH1PMWTMI", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290997023", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290997023", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID3022705466", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290997023", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290997023	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290997023	rupeeflow	ORDID3022705466	f	2025-12-29 04:33:25.582661	2025-12-29 04:33:25.582667	\N	f	\N
47	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PIN1D6B1IWJHOH5	ORDID1183354319	100.00	3.50	\N	Bulk ge	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID1183354319", "txnid": "PIN1D6B1IWJHOH5", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290332713", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290332713", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID1183354319", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290332713", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290332713	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290332713	rupeeflow	ORDID1183354319	f	2025-12-29 04:33:37.680622	2025-12-29 04:33:37.680627	\N	f	\N
48	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PIN78OHXWEJXY7G	ORDID1379121285	100.00	3.50	\N	Bulk ge	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID1379121285", "txnid": "PIN78OHXWEJXY7G", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290195007", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290195007", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID1379121285", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290195007", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290195007	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290195007	rupeeflow	ORDID1379121285	f	2025-12-29 05:45:32.966179	2025-12-29 05:45:32.966182	\N	f	\N
49	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PIN6FNPM3UIHOR3	ORDID1297652723	100.00	3.50	\N	Bulk ge	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID1297652723", "txnid": "PIN6FNPM3UIHOR3", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290482607", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290482607", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID1297652723", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290482607", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290482607	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290482607	rupeeflow	ORDID1297652723	f	2025-12-29 06:43:24.497492	2025-12-29 06:43:24.497496	\N	f	\N
50	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINUR7DQD6BYK1M	ORDID5786758097	120.00	4.20	\N	demo xtant	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID5786758097", "txnid": "PINUR7DQD6BYK1M", "amount": "120", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=120&cu=INR&tn=Payment+for+Order+100290793589", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=120&cu=INR&tn=Payment+for+Order+100290793589", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID5786758097", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=120&cu=INR&tn=Payment+for+Order+100290793589", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=120&cu=INR&tn=Payment+for+Order+100290793589	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=120&cu=INR&tn=Payment+for+Order+100290793589	rupeeflow	ORDID5786758097	f	2025-12-29 06:51:06.160254	2025-12-29 06:51:06.160258	\N	f	\N
108	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMFWKCV59IIS9	HC1767690934711QEU	100.00	5.90	\N	Keshav Mishraji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1497866907", "txnid": "PINMFWKCV59IIS9", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695Cd2B7678A5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695Cd2B7678A5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695Cd2B7678A5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695Cd2B7678A5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_c3695Cd2B7678A5", "upi_tr": "pt_c3695Cd2B7678A5", "txnid": "ORDID1497866907", "orderid": "ORDID1497866907", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1497866907", "rrn": "481612125866"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695Cd2B7678A5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695Cd2B7678A5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1497866907	f	2026-01-06 09:15:35.686459	2026-01-06 09:16:46.489162	481612125866	t	2026-01-06 09:16:43.369466+00
11267	2ce36d1e-5818-415f-b875-b357c8297e9d	PINGLZ4IGYKX6XN	hvngvhgv	100.00	1.18	string	Mwkhejw	failed	{"status": "failed", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}", "reference_id": null, "txnid": "PINGLZ4IGYKX6XN", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "TXF", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}"}}	\N	\N	unitpay	\N	f	2026-01-08 08:34:45.460274	2026-01-08 08:34:45.460278	\N	f	\N
114	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7ZVNXBNSRPSN	HC1767691127339L9U	100.00	5.90	\N	Kajal Kapoorkar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5330917308", "txnid": "PIN7ZVNXBNSRPSN", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CD378060D9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CD378060D9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CD378060D9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CD378060D9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b1695CD378060D9", "upi_tr": "pt_b1695CD378060D9", "txnid": "ORDID5330917308", "orderid": "ORDID5330917308", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CD378060D9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CD378060D9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5330917308	f	2026-01-06 09:18:48.258767	2026-01-06 09:18:48.258771	\N	f	\N
115	3c70dd22-df28-4a50-a034-4a378507c5bf	PINH7PUQZK68GKE	HC1767691222102K8G	100.00	5.90	\N	Shankar Vermaram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4265637159", "txnid": "PINH7PUQZK68GKE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695cD3d6BDD9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695cD3d6BDD9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695cD3d6BDD9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695cD3d6BDD9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6e695cD3d6BDD9c", "upi_tr": "pt_6e695cD3d6BDD9c", "txnid": "ORDID4265637159", "orderid": "ORDID4265637159", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695cD3d6BDD9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695cD3d6BDD9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4265637159	f	2026-01-06 09:20:23.032346	2026-01-06 09:20:23.032349	\N	f	\N
51	2ce36d1e-5818-415f-b875-b357c8297e9d	PINBRSCKHHZ5YC6	jwdbhjwehwveghw	100.00	0.00	string@vpa	Mewaram	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "jwdbhjwehwveghw", "txnid": "PINBRSCKHHZ5YC6", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290269723", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290269723", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "jwdbhjwehwveghw", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290269723", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290269723	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290269723	rupeeflow	jwdbhjwehwveghw	f	2025-12-29 09:58:17.700236	2025-12-29 09:58:17.700241	\N	f	\N
52	2ce36d1e-5818-415f-b875-b357c8297e9d	PINHJV81KUTC62I	sdbnsdvshd	100.00	0.00	string@vpa	Mewaram	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "sdbnsdvshd", "txnid": "PINHJV81KUTC62I", "amount": "100", "payment_url": "upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY8117021767002567&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "qr_text": "upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY8117021767002567&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "sdbnsdvshd", "intent": "upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY8117021767002567&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY8117021767002567&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01	upi://pay?pa=rupy.moksha1@fino&pn=Moksha1%20Private%20Limited&mc=5651&tr=PRY8117021767002567&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01	rupeeflow	sdbnsdvshd	f	2025-12-29 10:02:47.625244	2025-12-29 10:02:47.625248	\N	f	\N
53	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINVWJU41BYLNZK	ORDID8913122355	100.00	3.50	\N	demo xtant	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID8913122355", "txnid": "PINVWJU41BYLNZK", "amount": "100", "payment_url": "upi://pay?pa=rupy.futurebytestudios@fino&pn=FUTUREBYTESTUDIOS%20PRIVATE%20LIMITED&mc=5651&tr=PRY6023921767003258&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "qr_text": "upi://pay?pa=rupy.futurebytestudios@fino&pn=FUTUREBYTESTUDIOS%20PRIVATE%20LIMITED&mc=5651&tr=PRY6023921767003258&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID8913122355", "intent": "upi://pay?pa=rupy.futurebytestudios@fino&pn=FUTUREBYTESTUDIOS%20PRIVATE%20LIMITED&mc=5651&tr=PRY6023921767003258&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=rupy.futurebytestudios@fino&pn=FUTUREBYTESTUDIOS%20PRIVATE%20LIMITED&mc=5651&tr=PRY6023921767003258&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01	upi://pay?pa=rupy.futurebytestudios@fino&pn=FUTUREBYTESTUDIOS%20PRIVATE%20LIMITED&mc=5651&tr=PRY6023921767003258&tn=Shopping&am=100&cu=INR&mode=05&orgid=187064&catagory=01	rupeeflow	ORDID8913122355	f	2025-12-29 10:14:18.837618	2025-12-29 10:14:18.837622	\N	f	\N
11268	2ce36d1e-5818-415f-b875-b357c8297e9d	PINAN7DQVYVOIRQ	jhhjvghvghnvb	100.00	1.18	string	Mwkhejw	failed	{"status": "failed", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}", "reference_id": null, "txnid": "PINAN7DQVYVOIRQ", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "TXF", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}"}}	\N	\N	unitpay	\N	f	2026-01-08 08:57:54.773349	2026-01-08 08:57:54.773353	\N	f	\N
11270	ce49328b-23f5-4950-a9b4-b723fbe290c4	PINU3BKZIRO7TPS	a12312ASA001	100.00	5.31	\N	John Doe	failed	{"status": "failed", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}", "reference_id": null, "txnid": "PINU3BKZIRO7TPS", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "TXF", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}"}}	\N	\N	unitpay	\N	f	2026-01-09 07:16:51.069335	2026-01-09 07:16:51.069339	\N	f	\N
54	2ce36d1e-5818-415f-b875-b357c8297e9d	PING0RUQ16AC9O5	wshjesvghwceg	100.00	0.00	string@vpa	Akash	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "wshjesvghwceg", "txnid": "PING0RUQ16AC9O5", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290589353", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290589353", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "wshjesvghwceg", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290589353", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290589353	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290589353	rupeeflow	wshjesvghwceg	f	2025-12-30 05:39:09.654784	2025-12-30 05:39:09.654789	\N	f	\N
55	2ce36d1e-5818-415f-b875-b357c8297e9d	PINB7KV1UI03BSL	wjdgejshegwheg	100.00	0.00	string@vpa	Akash	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "wjdgejshegwheg", "txnid": "PINB7KV1UI03BSL", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290636321", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290636321", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "wjdgejshegwheg", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290636321", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290636321	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290636321	rupeeflow	wjdgejshegwheg	f	2025-12-30 05:44:10.166213	2025-12-30 05:44:10.166219	\N	f	\N
56	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHRT27KHP2ZK5	HC17670736014567CH	100.00	4.00	\N	Arjun Trivedilal	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "HC17670736014567CH", "txnid": "PINHRT27KHP2ZK5", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290837503", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290837503", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "HC17670736014567CH", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290837503", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290837503	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290837503	rupeeflow	HC17670736014567CH	f	2025-12-30 05:46:43.180189	2025-12-30 05:46:43.180193	\N	f	\N
57	3c70dd22-df28-4a50-a034-4a378507c5bf	PINM4BZLLMR5Q9M	HC1767074097047MBG	100.00	4.00	\N	Vaishali Kapoor	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "HC1767074097047MBG", "txnid": "PINM4BZLLMR5Q9M", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290702763", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290702763", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "HC1767074097047MBG", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290702763", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290702763	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290702763	rupeeflow	HC1767074097047MBG	f	2025-12-30 05:54:58.032227	2025-12-30 05:54:58.032231	\N	f	\N
58	3c70dd22-df28-4a50-a034-4a378507c5bf	PINYGLVNKO8H93D	HC1767075449598W5M	150.00	6.00	\N	Ekta Naidulal	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "HC1767075449598W5M", "txnid": "PINYGLVNKO8H93D", "amount": "150", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=150&cu=INR&tn=Payment+for+Order+100290195293", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=150&cu=INR&tn=Payment+for+Order+100290195293", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "HC1767075449598W5M", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=150&cu=INR&tn=Payment+for+Order+100290195293", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=150&cu=INR&tn=Payment+for+Order+100290195293	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=150&cu=INR&tn=Payment+for+Order+100290195293	rupeeflow	HC1767075449598W5M	f	2025-12-30 06:17:30.350902	2025-12-30 06:17:30.350906	\N	f	\N
59	3c70dd22-df28-4a50-a034-4a378507c5bf	PINONCKH1BZRH1X	HC1767077487114A26	151.00	6.04	\N	Chitra Banerjeeram	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "HC1767077487114A26", "txnid": "PINONCKH1BZRH1X", "amount": "151", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=151&cu=INR&tn=Payment+for+Order+100290595487", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=151&cu=INR&tn=Payment+for+Order+100290595487", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "HC1767077487114A26", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=151&cu=INR&tn=Payment+for+Order+100290595487", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=151&cu=INR&tn=Payment+for+Order+100290595487	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=151&cu=INR&tn=Payment+for+Order+100290595487	rupeeflow	HC1767077487114A26	f	2025-12-30 06:51:28.238842	2025-12-30 06:51:28.238846	\N	f	\N
11269	ce49328b-23f5-4950-a9b4-b723fbe290c4	PINR0K6I5UWPJWG	ZCADASDASDS001	100.00	5.31	\N	John Doe	failed	{"status": "failed", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}", "reference_id": null, "txnid": "PINR0K6I5UWPJWG", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "TXF", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}"}}	\N	\N	unitpay	\N	f	2026-01-09 07:16:32.952603	2026-01-09 07:16:32.952611	\N	f	\N
60	3c70dd22-df28-4a50-a034-4a378507c5bf	PINSTO8ZQ3TH68W	HC176707768609190S	152.00	6.08	\N	Chitra Chatterjeebabu	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "HC176707768609190S", "txnid": "PINSTO8ZQ3TH68W", "amount": "152", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=152&cu=INR&tn=Payment+for+Order+100290273877", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=152&cu=INR&tn=Payment+for+Order+100290273877", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "HC176707768609190S", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=152&cu=INR&tn=Payment+for+Order+100290273877", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=152&cu=INR&tn=Payment+for+Order+100290273877	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=152&cu=INR&tn=Payment+for+Order+100290273877	rupeeflow	HC176707768609190S	f	2025-12-30 06:54:47.00509	2025-12-30 06:54:47.005094	\N	f	\N
61	6b9b4e3b-3485-4467-8c23-2b7d21d4aeae	PINLGJL5NA2N1SN	ORDID9987087548	100.00	3.50	\N	demo xtant	pending	{"status": "success", "message": "Payment Link Generated successfully", "reference_id": "ORDID9987087548", "txnid": "PINLGJL5NA2N1SN", "amount": "100", "payment_url": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290909526", "qr_text": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290909526", "raw_response": {"statusCode": 201, "message": "Data Received", "success": true, "data": {"orderId": "ORDID9987087548", "intent": "upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290909526", "message": "Payment Link Generated successfully"}}}	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290909526	upi://pay?pa=merchant.lara800ware%40digikhata&pn=Laraware+Private+Limited&am=100&cu=INR&tn=Payment+for+Order+100290909526	rupeeflow	ORDID9987087548	f	2025-12-30 08:09:16.21245	2025-12-30 08:09:16.212454	\N	f	\N
62	2ce36d1e-5818-415f-b875-b357c8297e9d	PIND4VUCI6XYK9D	GDSHWGEYWG686757	100.00	0.00	string@gmai	Mewaram	failed	{"status": "failed", "message": "Failed to generate payment link", "reference_id": null, "txnid": "PIND4VUCI6XYK9D", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"message": "Failed to generate payment link", "error": "Bad Request", "statusCode": 400}}	\N	\N	rupeeflow	\N	f	2026-01-05 13:11:47.806128	2026-01-05 13:11:47.806136	\N	f	\N
111	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8Q84T1A99NMO	HC17676910390494PE	100.00	5.90	\N	Sheetal Bhatiababu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3207935459", "txnid": "PIN8Q84T1A99NMO", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CD31FBc8Ab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CD31FBc8Ab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CD31FBc8Ab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CD31FBc8Ab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A9695CD31FBc8Ab", "upi_tr": "pt_A9695CD31FBc8Ab", "txnid": "ORDID3207935459", "orderid": "ORDID3207935459", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3207935459", "rrn": "395016077485"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CD31FBc8Ab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CD31FBc8Ab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3207935459	f	2026-01-06 09:17:20.011649	2026-01-06 09:18:11.64596	395016077485	t	2026-01-06 09:18:09.157152+00
63	2ce36d1e-5818-415f-b875-b357c8297e9d	PINRBSIC70FZTW9	ghfhtfgfthgfc	100.00	0.00	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6625107994", "txnid": "PINRBSIC70FZTW9", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BB9c557D77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BB9c557D77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BB9c557D77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BB9c557D77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID6625107994", "orderid": "ORDID6625107994", "bankutr": "pending"}, "webhook_received": true, "orderId": "PINRBSIC70FZTW9", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BB9c557D77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BB9c557D77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID6625107994	f	2026-01-05 13:16:53.672237	2026-01-05 13:26:55.308706	\N	f	\N
64	2ce36d1e-5818-415f-b875-b357c8297e9d	PINHMRBOVLFIRQ7	SHDHGSFHTSFDA	100.00	0.00	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2959659288", "txnid": "PINHMRBOVLFIRQ7", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_3D695bBC5397B7B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_3D695bBC5397B7B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_3D695bBC5397B7B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_3D695bBC5397B7B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID2959659288", "orderid": "ORDID2959659288", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2959659288", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_3D695bBC5397B7B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_3D695bBC5397B7B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID2959659288	f	2026-01-05 13:27:47.915864	2026-01-05 13:40:09.083135	\N	f	\N
65	2ce36d1e-5818-415f-b875-b357c8297e9d	PINSM39DNT1EZZJ	sbvdbgsvdbscd	100.00	0.00	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8652839353", "txnid": "PINSM39DNT1EZZJ", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_7a695bC0001541a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_7a695bC0001541a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_7a695bC0001541a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_7a695bC0001541a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID8652839353", "orderid": "ORDID8652839353", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8652839353", "rrn": "116732508186"}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_7a695bC0001541a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_7a695bC0001541a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID8652839353	f	2026-01-05 13:43:28.378217	2026-01-05 13:44:07.205958	116732508186	f	\N
66	2ce36d1e-5818-415f-b875-b357c8297e9d	PINCU8W8398LXF9	hdgsfhgfdghfsd	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3745106444", "txnid": "PINCU8W8398LXF9", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_19695bD8cfD48A2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_19695bD8cfD48A2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_19695bD8cfD48A2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_19695bD8cfD48A2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID3745106444", "orderid": "ORDID3745106444", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3745106444", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_19695bD8cfD48A2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_19695bD8cfD48A2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID3745106444	f	2026-01-05 15:29:20.1481	2026-01-05 15:30:51.631414	\N	f	\N
121	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6RPWWKF6GB1A	HC1767691498317SU6	100.00	5.90	\N	Nandini Mehtababu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9499631022", "txnid": "PIN6RPWWKF6GB1A", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cD4eb0582a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cD4eb0582a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cD4eb0582a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cD4eb0582a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_54695cD4eb0582a", "upi_tr": "pt_54695cD4eb0582a", "txnid": "ORDID9499631022", "orderid": "ORDID9499631022", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cD4eb0582a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cD4eb0582a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9499631022	f	2026-01-06 09:24:59.26573	2026-01-06 09:24:59.265733	\N	f	\N
67	2ce36d1e-5818-415f-b875-b357c8297e9d	PINRYVI7HMJMFIF	sbdhsbdjhdghevd	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3312370049", "txnid": "PINRYVI7HMJMFIF", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_30695bda3A345f4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_30695bda3A345f4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_30695bda3A345f4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_30695bda3A345f4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID3312370049", "orderid": "ORDID3312370049", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3312370049", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_30695bda3A345f4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_30695bda3A345f4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID3312370049	f	2026-01-05 15:35:22.467312	2026-01-05 15:35:51.143536	\N	f	\N
112	3c70dd22-df28-4a50-a034-4a378507c5bf	PINN7XK7I68LL37	HC17676910834827I7	100.00	5.90	\N	Amit Menonesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5917775905", "txnid": "PINN7XK7I68LL37", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_05695Cd34C47FBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_05695Cd34C47FBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_05695Cd34C47FBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_05695Cd34C47FBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_05695Cd34C47FBb", "upi_tr": "pt_05695Cd34C47FBb", "txnid": "ORDID5917775905", "orderid": "ORDID5917775905", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5917775905", "rrn": "137453566314"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_05695Cd34C47FBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_05695Cd34C47FBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5917775905	f	2026-01-06 09:18:04.575812	2026-01-06 09:18:36.685618	137453566314	t	2026-01-06 09:18:35.335219+00
68	2ce36d1e-5818-415f-b875-b357c8297e9d	PINH00NH7OMWE3Y	dhvdhfvdahgfv	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3864183395", "txnid": "PINH00NH7OMWE3Y", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_dA695bdc8e077Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_dA695bdc8e077Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_dA695bdc8e077Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_dA695bdc8e077Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID3864183395", "orderid": "ORDID3864183395", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3864183395", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_dA695bdc8e077Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_dA695bdc8e077Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID3864183395	f	2026-01-05 15:45:18.28352	2026-01-05 15:46:18.515585	\N	f	\N
69	2ce36d1e-5818-415f-b875-b357c8297e9d	PIN468RZBX2OUAG	snbvdbnsvdbs	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8372870005", "txnid": "PIN468RZBX2OUAG", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_47695bdf496d659&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_47695bdf496d659&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_47695bdf496d659&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_47695bdf496d659&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID8372870005", "orderid": "ORDID8372870005", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8372870005", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_47695bdf496d659&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_47695bdf496d659&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID8372870005	f	2026-01-05 15:56:57.72594	2026-01-05 16:03:13.148921	\N	t	\N
70	2ce36d1e-5818-415f-b875-b357c8297e9d	PINXSYIAF4NQ2VW	sdjhgsgdsd	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2587697956", "txnid": "PINXSYIAF4NQ2VW", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_88695BE2e37e9d9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_88695BE2e37e9d9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_88695BE2e37e9d9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_88695BE2e37e9d9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID2587697956", "orderid": "ORDID2587697956", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2587697956", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_88695BE2e37e9d9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_88695BE2e37e9d9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID2587697956	f	2026-01-05 16:12:19.779699	2026-01-05 16:17:43.179627	\N	t	\N
113	3c70dd22-df28-4a50-a034-4a378507c5bf	PINL3ZJ984T3EC9	HC1767691102735ZCC	100.00	5.90	\N	Ritika Iyerendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3174362709", "txnid": "PINL3ZJ984T3EC9", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695cd35f6a736&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695cd35f6a736&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695cd35f6a736&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695cd35f6a736&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_55695cd35f6a736", "upi_tr": "pt_55695cd35f6a736", "txnid": "ORDID3174362709", "orderid": "ORDID3174362709", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3174362709", "rrn": "847218465033"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695cd35f6a736&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695cd35f6a736&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3174362709	f	2026-01-06 09:18:23.710849	2026-01-06 09:18:56.714913	847218465033	t	2026-01-06 09:18:54.222184+00
71	2ce36d1e-5818-415f-b875-b357c8297e9d	PINWTBZ6X5ZFC09	dbsndbnsd	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9300365586", "txnid": "PINWTBZ6X5ZFC09", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_B7695BE577279bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_B7695BE577279bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_B7695BE577279bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_B7695BE577279bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID9300365586", "orderid": "ORDID9300365586", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9300365586", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_B7695BE577279bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_B7695BE577279bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID9300365586	f	2026-01-05 16:23:19.421103	2026-01-05 17:12:13.209838	\N	t	\N
72	2ce36d1e-5818-415f-b875-b357c8297e9d	PINVSXO0AMBIEP8	sgdsvgdsvgefc	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7029055466", "txnid": "PINVSXO0AMBIEP8", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_Bc695BF14e7BA83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_Bc695BF14e7BA83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_Bc695BF14e7BA83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_Bc695BF14e7BA83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID7029055466", "orderid": "ORDID7029055466", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7029055466", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_Bc695BF14e7BA83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_Bc695BF14e7BA83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID7029055466	f	2026-01-05 17:13:50.786987	2026-01-05 17:15:33.798512	\N	t	\N
73	2ce36d1e-5818-415f-b875-b357c8297e9d	PINRBVH3THTJ2SR	wnhdvwgevwhge	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8671883748", "txnid": "PINRBVH3THTJ2SR", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BF37a98981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BF37a98981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BF37a98981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BF37a98981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID8671883748", "orderid": "ORDID8671883748", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8671883748", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BF37a98981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_2A695BF37a98981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID8671883748	f	2026-01-05 17:23:06.889233	2026-01-05 17:28:23.658798	\N	t	\N
74	2ce36d1e-5818-415f-b875-b357c8297e9d	PINYVNEZ1UCG1IR	whjdbwhvdesgdv	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2389699445", "txnid": "PINYVNEZ1UCG1IR", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_21695bF50E56631&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_21695bF50E56631&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_21695bF50E56631&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_21695bF50E56631&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID2389699445", "orderid": "ORDID2389699445", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2389699445", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_21695bF50E56631&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_21695bF50E56631&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID2389699445	f	2026-01-05 17:29:50.626108	2026-01-05 17:33:33.732889	\N	t	\N
75	2ce36d1e-5818-415f-b875-b357c8297e9d	PINSOA6MBMDUCK9	hjghgfhfytf	100.00	1.18	string@gmai	Mewaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6254254339", "txnid": "PINSOA6MBMDUCK9", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_eb695bfBa18AD4c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_eb695bfBa18AD4c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_eb695bfBa18AD4c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_eb695bfBa18AD4c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID6254254339", "orderid": "ORDID6254254339", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6254254339", "rrn": null}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_eb695bfBa18AD4c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_eb695bfBa18AD4c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID6254254339	f	2026-01-05 17:57:53.839346	2026-01-05 17:58:36.420954	\N	t	2026-01-05 17:58:35.066523+00
76	3c70dd22-df28-4a50-a034-4a378507c5bf	PINM99PBVJV2OW3	HC1767662396904AN1	130.00	6.14	\N	Divya Trivedinath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4415162294", "txnid": "PINM99PBVJV2OW3", "amount": "130", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695c633fC00cc&am=130.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695c633fC00cc&am=130.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695c633fC00cc&am=130.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695c633fC00cc&am=130.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4a695c633fC00cc", "upi_tr": "pt_4a695c633fC00cc", "txnid": "ORDID4415162294", "orderid": "ORDID4415162294", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695c633fC00cc&am=130.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695c633fC00cc&am=130.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4415162294	f	2026-01-06 01:20:00.131176	2026-01-06 01:20:00.132142	\N	f	\N
77	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHYSPJA07G0FT	HC1767682531087T5Q	120.00	7.08	\N	Vijay Chauhanrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4823451638", "txnid": "PINHYSPJA07G0FT", "amount": "120", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Cb1e483121&am=120.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Cb1e483121&am=120.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Cb1e483121&am=120.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Cb1e483121&am=120.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_93695Cb1e483121", "upi_tr": "pt_93695Cb1e483121", "txnid": "ORDID4823451638", "orderid": "ORDID4823451638", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Cb1e483121&am=120.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Cb1e483121&am=120.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4823451638	f	2026-01-06 06:55:32.857477	2026-01-06 06:55:32.857632	\N	f	\N
78	3c70dd22-df28-4a50-a034-4a378507c5bf	PINW08NVXFR3FAP	HC17676876702132SH	100.00	5.90	\N	Lalit Singhkar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8525966290", "txnid": "PINW08NVXFR3FAP", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695CC5F72A2D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695CC5F72A2D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695CC5F72A2D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695CC5F72A2D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Fd695CC5F72A2D2", "upi_tr": "pt_Fd695CC5F72A2D2", "txnid": "ORDID8525966290", "orderid": "ORDID8525966290", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695CC5F72A2D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695CC5F72A2D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8525966290	f	2026-01-06 08:21:11.450746	2026-01-06 08:21:11.45075	\N	f	\N
79	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCQ02WLR016SJ	HC1767687678206IZ2	200.00	11.80	\N	Kailash Patellal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7164600074", "txnid": "PINCQ02WLR016SJ", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695Cc5FeDdD71&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695Cc5FeDdD71&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695Cc5FeDdD71&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695Cc5FeDdD71&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_77695Cc5FeDdD71", "upi_tr": "pt_77695Cc5FeDdD71", "txnid": "ORDID7164600074", "orderid": "ORDID7164600074", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695Cc5FeDdD71&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695Cc5FeDdD71&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7164600074	f	2026-01-06 08:21:19.132804	2026-01-06 08:21:19.132808	\N	f	\N
80	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQ7V7TAFMY0QA	HC17676876784041OJ	200.00	11.80	\N	Sanjay Naidubabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4033721323", "txnid": "PINQ7V7TAFMY0QA", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cC5ff1B849&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cC5ff1B849&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cC5ff1B849&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cC5ff1B849&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_42695cC5ff1B849", "upi_tr": "pt_42695cC5ff1B849", "txnid": "ORDID4033721323", "orderid": "ORDID4033721323", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cC5ff1B849&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cC5ff1B849&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4033721323	f	2026-01-06 08:21:19.384282	2026-01-06 08:21:19.384287	\N	f	\N
119	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN89RLL94BZB8Y	HC1767691440657HB1	100.00	5.90	\N	Naveen Pillaiananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7329939017", "txnid": "PIN89RLL94BZB8Y", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695CD4b1815F1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695CD4b1815F1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695CD4b1815F1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695CD4b1815F1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_81695CD4b1815F1", "upi_tr": "pt_81695CD4b1815F1", "txnid": "ORDID7329939017", "orderid": "ORDID7329939017", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695CD4b1815F1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695CD4b1815F1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7329939017	f	2026-01-06 09:24:01.81577	2026-01-06 09:24:01.815776	\N	f	\N
91	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8SSVWEQQFGZ2	HC1767687715157QMW	100.00	5.90	\N	Kumar Kumarendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6827283730", "txnid": "PIN8SSVWEQQFGZ2", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695cc623dd296&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695cc623dd296&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695cc623dd296&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695cc623dd296&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_97695cc623dd296", "upi_tr": "pt_97695cc623dd296", "txnid": "ORDID6827283730", "orderid": "ORDID6827283730", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695cc623dd296&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695cc623dd296&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6827283730	f	2026-01-06 08:21:56.152445	2026-01-06 08:21:56.152449	\N	f	\N
96	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQ7L6LA0KIE7O	HC1767687720649L9T	100.00	5.90	\N	Sudhir Banerjeenath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5492736308", "txnid": "PINQ7L6LA0KIE7O", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695CC6295C12E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695CC6295C12E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695CC6295C12E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695CC6295C12E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D7695CC6295C12E", "upi_tr": "pt_D7695CC6295C12E", "txnid": "ORDID5492736308", "orderid": "ORDID5492736308", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695CC6295C12E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695CC6295C12E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5492736308	f	2026-01-06 08:22:01.653364	2026-01-06 08:22:01.653368	\N	f	\N
84	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7NTL3QGIG0VI	HC1767687687922Y7C	100.00	5.90	\N	Anjali Malhotraji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7468146646", "txnid": "PIN7NTL3QGIG0VI", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CC6089ac34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CC6089ac34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CC6089ac34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CC6089ac34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2A695CC6089ac34", "upi_tr": "pt_2A695CC6089ac34", "txnid": "ORDID7468146646", "orderid": "ORDID7468146646", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7468146646", "rrn": "099016802014"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CC6089ac34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CC6089ac34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7468146646	f	2026-01-06 08:21:28.884594	2026-01-06 08:27:09.534974	099016802014	t	2026-01-06 08:27:07.766991+00
86	3c70dd22-df28-4a50-a034-4a378507c5bf	PINS72EE0WDSVW5	HC1767687706445DIY	100.00	5.90	\N	Ekta Naiduananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1890124258", "txnid": "PINS72EE0WDSVW5", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695CC61B26172&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695CC61B26172&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695CC61B26172&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695CC61B26172&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_63695CC61B26172", "upi_tr": "pt_63695CC61B26172", "txnid": "ORDID1890124258", "orderid": "ORDID1890124258", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695CC61B26172&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695CC61B26172&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1890124258	f	2026-01-06 08:21:47.419928	2026-01-06 08:21:47.419931	\N	f	\N
88	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCEBBRVNS82SM	HC1767687708197F7R	200.00	11.80	\N	Meena Dwivedilal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6318158157", "txnid": "PINCEBBRVNS82SM", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695cc61cdC92f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695cc61cdC92f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695cc61cdC92f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695cc61cdC92f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_88695cc61cdC92f", "upi_tr": "pt_88695cc61cdC92f", "txnid": "ORDID6318158157", "orderid": "ORDID6318158157", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695cc61cdC92f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695cc61cdC92f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6318158157	f	2026-01-06 08:21:49.178423	2026-01-06 08:21:49.178427	\N	f	\N
123	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN08SIT0ZSZMXY	HC1767691685554G8I	100.00	5.90	\N	Vaishali Verma	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2168530695", "txnid": "PIN08SIT0ZSZMXY", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695CD5A64Ec03&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695CD5A64Ec03&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695CD5A64Ec03&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695CD5A64Ec03&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_CB695CD5A64Ec03", "upi_tr": "pt_CB695CD5A64Ec03", "txnid": "ORDID2168530695", "orderid": "ORDID2168530695", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695CD5A64Ec03&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695CD5A64Ec03&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2168530695	f	2026-01-06 09:28:06.597151	2026-01-06 09:28:06.597156	\N	f	\N
128	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBMMW45TFS9ET	HC1767692113873QHB	100.00	5.00	\N	Anjali Mishra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4693233281", "txnid": "PINBMMW45TFS9ET", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4E695Cd7529Cf19&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4E695Cd7529Cf19&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4E695Cd7529Cf19&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4E695Cd7529Cf19&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4E695Cd7529Cf19", "upi_tr": "pt_4E695Cd7529Cf19", "txnid": "ORDID4693233281", "orderid": "ORDID4693233281", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4E695Cd7529Cf19&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4E695Cd7529Cf19&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4693233281	f	2026-01-06 09:35:14.91761	2026-01-06 09:35:14.917614	\N	f	\N
90	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBN5ZNDV1X1VL	HC1767687709980FSP	100.00	5.90	\N	Dinesh Kapoorananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2560161918", "txnid": "PINBN5ZNDV1X1VL", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695Cc61eA24d2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695Cc61eA24d2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695Cc61eA24d2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695Cc61eA24d2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_a1695Cc61eA24d2", "upi_tr": "pt_a1695Cc61eA24d2", "txnid": "ORDID2560161918", "orderid": "ORDID2560161918", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2560161918", "rrn": "637213917550"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695Cc61eA24d2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695Cc61eA24d2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2560161918	f	2026-01-06 08:21:50.906549	2026-01-06 08:26:59.480733	637213917550	t	2026-01-06 08:26:57.114616+00
82	3c70dd22-df28-4a50-a034-4a378507c5bf	PINB1UW05P00ICG	HC17676876849550MW	200.00	11.80	\N	Deepak Chandrasekarnath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8622331585", "txnid": "PINB1UW05P00ICG", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695cC605a4259&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695cC605a4259&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695cC605a4259&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695cC605a4259&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_19695cC605a4259", "upi_tr": "pt_19695cC605a4259", "txnid": "ORDID8622331585", "orderid": "ORDID8622331585", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695cC605a4259&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695cC605a4259&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8622331585	f	2026-01-06 08:21:25.923235	2026-01-06 08:21:25.923239	\N	f	\N
85	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMU0FE7QGG8XP	HC1767687696338C6J	100.00	5.90	\N	Vaishali Kumarram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6614339885", "txnid": "PINMU0FE7QGG8XP", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e5695CC6111087D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e5695CC6111087D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e5695CC6111087D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e5695CC6111087D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e5695CC6111087D", "upi_tr": "pt_e5695CC6111087D", "txnid": "ORDID6614339885", "orderid": "ORDID6614339885", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e5695CC6111087D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e5695CC6111087D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6614339885	f	2026-01-06 08:21:37.357226	2026-01-06 08:21:37.357231	\N	f	\N
89	3c70dd22-df28-4a50-a034-4a378507c5bf	PINXFL5GPOJLQVE	HC1767687709762S11	100.00	5.90	\N	Omkar Shahendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7881850700", "txnid": "PINXFL5GPOJLQVE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CC61E70c42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CC61E70c42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CC61E70c42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CC61E70c42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_26695CC61E70c42", "upi_tr": "pt_26695CC61E70c42", "txnid": "ORDID7881850700", "orderid": "ORDID7881850700", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CC61E70c42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CC61E70c42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7881850700	f	2026-01-06 08:21:50.707566	2026-01-06 08:21:50.70757	\N	f	\N
93	3c70dd22-df28-4a50-a034-4a378507c5bf	PINX1HR1LTCY678	HC17676877175672NW	200.00	11.80	\N	Chitra Mishraendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4016030217", "txnid": "PINX1HR1LTCY678", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695CC62643656&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695CC62643656&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695CC62643656&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695CC62643656&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_24695CC62643656", "upi_tr": "pt_24695CC62643656", "txnid": "ORDID4016030217", "orderid": "ORDID4016030217", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695CC62643656&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695CC62643656&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4016030217	f	2026-01-06 08:21:58.510668	2026-01-06 08:21:58.510672	\N	f	\N
116	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6SGFXRLHGUUE	HC1767691222050YTU	100.00	5.90	\N	Asha Goyalnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2047954660", "txnid": "PIN6SGFXRLHGUUE", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695cD3d6c233C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695cD3d6c233C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695cD3d6c233C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695cD3d6c233C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_28695cD3d6c233C", "upi_tr": "pt_28695cD3d6c233C", "txnid": "ORDID2047954660", "orderid": "ORDID2047954660", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2047954660", "rrn": "314290617830"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695cD3d6c233C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695cD3d6c233C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2047954660	f	2026-01-06 09:20:23.054718	2026-01-06 09:21:51.850505	314290617830	t	2026-01-06 09:21:49.325672+00
92	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0KVTR4CRQSXQ	HC17676877157605PQ	100.00	5.90	\N	Radhika Duttaappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1762225775", "txnid": "PIN0KVTR4CRQSXQ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cC6246B033&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cC6246B033&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cC6246B033&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cC6246B033&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_63695cC6246B033", "upi_tr": "pt_63695cC6246B033", "txnid": "ORDID1762225775", "orderid": "ORDID1762225775", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cC6246B033&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cC6246B033&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1762225775	f	2026-01-06 08:21:56.690357	2026-01-06 08:21:56.69036	\N	f	\N
94	3c70dd22-df28-4a50-a034-4a378507c5bf	PINY2SINFGT9KWK	HC1767687718257BIM	200.00	11.80	\N	Asha Mishraananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7040659037", "txnid": "PINY2SINFGT9KWK", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e7695Cc626eEa72&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e7695Cc626eEa72&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e7695Cc626eEa72&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e7695Cc626eEa72&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e7695Cc626eEa72", "upi_tr": "pt_e7695Cc626eEa72", "txnid": "ORDID7040659037", "orderid": "ORDID7040659037", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e7695Cc626eEa72&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e7695Cc626eEa72&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7040659037	f	2026-01-06 08:21:59.25314	2026-01-06 08:21:59.253144	\N	f	\N
97	3c70dd22-df28-4a50-a034-4a378507c5bf	PINE5E6MTFU4FDX	HC1767687724544O6O	100.00	5.90	\N	Kailash Choprarao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2275520290", "txnid": "PINE5E6MTFU4FDX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695cC62D41FFC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695cC62D41FFC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695cC62D41FFC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695cC62D41FFC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_72695cC62D41FFC", "upi_tr": "pt_72695cC62D41FFC", "txnid": "ORDID2275520290", "orderid": "ORDID2275520290", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695cC62D41FFC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695cC62D41FFC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2275520290	f	2026-01-06 08:22:05.564316	2026-01-06 08:22:05.564322	\N	f	\N
100	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJF1BA9T7XFF9	HC1767687736482M0S	100.00	5.90	\N	Sunita Mathurram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8161574059", "txnid": "PINJF1BA9T7XFF9", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695Cc63931e83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695Cc63931e83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695Cc63931e83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695Cc63931e83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_33695Cc63931e83", "upi_tr": "pt_33695Cc63931e83", "txnid": "ORDID8161574059", "orderid": "ORDID8161574059", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695Cc63931e83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695Cc63931e83&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8161574059	f	2026-01-06 08:22:17.473662	2026-01-06 08:22:17.473666	\N	f	\N
118	3c70dd22-df28-4a50-a034-4a378507c5bf	PINOHI0PQPF1BQA	HC1767691427985GHN	100.00	5.90	\N	Omkar Yadavbabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2393928629", "txnid": "PINOHI0PQPF1BQA", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695Cd4a4B49c9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695Cd4a4B49c9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695Cd4a4B49c9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695Cd4a4B49c9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6A695Cd4a4B49c9", "upi_tr": "pt_6A695Cd4a4B49c9", "txnid": "ORDID2393928629", "orderid": "ORDID2393928629", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2393928629", "rrn": "600681926871"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695Cd4a4B49c9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695Cd4a4B49c9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2393928629	f	2026-01-06 09:23:48.983593	2026-01-06 09:24:26.980341	600681926871	t	2026-01-06 09:24:26.903975+00
120	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7YSYEO8YF1E6	HC17676914905444DL	100.00	5.90	\N	Dinesh Kapoorrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9523790136", "txnid": "PIN7YSYEO8YF1E6", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695CD4E3349c3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695CD4E3349c3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695CD4E3349c3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695CD4E3349c3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_85695CD4E3349c3", "upi_tr": "pt_85695CD4E3349c3", "txnid": "ORDID9523790136", "orderid": "ORDID9523790136", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695CD4E3349c3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695CD4E3349c3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9523790136	f	2026-01-06 09:24:51.45172	2026-01-06 09:24:51.451725	\N	f	\N
151	3c70dd22-df28-4a50-a034-4a378507c5bf	PINXKQ60TAMYUPP	HC1767693566733KTP	100.00	5.00	\N	Lakshmi Nairnath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6801198460", "txnid": "PINXKQ60TAMYUPP", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695cDCFF85b10&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695cDCFF85b10&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695cDCFF85b10&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695cDCFF85b10&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d8695cDCFF85b10", "upi_tr": "pt_d8695cDCFF85b10", "txnid": "ORDID6801198460", "orderid": "ORDID6801198460", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695cDCFF85b10&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695cDCFF85b10&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6801198460	f	2026-01-06 09:59:27.809298	2026-01-06 09:59:27.809301	\N	f	\N
125	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8A44JC510BHI	HC1767691780889024	100.00	5.90	\N	Nikhil Choprarao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6572973375", "txnid": "PIN8A44JC510BHI", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695cD60590671&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695cD60590671&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695cD60590671&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695cD60590671&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1f695cD60590671", "upi_tr": "pt_1f695cD60590671", "txnid": "ORDID6572973375", "orderid": "ORDID6572973375", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695cD60590671&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695cD60590671&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6572973375	f	2026-01-06 09:29:41.843993	2026-01-06 09:29:41.843997	\N	f	\N
126	3c70dd22-df28-4a50-a034-4a378507c5bf	PINOF599DIKSDF6	HC1767691791926KSD	100.00	5.90	\N	Lalit Nairji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7820809397", "txnid": "PINOF599DIKSDF6", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Cd61099203&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Cd61099203&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Cd61099203&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Cd61099203&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d6695Cd61099203", "upi_tr": "pt_d6695Cd61099203", "txnid": "ORDID7820809397", "orderid": "ORDID7820809397", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Cd61099203&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Cd61099203&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7820809397	f	2026-01-06 09:29:52.890591	2026-01-06 09:29:52.890596	\N	f	\N
98	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1EKCF0LULY0R	HC17676877262594FW	100.00	5.90	\N	Asha Duttaendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2640809844", "txnid": "PIN1EKCF0LULY0R", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ad695Cc62F00E62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ad695Cc62F00E62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ad695Cc62F00E62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ad695Cc62F00E62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_ad695Cc62F00E62", "upi_tr": "pt_ad695Cc62F00E62", "txnid": "ORDID2640809844", "orderid": "ORDID2640809844", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2640809844", "rrn": "783912178405"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ad695Cc62F00E62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ad695Cc62F00E62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2640809844	f	2026-01-06 08:22:07.277769	2026-01-06 08:27:29.592266	783912178405	t	2026-01-06 08:27:29.494093+00
220	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7SM1I1DWULPV	HC1767696024383P22	100.00	5.00	\N	Kailash Kulkarnibabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8090056024", "txnid": "PIN7SM1I1DWULPV", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE6991c44A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE6991c44A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE6991c44A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE6991c44A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_56695cE6991c44A", "upi_tr": "pt_56695cE6991c44A", "txnid": "ORDID8090056024", "orderid": "ORDID8090056024", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE6991c44A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE6991c44A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8090056024	f	2026-01-06 10:40:25.371168	2026-01-06 10:40:25.371171	\N	f	\N
221	3c70dd22-df28-4a50-a034-4a378507c5bf	PINP6ZVU9XVVVLI	HC1767696039458834	200.00	10.00	\N	Zoya Chauhanram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5292143277", "txnid": "PINP6ZVU9XVVVLI", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3a695ce6a829923&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3a695ce6a829923&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3a695ce6a829923&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3a695ce6a829923&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_3a695ce6a829923", "upi_tr": "pt_3a695ce6a829923", "txnid": "ORDID5292143277", "orderid": "ORDID5292143277", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3a695ce6a829923&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3a695ce6a829923&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5292143277	f	2026-01-06 10:40:40.412347	2026-01-06 10:40:40.412352	\N	f	\N
83	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQ34PCRGB4W3W	HC1767687685888GZ4	100.00	5.90	\N	Manoj Desaikar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8877258194", "txnid": "PINQ34PCRGB4W3W", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695cC60699E51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695cC60699E51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695cC60699E51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695cC60699E51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_29695cC60699E51", "upi_tr": "pt_29695cC60699E51", "txnid": "ORDID8877258194", "orderid": "ORDID8877258194", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8877258194", "rrn": "851054595716"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695cC60699E51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695cC60699E51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8877258194	f	2026-01-06 08:21:26.896538	2026-01-06 08:26:44.414301	851054595716	t	2026-01-06 08:26:42.382753+00
153	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7OSHSIVPWW0W	HC1767693642591FHQ	100.00	5.00	\N	Komal Reddyappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5710737237", "txnid": "PIN7OSHSIVPWW0W", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cDD4b480d4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cDD4b480d4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cDD4b480d4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cDD4b480d4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_68695cDD4b480d4", "upi_tr": "pt_68695cDD4b480d4", "txnid": "ORDID5710737237", "orderid": "ORDID5710737237", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cDD4b480d4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cDD4b480d4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5710737237	f	2026-01-06 10:00:43.55628	2026-01-06 10:00:43.556284	\N	f	\N
124	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBL2UHCALXEJB	HC1767691715622I70	100.00	5.90	\N	Prakash Thakurananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8711356381", "txnid": "PINBL2UHCALXEJB", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695CD5C44F0f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695CD5C44F0f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695CD5C44F0f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695CD5C44F0f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A0695CD5C44F0f7", "upi_tr": "pt_A0695CD5C44F0f7", "txnid": "ORDID8711356381", "orderid": "ORDID8711356381", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8711356381", "rrn": "515208511016"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695CD5C44F0f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695CD5C44F0f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8711356381	f	2026-01-06 09:28:36.578591	2026-01-06 09:31:15.764812	515208511016	t	2026-01-06 09:31:14.921574+00
81	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV3QBU5YX2G0Y	HC1767687678955VXC	100.00	5.90	\N	Rekha Pandeylal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6397299203", "txnid": "PINV3QBU5YX2G0Y", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695CC5FFA2d71&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695CC5FFA2d71&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695CC5FFA2d71&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695CC5FFA2d71&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B4695CC5FFA2d71", "upi_tr": "pt_B4695CC5FFA2d71", "txnid": "ORDID6397299203", "orderid": "ORDID6397299203", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6397299203", "rrn": "600680916913"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695CC5FFA2d71&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695CC5FFA2d71&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6397299203	f	2026-01-06 08:21:19.908445	2026-01-06 08:26:54.448208	600680916913	t	2026-01-06 08:26:52.352637+00
11271	ce49328b-23f5-4950-a9b4-b723fbe290c4	PIN4C5XMQY8T2QO	a12312ASA007	100.00	5.31	\N	John Doe	failed	{"status": "failed", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}", "reference_id": null, "txnid": "PIN4C5XMQY8T2QO", "amount": "100", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "TXF", "message": "{\\"statuscode\\":\\"FAILED\\",\\"status\\":\\"failed\\",\\"message\\":\\"ERROR:901\\"}"}}	\N	\N	unitpay	\N	f	2026-01-09 07:19:08.41207	2026-01-09 07:19:08.412074	\N	f	\N
11272	350c1879-98e4-44b1-8b39-b39e5ffd9836	PINVCPY884HWVLC	ref_1767979189	10.00	0.59	\N	John Doe	failed	{"status": "failed", "message": "The amount must be at least 50.", "reference_id": null, "txnid": "PINVCPY884HWVLC", "amount": "10", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "ERR", "status": "ERR", "message": "The amount must be at least 50."}}	\N	\N	unitpay	\N	f	2026-01-09 17:19:51.949635	2026-01-09 17:19:51.949765	\N	f	\N
87	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBTSKF89PXNJN	HC1767687708112DCJ	100.00	5.90	\N	Keshav Goyallal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2893115539", "txnid": "PINBTSKF89PXNJN", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CC61cd3ba0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CC61cd3ba0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CC61cd3ba0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CC61cd3ba0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E2695CC61cd3ba0", "upi_tr": "pt_E2695CC61cd3ba0", "txnid": "ORDID2893115539", "orderid": "ORDID2893115539", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2893115539", "rrn": "935664308924"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CC61cd3ba0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CC61cd3ba0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2893115539	f	2026-01-06 08:21:49.13836	2026-01-06 08:26:59.507664	935664308924	t	2026-01-06 08:26:57.418933+00
95	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBJ9I7EBAY8O2	HC1767687718880059	100.00	5.90	\N	Tanvi Patelkar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4034883764", "txnid": "PINBJ9I7EBAY8O2", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E0695Cc627860C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E0695Cc627860C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E0695Cc627860C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E0695Cc627860C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E0695Cc627860C0", "upi_tr": "pt_E0695Cc627860C0", "txnid": "ORDID4034883764", "orderid": "ORDID4034883764", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4034883764", "rrn": "600645020930"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E0695Cc627860C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E0695Cc627860C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4034883764	f	2026-01-06 08:21:59.813406	2026-01-06 08:27:19.559557	600645020930	t	2026-01-06 08:27:17.478936+00
99	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN577PCNKFQTAA	HC1767687729492Y4C	100.00	5.90	\N	Yamini Shahesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2744929175", "txnid": "PIN577PCNKFQTAA", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Da695cC63228d8F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Da695cC63228d8F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Da695cC63228d8F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Da695cC63228d8F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Da695cC63228d8F", "upi_tr": "pt_Da695cC63228d8F", "txnid": "ORDID2744929175", "orderid": "ORDID2744929175", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2744929175", "rrn": "644503142524"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Da695cC63228d8F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Da695cC63228d8F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2744929175	f	2026-01-06 08:22:10.402112	2026-01-06 08:27:44.628655	644503142524	t	2026-01-06 08:27:40.221275+00
122	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIIUV01ZTQMRH	HC1767691613995RWN	100.00	5.90	\N	Ravi Bhatiaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9561493921", "txnid": "PINIIUV01ZTQMRH", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EC695Cd55eB9802&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EC695Cd55eB9802&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EC695Cd55eB9802&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EC695Cd55eB9802&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_EC695Cd55eB9802", "upi_tr": "pt_EC695Cd55eB9802", "txnid": "ORDID9561493921", "orderid": "ORDID9561493921", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9561493921", "rrn": "641163736402"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EC695Cd55eB9802&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EC695Cd55eB9802&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9561493921	f	2026-01-06 09:26:55.025712	2026-01-06 09:27:37.132235	641163736402	t	2026-01-06 09:27:35.876087+00
101	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKBOYFN3L0NBL	HC1767687742319HQH	100.00	5.90	\N	Shruti Guptaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9594303884", "txnid": "PINKBOYFN3L0NBL", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695cC63f05Ba5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695cC63f05Ba5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695cC63f05Ba5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695cC63f05Ba5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0D695cC63f05Ba5", "upi_tr": "pt_0D695cC63f05Ba5", "txnid": "ORDID9594303884", "orderid": "ORDID9594303884", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9594303884", "rrn": "362400846386"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695cC63f05Ba5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695cC63f05Ba5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9594303884	f	2026-01-06 08:22:23.288048	2026-01-06 08:27:54.659626	362400846386	t	2026-01-06 08:27:49.866556+00
127	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1NQZB577BJOI	HC1767692017289F3C	100.00	5.00	\N	Tanvi Bhatiakar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9048580522", "txnid": "PIN1NQZB577BJOI", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695cD6f2033Df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695cD6f2033Df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695cD6f2033Df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695cD6f2033Df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e4695cD6f2033Df", "upi_tr": "pt_e4695cD6f2033Df", "txnid": "ORDID9048580522", "orderid": "ORDID9048580522", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695cD6f2033Df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695cD6f2033Df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9048580522	f	2026-01-06 09:33:38.264663	2026-01-06 09:33:38.264667	\N	f	\N
222	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGNGTTYF8S9QX	HC1767696042406IC4	100.00	5.00	\N	Lakshmi Dasbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6029952335", "txnid": "PINGNGTTYF8S9QX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695Ce6aB2155D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695Ce6aB2155D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695Ce6aB2155D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695Ce6aB2155D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Cd695Ce6aB2155D", "upi_tr": "pt_Cd695Ce6aB2155D", "txnid": "ORDID6029952335", "orderid": "ORDID6029952335", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695Ce6aB2155D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695Ce6aB2155D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6029952335	f	2026-01-06 10:40:43.396812	2026-01-06 10:40:43.396816	\N	f	\N
237	3c70dd22-df28-4a50-a034-4a378507c5bf	PINO42ZVQIR739B	HC1767696258682UH1	200.00	10.00	\N	Ankita Mathurrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4132458671", "txnid": "PINO42ZVQIR739B", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695Ce783646B6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695Ce783646B6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695Ce783646B6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695Ce783646B6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8D695Ce783646B6", "upi_tr": "pt_8D695Ce783646B6", "txnid": "ORDID4132458671", "orderid": "ORDID4132458671", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695Ce783646B6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695Ce783646B6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4132458671	f	2026-01-06 10:44:19.67115	2026-01-06 10:44:19.671154	\N	f	\N
152	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7O1AD3S41OJT	HC1767693599826VOO	100.00	5.00	\N	Ashok Naiduji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3903885829", "txnid": "PIN7O1AD3S41OJT", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695CDd207cB4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695CDd207cB4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695CDd207cB4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695CDd207cB4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_94695CDd207cB4d", "upi_tr": "pt_94695CDd207cB4d", "txnid": "ORDID3903885829", "orderid": "ORDID3903885829", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3903885829", "rrn": "600655073605"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695CDd207cB4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695CDd207cB4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3903885829	f	2026-01-06 10:00:00.783163	2026-01-06 10:00:42.205192	600655073605	t	2026-01-06 10:00:38.291133+00
313	3c70dd22-df28-4a50-a034-4a378507c5bf	PINVHS4BC4KP4NG	HC1767697547865SCS	200.00	10.00	\N	Meena Shahkar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2837399436", "txnid": "PINVHS4BC4KP4NG", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695Cec8c957A4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695Cec8c957A4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695Cec8c957A4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695Cec8c957A4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_43695Cec8c957A4", "upi_tr": "pt_43695Cec8c957A4", "txnid": "ORDID2837399436", "orderid": "ORDID2837399436", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695Cec8c957A4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695Cec8c957A4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2837399436	f	2026-01-06 11:05:48.88138	2026-01-06 11:05:48.881384	\N	f	\N
130	3c70dd22-df28-4a50-a034-4a378507c5bf	PINYBUBTH139KDA	HC1767692223426KN1	100.00	5.00	\N	Ankita Vermaappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6937604637", "txnid": "PINYBUBTH139KDA", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695cD7c0266aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695cD7c0266aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695cD7c0266aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695cD7c0266aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_81695cD7c0266aE", "upi_tr": "pt_81695cD7c0266aE", "txnid": "ORDID6937604637", "orderid": "ORDID6937604637", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6937604637", "rrn": "794494608700"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695cD7c0266aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695cD7c0266aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6937604637	f	2026-01-06 09:37:04.41406	2026-01-06 09:37:41.000115	794494608700	t	2026-01-06 09:37:39.594299+00
131	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGSRZU7LZ0JC8	HC176769228245504S	100.00	5.00	\N	Yogesh Iyer	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1232071858", "txnid": "PINGSRZU7LZ0JC8", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ea695Cd7fB3fDa8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ea695Cd7fB3fDa8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ea695Cd7fB3fDa8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ea695Cd7fB3fDa8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Ea695Cd7fB3fDa8", "upi_tr": "pt_Ea695Cd7fB3fDa8", "txnid": "ORDID1232071858", "orderid": "ORDID1232071858", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1232071858", "rrn": "418179776794"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ea695Cd7fB3fDa8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ea695Cd7fB3fDa8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1232071858	f	2026-01-06 09:38:03.502254	2026-01-06 09:38:51.085926	418179776794	t	2026-01-06 09:38:48.001171+00
238	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBUC82EOPANN4	HC1767696288389YIT	100.00	5.00	\N	Savita Kulkarniram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2889160482", "txnid": "PINBUC82EOPANN4", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695Ce7A12535E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695Ce7A12535E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695Ce7A12535E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695Ce7A12535E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e8695Ce7A12535E", "upi_tr": "pt_e8695Ce7A12535E", "txnid": "ORDID2889160482", "orderid": "ORDID2889160482", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695Ce7A12535E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695Ce7A12535E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2889160482	f	2026-01-06 10:44:49.403831	2026-01-06 10:44:49.403855	\N	f	\N
225	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQWB9ZY6JD2CL	HC1767696092976RSZ	200.00	10.00	\N	Manisha Yadavrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8162986852", "txnid": "PINQWB9ZY6JD2CL", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cB695Ce6ddb017f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cB695Ce6ddb017f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cB695Ce6ddb017f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cB695Ce6ddb017f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_cB695Ce6ddb017f", "upi_tr": "pt_cB695Ce6ddb017f", "txnid": "ORDID8162986852", "orderid": "ORDID8162986852", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cB695Ce6ddb017f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cB695Ce6ddb017f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8162986852	f	2026-01-06 10:41:33.972399	2026-01-06 10:41:33.972402	\N	f	\N
129	3c70dd22-df28-4a50-a034-4a378507c5bf	PINH90BAAMQK2RM	HC1767692196891TVT	100.00	5.00	\N	Yogesh Dubey	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9289617521", "txnid": "PINH90BAAMQK2RM", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695cd7A58fB39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695cd7A58fB39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695cd7A58fB39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695cd7A58fB39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_3F695cd7A58fB39", "upi_tr": "pt_3F695cd7A58fB39", "txnid": "ORDID9289617521", "orderid": "ORDID9289617521", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9289617521", "rrn": "392808004500"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695cd7A58fB39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695cd7A58fB39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9289617521	f	2026-01-06 09:36:37.845374	2026-01-06 09:37:46.025228	392808004500	t	2026-01-06 09:37:41.50418+00
133	3c70dd22-df28-4a50-a034-4a378507c5bf	PINWWUIQPQCIPD0	HC1767692574256MRR	100.00	5.00	\N	Pallavi Chandrasekarji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4631111850", "txnid": "PINWWUIQPQCIPD0", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cD91EF3cd0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cD91EF3cd0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cD91EF3cd0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cD91EF3cd0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_27695cD91EF3cd0", "upi_tr": "pt_27695cD91EF3cd0", "txnid": "ORDID4631111850", "orderid": "ORDID4631111850", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cD91EF3cd0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cD91EF3cd0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4631111850	f	2026-01-06 09:42:55.253641	2026-01-06 09:42:55.253645	\N	f	\N
135	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2RUB60CPQXAK	HC1767692647281D8U	100.00	5.00	\N	Ritika Dasendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1809815615", "txnid": "PIN2RUB60CPQXAK", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695Cd967F07B3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695Cd967F07B3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695Cd967F07B3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695Cd967F07B3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_81695Cd967F07B3", "upi_tr": "pt_81695Cd967F07B3", "txnid": "ORDID1809815615", "orderid": "ORDID1809815615", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695Cd967F07B3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695Cd967F07B3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1809815615	f	2026-01-06 09:44:08.252346	2026-01-06 09:44:08.25235	\N	f	\N
138	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQXAPD25TE66X	HC1767692862325QVJ	100.00	5.00	\N	Keshav Raoish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7937541058", "txnid": "PINQXAPD25TE66X", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695Cda3f0ac5E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695Cda3f0ac5E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695Cda3f0ac5E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695Cda3f0ac5E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_99695Cda3f0ac5E", "upi_tr": "pt_99695Cda3f0ac5E", "txnid": "ORDID7937541058", "orderid": "ORDID7937541058", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695Cda3f0ac5E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695Cda3f0ac5E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7937541058	f	2026-01-06 09:47:43.302745	2026-01-06 09:47:43.30275	\N	f	\N
155	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9TUPSQADSA8W	HC17676937977043RU	100.00	5.00	\N	Ganesh Kapoorish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7080282875", "txnid": "PIN9TUPSQADSA8W", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695cddE66E4a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695cddE66E4a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695cddE66E4a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695cddE66E4a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7C695cddE66E4a6", "upi_tr": "pt_7C695cddE66E4a6", "txnid": "ORDID7080282875", "orderid": "ORDID7080282875", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695cddE66E4a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695cddE66E4a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7080282875	f	2026-01-06 10:03:18.757542	2026-01-06 10:03:18.757547	\N	f	\N
132	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKA8ECYU2F9XQ	HC176769253283599F	100.00	5.00	\N	Mohan Dwivediappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2497403346", "txnid": "PINKA8ECYU2F9XQ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cD8F58e885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cD8F58e885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cD8F58e885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cD8F58e885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_82695cD8F58e885", "upi_tr": "pt_82695cD8F58e885", "txnid": "ORDID2497403346", "orderid": "ORDID2497403346", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2497403346", "rrn": "256694017979"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cD8F58e885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cD8F58e885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2497403346	f	2026-01-06 09:42:13.831761	2026-01-06 09:42:46.248055	256694017979	t	2026-01-06 09:42:44.69108+00
156	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5QRNYUMMHUD9	HC1767693925806OEM	100.00	5.00	\N	Harish Kulkarniananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1246442927", "txnid": "PIN5QRNYUMMHUD9", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bC695cDE6679cf0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bC695cDE6679cf0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bC695cDE6679cf0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bC695cDE6679cf0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_bC695cDE6679cf0", "upi_tr": "pt_bC695cDE6679cf0", "txnid": "ORDID1246442927", "orderid": "ORDID1246442927", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1246442927", "rrn": "600662611270"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bC695cDE6679cf0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bC695cDE6679cf0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1246442927	f	2026-01-06 10:05:26.744361	2026-01-06 10:06:07.445839	600662611270	t	2026-01-06 10:06:07.136453+00
342	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5X7PB0EM7PZL	HC1767697965112YIH	100.00	5.00	\N	Chitra Joshiappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6049057384", "txnid": "PIN5X7PB0EM7PZL", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_74695cee2DC9372&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_74695cee2DC9372&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_74695cee2DC9372&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_74695cee2DC9372&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_74695cee2DC9372", "upi_tr": "pt_74695cee2DC9372", "txnid": "ORDID6049057384", "orderid": "ORDID6049057384", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_74695cee2DC9372&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_74695cee2DC9372&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6049057384	f	2026-01-06 11:12:46.090196	2026-01-06 11:12:46.090201	\N	f	\N
349	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV7JIB0GB2U6Y	HC1767698044473XOT	100.00	5.00	\N	Vaishali Menonkar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8402257142", "txnid": "PINV7JIB0GB2U6Y", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0a695cEe7d3f2a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0a695cEe7d3f2a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0a695cEe7d3f2a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0a695cEe7d3f2a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0a695cEe7d3f2a4", "upi_tr": "pt_0a695cEe7d3f2a4", "txnid": "ORDID8402257142", "orderid": "ORDID8402257142", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0a695cEe7d3f2a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0a695cEe7d3f2a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8402257142	f	2026-01-06 11:14:05.52222	2026-01-06 11:14:05.522224	\N	f	\N
160	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6MKX1FSJDS9A	HC17676941136479PV	100.00	5.00	\N	Ankita Dwivedilal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4915061542", "txnid": "PIN6MKX1FSJDS9A", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1a695CdF2251C61&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1a695CdF2251C61&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1a695CdF2251C61&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1a695CdF2251C61&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1a695CdF2251C61", "upi_tr": "pt_1a695CdF2251C61", "txnid": "ORDID4915061542", "orderid": "ORDID4915061542", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1a695CdF2251C61&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1a695CdF2251C61&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4915061542	f	2026-01-06 10:08:34.606235	2026-01-06 10:08:34.606238	\N	f	\N
154	3c70dd22-df28-4a50-a034-4a378507c5bf	PINF57976F5MPVV	HC1767693773983WJQ	100.00	5.00	\N	Kiran Dasendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4048220239", "txnid": "PINF57976F5MPVV", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D0695CddCEAFe8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D0695CddCEAFe8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D0695CddCEAFe8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D0695CddCEAFe8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D0695CddCEAFe8E", "upi_tr": "pt_D0695CddCEAFe8E", "txnid": "ORDID4048220239", "orderid": "ORDID4048220239", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4048220239", "rrn": "600686532689"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D0695CddCEAFe8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D0695CddCEAFe8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4048220239	f	2026-01-06 10:02:54.969684	2026-01-06 10:03:47.3385	600686532689	t	2026-01-06 10:03:46.252132+00
136	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1WEP54SO5I26	HC1767692694278B2D	100.00	5.00	\N	Mahesh Naidulal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6029414486", "txnid": "PIN1WEP54SO5I26", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd996eB254&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd996eB254&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd996eB254&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd996eB254&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_11695cd996eB254", "upi_tr": "pt_11695cd996eB254", "txnid": "ORDID6029414486", "orderid": "ORDID6029414486", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6029414486", "rrn": "637205871054"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd996eB254&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695cd996eB254&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6029414486	f	2026-01-06 09:44:55.1976	2026-01-06 09:45:31.365504	637205871054	t	2026-01-06 09:45:27.35387+00
134	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJJ32TA44CK34	HC1767692633977S98	100.00	5.00	\N	Mahesh Mehtanath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7118505266", "txnid": "PINJJ32TA44CK34", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fe695cD95AA79FD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fe695cD95AA79FD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fe695cD95AA79FD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fe695cD95AA79FD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_fe695cD95AA79FD", "upi_tr": "pt_fe695cD95AA79FD", "txnid": "ORDID7118505266", "orderid": "ORDID7118505266", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7118505266", "rrn": "637251521540"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fe695cD95AA79FD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fe695cD95AA79FD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7118505266	f	2026-01-06 09:43:54.961657	2026-01-06 09:45:36.387459	637251521540	t	2026-01-06 09:45:33.891587+00
137	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDJX99K5PSL8L	HC1767692728335UFG	100.00	5.00	\N	Chandan Guptaji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9316951434", "txnid": "PINDJX99K5PSL8L", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c6695CD9b9b78Ad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c6695CD9b9b78Ad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c6695CD9b9b78Ad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c6695CD9b9b78Ad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_c6695CD9b9b78Ad", "upi_tr": "pt_c6695CD9b9b78Ad", "txnid": "ORDID9316951434", "orderid": "ORDID9316951434", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9316951434", "rrn": "395017537168"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c6695CD9b9b78Ad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c6695CD9b9b78Ad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9316951434	f	2026-01-06 09:45:29.998903	2026-01-06 09:46:21.42992	395017537168	t	2026-01-06 09:46:21.035474+00
139	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4AGVNGZ6QSHP	HC176769294718642L	100.00	5.00	\N	Manoj Vermababu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3106786940", "txnid": "PIN4AGVNGZ6QSHP", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695cdA93E925C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695cdA93E925C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695cdA93E925C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695cdA93E925C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E2695cdA93E925C", "upi_tr": "pt_E2695cdA93E925C", "txnid": "ORDID3106786940", "orderid": "ORDID3106786940", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3106786940", "rrn": "079740284181"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695cdA93E925C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695cdA93E925C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3106786940	f	2026-01-06 09:49:08.22972	2026-01-06 09:49:41.564768	079740284181	t	2026-01-06 09:49:41.22433+00
140	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKBC92W17J42R	HC1767692967836GE7	100.00	5.00	\N	Ashok Naidukar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8743157891", "txnid": "PINKBC92W17J42R", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cdaa89bc36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cdaa89bc36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cdaa89bc36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cdaa89bc36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_27695cdaa89bc36", "upi_tr": "pt_27695cdaa89bc36", "txnid": "ORDID8743157891", "orderid": "ORDID8743157891", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8743157891", "rrn": "116768335200"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cdaa89bc36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695cdaa89bc36&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8743157891	f	2026-01-06 09:49:28.872651	2026-01-06 09:50:11.617467	116768335200	t	2026-01-06 09:50:09.300136+00
141	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN42I8B06JAB5J	HC17676931203660UA	100.00	5.00	\N	Pooja Chandrasekarappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3328233854", "txnid": "PIN42I8B06JAB5J", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695cDb411737c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695cDb411737c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695cDb411737c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695cDb411737c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0d695cDb411737c", "upi_tr": "pt_0d695cDb411737c", "txnid": "ORDID3328233854", "orderid": "ORDID3328233854", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3328233854", "rrn": "600682374192"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695cDb411737c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695cDb411737c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3328233854	f	2026-01-06 09:52:01.346255	2026-01-06 09:52:41.710378	600682374192	t	2026-01-06 09:52:38.607973+00
147	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHZRXXXQM8YPB	HC17676932786929W8	100.00	5.00	\N	Raghav Shahish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8195904670", "txnid": "PINHZRXXXQM8YPB", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695CdBdf5FdAa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695CdBdf5FdAa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695CdBdf5FdAa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695CdBdf5FdAa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9F695CdBdf5FdAa", "upi_tr": "pt_9F695CdBdf5FdAa", "txnid": "ORDID8195904670", "orderid": "ORDID8195904670", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8195904670", "rrn": "760493177508"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695CdBdf5FdAa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695CdBdf5FdAa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8195904670	f	2026-01-06 09:54:39.635463	2026-01-06 09:55:11.860563	760493177508	t	2026-01-06 09:55:07.645148+00
142	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHNKKUYASNE7C	HC17676931533899PC	100.00	5.00	\N	Zoya Jainappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5960779803", "txnid": "PINHNKKUYASNE7C", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695cDb621eb57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695cDb621eb57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695cDb621eb57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695cDb621eb57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_47695cDb621eb57", "upi_tr": "pt_47695cDb621eb57", "txnid": "ORDID5960779803", "orderid": "ORDID5960779803", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5960779803", "rrn": "696902397298"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695cDb621eb57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695cDb621eb57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5960779803	f	2026-01-06 09:52:34.382497	2026-01-06 09:53:06.745856	696902397298	t	2026-01-06 09:53:06.458717+00
157	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN717M9KZ2VDJ3	HC1767693989136PK4	100.00	5.00	\N	Monika Kumarbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6758070402", "txnid": "PIN717M9KZ2VDJ3", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cDEa5d417B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cDEa5d417B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cDEa5d417B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cDEa5d417B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_62695cDEa5d417B", "upi_tr": "pt_62695cDEa5d417B", "txnid": "ORDID6758070402", "orderid": "ORDID6758070402", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cDEa5d417B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cDEa5d417B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6758070402	f	2026-01-06 10:06:30.145371	2026-01-06 10:06:30.145375	\N	f	\N
159	3c70dd22-df28-4a50-a034-4a378507c5bf	PINW9N5T4JWI1B0	HC1767694045488UBX	100.00	5.00	\N	Anil Mehtanath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4386442850", "txnid": "PINW9N5T4JWI1B0", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695cdEDE2Eb47&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695cdEDE2Eb47&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695cdEDE2Eb47&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695cdEDE2Eb47&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_06695cdEDE2Eb47", "upi_tr": "pt_06695cdEDE2Eb47", "txnid": "ORDID4386442850", "orderid": "ORDID4386442850", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695cdEDE2Eb47&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695cdEDE2Eb47&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4386442850	f	2026-01-06 10:07:26.431357	2026-01-06 10:07:26.43136	\N	f	\N
164	3c70dd22-df28-4a50-a034-4a378507c5bf	PINX4ELG57S888K	HC17676944953507NC	100.00	5.00	\N	Vivek Malhotraendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4968051734", "txnid": "PINX4ELG57S888K", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bD695cE0a00a21E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bD695cE0a00a21E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bD695cE0a00a21E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bD695cE0a00a21E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_bD695cE0a00a21E", "upi_tr": "pt_bD695cE0a00a21E", "txnid": "ORDID4968051734", "orderid": "ORDID4968051734", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bD695cE0a00a21E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bD695cE0a00a21E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4968051734	f	2026-01-06 10:14:56.302377	2026-01-06 10:14:56.302379	\N	f	\N
148	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV89JJ5FCYNVM	HC1767693407744VO2	100.00	5.00	\N	Shruti Pillaibabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7613436714", "txnid": "PINV89JJ5FCYNVM", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6F695cDC6073c0c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6F695cDC6073c0c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6F695cDC6073c0c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6F695cDC6073c0c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6F695cDC6073c0c", "upi_tr": "pt_6F695cDC6073c0c", "txnid": "ORDID7613436714", "orderid": "ORDID7613436714", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7613436714", "rrn": "338891145819"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6F695cDC6073c0c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6F695cDC6073c0c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7613436714	f	2026-01-06 09:56:48.73688	2026-01-06 09:57:26.954949	338891145819	t	2026-01-06 09:57:24.557867+00
144	3c70dd22-df28-4a50-a034-4a378507c5bf	PIND71U8X0PWSCV	HC1767693249894A4H	100.00	5.00	\N	Meena Dasendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4304503804", "txnid": "PIND71U8X0PWSCV", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DE695CDbc2933AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DE695CDbc2933AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DE695CDbc2933AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DE695CDbc2933AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_DE695CDbc2933AA", "upi_tr": "pt_DE695CDbc2933AA", "txnid": "ORDID4304503804", "orderid": "ORDID4304503804", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DE695CDbc2933AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DE695CDbc2933AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4304503804	f	2026-01-06 09:54:10.8507	2026-01-06 09:54:10.850705	\N	f	\N
143	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGRYC11Z4MZXJ	HC1767693220715LFV	100.00	5.00	\N	Yogesh Goyalji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9282526952", "txnid": "PINGRYC11Z4MZXJ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CDbA574E1B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CDbA574E1B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CDbA574E1B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CDbA574E1B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E2695CDbA574E1B", "upi_tr": "pt_E2695CDbA574E1B", "txnid": "ORDID9282526952", "orderid": "ORDID9282526952", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9282526952", "rrn": "395017938108"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CDbA574E1B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E2695CDbA574E1B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9282526952	f	2026-01-06 09:53:41.739209	2026-01-06 09:54:16.815921	395017938108	t	2026-01-06 09:54:14.66312+00
146	3c70dd22-df28-4a50-a034-4a378507c5bf	PINN17U91J7BS8S	HC1767693271054D6Z	100.00	5.00	\N	Meena Thakurnath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3776353419", "txnid": "PINN17U91J7BS8S", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Bc695CdBD7B592d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Bc695CdBD7B592d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Bc695CdBD7B592d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Bc695CdBD7B592d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Bc695CdBD7B592d", "upi_tr": "pt_Bc695CdBD7B592d", "txnid": "ORDID3776353419", "orderid": "ORDID3776353419", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Bc695CdBD7B592d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Bc695CdBD7B592d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3776353419	f	2026-01-06 09:54:31.971688	2026-01-06 09:54:31.971692	\N	f	\N
145	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLAGLUY93W33Y	HC1767693263838Y8W	100.00	5.00	\N	Kailash Yadavananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9180113899", "txnid": "PINLAGLUY93W33Y", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695cDBD085Eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695cDBD085Eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695cDBD085Eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695cDBD085Eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_16695cDBD085Eca", "upi_tr": "pt_16695cDBD085Eca", "txnid": "ORDID9180113899", "orderid": "ORDID9180113899", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9180113899", "rrn": "242336986211"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695cDBD085Eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695cDBD085Eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9180113899	f	2026-01-06 09:54:24.80714	2026-01-06 09:56:06.902981	242336986211	t	2026-01-06 09:56:04.197883+00
179	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN24A6V562RJVT	HC1767695054358U4Z	100.00	5.00	\N	Keshav Naidurao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3949035070", "txnid": "PIN24A6V562RJVT", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695CE2CF1dDc3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695CE2CF1dDc3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695CE2CF1dDc3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695CE2CF1dDc3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_86695CE2CF1dDc3", "upi_tr": "pt_86695CE2CF1dDc3", "txnid": "ORDID3949035070", "orderid": "ORDID3949035070", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695CE2CF1dDc3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695CE2CF1dDc3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3949035070	f	2026-01-06 10:24:15.371922	2026-01-06 10:24:15.371926	\N	f	\N
158	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6L9N5GVDN0LP	HC1767694011563GM6	100.00	5.00	\N	Vijay Chandrasekarkar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3436924964", "txnid": "PIN6L9N5GVDN0LP", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CDebC3e5B2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CDebC3e5B2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CDebC3e5B2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CDebC3e5B2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_97695CDebC3e5B2", "upi_tr": "pt_97695CDebC3e5B2", "txnid": "ORDID3436924964", "orderid": "ORDID3436924964", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3436924964", "rrn": "079036180561"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CDebC3e5B2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CDebC3e5B2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3436924964	f	2026-01-06 10:06:52.503944	2026-01-06 10:07:37.515147	079036180561	t	2026-01-06 10:07:34.244081+00
161	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQZESESV4LOSY	HC17676941377117RG	100.00	5.00	\N	Omkar Shahbabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1366906722", "txnid": "PINQZESESV4LOSY", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695cdf3a7380f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695cdf3a7380f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695cdf3a7380f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695cdf3a7380f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7d695cdf3a7380f", "upi_tr": "pt_7d695cdf3a7380f", "txnid": "ORDID1366906722", "orderid": "ORDID1366906722", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1366906722", "rrn": "161686987557"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695cdf3a7380f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695cdf3a7380f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1366906722	f	2026-01-06 10:08:58.722029	2026-01-06 10:09:27.624314	161686987557	t	2026-01-06 10:09:24.703666+00
162	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNYVKCCXEU7KB	HC1767694452037VDG	100.00	5.00	\N	Manisha Pandeyji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9790693829", "txnid": "PINNYVKCCXEU7KB", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695CE074ED9d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695CE074ED9d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695CE074ED9d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695CE074ED9d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_96695CE074ED9d5", "upi_tr": "pt_96695CE074ED9d5", "txnid": "ORDID9790693829", "orderid": "ORDID9790693829", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9790693829", "rrn": "004187714019"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695CE074ED9d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695CE074ED9d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9790693829	f	2026-01-06 10:14:13.232383	2026-01-06 10:14:47.829773	004187714019	t	2026-01-06 10:14:42.951219+00
149	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZN54DZET194V	HC1767693443216Q3L	100.00	5.00	\N	Omkar Chandrasekarji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2083352379", "txnid": "PINZN54DZET194V", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cdc83E2538&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cdc83E2538&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cdc83E2538&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cdc83E2538&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_07695cdc83E2538", "upi_tr": "pt_07695cdc83E2538", "txnid": "ORDID2083352379", "orderid": "ORDID2083352379", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2083352379", "rrn": "872575118391"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cdc83E2538&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cdc83E2538&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2083352379	f	2026-01-06 09:57:24.181719	2026-01-06 09:58:02.082898	872575118391	t	2026-01-06 09:57:57.783282+00
163	3c70dd22-df28-4a50-a034-4a378507c5bf	PINSZJU2ASRLFGH	HC1767694473051OBS	100.00	5.00	\N	Radhika Mathurappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5989301604", "txnid": "PINSZJU2ASRLFGH", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695CE089bcb42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695CE089bcb42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695CE089bcb42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695CE089bcb42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_EE695CE089bcb42", "upi_tr": "pt_EE695CE089bcb42", "txnid": "ORDID5989301604", "orderid": "ORDID5989301604", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5989301604", "rrn": "318199381397"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695CE089bcb42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695CE089bcb42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5989301604	f	2026-01-06 10:14:34.030371	2026-01-06 10:15:17.87785	318199381397	t	2026-01-06 10:15:14.983227+00
165	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHIC36UZMPDM0	HC17676945536974ZB	100.00	5.00	\N	Kumar Guptababu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7012279411", "txnid": "PINHIC36UZMPDM0", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695ce0dA6FcbE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695ce0dA6FcbE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695ce0dA6FcbE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695ce0dA6FcbE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_32695ce0dA6FcbE", "upi_tr": "pt_32695ce0dA6FcbE", "txnid": "ORDID7012279411", "orderid": "ORDID7012279411", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7012279411", "rrn": "116769556244"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695ce0dA6FcbE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695ce0dA6FcbE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7012279411	f	2026-01-06 10:15:54.734632	2026-01-06 10:16:27.941895	116769556244	t	2026-01-06 10:16:24.250749+00
174	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7U184SBQNEIK	HC1767694985044HE4	100.00	5.00	\N	Chitra Banerjeeram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8345577197", "txnid": "PIN7U184SBQNEIK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695Ce289d0185&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695Ce289d0185&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695Ce289d0185&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695Ce289d0185&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_19695Ce289d0185", "upi_tr": "pt_19695Ce289d0185", "txnid": "ORDID8345577197", "orderid": "ORDID8345577197", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8345577197", "rrn": "637243515604"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695Ce289d0185&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695Ce289d0185&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8345577197	f	2026-01-06 10:23:06.136247	2026-01-06 10:23:48.308308	637243515604	t	2026-01-06 10:23:46.93581+00
223	3c70dd22-df28-4a50-a034-4a378507c5bf	PINF87DIH8WPHBF	HC17676960530438HE	100.00	5.00	\N	Kiran Thakurkar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8284689013", "txnid": "PINF87DIH8WPHBF", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695CE6B5BC55a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695CE6B5BC55a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695CE6B5BC55a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695CE6B5BC55a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B2695CE6B5BC55a", "upi_tr": "pt_B2695CE6B5BC55a", "txnid": "ORDID8284689013", "orderid": "ORDID8284689013", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8284689013", "rrn": "053192253273"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695CE6B5BC55a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695CE6B5BC55a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8284689013	f	2026-01-06 10:40:54.030902	2026-01-06 10:41:34.67097	053192253273	t	2026-01-06 10:41:32.0881+00
166	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQFMSMZ9BDJ47	HC17676946078277UV	100.00	5.00	\N	Kailash Joshibabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8604797865", "txnid": "PINQFMSMZ9BDJ47", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695Ce11086327&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695Ce11086327&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695Ce11086327&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695Ce11086327&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9E695Ce11086327", "upi_tr": "pt_9E695Ce11086327", "txnid": "ORDID8604797865", "orderid": "ORDID8604797865", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8604797865", "rrn": "395019119881"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695Ce11086327&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695Ce11086327&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8604797865	f	2026-01-06 10:16:48.802942	2026-01-06 10:17:22.994717	395019119881	t	2026-01-06 10:17:22.473602+00
224	3c70dd22-df28-4a50-a034-4a378507c5bf	PINECN8PWZ24Y47	HC17676960861052SF	100.00	5.00	\N	Alka Reddyji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5539833245", "txnid": "PINECN8PWZ24Y47", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CE6d6D552a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CE6d6D552a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CE6d6D552a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CE6d6D552a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_88695CE6d6D552a", "upi_tr": "pt_88695CE6d6D552a", "txnid": "ORDID5539833245", "orderid": "ORDID5539833245", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5539833245", "rrn": "757391193338"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CE6d6D552a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CE6d6D552a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5539833245	f	2026-01-06 10:41:27.135993	2026-01-06 10:41:59.700264	757391193338	t	2026-01-06 10:41:55.699873+00
167	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBI5CTBQDA9EL	HC17676946085263YB	100.00	5.00	\N	Vinod Nairrao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1598385171", "txnid": "PINBI5CTBQDA9EL", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8F695Ce11135FB2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8F695Ce11135FB2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8F695Ce11135FB2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8F695Ce11135FB2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8F695Ce11135FB2", "upi_tr": "pt_8F695Ce11135FB2", "txnid": "ORDID1598385171", "orderid": "ORDID1598385171", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1598385171", "rrn": "637256930548"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8F695Ce11135FB2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8F695Ce11135FB2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1598385171	f	2026-01-06 10:16:49.457046	2026-01-06 10:17:38.02335	637256930548	t	2026-01-06 10:17:37.04637+00
226	3c70dd22-df28-4a50-a034-4a378507c5bf	PINC3TNDFCRHS77	HC1767696099423RBY	100.00	5.00	\N	Raghav Singhesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9814597646", "txnid": "PINC3TNDFCRHS77", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695ce6E41ea08&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695ce6E41ea08&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695ce6E41ea08&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695ce6E41ea08&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2d695ce6E41ea08", "upi_tr": "pt_2d695ce6E41ea08", "txnid": "ORDID9814597646", "orderid": "ORDID9814597646", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695ce6E41ea08&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695ce6E41ea08&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9814597646	f	2026-01-06 10:41:40.394995	2026-01-06 10:41:40.395	\N	f	\N
11273	2ce36d1e-5818-415f-b875-b357c8297e9d	PIN389QCYYR3ZKR	wbegwvewhgevw	100.00	1.18	string	string	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1399684565", "txnid": "PIN389QCYYR3ZKR", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_d96965ef1b8B9A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_d96965ef1b8B9A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_d96965ef1b8B9A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_d96965ef1b8B9A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID1399684565", "orderid": "ORDID1399684565", "bankutr": "pending"}}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_d96965ef1b8B9A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_d96965ef1b8B9A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID1399684565	f	2026-01-13 07:07:07.793677	2026-01-13 07:07:07.79368	\N	f	\N
168	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0X4OLAP1TOTG	HC1767694737727E2L	100.00	5.00	\N	Kiran Naidukar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2731757654", "txnid": "PIN0X4OLAP1TOTG", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695CE192697ec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695CE192697ec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695CE192697ec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695CE192697ec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_77695CE192697ec", "upi_tr": "pt_77695CE192697ec", "txnid": "ORDID2731757654", "orderid": "ORDID2731757654", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2731757654", "rrn": "364860631285"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695CE192697ec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695CE192697ec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2731757654	f	2026-01-06 10:18:58.695408	2026-01-06 10:19:33.119759	364860631285	t	2026-01-06 10:19:28.591201+00
169	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFZOFHU53PDU2	HC1767694801550IPF	100.00	5.00	\N	Raj Reddy	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1717187113", "txnid": "PINFZOFHU53PDU2", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695ce1D28e981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695ce1D28e981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695ce1D28e981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695ce1D28e981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_66695ce1D28e981", "upi_tr": "pt_66695ce1D28e981", "txnid": "ORDID1717187113", "orderid": "ORDID1717187113", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695ce1D28e981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695ce1D28e981&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1717187113	f	2026-01-06 10:20:02.915345	2026-01-06 10:20:02.915349	\N	f	\N
170	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9W3VFU16HJOS	HC1767694829246Q04	200.00	10.00	\N	Chitra Aggarwalendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9016007475", "txnid": "PIN9W3VFU16HJOS", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695ce1Ee0C2cA&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695ce1Ee0C2cA&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695ce1Ee0C2cA&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695ce1Ee0C2cA&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1f695ce1Ee0C2cA", "upi_tr": "pt_1f695ce1Ee0C2cA", "txnid": "ORDID9016007475", "orderid": "ORDID9016007475", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695ce1Ee0C2cA&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1f695ce1Ee0C2cA&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9016007475	f	2026-01-06 10:20:30.299182	2026-01-06 10:20:30.299186	\N	f	\N
171	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHR0QKI1XNI61	HC17676948405371PP	100.00	5.00	\N	Priya Patelish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3141375225", "txnid": "PINHR0QKI1XNI61", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c0695ce1F960D73&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c0695ce1F960D73&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c0695ce1F960D73&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c0695ce1F960D73&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_c0695ce1F960D73", "upi_tr": "pt_c0695ce1F960D73", "txnid": "ORDID3141375225", "orderid": "ORDID3141375225", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c0695ce1F960D73&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c0695ce1F960D73&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3141375225	f	2026-01-06 10:20:41.654594	2026-01-06 10:20:41.654597	\N	f	\N
227	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTJSIUJ781LKE	HC1767696102489YMT	100.00	5.00	\N	Sheetal Aggarwalnath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3398100628", "txnid": "PINTJSIUJ781LKE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695Ce6e72CAE5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695Ce6e72CAE5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695Ce6e72CAE5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695Ce6e72CAE5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_20695Ce6e72CAE5", "upi_tr": "pt_20695Ce6e72CAE5", "txnid": "ORDID3398100628", "orderid": "ORDID3398100628", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695Ce6e72CAE5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695Ce6e72CAE5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3398100628	f	2026-01-06 10:41:43.433359	2026-01-06 10:41:43.433362	\N	f	\N
172	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCJYHN8O1LQ79	HC176769487125615T	200.00	10.00	\N	Deepak Menonish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6290912155", "txnid": "PINCJYHN8O1LQ79", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695ce2180C0d0&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695ce2180C0d0&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695ce2180C0d0&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695ce2180C0d0&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_10695ce2180C0d0", "upi_tr": "pt_10695ce2180C0d0", "txnid": "ORDID6290912155", "orderid": "ORDID6290912155", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6290912155", "rrn": "464304208058"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695ce2180C0d0&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695ce2180C0d0&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6290912155	f	2026-01-06 10:21:12.330632	2026-01-06 10:21:48.217987	464304208058	t	2026-01-06 10:21:47.071974+00
173	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLM9J4U0JKGO5	HC17676949606350XO	200.00	10.00	\N	Dinesh Kumaresh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2436531487", "txnid": "PINLM9J4U0JKGO5", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695ce271634dF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695ce271634dF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695ce271634dF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695ce271634dF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_98695ce271634dF", "upi_tr": "pt_98695ce271634dF", "txnid": "ORDID2436531487", "orderid": "ORDID2436531487", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695ce271634dF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695ce271634dF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2436531487	f	2026-01-06 10:22:41.652385	2026-01-06 10:22:41.652388	\N	f	\N
175	3c70dd22-df28-4a50-a034-4a378507c5bf	PINWNZBYU3PVKF1	HC1767695009723C9T	200.00	10.00	\N	Ritika Mishraji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2329100725", "txnid": "PINWNZBYU3PVKF1", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695cE2a274236&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695cE2a274236&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695cE2a274236&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695cE2a274236&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_25695cE2a274236", "upi_tr": "pt_25695cE2a274236", "txnid": "ORDID2329100725", "orderid": "ORDID2329100725", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695cE2a274236&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695cE2a274236&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2329100725	f	2026-01-06 10:23:30.721088	2026-01-06 10:23:30.721091	\N	f	\N
176	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJ0ZZISRGKYNE	HC1767695021692E4A	100.00	5.00	\N	Sonia Chandrasekarram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8137550809", "txnid": "PINJ0ZZISRGKYNE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cE2AE66eCd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cE2AE66eCd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cE2AE66eCd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cE2AE66eCd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_38695cE2AE66eCd", "upi_tr": "pt_38695cE2AE66eCd", "txnid": "ORDID8137550809", "orderid": "ORDID8137550809", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cE2AE66eCd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cE2AE66eCd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8137550809	f	2026-01-06 10:23:42.686195	2026-01-06 10:23:42.686198	\N	f	\N
177	3c70dd22-df28-4a50-a034-4a378507c5bf	PINVKB1IG15UYK3	HC1767695026710SEM	100.00	5.00	\N	Sanjay Menonbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9786480396", "txnid": "PINVKB1IG15UYK3", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695ce2B367Cb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695ce2B367Cb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695ce2B367Cb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695ce2B367Cb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_36695ce2B367Cb1", "upi_tr": "pt_36695ce2B367Cb1", "txnid": "ORDID9786480396", "orderid": "ORDID9786480396", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695ce2B367Cb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695ce2B367Cb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9786480396	f	2026-01-06 10:23:47.6668	2026-01-06 10:23:47.666804	\N	f	\N
180	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4ZB1R7P0L8IL	HC1767695071687Q1J	100.00	5.00	\N	Asha Duttaappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5849469434", "txnid": "PIN4ZB1R7P0L8IL", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CE2E05eeEC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CE2E05eeEC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CE2E05eeEC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CE2E05eeEC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_55695CE2E05eeEC", "upi_tr": "pt_55695CE2E05eeEC", "txnid": "ORDID5849469434", "orderid": "ORDID5849469434", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CE2E05eeEC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CE2E05eeEC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5849469434	f	2026-01-06 10:24:32.6528	2026-01-06 10:24:32.652804	\N	f	\N
178	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6004MBWK3X4G	HC1767695031158EI5	100.00	5.00	\N	Raghav Dubeyendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8552615303", "txnid": "PIN6004MBWK3X4G", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695ce2B7e809f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695ce2B7e809f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695ce2B7e809f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695ce2B7e809f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_42695ce2B7e809f", "upi_tr": "pt_42695ce2B7e809f", "txnid": "ORDID8552615303", "orderid": "ORDID8552615303", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8552615303", "rrn": "988046171018"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695ce2B7e809f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695ce2B7e809f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8552615303	f	2026-01-06 10:23:52.204626	2026-01-06 10:25:03.408751	988046171018	t	2026-01-06 10:25:00.097365+00
181	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGJH0W2YZGGU7	HC1767695148135U2G	100.00	5.00	\N	Swati Pandeynath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6096352895", "txnid": "PINGJH0W2YZGGU7", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CE32Cebb31&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CE32Cebb31&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CE32Cebb31&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CE32Cebb31&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A9695CE32Cebb31", "upi_tr": "pt_A9695CE32Cebb31", "txnid": "ORDID6096352895", "orderid": "ORDID6096352895", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CE32Cebb31&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A9695CE32Cebb31&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6096352895	f	2026-01-06 10:25:49.208659	2026-01-06 10:25:49.208663	\N	f	\N
182	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLOQYIFU3X1W3	HC1767695166566CEX	200.00	10.00	\N	Rani Chatterjeeji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5253936305", "txnid": "PINLOQYIFU3X1W3", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce33f4d1D6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce33f4d1D6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce33f4d1D6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce33f4d1D6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7f695ce33f4d1D6", "upi_tr": "pt_7f695ce33f4d1D6", "txnid": "ORDID5253936305", "orderid": "ORDID5253936305", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce33f4d1D6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce33f4d1D6&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5253936305	f	2026-01-06 10:26:07.570543	2026-01-06 10:26:07.570548	\N	f	\N
329	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZURCC3WL3O9T	HC1767697757201P4R	100.00	5.00	\N	Meena Chandrasekarram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4051468984", "txnid": "PINZURCC3WL3O9T", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cED5de18fE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cED5de18fE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cED5de18fE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cED5de18fE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_38695cED5de18fE", "upi_tr": "pt_38695cED5de18fE", "txnid": "ORDID4051468984", "orderid": "ORDID4051468984", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4051468984", "rrn": "600699058557"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cED5de18fE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695cED5de18fE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4051468984	f	2026-01-06 11:09:18.1971	2026-01-06 11:09:46.541087	600699058557	t	2026-01-06 11:09:46.0187+00
184	3c70dd22-df28-4a50-a034-4a378507c5bf	PINPU6341106MGL	HC1767695214227TLP	100.00	5.00	\N	Mohan Mathurlal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1815413453", "txnid": "PINPU6341106MGL", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7e695Ce36ee30d1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7e695Ce36ee30d1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7e695Ce36ee30d1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7e695Ce36ee30d1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7e695Ce36ee30d1", "upi_tr": "pt_7e695Ce36ee30d1", "txnid": "ORDID1815413453", "orderid": "ORDID1815413453", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7e695Ce36ee30d1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7e695Ce36ee30d1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1815413453	f	2026-01-06 10:26:55.180787	2026-01-06 10:26:55.180792	\N	f	\N
183	3c70dd22-df28-4a50-a034-4a378507c5bf	PINH60XF7RXYLZP	HC1767695185706P5F	100.00	5.00	\N	Vaishali Chauhanbabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2260485876", "txnid": "PINH60XF7RXYLZP", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cE3526b59e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cE3526b59e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cE3526b59e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cE3526b59e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_07695cE3526b59e", "upi_tr": "pt_07695cE3526b59e", "txnid": "ORDID2260485876", "orderid": "ORDID2260485876", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2260485876", "rrn": "758362961288"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cE3526b59e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695cE3526b59e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2260485876	f	2026-01-06 10:26:26.725983	2026-01-06 10:26:58.487577	758362961288	t	2026-01-06 10:26:55.359945+00
185	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGON05JXEYDFA	HC1767695255563U3B	100.00	5.00	\N	Arun Shahbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7045596816", "txnid": "PINGON05JXEYDFA", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695Ce3984D4AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695Ce3984D4AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695Ce3984D4AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695Ce3984D4AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_90695Ce3984D4AA", "upi_tr": "pt_90695Ce3984D4AA", "txnid": "ORDID7045596816", "orderid": "ORDID7045596816", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695Ce3984D4AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695Ce3984D4AA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7045596816	f	2026-01-06 10:27:36.579433	2026-01-06 10:27:36.579437	\N	f	\N
316	3c70dd22-df28-4a50-a034-4a378507c5bf	PINO98BDPMAL4RE	HC1767697566427BTH	100.00	5.00	\N	Asha Mehtaananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4558920825", "txnid": "PINO98BDPMAL4RE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695cec9F21dF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695cec9F21dF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695cec9F21dF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695cec9F21dF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B4695cec9F21dF0", "upi_tr": "pt_B4695cec9F21dF0", "txnid": "ORDID4558920825", "orderid": "ORDID4558920825", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695cec9F21dF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B4695cec9F21dF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4558920825	f	2026-01-06 11:06:07.373213	2026-01-06 11:06:07.373218	\N	f	\N
550	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNBG0VNI9S2AK	HC1767703938792SK1	100.00	5.00	\N	Satish Iyerendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3935407008", "txnid": "PINNBG0VNI9S2AK", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eF695d0583A25C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eF695d0583A25C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eF695d0583A25C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eF695d0583A25C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_eF695d0583A25C3", "upi_tr": "pt_eF695d0583A25C3", "txnid": "ORDID3935407008", "orderid": "ORDID3935407008", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eF695d0583A25C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eF695d0583A25C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3935407008	f	2026-01-06 12:52:19.95929	2026-01-06 12:52:19.959294	\N	f	\N
186	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5HCYD0KHRY6T	HC17676953122776VX	100.00	5.00	\N	Geeta Dubey	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4803922516", "txnid": "PIN5HCYD0KHRY6T", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695cE3D11336f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695cE3D11336f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695cE3D11336f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695cE3D11336f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C2695cE3D11336f", "upi_tr": "pt_C2695cE3D11336f", "txnid": "ORDID4803922516", "orderid": "ORDID4803922516", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4803922516", "rrn": "600682943481"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695cE3D11336f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695cE3D11336f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4803922516	f	2026-01-06 10:28:33.322317	2026-01-06 10:29:18.586658	600682943481	t	2026-01-06 10:29:15.033948+00
187	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBXQDBQVT3Q5B	HC1767695338467Q47	100.00	5.00	\N	Shruti Iyerkar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7224728922", "txnid": "PINBXQDBQVT3Q5B", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bA695CE3Eb38c9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bA695CE3Eb38c9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bA695CE3Eb38c9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bA695CE3Eb38c9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_bA695CE3Eb38c9a", "upi_tr": "pt_bA695CE3Eb38c9a", "txnid": "ORDID7224728922", "orderid": "ORDID7224728922", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7224728922", "rrn": "000166584059"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bA695CE3Eb38c9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bA695CE3Eb38c9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7224728922	f	2026-01-06 10:28:59.489984	2026-01-06 10:29:33.619111	000166584059	t	2026-01-06 10:29:28.983445+00
239	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMDOJ8GP27D7G	HC1767696291113BIA	100.00	5.00	\N	Swati Daslal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8954734164", "txnid": "PINMDOJ8GP27D7G", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695ce7a3C8D7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695ce7a3C8D7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695ce7a3C8D7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695ce7a3C8D7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_90695ce7a3C8D7F", "upi_tr": "pt_90695ce7a3C8D7F", "txnid": "ORDID8954734164", "orderid": "ORDID8954734164", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695ce7a3C8D7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_90695ce7a3C8D7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8954734164	f	2026-01-06 10:44:52.099616	2026-01-06 10:44:52.099619	\N	f	\N
229	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN02OZUP83YONY	HC1767696127524KAE	100.00	5.00	\N	Bharat Banerjeeish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7836014604", "txnid": "PIN02OZUP83YONY", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE70038c6f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE70038c6f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE70038c6f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE70038c6f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_56695cE70038c6f", "upi_tr": "pt_56695cE70038c6f", "txnid": "ORDID7836014604", "orderid": "ORDID7836014604", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7836014604", "rrn": "600636948270"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE70038c6f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_56695cE70038c6f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7836014604	f	2026-01-06 10:42:08.469493	2026-01-06 10:42:44.764898	600636948270	t	2026-01-06 10:42:44.374528+00
11274	3d9aa4bc-1535-4017-a168-5a19f65c14d7	PINSL9XHRXYPYYN	ADADQWE11001	100.00	5.31	\N	John Doe	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9957880100", "txnid": "PINSL9XHRXYPYYN", "amount": "100", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_9769660731d9a0C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_9769660731d9a0C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_9769660731d9a0C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_9769660731d9a0C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID9957880100", "orderid": "ORDID9957880100", "bankutr": "pending"}}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_9769660731d9a0C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_9769660731d9a0C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID9957880100	f	2026-01-13 08:49:54.133723	2026-01-13 08:49:54.133727	\N	f	\N
190	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHDLICVMMKB5V	HC176769540439142P	100.00	5.00	\N	Ankita Pandeyendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3329183279", "txnid": "PINHDLICVMMKB5V", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE42d2D573&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE42d2D573&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE42d2D573&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE42d2D573&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_25695CE42d2D573", "upi_tr": "pt_25695CE42d2D573", "txnid": "ORDID3329183279", "orderid": "ORDID3329183279", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE42d2D573&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE42d2D573&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3329183279	f	2026-01-06 10:30:05.441851	2026-01-06 10:30:05.441856	\N	f	\N
319	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4UH0JEFBIV5P	HC1767697601860ANX	100.00	5.00	\N	Shruti Mishrakar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3909608265", "txnid": "PIN4UH0JEFBIV5P", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695cEcC296Db7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695cEcC296Db7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695cEcC296Db7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695cEcC296Db7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A2695cEcC296Db7", "upi_tr": "pt_A2695cEcC296Db7", "txnid": "ORDID3909608265", "orderid": "ORDID3909608265", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695cEcC296Db7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695cEcC296Db7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3909608265	f	2026-01-06 11:06:42.928958	2026-01-06 11:06:42.928962	\N	f	\N
321	3c70dd22-df28-4a50-a034-4a378507c5bf	PINR69QH84R11OD	HC1767697613338RRE	100.00	5.00	\N	Arjun Patelram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2301506755", "txnid": "PINR69QH84R11OD", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cecCe144aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cecCe144aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cecCe144aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cecCe144aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_42695cecCe144aE", "upi_tr": "pt_42695cecCe144aE", "txnid": "ORDID2301506755", "orderid": "ORDID2301506755", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cecCe144aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695cecCe144aE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2301506755	f	2026-01-06 11:06:54.330007	2026-01-06 11:06:54.330053	\N	f	\N
189	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTU1PYZ7E2KNM	HC1767695398482BH8	100.00	5.00	\N	Raj Yadavji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1725675108", "txnid": "PINTU1PYZ7E2KNM", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695ce4273ec8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695ce4273ec8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695ce4273ec8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695ce4273ec8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0F695ce4273ec8E", "upi_tr": "pt_0F695ce4273ec8E", "txnid": "ORDID1725675108", "orderid": "ORDID1725675108", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1725675108", "rrn": "696904471296"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695ce4273ec8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695ce4273ec8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1725675108	f	2026-01-06 10:29:59.507161	2026-01-06 10:30:33.673612	696904471296	t	2026-01-06 10:30:33.438288+00
188	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHVBFOM5J1DWK	HC1767695393228HGQ	100.00	5.00	\N	Shankar Kumarnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2999599841", "txnid": "PINHVBFOM5J1DWK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695cE42213177&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695cE42213177&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695cE42213177&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695cE42213177&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_91695cE42213177", "upi_tr": "pt_91695cE42213177", "txnid": "ORDID2999599841", "orderid": "ORDID2999599841", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2999599841", "rrn": "637236719613"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695cE42213177&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695cE42213177&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2999599841	f	2026-01-06 10:29:54.351301	2026-01-06 10:30:43.700554	637236719613	t	2026-01-06 10:30:43.033239+00
191	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV92D09S3757Z	HC17676954635860VR	100.00	5.00	\N	Naveen Pandeyesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8013375991", "txnid": "PINV92D09S3757Z", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695Ce4684Bf8c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695Ce4684Bf8c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695Ce4684Bf8c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695Ce4684Bf8c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Fd695Ce4684Bf8c", "upi_tr": "pt_Fd695Ce4684Bf8c", "txnid": "ORDID8013375991", "orderid": "ORDID8013375991", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695Ce4684Bf8c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fd695Ce4684Bf8c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8013375991	f	2026-01-06 10:31:04.572483	2026-01-06 10:31:04.572487	\N	f	\N
228	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5YJ1KB8RR3BT	HC1767696124916793	100.00	5.00	\N	Priya Chandrasekarrao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1229247405", "txnid": "PIN5YJ1KB8RR3BT", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695Ce6fDa890F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695Ce6fDa890F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695Ce6fDa890F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695Ce6fDa890F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_98695Ce6fDa890F", "upi_tr": "pt_98695Ce6fDa890F", "txnid": "ORDID1229247405", "orderid": "ORDID1229247405", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1229247405", "rrn": "600683144332"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695Ce6fDa890F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695Ce6fDa890F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1229247405	f	2026-01-06 10:42:05.936724	2026-01-06 10:42:39.73874	600683144332	t	2026-01-06 10:42:39.251675+00
193	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3SYIGYXLWJ82	HC1767695534032NTL	200.00	10.00	\N	Arjun Banerjee	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6113874555", "txnid": "PIN3SYIGYXLWJ82", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695ce4AECD02F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695ce4AECD02F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695ce4AECD02F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695ce4AECD02F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_13695ce4AECD02F", "upi_tr": "pt_13695ce4AECD02F", "txnid": "ORDID6113874555", "orderid": "ORDID6113874555", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6113874555", "rrn": "966586081381"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695ce4AECD02F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695ce4AECD02F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6113874555	f	2026-01-06 10:32:15.105459	2026-01-06 10:33:18.826629	966586081381	t	2026-01-06 10:33:14.547089+00
192	3c70dd22-df28-4a50-a034-4a378507c5bf	PINXBWP1VTADGLV	HC1767695518239HZ8	100.00	5.00	\N	Ritika Trivedibabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8967023219", "txnid": "PINXBWP1VTADGLV", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695ce49F0781B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695ce49F0781B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695ce49F0781B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695ce49F0781B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b6695ce49F0781B", "upi_tr": "pt_b6695ce49F0781B", "txnid": "ORDID8967023219", "orderid": "ORDID8967023219", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8967023219", "rrn": "600625041688"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695ce49F0781B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695ce49F0781B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8967023219	f	2026-01-06 10:31:59.278343	2026-01-06 10:32:38.777897	600625041688	t	2026-01-06 10:32:35.805567+00
393	3c70dd22-df28-4a50-a034-4a378507c5bf	PINI630GRUEFKIJ	HC17676995035864FF	100.00	5.00	\N	Arun Reddyappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1894958469", "txnid": "PINI630GRUEFKIJ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cf43054ec0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cf43054ec0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cf43054ec0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cf43054ec0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_33695cf43054ec0", "upi_tr": "pt_33695cf43054ec0", "txnid": "ORDID1894958469", "orderid": "ORDID1894958469", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1894958469", "rrn": "643919776991"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cf43054ec0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cf43054ec0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1894958469	f	2026-01-06 11:38:24.592574	2026-01-06 11:39:20.786135	643919776991	t	2026-01-06 11:39:17.229517+00
194	3c70dd22-df28-4a50-a034-4a378507c5bf	PINUM5LF0D4LZPK	HC1767695560943CK1	100.00	5.00	\N	Raghav Nairram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5739789349", "txnid": "PINUM5LF0D4LZPK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cE4C99ac3c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cE4C99ac3c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cE4C99ac3c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cE4C99ac3c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A1695cE4C99ac3c", "upi_tr": "pt_A1695cE4C99ac3c", "txnid": "ORDID5739789349", "orderid": "ORDID5739789349", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5739789349", "rrn": "395019947136"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cE4C99ac3c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cE4C99ac3c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5739789349	f	2026-01-06 10:32:41.868125	2026-01-06 10:33:18.841967	395019947136	t	2026-01-06 10:33:14.794216+00
195	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9ERPX705HP12	HC1767695598466Y5S	100.00	5.00	\N	Madhav Joshilal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4707451361", "txnid": "PIN9ERPX705HP12", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A8695cE4ef26146&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A8695cE4ef26146&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A8695cE4ef26146&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A8695cE4ef26146&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A8695cE4ef26146", "upi_tr": "pt_A8695cE4ef26146", "txnid": "ORDID4707451361", "orderid": "ORDID4707451361", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A8695cE4ef26146&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A8695cE4ef26146&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4707451361	f	2026-01-06 10:33:19.387073	2026-01-06 10:33:19.387077	\N	f	\N
196	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQIIE9F3LKK67	HC1767695664769W7W	100.00	5.00	\N	Harish Trivediram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6200020107", "txnid": "PINQIIE9F3LKK67", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE53189dBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE53189dBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE53189dBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE53189dBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_25695CE53189dBb", "upi_tr": "pt_25695CE53189dBb", "txnid": "ORDID6200020107", "orderid": "ORDID6200020107", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE53189dBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695CE53189dBb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6200020107	f	2026-01-06 10:34:25.80939	2026-01-06 10:34:25.809394	\N	f	\N
197	3c70dd22-df28-4a50-a034-4a378507c5bf	PINWQ4DFVBH42Q7	HC1767695676967BR1	100.00	5.00	\N	Shankar Bhatialal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8205891747", "txnid": "PINWQ4DFVBH42Q7", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695CE53DA35E2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695CE53DA35E2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695CE53DA35E2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695CE53DA35E2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b0695CE53DA35E2", "upi_tr": "pt_b0695CE53DA35E2", "txnid": "ORDID8205891747", "orderid": "ORDID8205891747", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695CE53DA35E2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695CE53DA35E2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8205891747	f	2026-01-06 10:34:37.92242	2026-01-06 10:34:37.922424	\N	f	\N
232	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIBJYC4EOS64V	HC1767696176407T3O	100.00	5.00	\N	Meena Menonesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9460049141", "txnid": "PINIBJYC4EOS64V", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695CE7311cfd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695CE7311cfd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695CE7311cfd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695CE7311cfd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_87695CE7311cfd2", "upi_tr": "pt_87695CE7311cfd2", "txnid": "ORDID9460049141", "orderid": "ORDID9460049141", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695CE7311cfd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695CE7311cfd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9460049141	f	2026-01-06 10:42:57.365964	2026-01-06 10:42:57.365968	\N	f	\N
199	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDU3QLUZ35S7P	HC1767695706079UUI	200.00	10.00	\N	Madhav Pandeylal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5750158313", "txnid": "PINDU3QLUZ35S7P", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7E695cE55acD5D4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7E695cE55acD5D4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7E695cE55acD5D4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7E695cE55acD5D4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7E695cE55acD5D4", "upi_tr": "pt_7E695cE55acD5D4", "txnid": "ORDID5750158313", "orderid": "ORDID5750158313", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7E695cE55acD5D4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7E695cE55acD5D4&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5750158313	f	2026-01-06 10:35:07.09407	2026-01-06 10:35:07.094074	\N	f	\N
200	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFSM520LZ0BRD	HC17676957074349T5	100.00	5.00	\N	Divya Shahish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5350946229", "txnid": "PINFSM520LZ0BRD", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_83695ce55c23a25&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_83695ce55c23a25&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_83695ce55c23a25&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_83695ce55c23a25&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_83695ce55c23a25", "upi_tr": "pt_83695ce55c23a25", "txnid": "ORDID5350946229", "orderid": "ORDID5350946229", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_83695ce55c23a25&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_83695ce55c23a25&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5350946229	f	2026-01-06 10:35:08.402456	2026-01-06 10:35:08.402459	\N	f	\N
231	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0ACM9XNH8O17	HC1767696158001WW9	100.00	5.00	\N	Sheetal Jain	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6065124318", "txnid": "PIN0ACM9XNH8O17", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695cE71eA93D5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695cE71eA93D5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695cE71eA93D5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695cE71eA93D5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E5695cE71eA93D5", "upi_tr": "pt_E5695cE71eA93D5", "txnid": "ORDID6065124318", "orderid": "ORDID6065124318", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6065124318", "rrn": "116770833281"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695cE71eA93D5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695cE71eA93D5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6065124318	f	2026-01-06 10:42:38.943836	2026-01-06 10:43:09.841483	116770833281	t	2026-01-06 10:43:07.626314+00
198	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFULROVHOYR4Y	HC1767695687921X47	100.00	5.00	\N	Mahesh Patelkar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3434898202", "txnid": "PINFULROVHOYR4Y", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E9695ce548bC09C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E9695ce548bC09C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E9695ce548bC09C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E9695ce548bC09C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E9695ce548bC09C", "upi_tr": "pt_E9695ce548bC09C", "txnid": "ORDID3434898202", "orderid": "ORDID3434898202", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3434898202", "rrn": "837394914580"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E9695ce548bC09C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E9695ce548bC09C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3434898202	f	2026-01-06 10:34:49.045162	2026-01-06 10:35:23.935551	837394914580	t	2026-01-06 10:35:22.406608+00
553	3c70dd22-df28-4a50-a034-4a378507c5bf	PINA04OQ80AZGPX	HC1767703964030TXG	100.00	5.00	\N	Ganesh Pillaiesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3871308206", "txnid": "PINA04OQ80AZGPX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d059cd26E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d059cd26E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d059cd26E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d059cd26E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4a695d059cd26E8", "upi_tr": "pt_4a695d059cd26E8", "txnid": "ORDID3871308206", "orderid": "ORDID3871308206", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d059cd26E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d059cd26E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3871308206	f	2026-01-06 12:52:45.152344	2026-01-06 12:52:45.152347	\N	f	\N
201	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMSWD4U691LQ6	HC1767695730884BCP	100.00	5.00	\N	Chandan Duttaish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1550262222", "txnid": "PINMSWD4U691LQ6", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b2695cE5738b8eE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b2695cE5738b8eE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b2695cE5738b8eE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b2695cE5738b8eE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b2695cE5738b8eE", "upi_tr": "pt_b2695cE5738b8eE", "txnid": "ORDID1550262222", "orderid": "ORDID1550262222", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1550262222", "rrn": "228812739221"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b2695cE5738b8eE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b2695cE5738b8eE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1550262222	f	2026-01-06 10:35:31.817319	2026-01-06 10:36:08.988476	228812739221	t	2026-01-06 10:36:07.127797+00
230	3c70dd22-df28-4a50-a034-4a378507c5bf	PINILTGCF5ZF22V	HC1767696143228MZV	100.00	5.00	\N	Komal Vermarao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9447130975", "txnid": "PINILTGCF5ZF22V", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bb695CE70fEa2f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bb695CE70fEa2f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bb695CE70fEa2f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bb695CE70fEa2f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_bb695CE70fEa2f7", "upi_tr": "pt_bb695CE70fEa2f7", "txnid": "ORDID9447130975", "orderid": "ORDID9447130975", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9447130975", "rrn": "812018366820"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bb695CE70fEa2f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bb695CE70fEa2f7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9447130975	f	2026-01-06 10:42:24.207834	2026-01-06 10:43:04.809047	812018366820	t	2026-01-06 10:43:02.682355+00
241	3c70dd22-df28-4a50-a034-4a378507c5bf	PINME2SNGVT1JGX	HC1767696317114FVK	100.00	5.00	\N	Mahesh Duttanath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3517095683", "txnid": "PINME2SNGVT1JGX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695Ce7BDD8853&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695Ce7BDD8853&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695Ce7BDD8853&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695Ce7BDD8853&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_54695Ce7BDD8853", "upi_tr": "pt_54695Ce7BDD8853", "txnid": "ORDID3517095683", "orderid": "ORDID3517095683", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695Ce7BDD8853&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695Ce7BDD8853&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3517095683	f	2026-01-06 10:45:18.153902	2026-01-06 10:45:18.153906	\N	f	\N
206	3c70dd22-df28-4a50-a034-4a378507c5bf	PINT2ZWX9C4OPG2	HC1767695830790NC9	100.00	5.00	\N	Sheetal Iyerish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6237528515", "txnid": "PINT2ZWX9C4OPG2", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D1695cE5D777BD6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D1695cE5D777BD6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D1695cE5D777BD6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D1695cE5D777BD6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D1695cE5D777BD6", "upi_tr": "pt_D1695cE5D777BD6", "txnid": "ORDID6237528515", "orderid": "ORDID6237528515", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D1695cE5D777BD6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D1695cE5D777BD6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6237528515	f	2026-01-06 10:37:11.754051	2026-01-06 10:37:11.754055	\N	f	\N
203	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMSRNWTXQUGD1	HC1767695806504TFI	100.00	5.00	\N	Monika Guptalal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2904373837", "txnid": "PINMSRNWTXQUGD1", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Ce5BF2Fa17&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Ce5BF2Fa17&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Ce5BF2Fa17&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Ce5BF2Fa17&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_f6695Ce5BF2Fa17", "upi_tr": "pt_f6695Ce5BF2Fa17", "txnid": "ORDID2904373837", "orderid": "ORDID2904373837", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2904373837", "rrn": "850707378446"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Ce5BF2Fa17&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Ce5BF2Fa17&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2904373837	f	2026-01-06 10:36:47.43516	2026-01-06 10:37:49.096289	850707378446	t	2026-01-06 10:37:45.048681+00
207	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRQVH3ARNPI58	HC1767695835880CSR	100.00	5.00	\N	Dinesh Nairappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3751160019", "txnid": "PINRQVH3ARNPI58", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695ce5dC8edB3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695ce5dC8edB3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695ce5dC8edB3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695ce5dC8edB3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_72695ce5dC8edB3", "upi_tr": "pt_72695ce5dC8edB3", "txnid": "ORDID3751160019", "orderid": "ORDID3751160019", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695ce5dC8edB3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695ce5dC8edB3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3751160019	f	2026-01-06 10:37:16.846005	2026-01-06 10:37:16.846028	\N	f	\N
208	3c70dd22-df28-4a50-a034-4a378507c5bf	PINYJM2CLBBH5T7	HC17676958445924G0	100.00	5.00	\N	Sneha Jainnath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7323122367", "txnid": "PINYJM2CLBBH5T7", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CE5E5538B8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CE5E5538B8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CE5E5538B8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CE5E5538B8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_60695CE5E5538B8", "upi_tr": "pt_60695CE5E5538B8", "txnid": "ORDID7323122367", "orderid": "ORDID7323122367", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CE5E5538B8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CE5E5538B8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7323122367	f	2026-01-06 10:37:25.578383	2026-01-06 10:37:25.578387	\N	f	\N
233	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLKOSW70G7QOV	HC1767696194107Q1X	200.00	10.00	\N	Satish Chatterjee	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3885293345", "txnid": "PINLKOSW70G7QOV", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695ce742D38bE&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695ce742D38bE&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695ce742D38bE&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695ce742D38bE&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5e695ce742D38bE", "upi_tr": "pt_5e695ce742D38bE", "txnid": "ORDID3885293345", "orderid": "ORDID3885293345", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695ce742D38bE&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695ce742D38bE&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3885293345	f	2026-01-06 10:43:15.128569	2026-01-06 10:43:15.128574	\N	f	\N
204	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0CWE7PNO6CQH	HC1767695811522FT0	200.00	10.00	\N	Lakshmi Dubeyrao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4157734932", "txnid": "PIN0CWE7PNO6CQH", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE5c437d76&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE5c437d76&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE5c437d76&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE5c437d76&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_97695CE5c437d76", "upi_tr": "pt_97695CE5c437d76", "txnid": "ORDID4157734932", "orderid": "ORDID4157734932", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4157734932", "rrn": "696904887360"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE5c437d76&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE5c437d76&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4157734932	f	2026-01-06 10:36:52.504378	2026-01-06 10:37:39.053358	696904887360	t	2026-01-06 10:37:37.96613+00
209	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDI6BAUST55PO	HC1767695864560AWK	100.00	5.00	\N	Anjali Iyer	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6255559761", "txnid": "PINDI6BAUST55PO", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695CE5f94CAa1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695CE5f94CAa1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695CE5f94CAa1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695CE5f94CAa1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A1695CE5f94CAa1", "upi_tr": "pt_A1695CE5f94CAa1", "txnid": "ORDID6255559761", "orderid": "ORDID6255559761", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695CE5f94CAa1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695CE5f94CAa1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6255559761	f	2026-01-06 10:37:45.571733	2026-01-06 10:37:45.571739	\N	f	\N
205	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN32ZJDNTTVSI3	HC1767695814098L0G	100.00	5.00	\N	Radhika Chopraesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6672194361", "txnid": "PIN32ZJDNTTVSI3", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b9695CE5c6c9551&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b9695CE5c6c9551&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b9695CE5c6c9551&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b9695CE5c6c9551&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b9695CE5c6c9551", "upi_tr": "pt_b9695CE5c6c9551", "txnid": "ORDID6672194361", "orderid": "ORDID6672194361", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6672194361", "rrn": "973333267153"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b9695CE5c6c9551&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b9695CE5c6c9551&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6672194361	f	2026-01-06 10:36:55.084781	2026-01-06 10:37:44.074415	973333267153	t	2026-01-06 10:37:42.613045+00
210	3c70dd22-df28-4a50-a034-4a378507c5bf	PINAWH2V2J0W0XE	HC17676958651817ZA	100.00	5.00	\N	Chitra Nairji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7660866141", "txnid": "PINAWH2V2J0W0XE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2c695cE5F9DF8AE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2c695cE5F9DF8AE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2c695cE5F9DF8AE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2c695cE5F9DF8AE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2c695cE5F9DF8AE", "upi_tr": "pt_2c695cE5F9DF8AE", "txnid": "ORDID7660866141", "orderid": "ORDID7660866141", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2c695cE5F9DF8AE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2c695cE5F9DF8AE&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7660866141	f	2026-01-06 10:37:46.182103	2026-01-06 10:37:46.182106	\N	f	\N
234	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGHYX6CEDC53O	HC17676962127216ZR	100.00	5.00	\N	Sita Yadavram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2996401613", "txnid": "PINGHYX6CEDC53O", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695CE7556Fa04&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695CE7556Fa04&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695CE7556Fa04&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695CE7556Fa04&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_a1695CE7556Fa04", "upi_tr": "pt_a1695CE7556Fa04", "txnid": "ORDID2996401613", "orderid": "ORDID2996401613", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695CE7556Fa04&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a1695CE7556Fa04&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2996401613	f	2026-01-06 10:43:33.734452	2026-01-06 10:43:33.734457	\N	f	\N
235	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZGUCT5U4U1VJ	HC1767696224798W0S	200.00	10.00	\N	Ramesh Chatterjeeram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1480171576", "txnid": "PINZGUCT5U4U1VJ", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B8695Ce7618B0Dd&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B8695Ce7618B0Dd&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B8695Ce7618B0Dd&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B8695Ce7618B0Dd&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B8695Ce7618B0Dd", "upi_tr": "pt_B8695Ce7618B0Dd", "txnid": "ORDID1480171576", "orderid": "ORDID1480171576", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B8695Ce7618B0Dd&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B8695Ce7618B0Dd&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1480171576	f	2026-01-06 10:43:45.814386	2026-01-06 10:43:45.81439	\N	f	\N
202	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKZ5OFVN9FOZ7	HC1767695800867LVQ	100.00	5.00	\N	Neha Joshiram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5111828336", "txnid": "PINKZ5OFVN9FOZ7", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695ce5b9B16Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695ce5b9B16Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695ce5b9B16Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695ce5b9B16Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b8695ce5b9B16Ae", "upi_tr": "pt_b8695ce5b9B16Ae", "txnid": "ORDID5111828336", "orderid": "ORDID5111828336", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5111828336", "rrn": "298139954878"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695ce5b9B16Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695ce5b9B16Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5111828336	f	2026-01-06 10:36:41.989572	2026-01-06 10:37:59.125674	298139954878	t	2026-01-06 10:37:57.653857+00
213	3c70dd22-df28-4a50-a034-4a378507c5bf	PINEO3X02CV1W1N	HC1767695898923L6Z	200.00	10.00	\N	Jaya Patelrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2523557518", "txnid": "PINEO3X02CV1W1N", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695ce61bbf77A&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695ce61bbf77A&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695ce61bbf77A&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695ce61bbf77A&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_3F695ce61bbf77A", "upi_tr": "pt_3F695ce61bbf77A", "txnid": "ORDID2523557518", "orderid": "ORDID2523557518", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695ce61bbf77A&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3F695ce61bbf77A&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2523557518	f	2026-01-06 10:38:20.034724	2026-01-06 10:38:20.034727	\N	f	\N
236	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHDCTQ1R6156Y	HC1767696252877LL6	100.00	5.00	\N	Ganesh Mishraappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6483854140", "txnid": "PINHDCTQ1R6156Y", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695ce77D8bDDC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695ce77D8bDDC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695ce77D8bDDC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695ce77D8bDDC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_94695ce77D8bDDC", "upi_tr": "pt_94695ce77D8bDDC", "txnid": "ORDID6483854140", "orderid": "ORDID6483854140", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695ce77D8bDDC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695ce77D8bDDC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6483854140	f	2026-01-06 10:44:13.799925	2026-01-06 10:44:13.79993	\N	f	\N
212	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV16W76377GKK	HC1767695877222E9T	100.00	5.00	\N	Deepak Dasappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4753048230", "txnid": "PINV16W76377GKK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE605e9077&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE605e9077&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE605e9077&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE605e9077&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C7695CE605e9077", "upi_tr": "pt_C7695CE605e9077", "txnid": "ORDID4753048230", "orderid": "ORDID4753048230", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4753048230", "rrn": "116770615417"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE605e9077&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE605e9077&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4753048230	f	2026-01-06 10:37:58.239303	2026-01-06 10:38:34.173315	116770615417	t	2026-01-06 10:38:32.42038+00
214	3c70dd22-df28-4a50-a034-4a378507c5bf	PINWRCRIEGVQ3RK	HC1767695920357JKM	200.00	10.00	\N	Vijay Chauhanlal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6546609602", "txnid": "PINWRCRIEGVQ3RK", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cE6311ee5D&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cE6311ee5D&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cE6311ee5D&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cE6311ee5D&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_62695cE6311ee5D", "upi_tr": "pt_62695cE6311ee5D", "txnid": "ORDID6546609602", "orderid": "ORDID6546609602", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cE6311ee5D&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_62695cE6311ee5D&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6546609602	f	2026-01-06 10:38:41.38568	2026-01-06 10:38:41.385684	\N	f	\N
219	3c70dd22-df28-4a50-a034-4a378507c5bf	PINAKZEQ2U6QJ8W	HC1767696003383BEL	200.00	10.00	\N	Bhavna Naidu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1692811726", "txnid": "PINAKZEQ2U6QJ8W", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B6695cE684397F3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B6695cE684397F3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B6695cE684397F3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B6695cE684397F3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B6695cE684397F3", "upi_tr": "pt_B6695cE684397F3", "txnid": "ORDID1692811726", "orderid": "ORDID1692811726", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B6695cE684397F3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B6695cE684397F3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1692811726	f	2026-01-06 10:40:04.476397	2026-01-06 10:40:04.476402	\N	f	\N
211	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9MV4GFBQZ07C	HC1767695873796HHQ	100.00	5.00	\N	Govind Kapoorlal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2739046531", "txnid": "PIN9MV4GFBQZ07C", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CE602828a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CE602828a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CE602828a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CE602828a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9B695CE602828a6", "upi_tr": "pt_9B695CE602828a6", "txnid": "ORDID2739046531", "orderid": "ORDID2739046531", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2739046531", "rrn": "378688481036"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CE602828a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CE602828a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2739046531	f	2026-01-06 10:37:54.809641	2026-01-06 10:38:54.205937	378688481036	t	2026-01-06 10:38:51.299178+00
215	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRGID7WJUBK55	HC17676959398227YT	100.00	5.00	\N	Harish Menonbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6836040973", "txnid": "PINRGID7WJUBK55", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695cE64483CF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695cE64483CF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695cE64483CF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695cE64483CF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_39695cE64483CF9", "upi_tr": "pt_39695cE64483CF9", "txnid": "ORDID6836040973", "orderid": "ORDID6836040973", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695cE64483CF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695cE64483CF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6836040973	f	2026-01-06 10:39:00.799546	2026-01-06 10:39:00.799551	\N	f	\N
217	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQRLLHGPU7VAW	HC1767695980969V6C	100.00	5.00	\N	Chitra Menonji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2723654273", "txnid": "PINQRLLHGPU7VAW", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695ce66dB6e8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695ce66dB6e8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695ce66dB6e8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695ce66dB6e8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A0695ce66dB6e8d", "upi_tr": "pt_A0695ce66dB6e8d", "txnid": "ORDID2723654273", "orderid": "ORDID2723654273", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695ce66dB6e8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A0695ce66dB6e8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2723654273	f	2026-01-06 10:39:41.996434	2026-01-06 10:39:41.996438	\N	f	\N
218	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCHQ61MTEMRQV	HC1767695986185XF9	100.00	5.00	\N	Jaya Jainji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8859081589", "txnid": "PINCHQ61MTEMRQV", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE672D5e70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE672D5e70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE672D5e70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE672D5e70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_97695CE672D5e70", "upi_tr": "pt_97695CE672D5e70", "txnid": "ORDID8859081589", "orderid": "ORDID8859081589", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE672D5e70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_97695CE672D5e70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8859081589	f	2026-01-06 10:39:47.118877	2026-01-06 10:39:47.11888	\N	f	\N
216	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8A3ORNYRWQDC	HC1767695968122366	100.00	5.00	\N	Priya Thakurji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9343234052", "txnid": "PIN8A3ORNYRWQDC", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695CE660ea1a5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695CE660ea1a5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695CE660ea1a5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695CE660ea1a5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_CC695CE660ea1a5", "upi_tr": "pt_CC695CE660ea1a5", "txnid": "ORDID9343234052", "orderid": "ORDID9343234052", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9343234052", "rrn": "902117481089"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695CE660ea1a5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695CE660ea1a5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9343234052	f	2026-01-06 10:39:29.214333	2026-01-06 10:40:04.588592	902117481089	t	2026-01-06 10:39:59.781548+00
314	3c70dd22-df28-4a50-a034-4a378507c5bf	PINPTUHWAXN4SUZ	HC1767697556107P7M	100.00	5.00	\N	Tanya Mishraesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7408965611", "txnid": "PINPTUHWAXN4SUZ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695Cec94CC63b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695Cec94CC63b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695Cec94CC63b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695Cec94CC63b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9F695Cec94CC63b", "upi_tr": "pt_9F695Cec94CC63b", "txnid": "ORDID7408965611", "orderid": "ORDID7408965611", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7408965611", "rrn": "637231227093"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695Cec94CC63b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695Cec94CC63b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7408965611	f	2026-01-06 11:05:57.105027	2026-01-06 11:06:36.308553	637231227093	t	2026-01-06 11:06:34.528526+00
240	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4G09O6SMPYAW	HC1767696298159EDK	100.00	5.00	\N	Amit Pandeyji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4506667606", "txnid": "PIN4G09O6SMPYAW", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1e695ce7AAD79C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1e695ce7AAD79C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1e695ce7AAD79C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1e695ce7AAD79C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1e695ce7AAD79C3", "upi_tr": "pt_1e695ce7AAD79C3", "txnid": "ORDID4506667606", "orderid": "ORDID4506667606", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4506667606", "rrn": "497110744130"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1e695ce7AAD79C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1e695ce7AAD79C3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4506667606	f	2026-01-06 10:44:59.153116	2026-01-06 10:45:34.937497	497110744130	t	2026-01-06 10:45:32.422828+00
243	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDNC3DTEQG41X	HC1767696395034337	100.00	5.00	\N	Zoya Patelendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1361125438", "txnid": "PINDNC3DTEQG41X", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695ce80bB4aFa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695ce80bB4aFa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695ce80bB4aFa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695ce80bB4aFa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_86695ce80bB4aFa", "upi_tr": "pt_86695ce80bB4aFa", "txnid": "ORDID1361125438", "orderid": "ORDID1361125438", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695ce80bB4aFa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695ce80bB4aFa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1361125438	f	2026-01-06 10:46:35.985004	2026-01-06 10:46:35.985031	\N	f	\N
11275	0ccb76fc-6666-4a61-8498-63864856131e	PIN60NY180CXIP9	197189582	200.00	11.80	\N	Aarya verma	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4156902650", "txnid": "PIN60NY180CXIP9", "amount": "200", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_E369661977A741a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_E369661977A741a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_E369661977A741a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_E369661977A741a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID4156902650", "orderid": "ORDID4156902650", "bankutr": "pending"}}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_E369661977A741a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_E369661977A741a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID4156902650	f	2026-01-13 10:07:51.919938	2026-01-13 10:07:51.919941	\N	f	\N
244	3c70dd22-df28-4a50-a034-4a378507c5bf	PINE9XTV3H2L2QN	HC1767696418787OV3	100.00	5.00	\N	Kiran Desaikar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1615784779", "txnid": "PINE9XTV3H2L2QN", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695cE823765C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695cE823765C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695cE823765C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695cE823765C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2d695cE823765C0", "upi_tr": "pt_2d695cE823765C0", "txnid": "ORDID1615784779", "orderid": "ORDID1615784779", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695cE823765C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2d695cE823765C0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1615784779	f	2026-01-06 10:46:59.727554	2026-01-06 10:46:59.727559	\N	f	\N
248	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTWU4ZC1LH65R	HC1767696468478IL3	100.00	5.00	\N	Mohan Chatterjeenath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9098713950", "txnid": "PINTWU4ZC1LH65R", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695cE8552A277&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695cE8552A277&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695cE8552A277&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695cE8552A277&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_59695cE8552A277", "upi_tr": "pt_59695cE8552A277", "txnid": "ORDID9098713950", "orderid": "ORDID9098713950", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695cE8552A277&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695cE8552A277&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9098713950	f	2026-01-06 10:47:49.420357	2026-01-06 10:47:49.42036	\N	f	\N
315	3c70dd22-df28-4a50-a034-4a378507c5bf	PINY98RJ25ZPPA2	HC1767697560152SJN	100.00	5.00	\N	Radhika Naiduendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7221543050", "txnid": "PINY98RJ25ZPPA2", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aB695CEc98dAB9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aB695CEc98dAB9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aB695CEc98dAB9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aB695CEc98dAB9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_aB695CEc98dAB9a", "upi_tr": "pt_aB695CEc98dAB9a", "txnid": "ORDID7221543050", "orderid": "ORDID7221543050", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7221543050", "rrn": "620562222781"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aB695CEc98dAB9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aB695CEc98dAB9a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7221543050	f	2026-01-06 11:06:01.16618	2026-01-06 11:06:36.322344	620562222781	t	2026-01-06 11:06:34.666576+00
242	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3LCSEOPM0P4H	HC17676963183512CC	100.00	5.00	\N	Rani Singhrao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1637687823", "txnid": "PIN3LCSEOPM0P4H", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8a695Ce7bf086CC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8a695Ce7bf086CC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8a695Ce7bf086CC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8a695Ce7bf086CC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8a695Ce7bf086CC", "upi_tr": "pt_8a695Ce7bf086CC", "txnid": "ORDID1637687823", "orderid": "ORDID1637687823", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1637687823", "rrn": "046318622848"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8a695Ce7bf086CC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8a695Ce7bf086CC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1637687823	f	2026-01-06 10:45:19.279567	2026-01-06 10:45:54.963932	046318622848	t	2026-01-06 10:45:53.338335+00
245	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6SDJD5YH66K8	HC1767696434768L6K	200.00	10.00	\N	Ankita Mehtababu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3816764939", "txnid": "PIN6SDJD5YH66K8", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c4695CE83380673&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c4695CE83380673&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c4695CE83380673&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c4695CE83380673&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_c4695CE83380673", "upi_tr": "pt_c4695CE83380673", "txnid": "ORDID3816764939", "orderid": "ORDID3816764939", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c4695CE83380673&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c4695CE83380673&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3816764939	f	2026-01-06 10:47:15.784085	2026-01-06 10:47:15.784089	\N	f	\N
247	3c70dd22-df28-4a50-a034-4a378507c5bf	PINWCZIAQDQUA6X	HC17676964667488EW	200.00	10.00	\N	Lakshmi Joshilal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6376961444", "txnid": "PINWCZIAQDQUA6X", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9e695CE85370413&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9e695CE85370413&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9e695CE85370413&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9e695CE85370413&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9e695CE85370413", "upi_tr": "pt_9e695CE85370413", "txnid": "ORDID6376961444", "orderid": "ORDID6376961444", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9e695CE85370413&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9e695CE85370413&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6376961444	f	2026-01-06 10:47:47.716249	2026-01-06 10:47:47.716253	\N	f	\N
249	3c70dd22-df28-4a50-a034-4a378507c5bf	PINEGCP0LD3R71F	HC1767696468691TKM	200.00	10.00	\N	Suresh Menonendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8426073842", "txnid": "PINEGCP0LD3R71F", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695ce85569dfC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695ce85569dfC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695ce85569dfC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695ce85569dfC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e3695ce85569dfC", "upi_tr": "pt_e3695ce85569dfC", "txnid": "ORDID8426073842", "orderid": "ORDID8426073842", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695ce85569dfC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695ce85569dfC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8426073842	f	2026-01-06 10:47:49.687234	2026-01-06 10:47:49.687237	\N	f	\N
246	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJENU3YFBGVEV	HC1767696448382BBY	200.00	10.00	\N	Rani Aggarwalish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4220440684", "txnid": "PINJENU3YFBGVEV", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695ce8411a305&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695ce8411a305&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695ce8411a305&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695ce8411a305&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_01695ce8411a305", "upi_tr": "pt_01695ce8411a305", "txnid": "ORDID4220440684", "orderid": "ORDID4220440684", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4220440684", "rrn": "208807278700"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695ce8411a305&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695ce8411a305&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4220440684	f	2026-01-06 10:47:29.378072	2026-01-06 10:48:10.077759	208807278700	t	2026-01-06 10:48:08.087174+00
250	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDOUB5YQKOH9B	HC1767696530736Y04	200.00	10.00	\N	Vaishali Shahendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8853565169", "txnid": "PINDOUB5YQKOH9B", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695Ce893700cC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695Ce893700cC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695Ce893700cC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695Ce893700cC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_3b695Ce893700cC", "upi_tr": "pt_3b695Ce893700cC", "txnid": "ORDID8853565169", "orderid": "ORDID8853565169", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695Ce893700cC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695Ce893700cC&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8853565169	f	2026-01-06 10:48:51.70137	2026-01-06 10:48:51.701374	\N	f	\N
253	3c70dd22-df28-4a50-a034-4a378507c5bf	PINE3LK80OUNG4L	HC1767696561309NY2	100.00	5.00	\N	Harish Raokar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6583847087", "txnid": "PINE3LK80OUNG4L", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6b695ce8B20B1Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6b695ce8B20B1Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6b695ce8B20B1Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6b695ce8B20B1Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6b695ce8B20B1Ea", "upi_tr": "pt_6b695ce8B20B1Ea", "txnid": "ORDID6583847087", "orderid": "ORDID6583847087", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6b695ce8B20B1Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6b695ce8B20B1Ea&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6583847087	f	2026-01-06 10:49:22.298702	2026-01-06 10:49:22.298706	\N	f	\N
263	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBOYURNG8LJG1	HC17676966785964YP	100.00	5.00	\N	Anjali Desairao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2024004962", "txnid": "PINBOYURNG8LJG1", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695Ce92756F9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695Ce92756F9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695Ce92756F9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695Ce92756F9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_66695Ce92756F9c", "upi_tr": "pt_66695Ce92756F9c", "txnid": "ORDID2024004962", "orderid": "ORDID2024004962", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695Ce92756F9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695Ce92756F9c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2024004962	f	2026-01-06 10:51:19.60319	2026-01-06 10:51:19.603194	\N	f	\N
273	3c70dd22-df28-4a50-a034-4a378507c5bf	PINANNY525WP0LQ	HC1767696872905RC3	100.00	5.00	\N	Priya Dwivedikar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1355194890", "txnid": "PINANNY525WP0LQ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce9E9992a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce9E9992a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce9E9992a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce9E9992a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7f695ce9E9992a6", "upi_tr": "pt_7f695ce9E9992a6", "txnid": "ORDID1355194890", "orderid": "ORDID1355194890", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce9E9992a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7f695ce9E9992a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1355194890	f	2026-01-06 10:54:33.882442	2026-01-06 10:54:33.882446	\N	f	\N
320	3c70dd22-df28-4a50-a034-4a378507c5bf	PINPH0SIB2L5TU0	HC1767697602135PEC	100.00	5.00	\N	Kailash Singhbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3764067973", "txnid": "PINPH0SIB2L5TU0", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695CECc2cC8F7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695CECc2cC8F7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695CECc2cC8F7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695CECc2cC8F7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_65695CECc2cC8F7", "upi_tr": "pt_65695CECc2cC8F7", "txnid": "ORDID3764067973", "orderid": "ORDID3764067973", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695CECc2cC8F7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695CECc2cC8F7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3764067973	f	2026-01-06 11:06:43.090775	2026-01-06 11:06:43.090779	\N	f	\N
396	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQ5YKPDGBC2WT	HC17676995955664S3	100.00	5.00	\N	Swati Kapoorendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1237764829", "txnid": "PINQ5YKPDGBC2WT", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cf48C41996&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cf48C41996&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cf48C41996&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cf48C41996&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_58695cf48C41996", "upi_tr": "pt_58695cf48C41996", "txnid": "ORDID1237764829", "orderid": "ORDID1237764829", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cf48C41996&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cf48C41996&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1237764829	f	2026-01-06 11:39:56.524541	2026-01-06 11:39:56.524544	\N	f	\N
252	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4AFVRFPVJ0PN	HC1767696539955LIP	200.00	10.00	\N	Ritika Kulkarniish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2435072752", "txnid": "PIN4AFVRFPVJ0PN", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695ce89ca2688&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695ce89ca2688&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695ce89ca2688&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695ce89ca2688&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_46695ce89ca2688", "upi_tr": "pt_46695ce89ca2688", "txnid": "ORDID2435072752", "orderid": "ORDID2435072752", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2435072752", "rrn": "878993143321"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695ce89ca2688&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695ce89ca2688&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2435072752	f	2026-01-06 10:49:00.922921	2026-01-06 10:49:40.148874	878993143321	t	2026-01-06 10:49:35.2222+00
256	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBICYK5J4HVSS	HC1767696589030XIG	100.00	5.00	\N	Meena Dubeyish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1422013015", "txnid": "PINBICYK5J4HVSS", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695ce8CdadF62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695ce8CdadF62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695ce8CdadF62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695ce8CdadF62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_43695ce8CdadF62", "upi_tr": "pt_43695ce8CdadF62", "txnid": "ORDID1422013015", "orderid": "ORDID1422013015", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695ce8CdadF62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695ce8CdadF62&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1422013015	f	2026-01-06 10:49:49.965896	2026-01-06 10:49:49.965899	\N	f	\N
254	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFXVM9PYGVT56	HC1767696567376V28	100.00	5.00	\N	Govind Malhotraappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1531672855", "txnid": "PINFXVM9PYGVT56", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CE8B816242&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CE8B816242&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CE8B816242&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CE8B816242&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_36695CE8B816242", "upi_tr": "pt_36695CE8B816242", "txnid": "ORDID1531672855", "orderid": "ORDID1531672855", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1531672855", "rrn": "824299509330"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CE8B816242&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CE8B816242&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1531672855	f	2026-01-06 10:49:28.358628	2026-01-06 10:50:45.301476	824299509330	t	2026-01-06 10:50:44.49143+00
255	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4K7S1GK06DKC	HC1767696571072RSV	100.00	5.00	\N	Mohan Kumarram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9768861779", "txnid": "PIN4K7S1GK06DKC", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695cE8BBBd7Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695cE8BBBd7Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695cE8BBBd7Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695cE8BBBd7Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_44695cE8BBBd7Fe", "upi_tr": "pt_44695cE8BBBd7Fe", "txnid": "ORDID9768861779", "orderid": "ORDID9768861779", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9768861779", "rrn": "690823270275"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695cE8BBBd7Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695cE8BBBd7Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9768861779	f	2026-01-06 10:49:32.014088	2026-01-06 10:50:05.199465	690823270275	t	2026-01-06 10:50:02.35473+00
259	3c70dd22-df28-4a50-a034-4a378507c5bf	PINVQQCY2K4WUHI	HC1767696610819MDF	100.00	5.00	\N	Harish Joshirao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7659428508", "txnid": "PINVQQCY2K4WUHI", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BD695Ce8e387d12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BD695Ce8e387d12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BD695Ce8e387d12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BD695Ce8e387d12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_BD695Ce8e387d12", "upi_tr": "pt_BD695Ce8e387d12", "txnid": "ORDID7659428508", "orderid": "ORDID7659428508", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BD695Ce8e387d12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BD695Ce8e387d12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7659428508	f	2026-01-06 10:50:11.811749	2026-01-06 10:50:11.811753	\N	f	\N
261	3c70dd22-df28-4a50-a034-4a378507c5bf	PINUMZWGVCAVYSH	HC1767696640801IYB	100.00	5.00	\N	Keshav Jainram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9988440346", "txnid": "PINUMZWGVCAVYSH", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695CE9018f6F3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695CE9018f6F3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695CE9018f6F3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695CE9018f6F3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F4695CE9018f6F3", "upi_tr": "pt_F4695CE9018f6F3", "txnid": "ORDID9988440346", "orderid": "ORDID9988440346", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695CE9018f6F3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695CE9018f6F3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9988440346	f	2026-01-06 10:50:41.884941	2026-01-06 10:50:41.884946	\N	f	\N
251	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3GY2VJNL48DF	HC1767696536894OT4	100.00	5.00	\N	Suresh Shahananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7224012479", "txnid": "PIN3GY2VJNL48DF", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695ce8999591b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695ce8999591b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695ce8999591b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695ce8999591b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_09695ce8999591b", "upi_tr": "pt_09695ce8999591b", "txnid": "ORDID7224012479", "orderid": "ORDID7224012479", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7224012479", "rrn": "395020883747"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695ce8999591b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695ce8999591b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7224012479	f	2026-01-06 10:48:57.870535	2026-01-06 10:50:20.230288	395020883747	t	2026-01-06 10:50:18.387983+00
258	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLEGMF0DY1PDK	HC17676966086739AE	100.00	5.00	\N	Sheetal Shahappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8551108352", "txnid": "PINLEGMF0DY1PDK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695CE8E1755Bf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695CE8E1755Bf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695CE8E1755Bf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695CE8E1755Bf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A2695CE8E1755Bf", "upi_tr": "pt_A2695CE8E1755Bf", "txnid": "ORDID8551108352", "orderid": "ORDID8551108352", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8551108352", "rrn": "944487385534"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695CE8E1755Bf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A2695CE8E1755Bf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8551108352	f	2026-01-06 10:50:09.713735	2026-01-06 10:50:40.260978	944487385534	t	2026-01-06 10:50:38.072568+00
317	3c70dd22-df28-4a50-a034-4a378507c5bf	PINA7P22D206QM9	HC1767697566637YBY	200.00	10.00	\N	Sanjay Guptaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7259242566", "txnid": "PINA7P22D206QM9", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A3695CEc9F5E5D9&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A3695CEc9F5E5D9&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A3695CEc9F5E5D9&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A3695CEc9F5E5D9&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A3695CEc9F5E5D9", "upi_tr": "pt_A3695CEc9F5E5D9", "txnid": "ORDID7259242566", "orderid": "ORDID7259242566", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7259242566", "rrn": "395021821113"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A3695CEc9F5E5D9&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A3695CEc9F5E5D9&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7259242566	f	2026-01-06 11:06:07.659367	2026-01-06 11:06:51.350868	395021821113	t	2026-01-06 11:06:46.590733+00
257	3c70dd22-df28-4a50-a034-4a378507c5bf	PINYEY5ODQZBCHM	HC1767696592972FB0	200.00	10.00	\N	Yamini Reddybabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2494677663", "txnid": "PINYEY5ODQZBCHM", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695CE8d1AEf35&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695CE8d1AEf35&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695CE8d1AEf35&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695CE8d1AEf35&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_47695CE8d1AEf35", "upi_tr": "pt_47695CE8d1AEf35", "txnid": "ORDID2494677663", "orderid": "ORDID2494677663", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2494677663", "rrn": "924331293412"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695CE8d1AEf35&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_47695CE8d1AEf35&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2494677663	f	2026-01-06 10:49:53.96137	2026-01-06 10:50:40.280002	924331293412	t	2026-01-06 10:50:38.273357+00
332	3c70dd22-df28-4a50-a034-4a378507c5bf	PINOEHRSH8IXJ0Z	HC1767697846216T32	100.00	5.00	\N	Komal Raoappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2893012925", "txnid": "PINOEHRSH8IXJ0Z", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E4695cedb6eB133&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E4695cedb6eB133&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E4695cedb6eB133&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E4695cedb6eB133&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E4695cedb6eB133", "upi_tr": "pt_E4695cedb6eB133", "txnid": "ORDID2893012925", "orderid": "ORDID2893012925", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E4695cedb6eB133&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E4695cedb6eB133&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2893012925	f	2026-01-06 11:10:47.223688	2026-01-06 11:10:47.223692	\N	f	\N
272	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN90FKXHS0FFOC	HC17676968071533PV	100.00	5.00	\N	Pallavi Mishranath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8896536589", "txnid": "PIN90FKXHS0FFOC", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695CE9a7Cd25b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695CE9a7Cd25b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695CE9a7Cd25b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695CE9a7Cd25b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_59695CE9a7Cd25b", "upi_tr": "pt_59695CE9a7Cd25b", "txnid": "ORDID8896536589", "orderid": "ORDID8896536589", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695CE9a7Cd25b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_59695CE9a7Cd25b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8896536589	f	2026-01-06 10:53:28.12256	2026-01-06 10:53:28.122564	\N	f	\N
322	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNDCHDFRE5PEZ	HC1767697614250PCG	100.00	5.00	\N	Zoya Kulkarnibabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3491484501", "txnid": "PINNDCHDFRE5PEZ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f5695CECcee7c12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f5695CECcee7c12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f5695CECcee7c12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f5695CECcee7c12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_f5695CECcee7c12", "upi_tr": "pt_f5695CECcee7c12", "txnid": "ORDID3491484501", "orderid": "ORDID3491484501", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f5695CECcee7c12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f5695CECcee7c12&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3491484501	f	2026-01-06 11:06:55.195771	2026-01-06 11:06:55.195775	\N	f	\N
264	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLFDXNUF8ZNRV	HC1767696682720TDY	100.00	5.00	\N	Lalit Duttakar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8315748958", "txnid": "PINLFDXNUF8ZNRV", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695Ce92B6f154&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695Ce92B6f154&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695Ce92B6f154&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695Ce92B6f154&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5e695Ce92B6f154", "upi_tr": "pt_5e695Ce92B6f154", "txnid": "ORDID8315748958", "orderid": "ORDID8315748958", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695Ce92B6f154&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695Ce92B6f154&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8315748958	f	2026-01-06 10:51:23.70461	2026-01-06 10:51:23.704613	\N	f	\N
262	3c70dd22-df28-4a50-a034-4a378507c5bf	PINH2109NQN493C	HC1767696667523FXZ	100.00	5.00	\N	Swati Chauhanji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6383472227", "txnid": "PINH2109NQN493C", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B5695ce91C3CC54&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B5695ce91C3CC54&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B5695ce91C3CC54&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B5695ce91C3CC54&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B5695ce91C3CC54", "upi_tr": "pt_B5695ce91C3CC54", "txnid": "ORDID6383472227", "orderid": "ORDID6383472227", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6383472227", "rrn": "830050021644"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B5695ce91C3CC54&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B5695ce91C3CC54&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6383472227	f	2026-01-06 10:51:08.487036	2026-01-06 10:51:40.369493	830050021644	t	2026-01-06 10:51:37.265103+00
269	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMHD9CFWZBY19	HC17676967856471UB	200.00	10.00	\N	Lalit Singh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5801122082", "txnid": "PINMHD9CFWZBY19", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Ce99254601&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Ce99254601&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Ce99254601&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Ce99254601&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d6695Ce99254601", "upi_tr": "pt_d6695Ce99254601", "txnid": "ORDID5801122082", "orderid": "ORDID5801122082", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Ce99254601&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d6695Ce99254601&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5801122082	f	2026-01-06 10:53:06.594066	2026-01-06 10:53:06.594071	\N	f	\N
271	3c70dd22-df28-4a50-a034-4a378507c5bf	PINEOPCHV3BVWKY	HC1767696793126DE6	100.00	5.00	\N	Yamini Chatterjeeendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9822276924", "txnid": "PINEOPCHV3BVWKY", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695ce999D0bb4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695ce999D0bb4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695ce999D0bb4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695ce999D0bb4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9E695ce999D0bb4", "upi_tr": "pt_9E695ce999D0bb4", "txnid": "ORDID9822276924", "orderid": "ORDID9822276924", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695ce999D0bb4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9E695ce999D0bb4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9822276924	f	2026-01-06 10:53:14.117789	2026-01-06 10:53:14.117793	\N	f	\N
260	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1TQ5KJUQB3BU	HC1767696640775LAK	100.00	5.00	\N	Ankita Patelendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4207854956", "txnid": "PIN1TQ5KJUQB3BU", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695CE90175aF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695CE90175aF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695CE90175aF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695CE90175aF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F3695CE90175aF9", "upi_tr": "pt_F3695CE90175aF9", "txnid": "ORDID4207854956", "orderid": "ORDID4207854956", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4207854956", "rrn": "600662872062"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695CE90175aF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695CE90175aF9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4207854956	f	2026-01-06 10:50:41.731516	2026-01-06 10:51:25.34399	600662872062	t	2026-01-06 10:51:25.112224+00
265	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLT4C9IHQCUXS	HC1767696737534TKN	100.00	5.00	\N	Raj Malhotralal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9927478966", "txnid": "PINLT4C9IHQCUXS", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_78695Ce9623e5A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_78695Ce9623e5A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_78695Ce9623e5A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_78695Ce9623e5A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_78695Ce9623e5A0", "upi_tr": "pt_78695Ce9623e5A0", "txnid": "ORDID9927478966", "orderid": "ORDID9927478966", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_78695Ce9623e5A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_78695Ce9623e5A0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9927478966	f	2026-01-06 10:52:18.489077	2026-01-06 10:52:18.489081	\N	f	\N
267	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN99C662Z91NNC	HC1767696768357N21	200.00	10.00	\N	Kiran Shahbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6620073527", "txnid": "PIN99C662Z91NNC", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Ce9810a808&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Ce9810a808&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Ce9810a808&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Ce9810a808&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_93695Ce9810a808", "upi_tr": "pt_93695Ce9810a808", "txnid": "ORDID6620073527", "orderid": "ORDID6620073527", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Ce9810a808&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_93695Ce9810a808&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6620073527	f	2026-01-06 10:52:49.299518	2026-01-06 10:52:49.29952	\N	f	\N
274	3c70dd22-df28-4a50-a034-4a378507c5bf	PINAVMMZBVUCDH4	HC1767696876500IBP	200.00	10.00	\N	Vaishali Chandrasekarrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5398275018", "txnid": "PINAVMMZBVUCDH4", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cE9ed3741F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cE9ed3741F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cE9ed3741F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cE9ed3741F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C7695cE9ed3741F", "upi_tr": "pt_C7695cE9ed3741F", "txnid": "ORDID5398275018", "orderid": "ORDID5398275018", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cE9ed3741F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cE9ed3741F&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5398275018	f	2026-01-06 10:54:37.491732	2026-01-06 10:54:37.491737	\N	f	\N
334	3c70dd22-df28-4a50-a034-4a378507c5bf	PINPJQB6UKICVA6	HC1767697849489NBN	100.00	5.00	\N	Dinesh Singhish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9045569553", "txnid": "PINPJQB6UKICVA6", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cedba2c11f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cedba2c11f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cedba2c11f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cedba2c11f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_20695cedba2c11f", "upi_tr": "pt_20695cedba2c11f", "txnid": "ORDID9045569553", "orderid": "ORDID9045569553", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cedba2c11f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cedba2c11f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9045569553	f	2026-01-06 11:10:50.457704	2026-01-06 11:10:50.457709	\N	f	\N
266	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6YOY3VY8ZSXK	HC1767696760306FUB	100.00	5.00	\N	Ganesh Kulkarniananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7379253635", "txnid": "PIN6YOY3VY8ZSXK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695Ce97912BCB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695Ce97912BCB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695Ce97912BCB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695Ce97912BCB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_18695Ce97912BCB", "upi_tr": "pt_18695Ce97912BCB", "txnid": "ORDID7379253635", "orderid": "ORDID7379253635", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7379253635", "rrn": "441996173977"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695Ce97912BCB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695Ce97912BCB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7379253635	f	2026-01-06 10:52:41.332339	2026-01-06 10:53:25.454409	441996173977	t	2026-01-06 10:53:22.044903+00
270	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6N3YIQVDXSM8	HC1767696785729U0I	100.00	5.00	\N	Yogesh Pandeyrao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1857039714", "txnid": "PIN6N3YIQVDXSM8", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE99272Ec8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE99272Ec8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE99272Ec8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE99272Ec8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C7695CE99272Ec8", "upi_tr": "pt_C7695CE99272Ec8", "txnid": "ORDID1857039714", "orderid": "ORDID1857039714", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1857039714", "rrn": "849400423934"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE99272Ec8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695CE99272Ec8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1857039714	f	2026-01-06 10:53:06.788917	2026-01-06 10:53:35.481358	849400423934	t	2026-01-06 10:53:32.392412+00
286	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5E7SG975PF57	HC1767697111751DK8	100.00	5.00	\N	Kailash Chandrasekarappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2907805501", "txnid": "PIN5E7SG975PF57", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695ceAd87751D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695ceAd87751D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695ceAd87751D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695ceAd87751D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_64695ceAd87751D", "upi_tr": "pt_64695ceAd87751D", "txnid": "ORDID2907805501", "orderid": "ORDID2907805501", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695ceAd87751D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695ceAd87751D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2907805501	f	2026-01-06 10:58:32.754721	2026-01-06 10:58:32.754723	\N	f	\N
268	3c70dd22-df28-4a50-a034-4a378507c5bf	PINEVETFA05OY9W	HC1767696777753T3B	100.00	5.00	\N	Lalita Duttanath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9787595712", "txnid": "PINEVETFA05OY9W", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CE98a7b00d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CE98a7b00d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CE98a7b00d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CE98a7b00d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A7695CE98a7b00d", "upi_tr": "pt_A7695CE98a7b00d", "txnid": "ORDID9787595712", "orderid": "ORDID9787595712", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9787595712", "rrn": "395021089975"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CE98a7b00d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CE98a7b00d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9787595712	f	2026-01-06 10:52:58.760964	2026-01-06 10:54:00.527072	395021089975	t	2026-01-06 10:53:57.768071+00
276	3c70dd22-df28-4a50-a034-4a378507c5bf	PINSLB5TWOXQ0KK	HC1767696905009PRP	100.00	5.00	\N	Sneha Chatterjeerao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3699774109", "txnid": "PINSLB5TWOXQ0KK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695CEa09Bbdf7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695CEa09Bbdf7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695CEa09Bbdf7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695CEa09Bbdf7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_53695CEa09Bbdf7", "upi_tr": "pt_53695CEa09Bbdf7", "txnid": "ORDID3699774109", "orderid": "ORDID3699774109", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3699774109", "rrn": "866015627897"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695CEa09Bbdf7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695CEa09Bbdf7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3699774109	f	2026-01-06 10:55:06.077084	2026-01-06 10:55:50.60641	866015627897	t	2026-01-06 10:55:49.258164+00
590	3c70dd22-df28-4a50-a034-4a378507c5bf	PINS50QD3F4ZMUI	HC1767704147120I84	100.00	5.00	\N	Arjun Mehtaji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6042028598", "txnid": "PINS50QD3F4ZMUI", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695d0653ED0c2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695d0653ED0c2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695d0653ED0c2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695d0653ED0c2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_36695d0653ED0c2", "upi_tr": "pt_36695d0653ED0c2", "txnid": "ORDID6042028598", "orderid": "ORDID6042028598", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695d0653ED0c2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695d0653ED0c2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6042028598	f	2026-01-06 12:55:48.244373	2026-01-06 12:55:48.244377	\N	f	\N
331	3c70dd22-df28-4a50-a034-4a378507c5bf	PINUOONNK1SHI5W	HC1767697838969J34	100.00	5.00	\N	Amit Menonendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2596459916", "txnid": "PINUOONNK1SHI5W", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dC695CeDafa6aA9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dC695CeDafa6aA9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dC695CeDafa6aA9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dC695CeDafa6aA9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_dC695CeDafa6aA9", "upi_tr": "pt_dC695CeDafa6aA9", "txnid": "ORDID2596459916", "orderid": "ORDID2596459916", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2596459916", "rrn": "600615164787"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dC695CeDafa6aA9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dC695CeDafa6aA9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2596459916	f	2026-01-06 11:10:39.961762	2026-01-06 11:11:11.614421	600615164787	t	2026-01-06 11:11:06.731177+00
275	3c70dd22-df28-4a50-a034-4a378507c5bf	PINP2EG10I9PKPI	HC1767696898643HFL	100.00	5.00	\N	Jaya Desairao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9462228733", "txnid": "PINP2EG10I9PKPI", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695CeA035eCbc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695CeA035eCbc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695CeA035eCbc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695CeA035eCbc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_11695CeA035eCbc", "upi_tr": "pt_11695CeA035eCbc", "txnid": "ORDID9462228733", "orderid": "ORDID9462228733", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9462228733", "rrn": "659629420432"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695CeA035eCbc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_11695CeA035eCbc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9462228733	f	2026-01-06 10:54:59.644905	2026-01-06 10:55:50.622557	659629420432	t	2026-01-06 10:55:49.519756+00
278	3c70dd22-df28-4a50-a034-4a378507c5bf	PINA6A1FR764XEU	HC17676969819168LF	200.00	10.00	\N	Sneha Kumarendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2118188602", "txnid": "PINA6A1FR764XEU", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695cea56A0146&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695cea56A0146&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695cea56A0146&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695cea56A0146&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_3c695cea56A0146", "upi_tr": "pt_3c695cea56A0146", "txnid": "ORDID2118188602", "orderid": "ORDID2118188602", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695cea56A0146&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695cea56A0146&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2118188602	f	2026-01-06 10:56:22.909224	2026-01-06 10:56:22.909227	\N	f	\N
280	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCR52Y4HV5Z0N	HC1767697006611DYU	200.00	10.00	\N	Ritika Desaikar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6739503060", "txnid": "PINCR52Y4HV5Z0N", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEa6f4f09f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEa6f4f09f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEa6f4f09f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEa6f4f09f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D7695cEa6f4f09f", "upi_tr": "pt_D7695cEa6f4f09f", "txnid": "ORDID6739503060", "orderid": "ORDID6739503060", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEa6f4f09f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEa6f4f09f&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6739503060	f	2026-01-06 10:56:47.587853	2026-01-06 10:56:47.587862	\N	f	\N
318	3c70dd22-df28-4a50-a034-4a378507c5bf	PINK0YVNZXYUGKJ	HC1767697583527EP3	100.00	5.00	\N	Ashok Pandeyram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2547596696", "txnid": "PINK0YVNZXYUGKJ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E1695CECB03b9df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E1695CECB03b9df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E1695CECB03b9df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E1695CECB03b9df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E1695CECB03b9df", "upi_tr": "pt_E1695CECB03b9df", "txnid": "ORDID2547596696", "orderid": "ORDID2547596696", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2547596696", "rrn": "163652633504"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E1695CECB03b9df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E1695CECB03b9df&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2547596696	f	2026-01-06 11:06:24.496162	2026-01-06 11:07:06.378214	163652633504	t	2026-01-06 11:07:06.220171+00
287	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5VMI3WITYGDB	HC1767697157373WBZ	200.00	10.00	\N	Zoya Banerjeeji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5046692851", "txnid": "PIN5VMI3WITYGDB", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695ceB061c264&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695ceB061c264&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695ceB061c264&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695ceB061c264&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6e695ceB061c264", "upi_tr": "pt_6e695ceB061c264", "txnid": "ORDID5046692851", "orderid": "ORDID5046692851", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695ceB061c264&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6e695ceB061c264&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5046692851	f	2026-01-06 10:59:18.370703	2026-01-06 10:59:18.370707	\N	f	\N
277	3c70dd22-df28-4a50-a034-4a378507c5bf	PINB8THF50KG68E	HC1767696971414Q5J	100.00	5.00	\N	Lakshmi Banerjee	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9150045323", "txnid": "PINB8THF50KG68E", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a2695CEa4C2BC42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a2695CEa4C2BC42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a2695CEa4C2BC42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a2695CEa4C2BC42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_a2695CEa4C2BC42", "upi_tr": "pt_a2695CEa4C2BC42", "txnid": "ORDID9150045323", "orderid": "ORDID9150045323", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9150045323", "rrn": "600683376762"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a2695CEa4C2BC42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a2695CEa4C2BC42&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9150045323	f	2026-01-06 10:56:12.445833	2026-01-06 10:56:50.668948	600683376762	t	2026-01-06 10:56:46.628971+00
281	3c70dd22-df28-4a50-a034-4a378507c5bf	PINO7N0WZRLAKYD	HC1767697017026MBK	100.00	5.00	\N	Rahul Joshiendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8955945252", "txnid": "PINO7N0WZRLAKYD", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695cea79B0803&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695cea79B0803&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695cea79B0803&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695cea79B0803&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_aE695cea79B0803", "upi_tr": "pt_aE695cea79B0803", "txnid": "ORDID8955945252", "orderid": "ORDID8955945252", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695cea79B0803&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695cea79B0803&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8955945252	f	2026-01-06 10:56:57.983049	2026-01-06 10:56:57.983053	\N	f	\N
279	3c70dd22-df28-4a50-a034-4a378507c5bf	PINEA4P084EB0A7	HC1767697004989352	100.00	5.00	\N	Pallavi Sharmaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1997760360", "txnid": "PINEA4P084EB0A7", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceA6dab4e7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceA6dab4e7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceA6dab4e7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceA6dab4e7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_27695ceA6dab4e7", "upi_tr": "pt_27695ceA6dab4e7", "txnid": "ORDID1997760360", "orderid": "ORDID1997760360", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1997760360", "rrn": "676423117425"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceA6dab4e7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceA6dab4e7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1997760360	f	2026-01-06 10:56:45.956304	2026-01-06 10:57:20.707121	676423117425	t	2026-01-06 10:57:15.838425+00
282	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8S4S38NNW1WA	HC176769701765820A	100.00	5.00	\N	Lalita Choprarao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4680790343", "txnid": "PIN8S4S38NNW1WA", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cEA7A5e8b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cEA7A5e8b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cEA7A5e8b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cEA7A5e8b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_54695cEA7A5e8b3", "upi_tr": "pt_54695cEA7A5e8b3", "txnid": "ORDID4680790343", "orderid": "ORDID4680790343", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4680790343", "rrn": "785331467111"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cEA7A5e8b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695cEA7A5e8b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4680790343	f	2026-01-06 10:56:58.659305	2026-01-06 10:57:35.734659	785331467111	t	2026-01-06 10:57:33.27512+00
288	3c70dd22-df28-4a50-a034-4a378507c5bf	PINEYFX7RKELQXY	HC17676971574808WF	200.00	10.00	\N	Pallavi Pillairam	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7777139203", "txnid": "PINEYFX7RKELQXY", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cb695cEb063209a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cb695cEb063209a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cb695cEb063209a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cb695cEb063209a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Cb695cEb063209a", "upi_tr": "pt_Cb695cEb063209a", "txnid": "ORDID7777139203", "orderid": "ORDID7777139203", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cb695cEb063209a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cb695cEb063209a&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7777139203	f	2026-01-06 10:59:18.459388	2026-01-06 10:59:18.459392	\N	f	\N
289	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQLYH0DKTBUT5	HC1767697159223P6S	100.00	5.00	\N	Omkar Kumarji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6918775271", "txnid": "PINQLYH0DKTBUT5", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695CEb07EA8cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695CEb07EA8cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695CEb07EA8cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695CEb07EA8cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_a6695CEb07EA8cd", "upi_tr": "pt_a6695CEb07EA8cd", "txnid": "ORDID6918775271", "orderid": "ORDID6918775271", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695CEb07EA8cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695CEb07EA8cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6918775271	f	2026-01-06 10:59:20.209078	2026-01-06 10:59:20.209081	\N	f	\N
283	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMDSHVSDPL7IR	HC17676970558163VE	100.00	5.00	\N	Manoj Reddylal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7259931032", "txnid": "PINMDSHVSDPL7IR", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695CEAA091D57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695CEAA091D57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695CEAA091D57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695CEAA091D57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_99695CEAA091D57", "upi_tr": "pt_99695CEAA091D57", "txnid": "ORDID7259931032", "orderid": "ORDID7259931032", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7259931032", "rrn": "637218827675"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695CEAA091D57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695CEAA091D57&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7259931032	f	2026-01-06 10:57:36.86836	2026-01-06 10:58:05.773432	637218827675	t	2026-01-06 10:58:05.347049+00
285	3c70dd22-df28-4a50-a034-4a378507c5bf	PINSB0Z5IDYQZZV	HC17676971065724YP	100.00	5.00	\N	Vikas Desaiananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3908171245", "txnid": "PINSB0Z5IDYQZZV", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEAd347774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEAd347774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEAd347774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEAd347774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D7695cEAd347774", "upi_tr": "pt_D7695cEAd347774", "txnid": "ORDID3908171245", "orderid": "ORDID3908171245", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEAd347774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D7695cEAd347774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3908171245	f	2026-01-06 10:58:27.546057	2026-01-06 10:58:27.546061	\N	f	\N
284	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN879FPT7UK4IX	HC1767697080498LVL	100.00	5.00	\N	Ravi Kapoorananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9552911836", "txnid": "PIN879FPT7UK4IX", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695cEAb935975&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695cEAb935975&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695cEAb935975&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695cEAb935975&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8c695cEAb935975", "upi_tr": "pt_8c695cEAb935975", "txnid": "ORDID9552911836", "orderid": "ORDID9552911836", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9552911836", "rrn": "187130639139"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695cEAb935975&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695cEAb935975&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9552911836	f	2026-01-06 10:58:01.498539	2026-01-06 10:58:30.80024	187130639139	t	2026-01-06 10:58:30.536545+00
296	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMMBIMSQ4JKLM	HC1767697254490WI5	100.00	5.00	\N	Chitra Malhotraram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1419441471", "txnid": "PINMMBIMSQ4JKLM", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695cEb6731A72&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695cEb6731A72&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695cEb6731A72&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695cEb6731A72&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B0695cEb6731A72", "upi_tr": "pt_B0695cEb6731A72", "txnid": "ORDID1419441471", "orderid": "ORDID1419441471", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695cEb6731A72&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695cEb6731A72&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1419441471	f	2026-01-06 11:00:55.471618	2026-01-06 11:00:55.471623	\N	f	\N
301	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8MD9LUOOVRQ3	HC1767697375490TTL	100.00	5.00	\N	Pooja Pandeyendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3972744881", "txnid": "PIN8MD9LUOOVRQ3", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cebe03536e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cebe03536e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cebe03536e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cebe03536e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_33695cebe03536e", "upi_tr": "pt_33695cebe03536e", "txnid": "ORDID3972744881", "orderid": "ORDID3972744881", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cebe03536e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695cebe03536e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3972744881	f	2026-01-06 11:02:56.474633	2026-01-06 11:02:56.474636	\N	f	\N
290	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN127LQ43JI760	HC1767697166310N9E	100.00	5.00	\N	Radhika Chauhanram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8929978671", "txnid": "PIN127LQ43JI760", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CeB0f0a002&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CeB0f0a002&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CeB0f0a002&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CeB0f0a002&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_88695CeB0f0a002", "upi_tr": "pt_88695CeB0f0a002", "txnid": "ORDID8929978671", "orderid": "ORDID8929978671", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CeB0f0a002&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_88695CeB0f0a002&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8929978671	f	2026-01-06 10:59:27.314215	2026-01-06 10:59:27.31422	\N	f	\N
292	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4AQ91JB2KHIP	HC1767697212165Y5G	100.00	5.00	\N	Ankita Chauhanesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5117005713", "txnid": "PIN4AQ91JB2KHIP", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7b695CEB3CEA0dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7b695CEB3CEA0dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7b695CEB3CEA0dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7b695CEB3CEA0dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7b695CEB3CEA0dc", "upi_tr": "pt_7b695CEB3CEA0dc", "txnid": "ORDID5117005713", "orderid": "ORDID5117005713", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7b695CEB3CEA0dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7b695CEB3CEA0dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5117005713	f	2026-01-06 11:00:13.226152	2026-01-06 11:00:13.226156	\N	f	\N
294	3c70dd22-df28-4a50-a034-4a378507c5bf	PINL03A9GQY2Q4J	HC17676972511132AJ	100.00	5.00	\N	Lakshmi Kapoorji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9635092872", "txnid": "PINL03A9GQY2Q4J", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695ceB63D325a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695ceB63D325a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695ceB63D325a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695ceB63D325a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_bf695ceB63D325a", "upi_tr": "pt_bf695ceB63D325a", "txnid": "ORDID9635092872", "orderid": "ORDID9635092872", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695ceB63D325a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695ceB63D325a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9635092872	f	2026-01-06 11:00:52.138798	2026-01-06 11:00:52.138801	\N	f	\N
335	3c70dd22-df28-4a50-a034-4a378507c5bf	PINPJT8EL7BBWPG	HC176769790432653N	100.00	5.00	\N	Vaishali Verma	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1974653989", "txnid": "PINPJT8EL7BBWPG", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cEdf10764D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cEdf10764D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cEdf10764D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cEdf10764D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_58695cEdf10764D", "upi_tr": "pt_58695cEdf10764D", "txnid": "ORDID1974653989", "orderid": "ORDID1974653989", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cEdf10764D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695cEdf10764D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1974653989	f	2026-01-06 11:11:45.276195	2026-01-06 11:11:45.276198	\N	f	\N
295	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQBHPA4IF4LAK	HC1767697254323DW9	100.00	5.00	\N	Chandan Chauhanananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8344766956", "txnid": "PINQBHPA4IF4LAK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695CeB670EDbD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695CeB670EDbD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695CeB670EDbD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695CeB670EDbD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C2695CeB670EDbD", "upi_tr": "pt_C2695CeB670EDbD", "txnid": "ORDID8344766956", "orderid": "ORDID8344766956", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8344766956", "rrn": "116771767430"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695CeB670EDbD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C2695CeB670EDbD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8344766956	f	2026-01-06 11:00:55.358449	2026-01-06 11:01:25.945743	116771767430	t	2026-01-06 11:01:25.285997+00
291	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN48J6L2JLMWQ1	HC1767697200272TQO	100.00	5.00	\N	Anil Goyalananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7098817106", "txnid": "PIN48J6L2JLMWQ1", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceB312715E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceB312715E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceB312715E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceB312715E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_31695ceB312715E", "upi_tr": "pt_31695ceB312715E", "txnid": "ORDID7098817106", "orderid": "ORDID7098817106", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7098817106", "rrn": "328976586269"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceB312715E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceB312715E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7098817106	f	2026-01-06 11:00:01.444237	2026-01-06 11:00:50.890322	328976586269	t	2026-01-06 11:00:48.291453+00
293	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5UU6PTS0RHF4	HC1767697232136DX1	200.00	10.00	\N	Meena Iyer	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9350288687", "txnid": "PIN5UU6PTS0RHF4", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695ceB50d77C3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695ceB50d77C3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695ceB50d77C3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695ceB50d77C3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_81695ceB50d77C3", "upi_tr": "pt_81695ceB50d77C3", "txnid": "ORDID9350288687", "orderid": "ORDID9350288687", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9350288687", "rrn": "738354930068"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695ceB50d77C3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_81695ceB50d77C3&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9350288687	f	2026-01-06 11:00:33.130101	2026-01-06 11:01:05.915691	738354930068	t	2026-01-06 11:01:02.898359+00
298	3c70dd22-df28-4a50-a034-4a378507c5bf	PINXVJUUWJQB652	HC17676973117812P7	200.00	10.00	\N	Nandini Raorao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5812379249", "txnid": "PINXVJUUWJQB652", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695CebA07F862&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695CebA07F862&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695CebA07F862&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695CebA07F862&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_46695CebA07F862", "upi_tr": "pt_46695CebA07F862", "txnid": "ORDID5812379249", "orderid": "ORDID5812379249", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695CebA07F862&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_46695CebA07F862&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5812379249	f	2026-01-06 11:01:52.782791	2026-01-06 11:01:52.782794	\N	f	\N
300	3c70dd22-df28-4a50-a034-4a378507c5bf	PINX729BVBJJ3R4	HC1767697338549HYQ	100.00	5.00	\N	Sonia Shahkar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8738038385", "txnid": "PINX729BVBJJ3R4", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695cEbBb476d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695cEbBb476d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695cEbBb476d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695cEbBb476d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5D695cEbBb476d6", "upi_tr": "pt_5D695cEbBb476d6", "txnid": "ORDID8738038385", "orderid": "ORDID8738038385", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695cEbBb476d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695cEbBb476d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8738038385	f	2026-01-06 11:02:19.544828	2026-01-06 11:02:19.544833	\N	f	\N
299	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6LE7ZYBDJMWR	HC1767697318170D2H	100.00	5.00	\N	Dinesh Shah	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4509847701", "txnid": "PIN6LE7ZYBDJMWR", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceba6d6E5e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceba6d6E5e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceba6d6E5e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceba6d6E5e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_27695ceba6d6E5e", "upi_tr": "pt_27695ceba6d6E5e", "txnid": "ORDID4509847701", "orderid": "ORDID4509847701", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceba6d6E5e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695ceba6d6E5e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4509847701	f	2026-01-06 11:01:59.156994	2026-01-06 11:01:59.156999	\N	f	\N
324	3c70dd22-df28-4a50-a034-4a378507c5bf	PINETWC5VGX73TO	HC1767697670387T1G	100.00	5.00	\N	Nandini Kulkarniram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6984176326", "txnid": "PINETWC5VGX73TO", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_AB695ceD07220D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_AB695ceD07220D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_AB695ceD07220D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_AB695ceD07220D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_AB695ceD07220D2", "upi_tr": "pt_AB695ceD07220D2", "txnid": "ORDID6984176326", "orderid": "ORDID6984176326", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_AB695ceD07220D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_AB695ceD07220D2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6984176326	f	2026-01-06 11:07:51.405804	2026-01-06 11:07:51.405806	\N	f	\N
297	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIHK2HC7TNWAU	HC1767697298809KJ6	100.00	5.00	\N	Chitra Pillaikar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4150155357", "txnid": "PINIHK2HC7TNWAU", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695CEb93827a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695CEb93827a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695CEb93827a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695CEb93827a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0F695CEb93827a6", "upi_tr": "pt_0F695CEb93827a6", "txnid": "ORDID4150155357", "orderid": "ORDID4150155357", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4150155357", "rrn": "356592217781"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695CEb93827a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695CEb93827a6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4150155357	f	2026-01-06 11:01:39.783414	2026-01-06 11:02:10.985931	356592217781	t	2026-01-06 11:02:10.610322+00
307	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGVMXWKAXN47L	HC1767697448740H8S	200.00	10.00	\N	Kailash Daslal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8373642172", "txnid": "PINGVMXWKAXN47L", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7a695CEc296eAAb&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7a695CEc296eAAb&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7a695CEc296eAAb&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7a695CEc296eAAb&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7a695CEc296eAAb", "upi_tr": "pt_7a695CEc296eAAb", "txnid": "ORDID8373642172", "orderid": "ORDID8373642172", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7a695CEc296eAAb&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7a695CEc296eAAb&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8373642172	f	2026-01-06 11:04:09.708618	2026-01-06 11:04:09.708621	\N	f	\N
309	3c70dd22-df28-4a50-a034-4a378507c5bf	PINVS2YRT3AZIEH	HC1767697456466HMO	200.00	10.00	\N	Ganesh Kumarish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5264740875", "txnid": "PINVS2YRT3AZIEH", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695cEC312DfAF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695cEC312DfAF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695cEC312DfAF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695cEC312DfAF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_09695cEC312DfAF", "upi_tr": "pt_09695cEC312DfAF", "txnid": "ORDID5264740875", "orderid": "ORDID5264740875", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695cEC312DfAF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695cEC312DfAF&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5264740875	f	2026-01-06 11:04:17.447702	2026-01-06 11:04:17.447706	\N	f	\N
304	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIB7RL1BDXV58	HC1767697394458W3Q	100.00	5.00	\N	Deepak Banerjeenath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7814499218", "txnid": "PINIB7RL1BDXV58", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695ceBF339e51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695ceBF339e51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695ceBF339e51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695ceBF339e51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_33695ceBF339e51", "upi_tr": "pt_33695ceBF339e51", "txnid": "ORDID7814499218", "orderid": "ORDID7814499218", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695ceBF339e51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_33695ceBF339e51&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7814499218	f	2026-01-06 11:03:15.50957	2026-01-06 11:03:15.509575	\N	f	\N
306	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBBPZ0CORNBQ5	HC1767697432536AWR	200.00	10.00	\N	Neha Nairappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6629043394", "txnid": "PINBBPZ0CORNBQ5", "amount": "200.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695CEc193C90b&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695CEc193C90b&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695CEc193C90b&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695CEc193C90b&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_03695CEc193C90b", "upi_tr": "pt_03695CEc193C90b", "txnid": "ORDID6629043394", "orderid": "ORDID6629043394", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695CEc193C90b&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695CEc193C90b&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6629043394	f	2026-01-06 11:03:53.50061	2026-01-06 11:03:53.500614	\N	f	\N
325	3c70dd22-df28-4a50-a034-4a378507c5bf	PINVDBFEK0HVMKE	HC1767697680384TEO	100.00	5.00	\N	Meena Desaiappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6612929982", "txnid": "PINVDBFEK0HVMKE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695cED11158A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695cED11158A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695cED11158A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695cED11158A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_01695cED11158A9", "upi_tr": "pt_01695cED11158A9", "txnid": "ORDID6612929982", "orderid": "ORDID6612929982", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695cED11158A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_01695cED11158A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6612929982	f	2026-01-06 11:08:01.347067	2026-01-06 11:08:01.347072	\N	f	\N
327	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4AZCLY713T8O	HC1767697725613KUO	100.00	5.00	\N	Radhika Singhji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9361541226", "txnid": "PIN4AZCLY713T8O", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695ceD3e59B77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695ceD3e59B77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695ceD3e59B77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695ceD3e59B77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d8695ceD3e59B77", "upi_tr": "pt_d8695ceD3e59B77", "txnid": "ORDID9361541226", "orderid": "ORDID9361541226", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9361541226", "rrn": "116772178734"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695ceD3e59B77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d8695ceD3e59B77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9361541226	f	2026-01-06 11:08:46.628527	2026-01-06 11:09:21.485827	116772178734	t	2026-01-06 11:09:21.393858+00
330	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9QAOGJSZF4OD	HC1767697813176YKG	100.00	5.00	\N	Priya Yadavish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4753396503", "txnid": "PIN9QAOGJSZF4OD", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceD95e5Ad3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceD95e5Ad3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceD95e5Ad3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceD95e5Ad3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_31695ceD95e5Ad3", "upi_tr": "pt_31695ceD95e5Ad3", "txnid": "ORDID4753396503", "orderid": "ORDID4753396503", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceD95e5Ad3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_31695ceD95e5Ad3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4753396503	f	2026-01-06 11:10:14.200448	2026-01-06 11:10:14.200452	\N	f	\N
1142	3c70dd22-df28-4a50-a034-4a378507c5bf	PINAMETRK42MK6R	HC17677091563940ZR	100.00	5.00	\N	Ravi Vermaram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4045218091", "txnid": "PINAMETRK42MK6R", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D19e52d1fA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D19e52d1fA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D19e52d1fA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D19e52d1fA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_29695D19e52d1fA", "upi_tr": "pt_29695D19e52d1fA", "txnid": "ORDID4045218091", "orderid": "ORDID4045218091", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D19e52d1fA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D19e52d1fA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4045218091	f	2026-01-06 14:19:17.467559	2026-01-06 14:19:17.467562	\N	f	\N
303	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRK5I178H6SU4	HC1767697394407PK1	100.00	5.00	\N	Chitra Singhesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4017233237", "txnid": "PINRK5I178H6SU4", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695cebf32BF09&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695cebf32BF09&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695cebf32BF09&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695cebf32BF09&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4A695cebf32BF09", "upi_tr": "pt_4A695cebf32BF09", "txnid": "ORDID4017233237", "orderid": "ORDID4017233237", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4017233237", "rrn": "395021656640"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695cebf32BF09&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695cebf32BF09&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4017233237	f	2026-01-06 11:03:15.442647	2026-01-06 11:03:56.051894	395021656640	t	2026-01-06 11:03:52.412507+00
406	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6T533DZQ43DK	HC1767699780623N2F	100.00	5.00	\N	Vaishali Chatterjeeram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8215796112", "txnid": "PIN6T533DZQ43DK", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ee695CF545691B0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ee695CF545691B0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ee695CF545691B0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ee695CF545691B0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Ee695CF545691B0", "upi_tr": "pt_Ee695CF545691B0", "txnid": "ORDID8215796112", "orderid": "ORDID8215796112", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ee695CF545691B0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ee695CF545691B0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8215796112	f	2026-01-06 11:43:01.778355	2026-01-06 11:43:01.778361	\N	f	\N
305	3c70dd22-df28-4a50-a034-4a378507c5bf	PING344KABR87OD	HC1767697425752FH8	100.00	5.00	\N	Savita Guptanath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3584933447", "txnid": "PING344KABR87OD", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695CEc12810bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695CEc12810bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695CEc12810bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695CEc12810bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_52695CEc12810bc", "upi_tr": "pt_52695CEc12810bc", "txnid": "ORDID3584933447", "orderid": "ORDID3584933447", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3584933447", "rrn": "395021690842"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695CEc12810bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695CEc12810bc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3584933447	f	2026-01-06 11:03:46.800555	2026-01-06 11:04:31.103436	395021690842	t	2026-01-06 11:04:28.269235+00
336	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2FF6VV3MG73S	HC1767697917236WUO	100.00	5.00	\N	Sheetal Malhotrarao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4439504037", "txnid": "PIN2FF6VV3MG73S", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695cEdfDE909C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695cEdfDE909C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695cEdfDE909C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695cEdfDE909C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_a6695cEdfDE909C", "upi_tr": "pt_a6695cEdfDE909C", "txnid": "ORDID4439504037", "orderid": "ORDID4439504037", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4439504037", "rrn": "637206386117"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695cEdfDE909C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a6695cEdfDE909C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4439504037	f	2026-01-06 11:11:58.220714	2026-01-06 11:12:36.705295	637206386117	t	2026-01-06 11:12:34.19639+00
302	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZWLP221BR2KF	HC1767697391739IUW	200.00	10.00	\N	Rahul Aggarwalnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5431697979", "txnid": "PINZWLP221BR2KF", "amount": "200", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cEbf07aD30&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cEbf07aD30&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cEbf07aD30&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cEbf07aD30&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C7695cEbf07aD30", "upi_tr": "pt_C7695cEbf07aD30", "txnid": "ORDID5431697979", "orderid": "ORDID5431697979", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5431697979", "rrn": "696906488913"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cEbf07aD30&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C7695cEbf07aD30&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5431697979	f	2026-01-06 11:03:12.764198	2026-01-06 11:03:56.064444	696906488913	t	2026-01-06 11:03:53.502988+00
311	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2SVQVO67XX4A	HC1767697478159Z65	100.00	5.00	\N	Lalit Pandeybabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5159185377", "txnid": "PIN2SVQVO67XX4A", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695CeC46dC732&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695CeC46dC732&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695CeC46dC732&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695CeC46dC732&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_3b695CeC46dC732", "upi_tr": "pt_3b695CeC46dC732", "txnid": "ORDID5159185377", "orderid": "ORDID5159185377", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5159185377", "rrn": "600683515965"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695CeC46dC732&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3b695CeC46dC732&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5159185377	f	2026-01-06 11:04:39.173169	2026-01-06 11:05:06.193449	600683515965	t	2026-01-06 11:05:05.518131+00
323	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTNJEI4Z0P6MX	HC1767697655277IYV	100.00	5.00	\N	Meena Banerjeeish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2437769976", "txnid": "PINTNJEI4Z0P6MX", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695CeCf802d93&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695CeCf802d93&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695CeCf802d93&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695CeCf802d93&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D2695CeCf802d93", "upi_tr": "pt_D2695CeCf802d93", "txnid": "ORDID2437769976", "orderid": "ORDID2437769976", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2437769976", "rrn": "233455184372"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695CeCf802d93&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D2695CeCf802d93&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2437769976	f	2026-01-06 11:07:36.261137	2026-01-06 11:08:26.433983	233455184372	t	2026-01-06 11:08:21.979437+00
328	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1UO51QC8I5JK	HC1767697739153IJ4	100.00	5.00	\N	Sheetal Yadavnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5127273855", "txnid": "PIN1UO51QC8I5JK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695cEd4bcd2EB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695cEd4bcd2EB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695cEd4bcd2EB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695cEd4bcd2EB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_36695cEd4bcd2EB", "upi_tr": "pt_36695cEd4bcd2EB", "txnid": "ORDID5127273855", "orderid": "ORDID5127273855", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5127273855", "rrn": "395021982714"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695cEd4bcd2EB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695cEd4bcd2EB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5127273855	f	2026-01-06 11:09:00.108198	2026-01-06 11:09:36.523097	395021982714	t	2026-01-06 11:09:32.854711+00
395	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIYA0B690RG13	HC17676995890218Z7	100.00	5.00	\N	Tanya Chatterjeenath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9561958533", "txnid": "PINIYA0B690RG13", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695CF485cD35e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695CF485cD35e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695CF485cD35e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695CF485cD35e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_54695CF485cD35e", "upi_tr": "pt_54695CF485cD35e", "txnid": "ORDID9561958533", "orderid": "ORDID9561958533", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9561958533", "rrn": "864616140288"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695CF485cD35e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695CF485cD35e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9561958533	f	2026-01-06 11:39:50.091129	2026-01-06 11:40:37.699262	864616140288	t	2026-01-06 11:40:34.962871+00
326	3c70dd22-df28-4a50-a034-4a378507c5bf	PINB0SB02Z8DT7V	HC1767697723198IYW	100.00	5.00	\N	Komal Chauhanendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6706997496", "txnid": "PINB0SB02Z8DT7V", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEd3beab76&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEd3beab76&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEd3beab76&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEd3beab76&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_f8695cEd3beab76", "upi_tr": "pt_f8695cEd3beab76", "txnid": "ORDID6706997496", "orderid": "ORDID6706997496", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6706997496", "rrn": "928978559564"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEd3beab76&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEd3beab76&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6706997496	f	2026-01-06 11:08:44.225195	2026-01-06 11:09:26.503107	928978559564	t	2026-01-06 11:09:25.750243+00
308	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJD5JCFZ8D4VY	HC1767697455318CWH	100.00	5.00	\N	Tanvi Kapoorish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1328069135", "txnid": "PINJD5JCFZ8D4VY", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dE695CEC300CF44&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dE695CEC300CF44&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dE695CEC300CF44&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dE695CEC300CF44&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_dE695CEC300CF44", "upi_tr": "pt_dE695CEC300CF44", "txnid": "ORDID1328069135", "orderid": "ORDID1328069135", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1328069135", "rrn": "332605686781"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dE695CEC300CF44&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dE695CEC300CF44&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1328069135	f	2026-01-06 11:04:16.313239	2026-01-06 11:04:46.126471	332605686781	t	2026-01-06 11:04:45.974976+00
310	3c70dd22-df28-4a50-a034-4a378507c5bf	PINK5OARAOQ133I	HC1767697467623PDM	100.00	5.00	\N	Manisha Goyalendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3646829162", "txnid": "PINK5OARAOQ133I", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fa695ceC3C5D136&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fa695ceC3C5D136&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fa695ceC3C5D136&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fa695ceC3C5D136&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Fa695ceC3C5D136", "upi_tr": "pt_Fa695ceC3C5D136", "txnid": "ORDID3646829162", "orderid": "ORDID3646829162", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3646829162", "rrn": "241180273026"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fa695ceC3C5D136&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Fa695ceC3C5D136&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3646829162	f	2026-01-06 11:04:28.63444	2026-01-06 11:05:11.214255	241180273026	t	2026-01-06 11:05:07.179316+00
398	3c70dd22-df28-4a50-a034-4a378507c5bf	PINSYP1A00GVO3O	HC1767699668948ILD	100.00	5.00	\N	Govind Mehtaji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3963909117", "txnid": "PINSYP1A00GVO3O", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695cF4D5a23e8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695cF4D5a23e8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695cF4D5a23e8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695cF4D5a23e8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_99695cF4D5a23e8", "upi_tr": "pt_99695cF4D5a23e8", "txnid": "ORDID3963909117", "orderid": "ORDID3963909117", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695cF4D5a23e8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695cF4D5a23e8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3963909117	f	2026-01-06 11:41:09.932228	2026-01-06 11:41:09.932233	\N	f	\N
401	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3LVMNXFBV52C	HC1767699711749JBD	100.00	5.00	\N	Mohan Dubeyendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5130224107", "txnid": "PIN3LVMNXFBV52C", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CF50075034&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CF50075034&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CF50075034&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CF50075034&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A7695CF50075034", "upi_tr": "pt_A7695CF50075034", "txnid": "ORDID5130224107", "orderid": "ORDID5130224107", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CF50075034&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A7695CF50075034&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5130224107	f	2026-01-06 11:41:52.749281	2026-01-06 11:41:52.749286	\N	f	\N
361	3c70dd22-df28-4a50-a034-4a378507c5bf	PINAE4HCS150BUH	HC1767698867227OTG	100.00	5.00	\N	Neha Menonram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8849343036", "txnid": "PINAE4HCS150BUH", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695CF1b3Edbe8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695CF1b3Edbe8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695CF1b3Edbe8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695CF1b3Edbe8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_29695CF1b3Edbe8", "upi_tr": "pt_29695CF1b3Edbe8", "txnid": "ORDID8849343036", "orderid": "ORDID8849343036", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695CF1b3Edbe8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695CF1b3Edbe8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8849343036	f	2026-01-06 11:27:48.221979	2026-01-06 11:27:48.221983	\N	f	\N
312	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBHVZZ21JPBBG	HC1767697510476DG3	100.00	5.00	\N	Vikas Kulkarniesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7993580791", "txnid": "PINBHVZZ21JPBBG", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695CEc67369f1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695CEc67369f1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695CEc67369f1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695CEc67369f1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4A695CEc67369f1", "upi_tr": "pt_4A695CEc67369f1", "txnid": "ORDID7993580791", "orderid": "ORDID7993580791", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7993580791", "rrn": "637223715906"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695CEc67369f1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4A695CEc67369f1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7993580791	f	2026-01-06 11:05:11.466363	2026-01-06 11:05:41.250356	637223715906	t	2026-01-06 11:05:39.108969+00
333	3c70dd22-df28-4a50-a034-4a378507c5bf	PINS75ZFIBCEIH3	HC1767697846392SRW	100.00	5.00	\N	Lakshmi Patel	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8574857122", "txnid": "PINS75ZFIBCEIH3", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fd695CEDb720066&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fd695CEDb720066&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fd695CEDb720066&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fd695CEDb720066&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_fd695CEDb720066", "upi_tr": "pt_fd695CEDb720066", "txnid": "ORDID8574857122", "orderid": "ORDID8574857122", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fd695CEDb720066&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fd695CEDb720066&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8574857122	f	2026-01-06 11:10:47.37917	2026-01-06 11:10:47.379173	\N	f	\N
338	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8ULYZ9FZG7LI	HC1767697927179DRD	100.00	5.00	\N	Harish Shahananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9495320695", "txnid": "PIN8ULYZ9FZG7LI", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695Cee07e2958&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695Cee07e2958&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695Cee07e2958&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695Cee07e2958&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_70695Cee07e2958", "upi_tr": "pt_70695Cee07e2958", "txnid": "ORDID9495320695", "orderid": "ORDID9495320695", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695Cee07e2958&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695Cee07e2958&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9495320695	f	2026-01-06 11:12:08.193558	2026-01-06 11:12:08.193561	\N	f	\N
337	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7GHLEMUSNG7X	HC1767697924033TOB	100.00	5.00	\N	Chitra Mishrababu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8598214934", "txnid": "PIN7GHLEMUSNG7X", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F9695CEE04d0747&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F9695CEE04d0747&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F9695CEE04d0747&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F9695CEE04d0747&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F9695CEE04d0747", "upi_tr": "pt_F9695CEE04d0747", "txnid": "ORDID8598214934", "orderid": "ORDID8598214934", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8598214934", "rrn": "243012458742"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F9695CEE04d0747&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F9695CEE04d0747&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8598214934	f	2026-01-06 11:12:05.171598	2026-01-06 11:12:31.687079	243012458742	t	2026-01-06 11:12:27.834614+00
412	3c70dd22-df28-4a50-a034-4a378507c5bf	PINP9LNTODJLCDO	HC1767703347005N4S	100.00	5.00	\N	Neha Singhrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5544365944", "txnid": "PINP9LNTODJLCDO", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_34695d0333Cec53&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_34695d0333Cec53&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_34695d0333Cec53&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_34695d0333Cec53&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_34695d0333Cec53", "upi_tr": "pt_34695d0333Cec53", "txnid": "ORDID5544365944", "orderid": "ORDID5544365944", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_34695d0333Cec53&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_34695d0333Cec53&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5544365944	f	2026-01-06 12:42:28.134405	2026-01-06 12:42:28.134409	\N	f	\N
341	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCD47FLOX97MK	HC1767697962138MRC	100.00	5.00	\N	Raghav Bhatiaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6057678678", "txnid": "PINCD47FLOX97MK", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695CEE2Ad0335&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695CEE2Ad0335&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695CEE2Ad0335&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695CEE2Ad0335&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5D695CEE2Ad0335", "upi_tr": "pt_5D695CEE2Ad0335", "txnid": "ORDID6057678678", "orderid": "ORDID6057678678", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6057678678", "rrn": "756305750775"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695CEE2Ad0335&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695CEE2Ad0335&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6057678678	f	2026-01-06 11:12:43.120637	2026-01-06 11:13:31.812394	756305750775	t	2026-01-06 11:13:28.472226+00
348	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5687EOH7QEZZ	HC176769803656822J	100.00	5.00	\N	Pallavi Malhotraram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3124210615", "txnid": "PIN5687EOH7QEZZ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bd695cEE7545D89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bd695cEE7545D89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bd695cEE7545D89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bd695cEE7545D89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_bd695cEE7545D89", "upi_tr": "pt_bd695cEE7545D89", "txnid": "ORDID3124210615", "orderid": "ORDID3124210615", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3124210615", "rrn": "600647924679"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bd695cEE7545D89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bd695cEE7545D89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3124210615	f	2026-01-06 11:13:57.530244	2026-01-06 11:14:31.875227	600647924679	t	2026-01-06 11:14:30.583321+00
350	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLROOX2R5TALL	HC1767698069683CBN	100.00	5.00	\N	Sita Duttalal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6311588836", "txnid": "PINLROOX2R5TALL", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d4695cEE966adDD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d4695cEE966adDD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d4695cEE966adDD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d4695cEE966adDD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d4695cEE966adDD", "upi_tr": "pt_d4695cEE966adDD", "txnid": "ORDID6311588836", "orderid": "ORDID6311588836", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6311588836", "rrn": "116772480199"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d4695cEE966adDD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d4695cEE966adDD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6311588836	f	2026-01-06 11:14:30.709462	2026-01-06 11:15:01.991764	116772480199	t	2026-01-06 11:14:59.216311+00
399	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0SLWD1PFLN56	HC17676996695035JC	100.00	5.00	\N	Bharat Naiduram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1316016407", "txnid": "PIN0SLWD1PFLN56", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cF4D641b70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cF4D641b70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cF4D641b70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cF4D641b70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_63695cF4D641b70", "upi_tr": "pt_63695cF4D641b70", "txnid": "ORDID1316016407", "orderid": "ORDID1316016407", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cF4D641b70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695cF4D641b70&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1316016407	f	2026-01-06 11:41:10.517412	2026-01-06 11:41:10.517416	\N	f	\N
340	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCGU205Y7HEDT	HC1767697954964U1Y	100.00	5.00	\N	Geeta Dwivediji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4554660996", "txnid": "PINCGU205Y7HEDT", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CEe239c276&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CEe239c276&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CEe239c276&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CEe239c276&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_55695CEe239c276", "upi_tr": "pt_55695CEe239c276", "txnid": "ORDID4554660996", "orderid": "ORDID4554660996", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4554660996", "rrn": "637219326032"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CEe239c276&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695CEe239c276&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4554660996	f	2026-01-06 11:12:35.886076	2026-01-06 11:13:06.754091	637219326032	t	2026-01-06 11:13:02.448927+00
551	3c70dd22-df28-4a50-a034-4a378507c5bf	PINF7A5B10L6PS0	HC1767703944936JWB	100.00	5.00	\N	Kiran Jainendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7602474188", "txnid": "PINF7A5B10L6PS0", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695D0589b571f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695D0589b571f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695D0589b571f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695D0589b571f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e8695D0589b571f", "upi_tr": "pt_e8695D0589b571f", "txnid": "ORDID7602474188", "orderid": "ORDID7602474188", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695D0589b571f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e8695D0589b571f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7602474188	f	2026-01-06 12:52:26.012249	2026-01-06 12:52:26.012253	\N	f	\N
400	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9M8XII9YGT2Y	HC176769970775805A	100.00	5.00	\N	Radhika Sharmaappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9269022394", "txnid": "PIN9M8XII9YGT2Y", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cf4Fc78A1D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cf4Fc78A1D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cf4Fc78A1D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cf4Fc78A1D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_20695cf4Fc78A1D", "upi_tr": "pt_20695cf4Fc78A1D", "txnid": "ORDID9269022394", "orderid": "ORDID9269022394", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cf4Fc78A1D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_20695cf4Fc78A1D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9269022394	f	2026-01-06 11:41:48.757524	2026-01-06 11:41:48.757529	\N	f	\N
352	3c70dd22-df28-4a50-a034-4a378507c5bf	PINS9MBMQTX30YN	HC1767698162800LW8	100.00	5.00	\N	Pooja Bhatianath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3637688237", "txnid": "PINS9MBMQTX30YN", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CeEf38c8EA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CeEf38c8EA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CeEf38c8EA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CeEf38c8EA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_36695CeEf38c8EA", "upi_tr": "pt_36695CeEf38c8EA", "txnid": "ORDID3637688237", "orderid": "ORDID3637688237", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3637688237", "rrn": "116772567581"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CeEf38c8EA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_36695CeEf38c8EA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3637688237	f	2026-01-06 11:16:03.817649	2026-01-06 11:16:42.136002	116772567581	t	2026-01-06 11:16:41.857153+00
376	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN63MK30LLULF3	HC1767699174665ZBY	100.00	5.00	\N	Priya Guptarao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6605062045", "txnid": "PIN63MK30LLULF3", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695Cf2E75e6EC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695Cf2E75e6EC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695Cf2E75e6EC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695Cf2E75e6EC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_30695Cf2E75e6EC", "upi_tr": "pt_30695Cf2E75e6EC", "txnid": "ORDID6605062045", "orderid": "ORDID6605062045", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695Cf2E75e6EC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695Cf2E75e6EC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6605062045	f	2026-01-06 11:32:55.662743	2026-01-06 11:32:55.662747	\N	f	\N
397	3c70dd22-df28-4a50-a034-4a378507c5bf	PING355Q2BXMF31	HC1767699645030QW7	100.00	5.00	\N	Shruti Menon	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4292240868", "txnid": "PING355Q2BXMF31", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695cf4bDB55Aa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695cf4bDB55Aa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695cf4bDB55Aa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695cf4bDB55Aa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2b695cf4bDB55Aa", "upi_tr": "pt_2b695cf4bDB55Aa", "txnid": "ORDID4292240868", "orderid": "ORDID4292240868", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4292240868", "rrn": "290209252286"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695cf4bDB55Aa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695cf4bDB55Aa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4292240868	f	2026-01-06 11:40:45.994283	2026-01-06 11:41:27.744267	290209252286	t	2026-01-06 11:41:24.367114+00
428	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCZB72YLDXHG7	HC1767703444799HO4	100.00	5.00	\N	Lakshmi Chopraji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5228336548", "txnid": "PINCZB72YLDXHG7", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695D0395a4Ef1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695D0395a4Ef1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695D0395a4Ef1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695D0395a4Ef1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_03695D0395a4Ef1", "upi_tr": "pt_03695D0395a4Ef1", "txnid": "ORDID5228336548", "orderid": "ORDID5228336548", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695D0395a4Ef1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_03695D0395a4Ef1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5228336548	f	2026-01-06 12:44:05.961175	2026-01-06 12:44:05.961179	\N	f	\N
339	3c70dd22-df28-4a50-a034-4a378507c5bf	PINUH1XX9OAPEO4	HC1767697941341BQO	100.00	5.00	\N	Sneha Raoji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1327745233", "txnid": "PINUH1XX9OAPEO4", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CEE16136aD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CEE16136aD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CEE16136aD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CEE16136aD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2A695CEE16136aD", "upi_tr": "pt_2A695CEE16136aD", "txnid": "ORDID1327745233", "orderid": "ORDID1327745233", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1327745233", "rrn": "116772389782"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CEE16136aD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2A695CEE16136aD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1327745233	f	2026-01-06 11:12:22.331344	2026-01-06 11:13:16.771678	116772389782	t	2026-01-06 11:13:13.207944+00
344	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTFAP95W8YA60	HC1767697998430YUA	100.00	5.00	\N	Pallavi Reddyram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3905369122", "txnid": "PINTFAP95W8YA60", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695CEE4f5f76D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695CEE4f5f76D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695CEE4f5f76D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695CEE4f5f76D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4C695CEE4f5f76D", "upi_tr": "pt_4C695CEE4f5f76D", "txnid": "ORDID3905369122", "orderid": "ORDID3905369122", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695CEE4f5f76D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695CEE4f5f76D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3905369122	f	2026-01-06 11:13:19.634525	2026-01-06 11:13:19.634529	\N	f	\N
346	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNLKND1A2IL5W	HC1767698013978C2N	100.00	5.00	\N	Mohan Yadavendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9852462278", "txnid": "PINNLKND1A2IL5W", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695ceE5eAc455&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695ceE5eAc455&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695ceE5eAc455&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695ceE5eAc455&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_c3695ceE5eAc455", "upi_tr": "pt_c3695ceE5eAc455", "txnid": "ORDID9852462278", "orderid": "ORDID9852462278", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695ceE5eAc455&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c3695ceE5eAc455&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9852462278	f	2026-01-06 11:13:34.983603	2026-01-06 11:13:34.983607	\N	f	\N
542	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLOI7X9LJ199N	HC17677039178891H6	100.00	5.00	\N	Deepak Sharmaananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6931991583", "txnid": "PINLOI7X9LJ199N", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fa695d056eA7183&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fa695d056eA7183&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fa695d056eA7183&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fa695d056eA7183&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_fa695d056eA7183", "upi_tr": "pt_fa695d056eA7183", "txnid": "ORDID6931991583", "orderid": "ORDID6931991583", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6931991583", "rrn": "809053648051"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fa695d056eA7183&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fa695d056eA7183&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6931991583	f	2026-01-06 12:51:58.946718	2026-01-06 12:52:36.053179	809053648051	t	2026-01-06 12:52:32.285435+00
345	3c70dd22-df28-4a50-a034-4a378507c5bf	PINR0SBCITSJEQB	HC1767697999502CNB	100.00	5.00	\N	Arun Singhendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6713150502", "txnid": "PINR0SBCITSJEQB", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEe503E0EF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEe503E0EF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEe503E0EF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEe503E0EF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_f8695cEe503E0EF", "upi_tr": "pt_f8695cEe503E0EF", "txnid": "ORDID6713150502", "orderid": "ORDID6713150502", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEe503E0EF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f8695cEe503E0EF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6713150502	f	2026-01-06 11:13:20.544633	2026-01-06 11:13:20.544636	\N	f	\N
343	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLRQWI2R3BV90	HC1767697975827AG2	100.00	5.00	\N	Tanya Mehtaesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4143322609", "txnid": "PINLRQWI2R3BV90", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5b695CEe3893902&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5b695CEe3893902&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5b695CEe3893902&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5b695CEe3893902&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5b695CEe3893902", "upi_tr": "pt_5b695CEe3893902", "txnid": "ORDID4143322609", "orderid": "ORDID4143322609", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4143322609", "rrn": "696907091929"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5b695CEe3893902&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5b695CEe3893902&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4143322609	f	2026-01-06 11:12:56.880586	2026-01-06 11:13:31.796714	696907091929	t	2026-01-06 11:13:26.778542+00
347	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9HGJFE545Y2P	HC1767698031007YQM	100.00	5.00	\N	Harish Singh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4081749174", "txnid": "PIN9HGJFE545Y2P", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CeE6fBa138&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CeE6fBa138&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CeE6fBa138&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CeE6fBa138&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_26695CeE6fBa138", "upi_tr": "pt_26695CeE6fBa138", "txnid": "ORDID4081749174", "orderid": "ORDID4081749174", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4081749174", "rrn": "395022271093"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CeE6fBa138&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695CeE6fBa138&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4081749174	f	2026-01-06 11:13:52.027326	2026-01-06 11:14:31.857914	395022271093	t	2026-01-06 11:14:29.076776+00
11276	0ccb76fc-6666-4a61-8498-63864856131e	PIN8KDE42N2B75S	197202162	200.00	11.80	\N	Utkarsh mathur	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4115348096", "txnid": "PIN8KDE42N2B75S", "amount": "200", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_4769661A9745f08&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "qr_text": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_4769661A9745f08&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_4769661A9745f08&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "payment_url": "upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_4769661A9745f08&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137", "apitxnid": "", "upi_tr": "", "txnid": "ORDID4115348096", "orderid": "ORDID4115348096", "bankutr": "pending"}}	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_4769661A9745f08&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	upi://pay?pa=open9006102366519@yesbank&pn=Pipo%20Zenpay%20Private%20Limited&tr=int_pt_4769661A9745f08&am=200.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=5137	unitpay	ORDID4115348096	f	2026-01-13 10:12:39.51855	2026-01-13 10:12:39.518553	\N	f	\N
351	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9K60YJX4OSFD	HC1767698158561XD4	100.00	5.00	\N	Lalita Vermaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8194283877", "txnid": "PIN9K60YJX4OSFD", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CEeeF4c7b1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CEeeF4c7b1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CEeeF4c7b1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CEeeF4c7b1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9B695CEeeF4c7b1", "upi_tr": "pt_9B695CEeeF4c7b1", "txnid": "ORDID8194283877", "orderid": "ORDID8194283877", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8194283877", "rrn": "474605769118"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CEeeF4c7b1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695CEeeF4c7b1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8194283877	f	2026-01-06 11:15:59.582401	2026-01-06 11:16:32.100976	474605769118	t	2026-01-06 11:16:30.769706+00
404	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN155KFCPLUKAN	HC1767699757502WCJ	100.00	5.00	\N	Ankita Kumarlal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6530347885", "txnid": "PIN155KFCPLUKAN", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cF52e37b27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cF52e37b27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cF52e37b27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cF52e37b27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_68695cF52e37b27", "upi_tr": "pt_68695cF52e37b27", "txnid": "ORDID6530347885", "orderid": "ORDID6530347885", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cF52e37b27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695cF52e37b27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6530347885	f	2026-01-06 11:42:38.492593	2026-01-06 11:42:38.492598	\N	f	\N
552	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDPFFFFAB2QC0	HC1767703958910T40	100.00	5.00	\N	Alka Banerjeeendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9813731590", "txnid": "PINDPFFFFAB2QC0", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695d0597B3675&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695d0597B3675&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695d0597B3675&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695d0597B3675&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_25695d0597B3675", "upi_tr": "pt_25695d0597B3675", "txnid": "ORDID9813731590", "orderid": "ORDID9813731590", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695d0597B3675&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695d0597B3675&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9813731590	f	2026-01-06 12:52:40.007054	2026-01-06 12:52:40.007058	\N	f	\N
763	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKUN0N1RQYMWC	HC1767705204092KPN	100.00	5.00	\N	Vinod Malhotraappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7989731293", "txnid": "PINKUN0N1RQYMWC", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695D0a74D1eAB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695D0a74D1eAB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695D0a74D1eAB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695D0a74D1eAB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5F695D0a74D1eAB", "upi_tr": "pt_5F695D0a74D1eAB", "txnid": "ORDID7989731293", "orderid": "ORDID7989731293", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695D0a74D1eAB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5F695D0a74D1eAB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7989731293	f	2026-01-06 13:13:25.118173	2026-01-06 13:13:25.118178	\N	f	\N
405	3c70dd22-df28-4a50-a034-4a378507c5bf	PINU7I3IUYGZMZX	HC17676997603524G1	100.00	5.00	\N	Lalit Pandeyendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4166699479", "txnid": "PINU7I3IUYGZMZX", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Cf53109431&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Cf53109431&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Cf53109431&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Cf53109431&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_f6695Cf53109431", "upi_tr": "pt_f6695Cf53109431", "txnid": "ORDID4166699479", "orderid": "ORDID4166699479", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4166699479", "rrn": "171302507791"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Cf53109431&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f6695Cf53109431&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4166699479	f	2026-01-06 11:42:41.28593	2026-01-06 11:43:17.850311	171302507791	t	2026-01-06 11:43:16.94375+00
353	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMGVEWOHPHIRR	HC17676982878707PU	100.00	5.00	\N	Zoya Bhatialal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3555296544", "txnid": "PINMGVEWOHPHIRR", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695CEf709793e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695CEf709793e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695CEf709793e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695CEf709793e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F6695CEf709793e", "upi_tr": "pt_F6695CEf709793e", "txnid": "ORDID3555296544", "orderid": "ORDID3555296544", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3555296544", "rrn": "665490817731"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695CEf709793e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695CEf709793e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3555296544	f	2026-01-06 11:18:08.904334	2026-01-06 11:19:07.240234	665490817731	t	2026-01-06 11:19:04.463527+00
354	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLQ3I179BE01W	HC1767698625691FOB	100.00	5.00	\N	Manisha Singhesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2932148057", "txnid": "PINLQ3I179BE01W", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695cF0c26dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695cF0c26dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695cF0c26dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695cF0c26dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F4695cF0c26dBAc", "upi_tr": "pt_F4695cF0c26dBAc", "txnid": "ORDID2932148057", "orderid": "ORDID2932148057", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695cF0c26dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F4695cF0c26dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2932148057	f	2026-01-06 11:23:46.71851	2026-01-06 11:23:46.718514	\N	f	\N
356	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRM8M1118X9PH	HC1767698680905091	100.00	5.00	\N	Chandan Aggarwalendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9890046365", "txnid": "PINRM8M1118X9PH", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695cf0F99eb9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695cf0F99eb9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695cf0F99eb9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695cf0F99eb9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e3695cf0F99eb9b", "upi_tr": "pt_e3695cf0F99eb9b", "txnid": "ORDID9890046365", "orderid": "ORDID9890046365", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695cf0F99eb9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695cf0F99eb9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9890046365	f	2026-01-06 11:24:41.925974	2026-01-06 11:24:41.925977	\N	f	\N
357	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN96RSO7BR7JQB	HC17676986898101ZB	100.00	5.00	\N	Omkar Patelji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3895012142", "txnid": "PIN96RSO7BR7JQB", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BF695cf1027dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BF695cf1027dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BF695cf1027dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BF695cf1027dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_BF695cf1027dBAc", "upi_tr": "pt_BF695cf1027dBAc", "txnid": "ORDID3895012142", "orderid": "ORDID3895012142", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BF695cf1027dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_BF695cf1027dBAc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3895012142	f	2026-01-06 11:24:50.749802	2026-01-06 11:24:50.749805	\N	f	\N
432	3c70dd22-df28-4a50-a034-4a378507c5bf	PINWBN48DQ5YDG5	HC1767703457396JPS	100.00	5.00	\N	Ekta Chatterjeeish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9427556850", "txnid": "PINWBN48DQ5YDG5", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_48695d03A2362E3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_48695d03A2362E3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_48695d03A2362E3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_48695d03A2362E3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_48695d03A2362E3", "upi_tr": "pt_48695d03A2362E3", "txnid": "ORDID9427556850", "orderid": "ORDID9427556850", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_48695d03A2362E3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_48695d03A2362E3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9427556850	f	2026-01-06 12:44:18.504252	2026-01-06 12:44:18.504255	\N	f	\N
355	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1FNHVZIOJRNW	HC1767698633354OCA	100.00	5.00	\N	Govind Dubeyappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6063462574", "txnid": "PIN1FNHVZIOJRNW", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695CF0CA690a0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695CF0CA690a0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695CF0CA690a0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695CF0CA690a0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0B695CF0CA690a0", "upi_tr": "pt_0B695CF0CA690a0", "txnid": "ORDID6063462574", "orderid": "ORDID6063462574", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6063462574", "rrn": "395022910431"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695CF0CA690a0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695CF0CA690a0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6063462574	f	2026-01-06 11:23:54.702688	2026-01-06 11:25:27.502353	395022910431	t	2026-01-06 11:25:26.410814+00
359	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5Z3FDZ1A2A5J	HC1767698757997FSM	100.00	5.00	\N	Mahesh Trivediish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7815743302", "txnid": "PIN5Z3FDZ1A2A5J", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9a695CF146b10b8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9a695CF146b10b8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9a695CF146b10b8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9a695CF146b10b8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9a695CF146b10b8", "upi_tr": "pt_9a695CF146b10b8", "txnid": "ORDID7815743302", "orderid": "ORDID7815743302", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9a695CF146b10b8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9a695CF146b10b8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7815743302	f	2026-01-06 11:25:58.989942	2026-01-06 11:25:58.989946	\N	f	\N
360	3c70dd22-df28-4a50-a034-4a378507c5bf	PINC4GPNG5M94NT	HC1767698775628R8U	100.00	5.00	\N	Kiran Kulkarniendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5075233719", "txnid": "PINC4GPNG5M94NT", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Dd695cF158504Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Dd695cF158504Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Dd695cF158504Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Dd695cF158504Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Dd695cF158504Cf", "upi_tr": "pt_Dd695cF158504Cf", "txnid": "ORDID5075233719", "orderid": "ORDID5075233719", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Dd695cF158504Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Dd695cF158504Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5075233719	f	2026-01-06 11:26:16.562001	2026-01-06 11:26:16.562005	\N	f	\N
365	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGVOS5TGGQ1GD	HC1767698927498UGF	100.00	5.00	\N	Alka Pillaiish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4152050387", "txnid": "PINGVOS5TGGQ1GD", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_45695Cf1F0361dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_45695Cf1F0361dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_45695Cf1F0361dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_45695Cf1F0361dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_45695Cf1F0361dc", "upi_tr": "pt_45695Cf1F0361dc", "txnid": "ORDID4152050387", "orderid": "ORDID4152050387", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_45695Cf1F0361dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_45695Cf1F0361dc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4152050387	f	2026-01-06 11:28:48.486801	2026-01-06 11:28:48.486804	\N	f	\N
358	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN81HCSKZULUYC	HC17676987197072FB	100.00	5.00	\N	Omkar Duttanath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6858908740", "txnid": "PIN81HCSKZULUYC", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695Cf1208196a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695Cf1208196a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695Cf1208196a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695Cf1208196a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_38695Cf1208196a", "upi_tr": "pt_38695Cf1208196a", "txnid": "ORDID6858908740", "orderid": "ORDID6858908740", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6858908740", "rrn": "150754322816"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695Cf1208196a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695Cf1208196a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6858908740	f	2026-01-06 11:25:20.800579	2026-01-06 11:26:07.541231	150754322816	t	2026-01-06 11:26:06.558045+00
403	3c70dd22-df28-4a50-a034-4a378507c5bf	PINUO75BMCZHU2Z	HC1767699729399JQ2	100.00	5.00	\N	Asha Chauhanappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5678232440", "txnid": "PINUO75BMCZHU2Z", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C9695CF51220567&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C9695CF51220567&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C9695CF51220567&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C9695CF51220567&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C9695CF51220567", "upi_tr": "pt_C9695CF51220567", "txnid": "ORDID5678232440", "orderid": "ORDID5678232440", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5678232440", "rrn": "219529423488"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C9695CF51220567&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C9695CF51220567&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5678232440	f	2026-01-06 11:42:10.404821	2026-01-06 11:42:52.806849	219529423488	t	2026-01-06 11:42:49.152261+00
364	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIYBR7RQXZA6M	HC1767698924796QFL	100.00	5.00	\N	Pooja Kumar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7220030932", "txnid": "PINIYBR7RQXZA6M", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695cf1Ed88206&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695cf1Ed88206&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695cf1Ed88206&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695cf1Ed88206&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b8695cf1Ed88206", "upi_tr": "pt_b8695cf1Ed88206", "txnid": "ORDID7220030932", "orderid": "ORDID7220030932", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695cf1Ed88206&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b8695cf1Ed88206&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7220030932	f	2026-01-06 11:28:45.818915	2026-01-06 11:28:45.818919	\N	f	\N
372	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMK89NRI91S19	HC1767699021230SVH	100.00	5.00	\N	Divya Singhbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1212903679", "txnid": "PINMK89NRI91S19", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_84695cf24DeA916&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_84695cf24DeA916&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_84695cf24DeA916&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_84695cf24DeA916&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_84695cf24DeA916", "upi_tr": "pt_84695cf24DeA916", "txnid": "ORDID1212903679", "orderid": "ORDID1212903679", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_84695cf24DeA916&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_84695cf24DeA916&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1212903679	f	2026-01-06 11:30:22.218911	2026-01-06 11:30:22.218915	\N	f	\N
402	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3M39XJXCY1Q6	HC1767699715280AP8	100.00	5.00	\N	Sneha Kulkarnikar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4554431253", "txnid": "PIN3M39XJXCY1Q6", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695cf503F325E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695cf503F325E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695cf503F325E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695cf503F325E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_24695cf503F325E", "upi_tr": "pt_24695cf503F325E", "txnid": "ORDID4554431253", "orderid": "ORDID4554431253", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4554431253", "rrn": "929153469823"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695cf503F325E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695cf503F325E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4554431253	f	2026-01-06 11:41:56.245413	2026-01-06 11:42:52.82067	929153469823	t	2026-01-06 11:42:50.861732+00
366	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQILARJF4BI5W	HC1767698945216MMS	100.00	5.00	\N	Ritika Duttababu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4104557802", "txnid": "PINQILARJF4BI5W", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CF201e6Eb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CF201e6Eb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CF201e6Eb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CF201e6Eb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b1695CF201e6Eb1", "upi_tr": "pt_b1695CF201e6Eb1", "txnid": "ORDID4104557802", "orderid": "ORDID4104557802", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CF201e6Eb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b1695CF201e6Eb1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4104557802	f	2026-01-06 11:29:06.209783	2026-01-06 11:29:06.209786	\N	f	\N
363	3c70dd22-df28-4a50-a034-4a378507c5bf	PINHZ18WKPGZKP4	HC1767698908810C1A	100.00	5.00	\N	Chitra Chatterjeerao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6030899880", "txnid": "PINHZ18WKPGZKP4", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695cF1dD7e90D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695cF1dD7e90D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695cF1dD7e90D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695cF1dD7e90D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_95695cF1dD7e90D", "upi_tr": "pt_95695cF1dD7e90D", "txnid": "ORDID6030899880", "orderid": "ORDID6030899880", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6030899880", "rrn": "411035151121"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695cF1dD7e90D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695cF1dD7e90D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6030899880	f	2026-01-06 11:28:29.770119	2026-01-06 11:29:07.659755	411035151121	t	2026-01-06 11:29:07.260886+00
368	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTTF4WOJ2PIJ8	HC17676989855319PJ	100.00	5.00	\N	Jaya Iyerananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7702169184", "txnid": "PINTTF4WOJ2PIJ8", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695Cf22A437cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695Cf22A437cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695Cf22A437cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695Cf22A437cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0B695Cf22A437cd", "upi_tr": "pt_0B695Cf22A437cd", "txnid": "ORDID7702169184", "orderid": "ORDID7702169184", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695Cf22A437cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0B695Cf22A437cd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7702169184	f	2026-01-06 11:29:46.518564	2026-01-06 11:29:46.518568	\N	f	\N
370	3c70dd22-df28-4a50-a034-4a378507c5bf	PINWDLXGLO378EX	HC1767699009690O8F	100.00	5.00	\N	Vijay Reddyananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5402660102", "txnid": "PINWDLXGLO378EX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_00695cF24270486&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_00695cF24270486&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_00695cF24270486&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_00695cF24270486&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_00695cF24270486", "upi_tr": "pt_00695cF24270486", "txnid": "ORDID5402660102", "orderid": "ORDID5402660102", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_00695cF24270486&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_00695cF24270486&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5402660102	f	2026-01-06 11:30:10.711895	2026-01-06 11:30:10.711899	\N	f	\N
362	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0JQ5OS6FUO3L	HC176769890294022W	100.00	5.00	\N	Ankita Guptarao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3155439588", "txnid": "PIN0JQ5OS6FUO3L", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695CF1D7a1477&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695CF1D7a1477&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695CF1D7a1477&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695CF1D7a1477&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_39695CF1D7a1477", "upi_tr": "pt_39695CF1D7a1477", "txnid": "ORDID3155439588", "orderid": "ORDID3155439588", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3155439588", "rrn": "600683914272"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695CF1D7a1477&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695CF1D7a1477&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3155439588	f	2026-01-06 11:28:23.906347	2026-01-06 11:29:17.684105	600683914272	t	2026-01-06 11:29:12.802656+00
436	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN95MF499BURX8	HC1767703489417KKD	100.00	5.00	\N	Amit Goyalappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1167684451", "txnid": "PIN95MF499BURX8", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aF695d03c2955F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aF695d03c2955F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aF695d03c2955F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aF695d03c2955F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_aF695d03c2955F2", "upi_tr": "pt_aF695d03c2955F2", "txnid": "ORDID1167684451", "orderid": "ORDID1167684451", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aF695d03c2955F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aF695d03c2955F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1167684451	f	2026-01-06 12:44:50.885469	2026-01-06 12:44:50.885472	\N	f	\N
367	3c70dd22-df28-4a50-a034-4a378507c5bf	PINAGC44O0IL308	HC176769894990219E	100.00	5.00	\N	Alka Kumarbabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5246936319", "txnid": "PINAGC44O0IL308", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695Cf206A8000&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695Cf206A8000&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695Cf206A8000&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695Cf206A8000&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_55695Cf206A8000", "upi_tr": "pt_55695Cf206A8000", "txnid": "ORDID5246936319", "orderid": "ORDID5246936319", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5246936319", "rrn": "600611755150"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695Cf206A8000&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695Cf206A8000&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5246936319	f	2026-01-06 11:29:10.927194	2026-01-06 11:29:52.723246	600611755150	t	2026-01-06 11:29:51.917031+00
379	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8RTQMGFSNNTR	HC1767699225009CMY	100.00	5.00	\N	Sheetal Iyerkar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5545664142", "txnid": "PIN8RTQMGFSNNTR", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eb695cF319aA871&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eb695cF319aA871&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eb695cF319aA871&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eb695cF319aA871&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_eb695cF319aA871", "upi_tr": "pt_eb695cF319aA871", "txnid": "ORDID5545664142", "orderid": "ORDID5545664142", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5545664142", "rrn": "600626092859"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eb695cF319aA871&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eb695cF319aA871&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5545664142	f	2026-01-06 11:33:45.957796	2026-01-06 11:34:13.01243	600626092859	t	2026-01-06 11:34:12.595465+00
385	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFCNBECJNXWSB	HC1767699271987EVS	100.00	5.00	\N	Amit Menonji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8306734688", "txnid": "PINFCNBECJNXWSB", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C6695CF348AD5CF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C6695CF348AD5CF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C6695CF348AD5CF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C6695CF348AD5CF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C6695CF348AD5CF", "upi_tr": "pt_C6695CF348AD5CF", "txnid": "ORDID8306734688", "orderid": "ORDID8306734688", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8306734688", "rrn": "116773567774"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C6695CF348AD5CF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C6695CF348AD5CF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8306734688	f	2026-01-06 11:34:32.974622	2026-01-06 11:35:03.100497	116773567774	t	2026-01-06 11:35:01.096296+00
407	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFTJ5HPRKAQJP	HC1767703132573A77	100.00	5.00	\N	Deepak Nairji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8801684705", "txnid": "PINFTJ5HPRKAQJP", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695D025d7468B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695D025d7468B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695D025d7468B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695D025d7468B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b0695D025d7468B", "upi_tr": "pt_b0695D025d7468B", "txnid": "ORDID8801684705", "orderid": "ORDID8801684705", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695D025d7468B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b0695D025d7468B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8801684705	f	2026-01-06 12:38:53.763297	2026-01-06 12:38:53.763301	\N	f	\N
408	3c70dd22-df28-4a50-a034-4a378507c5bf	PINH3AC21YI68Z5	HC1767703183333TUL	100.00	5.00	\N	Vijay Iyerendra	failed	{"status": "failed", "message": "{\\"status\\":\\"failed\\",\\"message\\":\\"Something went wrong\\"}", "reference_id": null, "txnid": "PINH3AC21YI68Z5", "amount": "100.00", "payment_url": null, "qr_text": null, "raw_response": {"statuscode": "TXF", "message": "{\\"status\\":\\"failed\\",\\"message\\":\\"Something went wrong\\"}"}}	\N	\N	unitpay	\N	f	2026-01-06 12:39:44.213802	2026-01-06 12:39:44.213806	\N	f	\N
371	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCMFP70HHBMCC	HC17676990114497ZB	100.00	5.00	\N	Divya Kumaresh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5772282009", "txnid": "PINCMFP70HHBMCC", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c8695cF24432c27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c8695cF24432c27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c8695cF24432c27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c8695cF24432c27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_c8695cF24432c27", "upi_tr": "pt_c8695cF24432c27", "txnid": "ORDID5772282009", "orderid": "ORDID5772282009", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5772282009", "rrn": "694081020625"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c8695cF24432c27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_c8695cF24432c27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5772282009	f	2026-01-06 11:30:12.471413	2026-01-06 11:30:42.793278	694081020625	t	2026-01-06 11:30:39.276844+00
544	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1BKHHC1BF5XE	HC17677039208152SS	100.00	5.00	\N	Tanya Dasesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7481322157", "txnid": "PIN1BKHHC1BF5XE", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695d0571C11C1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695d0571C11C1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695d0571C11C1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695d0571C11C1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_27695d0571C11C1", "upi_tr": "pt_27695d0571C11C1", "txnid": "ORDID7481322157", "orderid": "ORDID7481322157", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7481322157", "rrn": "600691057213"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695d0571C11C1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_27695d0571C11C1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7481322157	f	2026-01-06 12:52:02.311294	2026-01-06 12:52:41.077321	600691057213	t	2026-01-06 12:52:36.84875+00
373	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJ42L1YEEJ4R0	HC17676990792316TB	100.00	5.00	\N	Amit Iyerlal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9402610115", "txnid": "PINJ42L1YEEJ4R0", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695cf287e8A16&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695cf287e8A16&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695cf287e8A16&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695cf287e8A16&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8C695cf287e8A16", "upi_tr": "pt_8C695cf287e8A16", "txnid": "ORDID9402610115", "orderid": "ORDID9402610115", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9402610115", "rrn": "367293051307"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695cf287e8A16&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695cf287e8A16&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9402610115	f	2026-01-06 11:31:20.209121	2026-01-06 11:31:47.865291	367293051307	t	2026-01-06 11:31:45.414069+00
375	3c70dd22-df28-4a50-a034-4a378507c5bf	PINOMN3EFA5KXGR	HC176769915182460O	100.00	5.00	\N	Kiran Iyerrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1712309282", "txnid": "PINOMN3EFA5KXGR", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CF2d0957Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CF2d0957Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CF2d0957Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CF2d0957Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_60695CF2d0957Fe", "upi_tr": "pt_60695CF2d0957Fe", "txnid": "ORDID1712309282", "orderid": "ORDID1712309282", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CF2d0957Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_60695CF2d0957Fe&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1712309282	f	2026-01-06 11:32:32.887509	2026-01-06 11:32:32.887512	\N	f	\N
374	3c70dd22-df28-4a50-a034-4a378507c5bf	PINB15L631QW109	HC1767699142684I2Q	100.00	5.00	\N	Vikas Duttakar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3996745004", "txnid": "PINB15L631QW109", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d9695Cf2C763C0f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d9695Cf2C763C0f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d9695Cf2C763C0f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d9695Cf2C763C0f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d9695Cf2C763C0f", "upi_tr": "pt_d9695Cf2C763C0f", "txnid": "ORDID3996745004", "orderid": "ORDID3996745004", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3996745004", "rrn": "172004526771"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d9695Cf2C763C0f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d9695Cf2C763C0f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3996745004	f	2026-01-06 11:32:23.656121	2026-01-06 11:32:57.926131	172004526771	t	2026-01-06 11:32:52.929953+00
378	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLBUSHCICC8N3	HC1767699203273ID1	100.00	5.00	\N	Yamini Goyalrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6153349909", "txnid": "PINLBUSHCICC8N3", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695Cf304101E0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695Cf304101E0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695Cf304101E0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695Cf304101E0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F3695Cf304101E0", "upi_tr": "pt_F3695Cf304101E0", "txnid": "ORDID6153349909", "orderid": "ORDID6153349909", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695Cf304101E0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F3695Cf304101E0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6153349909	f	2026-01-06 11:33:24.302852	2026-01-06 11:33:24.302855	\N	f	\N
410	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKPPMBGPHEJOZ	HC1767703335868TY4	100.00	5.00	\N	Anil Aggarwallal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9753997459", "txnid": "PINKPPMBGPHEJOZ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695d0328B0c8A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695d0328B0c8A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695d0328B0c8A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695d0328B0c8A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_96695d0328B0c8A", "upi_tr": "pt_96695d0328B0c8A", "txnid": "ORDID9753997459", "orderid": "ORDID9753997459", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695d0328B0c8A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_96695d0328B0c8A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9753997459	f	2026-01-06 12:42:17.005983	2026-01-06 12:42:17.005987	\N	f	\N
413	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1DTYR48ONNZB	HC1767703357923M19	100.00	5.00	\N	Suresh Dwivedilal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4846552520", "txnid": "PIN1DTYR48ONNZB", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4F695D033EB30F8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4F695D033EB30F8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4F695D033EB30F8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4F695D033EB30F8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4F695D033EB30F8", "upi_tr": "pt_4F695D033EB30F8", "txnid": "ORDID4846552520", "orderid": "ORDID4846552520", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4F695D033EB30F8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4F695D033EB30F8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4846552520	f	2026-01-06 12:42:39.006248	2026-01-06 12:42:39.006252	\N	f	\N
380	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN49648SSFDCUH	HC1767699225316QUD	100.00	5.00	\N	Vikas Sharma	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9979188524", "txnid": "PIN49648SSFDCUH", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E7695CF31a1469E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E7695CF31a1469E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E7695CF31a1469E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E7695CF31a1469E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E7695CF31a1469E", "upi_tr": "pt_E7695CF31a1469E", "txnid": "ORDID9979188524", "orderid": "ORDID9979188524", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E7695CF31a1469E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E7695CF31a1469E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9979188524	f	2026-01-06 11:33:46.320843	2026-01-06 11:33:46.320846	\N	f	\N
377	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN46K3RJP2JWCA	HC17676991999091FT	100.00	5.00	\N	Kailash Singhkar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6856936119", "txnid": "PIN46K3RJP2JWCA", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695Cf300A0030&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695Cf300A0030&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695Cf300A0030&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695Cf300A0030&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_63695Cf300A0030", "upi_tr": "pt_63695Cf300A0030", "txnid": "ORDID6856936119", "orderid": "ORDID6856936119", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6856936119", "rrn": "317970498916"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695Cf300A0030&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695Cf300A0030&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6856936119	f	2026-01-06 11:33:20.908094	2026-01-06 11:33:52.982336	317970498916	t	2026-01-06 11:33:51.937683+00
382	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCPZ7OUYIGG9S	HC1767699248982XJB	100.00	5.00	\N	Arjun Dwivediesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4248274562", "txnid": "PINCPZ7OUYIGG9S", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695cf331a98cB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695cf331a98cB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695cf331a98cB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695cf331a98cB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9F695cf331a98cB", "upi_tr": "pt_9F695cf331a98cB", "txnid": "ORDID4248274562", "orderid": "ORDID4248274562", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4248274562", "rrn": "116773553781"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695cf331a98cB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9F695cf331a98cB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4248274562	f	2026-01-06 11:34:09.941206	2026-01-06 11:34:53.062672	116773553781	t	2026-01-06 11:34:48.516773+00
384	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8IVFFVZJWOE9	HC1767699263373YBH	100.00	5.00	\N	Kiran Rao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8095362859", "txnid": "PIN8IVFFVZJWOE9", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695cf3401BA27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695cf3401BA27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695cf3401BA27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695cf3401BA27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_85695cf3401BA27", "upi_tr": "pt_85695cf3401BA27", "txnid": "ORDID8095362859", "orderid": "ORDID8095362859", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695cf3401BA27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695cf3401BA27&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8095362859	f	2026-01-06 11:34:24.353911	2026-01-06 11:34:24.353914	\N	f	\N
411	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3VEDUNH34TF6	HC17677033434880AE	100.00	5.00	\N	Swati Menonish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2425585848", "txnid": "PIN3VEDUNH34TF6", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fB695d033054eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fB695d033054eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fB695d033054eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fB695d033054eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_fB695d033054eca", "upi_tr": "pt_fB695d033054eca", "txnid": "ORDID2425585848", "orderid": "ORDID2425585848", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fB695d033054eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fB695d033054eca&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2425585848	f	2026-01-06 12:42:24.70144	2026-01-06 12:42:24.701444	\N	f	\N
1684	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2L2HU5TAG0JM	HC1767709516583R82	100.00	5.00	\N	Chitra Sharmalal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7838465201", "txnid": "PIN2L2HU5TAG0JM", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_89695d1b4D496d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_89695d1b4D496d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_89695d1b4D496d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_89695d1b4D496d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_89695d1b4D496d5", "upi_tr": "pt_89695d1b4D496d5", "txnid": "ORDID7838465201", "orderid": "ORDID7838465201", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_89695d1b4D496d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_89695d1b4D496d5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7838465201	f	2026-01-06 14:25:17.543416	2026-01-06 14:25:17.543421	\N	f	\N
381	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCPKR7FXW1XEE	HC1767699235604VRP	100.00	5.00	\N	Satish Dwivedi	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8333154755", "txnid": "PINCPKR7FXW1XEE", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cf32445572&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cf32445572&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cf32445572&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cf32445572&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A1695cf32445572", "upi_tr": "pt_A1695cf32445572", "txnid": "ORDID8333154755", "orderid": "ORDID8333154755", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8333154755", "rrn": "375958847297"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cf32445572&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A1695cf32445572&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8333154755	f	2026-01-06 11:33:56.520764	2026-01-06 11:34:38.037747	375958847297	t	2026-01-06 11:34:35.681486+00
386	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBI7OWE1ZAHA2	HC17676992919340ZD	100.00	5.00	\N	Subhash Yadavnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7018374812", "txnid": "PINBI7OWE1ZAHA2", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695cF35cA6809&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695cF35cA6809&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695cF35cA6809&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695cF35cA6809&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_bf695cF35cA6809", "upi_tr": "pt_bf695cF35cA6809", "txnid": "ORDID7018374812", "orderid": "ORDID7018374812", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7018374812", "rrn": "134583450981"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695cF35cA6809&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_bf695cF35cA6809&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7018374812	f	2026-01-06 11:34:52.955757	2026-01-06 11:35:43.214363	134583450981	t	2026-01-06 11:35:42.279378+00
433	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1XKZFC8QAZOT	HC17677034638119WM	100.00	5.00	\N	Sanjay Pillaiappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4569678079", "txnid": "PIN1XKZFC8QAZOT", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8e695D03A8AaFFc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8e695D03A8AaFFc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8e695D03A8AaFFc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8e695D03A8AaFFc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8e695D03A8AaFFc", "upi_tr": "pt_8e695D03A8AaFFc", "txnid": "ORDID4569678079", "orderid": "ORDID4569678079", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8e695D03A8AaFFc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8e695D03A8AaFFc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4569678079	f	2026-01-06 12:44:24.989641	2026-01-06 12:44:24.989644	\N	f	\N
383	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDQEH7D5EHS25	HC17676992608813SM	100.00	5.00	\N	Anil Dubeyrao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7662425666", "txnid": "PINDQEH7D5EHS25", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ff695CF33d91a3B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ff695CF33d91a3B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ff695CF33d91a3B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ff695CF33d91a3B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Ff695CF33d91a3B", "upi_tr": "pt_Ff695CF33d91a3B", "txnid": "ORDID7662425666", "orderid": "ORDID7662425666", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7662425666", "rrn": "033466545852"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ff695CF33d91a3B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ff695CF33d91a3B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7662425666	f	2026-01-06 11:34:21.842403	2026-01-06 11:35:03.149553	033466545852	t	2026-01-06 11:35:02.160781+00
392	3c70dd22-df28-4a50-a034-4a378507c5bf	PINU4T50R4VJE68	HC1767699492636MZF	100.00	5.00	\N	Komal Kulkarninath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6954976010", "txnid": "PINU4T50R4VJE68", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695cf4255E7D1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695cf4255E7D1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695cf4255E7D1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695cf4255E7D1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F6695cf4255E7D1", "upi_tr": "pt_F6695cf4255E7D1", "txnid": "ORDID6954976010", "orderid": "ORDID6954976010", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695cf4255E7D1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F6695cf4255E7D1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6954976010	f	2026-01-06 11:38:13.6396	2026-01-06 11:38:13.639605	\N	f	\N
394	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRUDNN3YWBO4V	HC17676995511891A9	100.00	5.00	\N	Ekta Singhendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4645383198", "txnid": "PINRUDNN3YWBO4V", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695cF45feD451&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695cF45feD451&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695cF45feD451&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695cF45feD451&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_43695cF45feD451", "upi_tr": "pt_43695cF45feD451", "txnid": "ORDID4645383198", "orderid": "ORDID4645383198", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695cF45feD451&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695cF45feD451&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4645383198	f	2026-01-06 11:39:12.242679	2026-01-06 11:39:12.242684	\N	f	\N
409	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFAQ8KV7IOCFO	HC1767703302817BMV	100.00	5.00	\N	Amit Bhattacharyaji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8825430288", "txnid": "PINFAQ8KV7IOCFO", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0C695D0307E8999&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0C695D0307E8999&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0C695D0307E8999&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0C695D0307E8999&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0C695D0307E8999", "upi_tr": "pt_0C695D0307E8999", "txnid": "ORDID8825430288", "orderid": "ORDID8825430288", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8825430288", "rrn": "600662471390"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0C695D0307E8999&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0C695D0307E8999&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8825430288	f	2026-01-06 12:41:44.222725	2026-01-06 12:42:24.8979	600662471390	t	2026-01-06 12:42:24.507434+00
369	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDE4Q8N9CMZ7X	HC1767698996355I3G	100.00	5.00	\N	Anjali Dubeyappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2646744173", "txnid": "PINDE4Q8N9CMZ7X", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cF2351153A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cF2351153A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cF2351153A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cF2351153A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_82695cF2351153A", "upi_tr": "pt_82695cF2351153A", "txnid": "ORDID2646744173", "orderid": "ORDID2646744173", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2646744173", "rrn": "578828420111"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cF2351153A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695cF2351153A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2646744173	f	2026-01-06 11:29:57.339255	2026-01-06 11:35:33.19452	578828420111	t	2026-01-06 11:35:29.790505+00
388	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIMLVF1VO27D3	HC17676993834578GK	100.00	5.00	\N	Swati Bhatiaji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9580612841", "txnid": "PINIMLVF1VO27D3", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695cF3B829f8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695cF3B829f8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695cF3B829f8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695cF3B829f8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_CC695cF3B829f8E", "upi_tr": "pt_CC695cF3B829f8E", "txnid": "ORDID9580612841", "orderid": "ORDID9580612841", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695cF3B829f8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CC695cF3B829f8E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9580612841	f	2026-01-06 11:36:24.438347	2026-01-06 11:36:24.438351	\N	f	\N
425	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0ER48H0F4WSS	HC1767703439321D9E	100.00	5.00	\N	Divya Singhananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3458063645", "txnid": "PIN0ER48H0F4WSS", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d039030c07&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d039030c07&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d039030c07&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d039030c07&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_54695d039030c07", "upi_tr": "pt_54695d039030c07", "txnid": "ORDID3458063645", "orderid": "ORDID3458063645", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d039030c07&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d039030c07&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3458063645	f	2026-01-06 12:44:00.491313	2026-01-06 12:44:00.491318	\N	f	\N
429	3c70dd22-df28-4a50-a034-4a378507c5bf	PINYJWZDKNCBWPX	HC176770344922202N	100.00	5.00	\N	Tanvi Dasrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2536758008", "txnid": "PINYJWZDKNCBWPX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695d039a0D0C5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695d039a0D0C5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695d039a0D0C5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695d039a0D0C5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_61695d039a0D0C5", "upi_tr": "pt_61695d039a0D0C5", "txnid": "ORDID2536758008", "orderid": "ORDID2536758008", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695d039a0D0C5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695d039a0D0C5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2536758008	f	2026-01-06 12:44:10.335129	2026-01-06 12:44:10.335133	\N	f	\N
387	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0N7GSCJZB8KU	HC17676993777618ZI	100.00	5.00	\N	Ravi Mishraji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1747086013", "txnid": "PIN0N7GSCJZB8KU", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695Cf3b27c0A6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695Cf3b27c0A6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695Cf3b27c0A6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695Cf3b27c0A6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_aE695Cf3b27c0A6", "upi_tr": "pt_aE695Cf3b27c0A6", "txnid": "ORDID1747086013", "orderid": "ORDID1747086013", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1747086013", "rrn": "436978020758"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695Cf3b27c0A6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_aE695Cf3b27c0A6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1747086013	f	2026-01-06 11:36:18.76709	2026-01-06 11:36:53.261321	436978020758	t	2026-01-06 11:36:50.942332+00
415	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZQQ4M764SCT5	HC17677033642344ER	100.00	5.00	\N	Lalita Reddyappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3777805512", "txnid": "PINZQQ4M764SCT5", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695D03450A493&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695D03450A493&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695D03450A493&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695D03450A493&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_94695D03450A493", "upi_tr": "pt_94695D03450A493", "txnid": "ORDID3777805512", "orderid": "ORDID3777805512", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695D03450A493&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695D03450A493&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3777805512	f	2026-01-06 12:42:45.312877	2026-01-06 12:42:45.312881	\N	f	\N
592	3c70dd22-df28-4a50-a034-4a378507c5bf	PINUQ1GRPJ9QHHN	HC17677041496633S7	100.00	5.00	\N	Monika Joshibabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1712587906", "txnid": "PINUQ1GRPJ9QHHN", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D06568002E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D06568002E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D06568002E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D06568002E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2b695D06568002E", "upi_tr": "pt_2b695D06568002E", "txnid": "ORDID1712587906", "orderid": "ORDID1712587906", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D06568002E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D06568002E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1712587906	f	2026-01-06 12:55:50.802298	2026-01-06 12:55:50.802302	\N	f	\N
390	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZ7KSTE5KPYVS	HC1767699427609XEG	100.00	5.00	\N	Shankar Sharmakar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6506529903", "txnid": "PINZ7KSTE5KPYVS", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695CF3e452791&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695CF3e452791&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695CF3e452791&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695CF3e452791&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e4695CF3e452791", "upi_tr": "pt_e4695CF3e452791", "txnid": "ORDID6506529903", "orderid": "ORDID6506529903", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6506529903", "rrn": "116773726511"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695CF3e452791&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695CF3e452791&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6506529903	f	2026-01-06 11:37:08.595351	2026-01-06 11:37:48.309614	116773726511	t	2026-01-06 11:37:45.143895+00
437	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6QF5JJOUSCYY	HC17677034926916ZQ	100.00	5.00	\N	Tanvi Vermaendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6655417182", "txnid": "PIN6QF5JJOUSCYY", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D03C57eFcD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D03C57eFcD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D03C57eFcD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D03C57eFcD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C5695D03C57eFcD", "upi_tr": "pt_C5695D03C57eFcD", "txnid": "ORDID6655417182", "orderid": "ORDID6655417182", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D03C57eFcD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D03C57eFcD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6655417182	f	2026-01-06 12:44:53.832598	2026-01-06 12:44:53.832602	\N	f	\N
391	3c70dd22-df28-4a50-a034-4a378507c5bf	PINC2X8BATWF115	HC1767699461191BAP	100.00	5.00	\N	Nikhil Pandeyananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7815689926", "txnid": "PINC2X8BATWF115", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695CF405e2668&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695CF405e2668&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695CF405e2668&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695CF405e2668&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_07695CF405e2668", "upi_tr": "pt_07695CF405e2668", "txnid": "ORDID7815689926", "orderid": "ORDID7815689926", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7815689926", "rrn": "276223375425"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695CF405e2668&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_07695CF405e2668&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7815689926	f	2026-01-06 11:37:42.180247	2026-01-06 11:38:25.699177	276223375425	t	2026-01-06 11:38:24.976846+00
389	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCUET0WOY63KR	HC1767699416824TDS	100.00	5.00	\N	Chitra Chandrasekar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9056251360", "txnid": "PINCUET0WOY63KR", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5c695CF3d990AC9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5c695CF3d990AC9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5c695CF3d990AC9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5c695CF3d990AC9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5c695CF3d990AC9", "upi_tr": "pt_5c695CF3d990AC9", "txnid": "ORDID9056251360", "orderid": "ORDID9056251360", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9056251360", "rrn": "116773770003"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5c695CF3d990AC9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5c695CF3d990AC9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9056251360	f	2026-01-06 11:36:57.841506	2026-01-06 11:38:30.721266	116773770003	t	2026-01-06 11:38:28.109763+00
421	3c70dd22-df28-4a50-a034-4a378507c5bf	PINL2F1ZW7SHO3D	HC1767703420511PGZ	100.00	5.00	\N	Sunita Aggarwalbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1236903674", "txnid": "PINL2F1ZW7SHO3D", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a8695D037da2906&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a8695D037da2906&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a8695D037da2906&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a8695D037da2906&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_a8695D037da2906", "upi_tr": "pt_a8695D037da2906", "txnid": "ORDID1236903674", "orderid": "ORDID1236903674", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a8695D037da2906&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a8695D037da2906&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1236903674	f	2026-01-06 12:43:41.928946	2026-01-06 12:43:41.928951	\N	f	\N
424	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMG0RHJC43I4C	HC17677034344044GR	100.00	5.00	\N	Arjun Dwivedikar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6638582785", "txnid": "PINMG0RHJC43I4C", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d038b441F9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d038b441F9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d038b441F9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d038b441F9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1E695d038b441F9", "upi_tr": "pt_1E695d038b441F9", "txnid": "ORDID6638582785", "orderid": "ORDID6638582785", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d038b441F9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d038b441F9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6638582785	f	2026-01-06 12:43:55.550999	2026-01-06 12:43:55.551003	\N	f	\N
426	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6DRC11D8Q37D	HC1767703441188Y5K	100.00	5.00	\N	Bhavna Thakurji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1999988074", "txnid": "PIN6DRC11D8Q37D", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695D0392275E7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695D0392275E7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695D0392275E7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695D0392275E7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_19695D0392275E7", "upi_tr": "pt_19695D0392275E7", "txnid": "ORDID1999988074", "orderid": "ORDID1999988074", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695D0392275E7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_19695D0392275E7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1999988074	f	2026-01-06 12:44:02.481108	2026-01-06 12:44:02.481112	\N	f	\N
545	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBTERHYEJQ59F	HC1767703924607M9F	100.00	5.00	\N	Shankar Patelish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1403862221", "txnid": "PINBTERHYEJQ59F", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cf695D057563Caf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cf695D057563Caf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cf695D057563Caf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cf695D057563Caf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Cf695D057563Caf", "upi_tr": "pt_Cf695D057563Caf", "txnid": "ORDID1403862221", "orderid": "ORDID1403862221", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1403862221", "rrn": "065927949924"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cf695D057563Caf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cf695D057563Caf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1403862221	f	2026-01-06 12:52:05.681432	2026-01-06 12:52:41.099531	065927949924	t	2026-01-06 12:52:39.329522+00
420	3c70dd22-df28-4a50-a034-4a378507c5bf	PINF2ZOLK3FO2H8	HC1767703405471ICS	100.00	5.00	\N	Govind Banerjee	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5028141105", "txnid": "PINF2ZOLK3FO2H8", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695d036E4532E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695d036E4532E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695d036E4532E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695d036E4532E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_32695d036E4532E", "upi_tr": "pt_32695d036E4532E", "txnid": "ORDID5028141105", "orderid": "ORDID5028141105", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695d036E4532E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695d036E4532E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5028141105	f	2026-01-06 12:43:26.581494	2026-01-06 12:43:26.581498	\N	f	\N
414	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNCE6UBX802EQ	HC1767703362537323	100.00	5.00	\N	Geeta Mathurrao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5051888577", "txnid": "PINNCE6UBX802EQ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695D03435960f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695D03435960f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695D03435960f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695D03435960f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0d695D03435960f", "upi_tr": "pt_0d695D03435960f", "txnid": "ORDID5051888577", "orderid": "ORDID5051888577", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5051888577", "rrn": "079928239863"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695D03435960f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0d695D03435960f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5051888577	f	2026-01-06 12:42:43.63012	2026-01-06 12:43:34.964079	079928239863	t	2026-01-06 12:43:30.286941+00
557	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3PWQ6GN2XKTT	HC17677039805802U3	100.00	5.00	\N	Keshav Sharma	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3418935131", "txnid": "PIN3PWQ6GN2XKTT", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d05ad72d7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d05ad72d7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d05ad72d7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d05ad72d7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A5695d05ad72d7F", "upi_tr": "pt_A5695d05ad72d7F", "txnid": "ORDID3418935131", "orderid": "ORDID3418935131", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3418935131", "rrn": "771193837671"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d05ad72d7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d05ad72d7F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3418935131	f	2026-01-06 12:53:01.789553	2026-01-06 12:53:46.175994	771193837671	t	2026-01-06 12:53:41.608511+00
416	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLZ9NBVKJAJLJ	HC176770336699410A	100.00	5.00	\N	Sneha Chauhan	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5277153257", "txnid": "PINLZ9NBVKJAJLJ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695d0347cF7e6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695d0347cF7e6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695d0347cF7e6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695d0347cF7e6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_53695d0347cF7e6", "upi_tr": "pt_53695d0347cF7e6", "txnid": "ORDID5277153257", "orderid": "ORDID5277153257", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5277153257", "rrn": "238866688996"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695d0347cF7e6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_53695d0347cF7e6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5277153257	f	2026-01-06 12:42:48.14377	2026-01-06 12:43:29.943885	238866688996	t	2026-01-06 12:43:26.076969+00
417	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNK8X780J1Z8J	HC1767703380276P4O	100.00	5.00	\N	Savita Patel	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4005494605", "txnid": "PINNK8X780J1Z8J", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695D03551d040&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695D03551d040&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695D03551d040&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695D03551d040&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_EE695D03551d040", "upi_tr": "pt_EE695D03551d040", "txnid": "ORDID4005494605", "orderid": "ORDID4005494605", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4005494605", "rrn": "944738498924"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695D03551d040&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695D03551d040&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4005494605	f	2026-01-06 12:43:01.4195	2026-01-06 12:43:54.989206	944738498924	t	2026-01-06 12:43:50.432185+00
427	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRH6V3ACI9SPQ	HC1767703444286V5Y	100.00	5.00	\N	Dinesh Goyalappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5992135341", "txnid": "PINRH6V3ACI9SPQ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695D039517efD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695D039517efD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695D039517efD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695D039517efD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_95695D039517efD", "upi_tr": "pt_95695D039517efD", "txnid": "ORDID5992135341", "orderid": "ORDID5992135341", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5992135341", "rrn": "167789037759"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695D039517efD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_95695D039517efD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5992135341	f	2026-01-06 12:44:05.381622	2026-01-06 12:44:35.047597	167789037759	t	2026-01-06 12:44:31.881312+00
431	3c70dd22-df28-4a50-a034-4a378507c5bf	PINYMR3ZNKOTLCR	HC1767703455594PWZ	100.00	5.00	\N	Tanya Mishraish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4937833875", "txnid": "PINYMR3ZNKOTLCR", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d03a05cb5D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d03a05cb5D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d03a05cb5D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d03a05cb5D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_A5695d03a05cb5D", "upi_tr": "pt_A5695d03a05cb5D", "txnid": "ORDID4937833875", "orderid": "ORDID4937833875", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4937833875", "rrn": "395028807328"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d03a05cb5D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_A5695d03a05cb5D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4937833875	f	2026-01-06 12:44:16.636366	2026-01-06 12:45:00.091152	395028807328	t	2026-01-06 12:44:57.845811+00
423	3c70dd22-df28-4a50-a034-4a378507c5bf	PINI1BBGIBXQ5MR	HC17677034342296S0	100.00	5.00	\N	Sonia Mathur	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2384883171", "txnid": "PINI1BBGIBXQ5MR", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d038b0AcEa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d038b0AcEa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d038b0AcEa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d038b0AcEa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8c695d038b0AcEa", "upi_tr": "pt_8c695d038b0AcEa", "txnid": "ORDID2384883171", "orderid": "ORDID2384883171", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d038b0AcEa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d038b0AcEa&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2384883171	f	2026-01-06 12:43:55.319212	2026-01-06 12:43:55.319216	\N	f	\N
419	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZCD2N2YUZ5W7	HC1767703395456ISC	100.00	5.00	\N	Swati Goyalnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6813097912", "txnid": "PINZCD2N2YUZ5W7", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695d03644d9a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695d03644d9a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695d03644d9a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695d03644d9a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7C695d03644d9a4", "upi_tr": "pt_7C695d03644d9a4", "txnid": "ORDID6813097912", "orderid": "ORDID6813097912", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6813097912", "rrn": "977577260640"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695d03644d9a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7C695d03644d9a4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6813097912	f	2026-01-06 12:43:16.617078	2026-01-06 12:44:00.010233	977577260640	t	2026-01-06 12:43:56.132385+00
434	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2ATA8VE4CJBY	HC1767703466366HMO	100.00	5.00	\N	Pooja Iyerendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2136171358", "txnid": "PIN2ATA8VE4CJBY", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695d03aB29f6E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695d03aB29f6E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695d03aB29f6E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695d03aB29f6E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6A695d03aB29f6E", "upi_tr": "pt_6A695d03aB29f6E", "txnid": "ORDID2136171358", "orderid": "ORDID2136171358", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695d03aB29f6E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6A695d03aB29f6E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2136171358	f	2026-01-06 12:44:27.454062	2026-01-06 12:44:27.454066	\N	f	\N
435	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGO34XUZHV6XT	HC1767703488547NL5	100.00	5.00	\N	Rekha Mehtarao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7655277317", "txnid": "PINGO34XUZHV6XT", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1B695d03c15f986&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1B695d03c15f986&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1B695d03c15f986&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1B695d03c15f986&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1B695d03c15f986", "upi_tr": "pt_1B695d03c15f986", "txnid": "ORDID7655277317", "orderid": "ORDID7655277317", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1B695d03c15f986&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1B695d03c15f986&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7655277317	f	2026-01-06 12:44:49.660399	2026-01-06 12:44:49.660402	\N	f	\N
438	3c70dd22-df28-4a50-a034-4a378507c5bf	PINYTC5ONF91I52	HC1767703499668YRS	100.00	5.00	\N	Manoj Naiduji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4764868557", "txnid": "PINYTC5ONF91I52", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695d03CC763Fb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695d03CC763Fb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695d03CC763Fb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695d03CC763Fb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_10695d03CC763Fb", "upi_tr": "pt_10695d03CC763Fb", "txnid": "ORDID4764868557", "orderid": "ORDID4764868557", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695d03CC763Fb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_10695d03CC763Fb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4764868557	f	2026-01-06 12:45:00.763455	2026-01-06 12:45:00.763459	\N	f	\N
430	3c70dd22-df28-4a50-a034-4a378507c5bf	PINU1J39NR46EPF	HC1767703451918G0R	100.00	5.00	\N	Bhavna Reddynath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4276604441", "txnid": "PINU1J39NR46EPF", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695D039CB0650&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695D039CB0650&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695D039CB0650&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695D039CB0650&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_32695D039CB0650", "upi_tr": "pt_32695D039CB0650", "txnid": "ORDID4276604441", "orderid": "ORDID4276604441", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4276604441", "rrn": "116778069706"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695D039CB0650&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_32695D039CB0650&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4276604441	f	2026-01-06 12:44:12.988988	2026-01-06 12:45:00.116948	116778069706	t	2026-01-06 12:44:58.870575+00
554	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5817E72RA0T4	HC1767703967875KS4	100.00	5.00	\N	Sonia Singhbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4927648243", "txnid": "PIN5817E72RA0T4", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695d05A0B2534&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695d05A0B2534&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695d05A0B2534&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695d05A0B2534&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B0695d05A0B2534", "upi_tr": "pt_B0695d05A0B2534", "txnid": "ORDID4927648243", "orderid": "ORDID4927648243", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695d05A0B2534&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B0695d05A0B2534&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4927648243	f	2026-01-06 12:52:49.012416	2026-01-06 12:52:49.01242	\N	f	\N
563	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIKPTSTZAJA13	HC1767704003629S1L	100.00	5.00	\N	Sneha Sharmakar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1269590135", "txnid": "PINIKPTSTZAJA13", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695D05c4763b6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695D05c4763b6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695D05c4763b6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695D05c4763b6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_54695D05c4763b6", "upi_tr": "pt_54695D05c4763b6", "txnid": "ORDID1269590135", "orderid": "ORDID1269590135", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695D05c4763b6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695D05c4763b6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1269590135	f	2026-01-06 12:53:24.762776	2026-01-06 12:53:24.762779	\N	f	\N
565	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4X5LVD45QPLL	HC17677040151925XS	100.00	5.00	\N	Geeta Pandey	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4042154883", "txnid": "PIN4X5LVD45QPLL", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695D05D00C08e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695D05D00C08e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695D05D00C08e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695D05D00C08e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_82695D05D00C08e", "upi_tr": "pt_82695D05D00C08e", "txnid": "ORDID4042154883", "orderid": "ORDID4042154883", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695D05D00C08e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_82695D05D00C08e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4042154883	f	2026-01-06 12:53:36.321343	2026-01-06 12:53:36.321348	\N	f	\N
569	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZYHZQ5KJYXLW	HC1767704032947DJA	100.00	5.00	\N	Manoj Kapoornath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6956966810", "txnid": "PINZYHZQ5KJYXLW", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F2695d05E1c516b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F2695d05E1c516b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F2695d05E1c516b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F2695d05E1c516b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F2695d05E1c516b", "upi_tr": "pt_F2695d05E1c516b", "txnid": "ORDID6956966810", "orderid": "ORDID6956966810", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F2695d05E1c516b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F2695d05E1c516b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6956966810	f	2026-01-06 12:53:54.076786	2026-01-06 12:53:54.07679	\N	f	\N
439	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZAOCH992VJW4	HC176770350067578V	100.00	5.00	\N	Bharat Mathuresh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6567333376", "txnid": "PINZAOCH992VJW4", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695D03cd81272&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695D03cd81272&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695D03cd81272&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695D03cd81272&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_72695D03cd81272", "upi_tr": "pt_72695D03cd81272", "txnid": "ORDID6567333376", "orderid": "ORDID6567333376", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695D03cd81272&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_72695D03cd81272&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6567333376	f	2026-01-06 12:45:01.820869	2026-01-06 12:45:01.820875	\N	f	\N
441	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4IELH3BQ9RZQ	HC1767703510498I94	100.00	5.00	\N	Dinesh Chandrasekarnath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3745479412", "txnid": "PIN4IELH3BQ9RZQ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695d03D756be5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695d03D756be5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695d03D756be5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695d03D756be5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_65695d03D756be5", "upi_tr": "pt_65695d03D756be5", "txnid": "ORDID3745479412", "orderid": "ORDID3745479412", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695d03D756be5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_65695d03D756be5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3745479412	f	2026-01-06 12:45:11.647435	2026-01-06 12:45:11.647439	\N	f	\N
555	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLQ5NZ56XSPIQ	HC17677039679057MD	100.00	5.00	\N	Prakash Joshirao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7797386547", "txnid": "PINLQ5NZ56XSPIQ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ec695d05A0B4dec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ec695d05A0B4dec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ec695d05A0B4dec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ec695d05A0B4dec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Ec695d05A0B4dec", "upi_tr": "pt_Ec695d05A0B4dec", "txnid": "ORDID7797386547", "orderid": "ORDID7797386547", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ec695d05A0B4dec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ec695d05A0B4dec&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7797386547	f	2026-01-06 12:52:49.025721	2026-01-06 12:52:49.025726	\N	f	\N
559	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7062ZMD3FFZG	HC17677039910410LJ	100.00	5.00	\N	Harish Kapoorish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8518323745", "txnid": "PIN7062ZMD3FFZG", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0E695D05b7d7805&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0E695D05b7d7805&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0E695D05b7d7805&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0E695D05b7d7805&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0E695D05b7d7805", "upi_tr": "pt_0E695D05b7d7805", "txnid": "ORDID8518323745", "orderid": "ORDID8518323745", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0E695D05b7d7805&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0E695D05b7d7805&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8518323745	f	2026-01-06 12:53:12.154287	2026-01-06 12:53:12.15429	\N	f	\N
766	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBQO4ZLI2RE8E	HC17677052271330GG	100.00	5.00	\N	Govind Trivedi	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4280375011", "txnid": "PINBQO4ZLI2RE8E", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7B695D0A8BD0e9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7B695D0A8BD0e9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7B695D0A8BD0e9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7B695D0A8BD0e9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7B695D0A8BD0e9d", "upi_tr": "pt_7B695D0A8BD0e9d", "txnid": "ORDID4280375011", "orderid": "ORDID4280375011", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7B695D0A8BD0e9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7B695D0A8BD0e9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4280375011	f	2026-01-06 13:13:48.13206	2026-01-06 13:13:48.132064	\N	f	\N
442	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTTCA0XLP1NT8	HC17677035156441GJ	100.00	5.00	\N	Raghav Trivediish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8788504796", "txnid": "PINTTCA0XLP1NT8", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D03dC7Bd99&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D03dC7Bd99&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D03dC7Bd99&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D03dC7Bd99&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0D695D03dC7Bd99", "upi_tr": "pt_0D695D03dC7Bd99", "txnid": "ORDID8788504796", "orderid": "ORDID8788504796", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D03dC7Bd99&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D03dC7Bd99&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8788504796	f	2026-01-06 12:45:16.80805	2026-01-06 12:45:16.808054	\N	f	\N
443	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBXENXJPNX0AE	HC1767703519702GU0	100.00	5.00	\N	Madhav Menonram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1908012175", "txnid": "PINBXENXJPNX0AE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d03E083318&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d03E083318&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d03E083318&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d03E083318&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8c695d03E083318", "upi_tr": "pt_8c695d03E083318", "txnid": "ORDID1908012175", "orderid": "ORDID1908012175", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d03E083318&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d03E083318&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1908012175	f	2026-01-06 12:45:20.814458	2026-01-06 12:45:20.814462	\N	f	\N
450	3c70dd22-df28-4a50-a034-4a378507c5bf	PINL7Z0XOHLYA7H	HC1767703547887MB9	100.00	5.00	\N	Vinod Menonji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1697158658", "txnid": "PINL7Z0XOHLYA7H", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695d03fCB8FaF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695d03fCB8FaF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695d03fCB8FaF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695d03fCB8FaF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_29695d03fCB8FaF", "upi_tr": "pt_29695d03fCB8FaF", "txnid": "ORDID1697158658", "orderid": "ORDID1697158658", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695d03fCB8FaF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695d03fCB8FaF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1697158658	f	2026-01-06 12:45:49.018185	2026-01-06 12:45:49.018189	\N	f	\N
445	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFG5C30NN3238	HC17677035313962U7	100.00	5.00	\N	Suresh Aggarwalbabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6311634405", "txnid": "PINFG5C30NN3238", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695d03ec2Dae1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695d03ec2Dae1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695d03ec2Dae1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695d03ec2Dae1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_28695d03ec2Dae1", "upi_tr": "pt_28695d03ec2Dae1", "txnid": "ORDID6311634405", "orderid": "ORDID6311634405", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6311634405", "rrn": "600685446353"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695d03ec2Dae1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_28695d03ec2Dae1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6311634405	f	2026-01-06 12:45:32.457587	2026-01-06 12:46:10.226167	600685446353	t	2026-01-06 12:46:07.309889+00
455	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN0OQAU5IEFGB8	HC176770357781000H	100.00	5.00	\N	Harish Bhatiaappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4694643819", "txnid": "PIN0OQAU5IEFGB8", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d041A9Fed7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d041A9Fed7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d041A9Fed7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d041A9Fed7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_52695d041A9Fed7", "upi_tr": "pt_52695d041A9Fed7", "txnid": "ORDID4694643819", "orderid": "ORDID4694643819", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d041A9Fed7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d041A9Fed7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4694643819	f	2026-01-06 12:46:18.94161	2026-01-06 12:46:18.941615	\N	f	\N
765	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMU936UIS3J70	HC176770521589521Q	100.00	5.00	\N	Satish Thakur	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6688376889", "txnid": "PINMU936UIS3J70", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695d0A80AB561&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695d0A80AB561&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695d0A80AB561&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695d0A80AB561&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_63695d0A80AB561", "upi_tr": "pt_63695d0A80AB561", "txnid": "ORDID6688376889", "orderid": "ORDID6688376889", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695d0A80AB561&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_63695d0A80AB561&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6688376889	f	2026-01-06 13:13:36.989234	2026-01-06 13:13:36.989236	\N	f	\N
447	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5G0D1E5TLUYR	HC1767703538128WIG	100.00	5.00	\N	Ashok Patelesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4030856858", "txnid": "PIN5G0D1E5TLUYR", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695D03f2e41eA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695D03f2e41eA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695D03f2e41eA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695D03f2e41eA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_99695D03f2e41eA", "upi_tr": "pt_99695D03f2e41eA", "txnid": "ORDID4030856858", "orderid": "ORDID4030856858", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695D03f2e41eA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_99695D03f2e41eA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4030856858	f	2026-01-06 12:45:39.197334	2026-01-06 12:45:39.197337	\N	f	\N
448	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN04WHC6SSLSN1	HC17677035422765OG	100.00	5.00	\N	Komal Shahrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2973444827", "txnid": "PIN04WHC6SSLSN1", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695D03f71237A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695D03f71237A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695D03f71237A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695D03f71237A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_77695D03f71237A", "upi_tr": "pt_77695D03f71237A", "txnid": "ORDID2973444827", "orderid": "ORDID2973444827", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695D03f71237A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695D03f71237A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2973444827	f	2026-01-06 12:45:43.36936	2026-01-06 12:45:43.369364	\N	f	\N
451	3c70dd22-df28-4a50-a034-4a378507c5bf	PINX36WXY53KL7M	HC1767703553126LQJ	100.00	5.00	\N	Ashok Chauhannath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4618028905", "txnid": "PINX36WXY53KL7M", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C3695d0401f275B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C3695d0401f275B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C3695d0401f275B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C3695d0401f275B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C3695d0401f275B", "upi_tr": "pt_C3695d0401f275B", "txnid": "ORDID4618028905", "orderid": "ORDID4618028905", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C3695d0401f275B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C3695d0401f275B&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4618028905	f	2026-01-06 12:45:54.266756	2026-01-06 12:45:54.266759	\N	f	\N
561	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTG93JB0C45TQ	HC17677039971503MW	100.00	5.00	\N	Meena Chandrasekarji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4673951859", "txnid": "PINTG93JB0C45TQ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DA695D05BDEC321&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DA695D05BDEC321&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DA695D05BDEC321&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DA695D05BDEC321&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_DA695D05BDEC321", "upi_tr": "pt_DA695D05BDEC321", "txnid": "ORDID4673951859", "orderid": "ORDID4673951859", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DA695D05BDEC321&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DA695D05BDEC321&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4673951859	f	2026-01-06 12:53:18.260105	2026-01-06 12:53:18.26011	\N	f	\N
422	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2SIZWDLT2G50	HC1767703423516D09	100.00	5.00	\N	Asha Reddyji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7133258806", "txnid": "PIN2SIZWDLT2G50", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D03804d150&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D03804d150&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D03804d150&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D03804d150&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5d695D03804d150", "upi_tr": "pt_5d695D03804d150", "txnid": "ORDID7133258806", "orderid": "ORDID7133258806", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7133258806", "rrn": "637207081246"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D03804d150&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D03804d150&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7133258806	f	2026-01-06 12:43:44.595494	2026-01-06 12:45:50.180355	637207081246	t	2026-01-06 12:45:49.566838+00
452	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBNCNRMYBYFG3	HC1767703556453D9T	100.00	5.00	\N	Vikas Trivediesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4031366537", "txnid": "PINBNCNRMYBYFG3", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_51695D040548e2F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_51695D040548e2F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_51695D040548e2F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_51695D040548e2F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_51695D040548e2F", "upi_tr": "pt_51695D040548e2F", "txnid": "ORDID4031366537", "orderid": "ORDID4031366537", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_51695D040548e2F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_51695D040548e2F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4031366537	f	2026-01-06 12:45:57.578724	2026-01-06 12:45:57.578728	\N	f	\N
453	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLDNWPWCBA826	HC1767703560051AJ2	100.00	5.00	\N	Ritika Yadavappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2997443700", "txnid": "PINLDNWPWCBA826", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695D0408DB60A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695D0408DB60A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695D0408DB60A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695D0408DB60A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_38695D0408DB60A", "upi_tr": "pt_38695D0408DB60A", "txnid": "ORDID2997443700", "orderid": "ORDID2997443700", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695D0408DB60A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695D0408DB60A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2997443700	f	2026-01-06 12:46:01.162571	2026-01-06 12:46:01.162576	\N	f	\N
458	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8R5NK9BSV678	HC17677035934651SV	100.00	5.00	\N	Sheetal Aggarwalji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3220957419", "txnid": "PIN8R5NK9BSV678", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a4695D042A3eEfb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a4695D042A3eEfb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a4695D042A3eEfb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a4695D042A3eEfb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_a4695D042A3eEfb", "upi_tr": "pt_a4695D042A3eEfb", "txnid": "ORDID3220957419", "orderid": "ORDID3220957419", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a4695D042A3eEfb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_a4695D042A3eEfb&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3220957419	f	2026-01-06 12:46:34.53441	2026-01-06 12:46:34.534415	\N	f	\N
461	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1PRK3LVMEJQM	HC1767703602838NRC	100.00	5.00	\N	Sunita Raoji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3742008265", "txnid": "PIN1PRK3LVMEJQM", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695d0433a3432&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695d0433a3432&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695d0433a3432&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695d0433a3432&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_70695d0433a3432", "upi_tr": "pt_70695d0433a3432", "txnid": "ORDID3742008265", "orderid": "ORDID3742008265", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695d0433a3432&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_70695d0433a3432&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3742008265	f	2026-01-06 12:46:43.935468	2026-01-06 12:46:43.935471	\N	f	\N
440	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNNN3ECSY60YA	HC1767703509611R2O	100.00	5.00	\N	Monika Rao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6775118833", "txnid": "PINNNN3ECSY60YA", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1D695d03D670c3a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1D695d03D670c3a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1D695d03D670c3a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1D695d03D670c3a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1D695d03D670c3a", "upi_tr": "pt_1D695d03D670c3a", "txnid": "ORDID6775118833", "orderid": "ORDID6775118833", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6775118833", "rrn": "412376026264"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1D695d03D670c3a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1D695d03D670c3a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6775118833	f	2026-01-06 12:45:10.752453	2026-01-06 12:45:50.16566	412376026264	t	2026-01-06 12:45:46.114719+00
418	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLG25341C56SE	HC1767703388679YFE	100.00	5.00	\N	Keshav Desaiish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1364526485", "txnid": "PINLG25341C56SE", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_02695D035d7E953&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_02695D035d7E953&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_02695D035d7E953&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_02695D035d7E953&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_02695D035d7E953", "upi_tr": "pt_02695D035d7E953", "txnid": "ORDID1364526485", "orderid": "ORDID1364526485", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1364526485", "rrn": "600627619429"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_02695D035d7E953&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_02695D035d7E953&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1364526485	f	2026-01-06 12:43:09.805747	2026-01-06 12:45:55.202302	600627619429	t	2026-01-06 12:45:52.55249+00
449	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLAF0YOBOVTEC	HC1767703545462C64	100.00	5.00	\N	Pooja Chauhanish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5522015469", "txnid": "PINLAF0YOBOVTEC", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_04695d03Fa488A4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_04695d03Fa488A4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_04695d03Fa488A4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_04695d03Fa488A4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_04695d03Fa488A4", "upi_tr": "pt_04695d03Fa488A4", "txnid": "ORDID5522015469", "orderid": "ORDID5522015469", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5522015469", "rrn": "600685464426"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_04695d03Fa488A4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_04695d03Fa488A4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5522015469	f	2026-01-06 12:45:46.573873	2026-01-06 12:46:25.265309	600685464426	t	2026-01-06 12:46:20.503883+00
446	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBCHA848BDPHM	HC1767703533983L01	100.00	5.00	\N	Alka Desaibabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1851084488", "txnid": "PINBCHA848BDPHM", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D8695D03EEbee65&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D8695D03EEbee65&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D8695D03EEbee65&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D8695D03EEbee65&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_D8695D03EEbee65", "upi_tr": "pt_D8695D03EEbee65", "txnid": "ORDID1851084488", "orderid": "ORDID1851084488", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1851084488", "rrn": "421086394366"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D8695D03EEbee65&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_D8695D03EEbee65&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1851084488	f	2026-01-06 12:45:35.0585	2026-01-06 12:46:25.277491	421086394366	t	2026-01-06 12:46:21.031155+00
562	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5NZOEN3ZD7HH	HC1767704001515OP7	100.00	5.00	\N	Sneha Aggarwalendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8098345916", "txnid": "PIN5NZOEN3ZD7HH", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5E695d05C25ae9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5E695d05C25ae9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5E695d05C25ae9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5E695d05C25ae9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5E695d05C25ae9d", "upi_tr": "pt_5E695d05C25ae9d", "txnid": "ORDID8098345916", "orderid": "ORDID8098345916", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5E695d05C25ae9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5E695d05C25ae9d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8098345916	f	2026-01-06 12:53:22.659415	2026-01-06 12:53:22.659419	\N	f	\N
566	3c70dd22-df28-4a50-a034-4a378507c5bf	PINOR1Q93D1RHHP	HC176770401542145B	100.00	5.00	\N	Ravi Bhatiaesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4064068044", "txnid": "PINOR1Q93D1RHHP", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695D05D036262&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695D05D036262&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695D05D036262&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695D05D036262&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_06695D05D036262", "upi_tr": "pt_06695D05D036262", "txnid": "ORDID4064068044", "orderid": "ORDID4064068044", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695D05D036262&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_06695D05D036262&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4064068044	f	2026-01-06 12:53:36.499727	2026-01-06 12:53:36.49973	\N	f	\N
564	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFEOJ97YBH0TZ	HC1767704010346UXT	100.00	5.00	\N	Pooja Singhji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4222628891", "txnid": "PINFEOJ97YBH0TZ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695d05Cb21134&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695d05Cb21134&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695d05Cb21134&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695d05Cb21134&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C5695d05Cb21134", "upi_tr": "pt_C5695d05Cb21134", "txnid": "ORDID4222628891", "orderid": "ORDID4222628891", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695d05Cb21134&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695d05Cb21134&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4222628891	f	2026-01-06 12:53:31.416521	2026-01-06 12:53:31.416525	\N	f	\N
444	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIIA8O7WN6C5C	HC1767703526842QJP	100.00	5.00	\N	Tanvi Singhendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1815242524", "txnid": "PINIIA8O7WN6C5C", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695D03e7A6eB7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695D03e7A6eB7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695D03e7A6eB7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695D03e7A6eB7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_22695D03e7A6eB7", "upi_tr": "pt_22695D03e7A6eB7", "txnid": "ORDID1815242524", "orderid": "ORDID1815242524", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1815242524", "rrn": "252120049015"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695D03e7A6eB7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695D03e7A6eB7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1815242524	f	2026-01-06 12:45:27.953065	2026-01-06 12:46:15.245042	252120049015	t	2026-01-06 12:46:11.897496+00
456	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGYAEAJ6BYTUF	HC1767703585349BVY	100.00	5.00	\N	Sita Trivedilal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5307783754", "txnid": "PINGYAEAJ6BYTUF", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695D042232D30&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695D042232D30&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695D042232D30&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695D042232D30&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_75695D042232D30", "upi_tr": "pt_75695D042232D30", "txnid": "ORDID5307783754", "orderid": "ORDID5307783754", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695D042232D30&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695D042232D30&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5307783754	f	2026-01-06 12:46:26.509376	2026-01-06 12:46:26.509379	\N	f	\N
457	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4JX9FLTWYRC6	HC1767703592884QA5	100.00	5.00	\N	Kumar Dwivedilal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1907008988", "txnid": "PIN4JX9FLTWYRC6", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695d0429B387e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695d0429B387e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695d0429B387e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695d0429B387e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_43695d0429B387e", "upi_tr": "pt_43695d0429B387e", "txnid": "ORDID1907008988", "orderid": "ORDID1907008988", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695d0429B387e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695d0429B387e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1907008988	f	2026-01-06 12:46:34.013273	2026-01-06 12:46:34.013278	\N	f	\N
454	3c70dd22-df28-4a50-a034-4a378507c5bf	PINB7M3AG0WA58W	HC1767703571961LAM	100.00	5.00	\N	Lalita Kulkarniesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6665188278", "txnid": "PINB7M3AG0WA58W", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695d0414bB249&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695d0414bB249&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695d0414bB249&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695d0414bB249&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_91695d0414bB249", "upi_tr": "pt_91695d0414bB249", "txnid": "ORDID6665188278", "orderid": "ORDID6665188278", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6665188278", "rrn": "600649299183"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695d0414bB249&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_91695d0414bB249&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6665188278	f	2026-01-06 12:46:13.052717	2026-01-06 12:46:45.307498	600649299183	t	2026-01-06 12:46:40.860897+00
472	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN08CJVM763RWZ	HC1767703651818I7L	100.00	5.00	\N	Ekta Dubeyram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3750778978", "txnid": "PIN08CJVM763RWZ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695D04649a6a8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695D04649a6a8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695D04649a6a8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695D04649a6a8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_B2695D04649a6a8", "upi_tr": "pt_B2695D04649a6a8", "txnid": "ORDID3750778978", "orderid": "ORDID3750778978", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695D04649a6a8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_B2695D04649a6a8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3750778978	f	2026-01-06 12:47:32.915343	2026-01-06 12:47:32.915347	\N	f	\N
460	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRDJVBA42M0E4	HC17677035991081JY	100.00	5.00	\N	Sneha Guptaappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9785312384", "txnid": "PINRDJVBA42M0E4", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7D695D042fdee39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7D695D042fdee39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7D695D042fdee39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7D695D042fdee39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7D695D042fdee39", "upi_tr": "pt_7D695D042fdee39", "txnid": "ORDID9785312384", "orderid": "ORDID9785312384", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9785312384", "rrn": "387496557185"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7D695D042fdee39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7D695D042fdee39&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9785312384	f	2026-01-06 12:46:40.17373	2026-01-06 12:47:35.37392	387496557185	t	2026-01-06 12:47:34.858785+00
462	3c70dd22-df28-4a50-a034-4a378507c5bf	PINPKGEDNLJ3HXY	HC1767703606028GDO	100.00	5.00	\N	Rahul Chopralal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3507476340", "txnid": "PINPKGEDNLJ3HXY", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d0436CA7aB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d0436CA7aB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d0436CA7aB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d0436CA7aB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4a695d0436CA7aB", "upi_tr": "pt_4a695d0436CA7aB", "txnid": "ORDID3507476340", "orderid": "ORDID3507476340", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3507476340", "rrn": "637664106688"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d0436CA7aB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4a695d0436CA7aB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3507476340	f	2026-01-06 12:46:47.127638	2026-01-06 12:47:45.391594	637664106688	t	2026-01-06 12:47:40.537441+00
467	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBYM2XQWLFXFY	HC17677036316878HJ	100.00	5.00	\N	Dinesh Thakurji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7644528703", "txnid": "PINBYM2XQWLFXFY", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d04507AdfD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d04507AdfD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d04507AdfD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d04507AdfD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8c695d04507AdfD", "upi_tr": "pt_8c695d04507AdfD", "txnid": "ORDID7644528703", "orderid": "ORDID7644528703", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7644528703", "rrn": "708319418230"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d04507AdfD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8c695d04507AdfD&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7644528703	f	2026-01-06 12:47:12.766568	2026-01-06 12:48:05.418037	708319418230	t	2026-01-06 12:48:01.614641+00
463	3c70dd22-df28-4a50-a034-4a378507c5bf	PINSXVA52QC2QM1	HC1767703606184XUC	100.00	5.00	\N	Asha Menonesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7044347560", "txnid": "PINSXVA52QC2QM1", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695D0437028d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695D0437028d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695D0437028d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695D0437028d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Cd695D0437028d6", "upi_tr": "pt_Cd695D0437028d6", "txnid": "ORDID7044347560", "orderid": "ORDID7044347560", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695D0437028d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695D0437028d6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7044347560	f	2026-01-06 12:46:47.296494	2026-01-06 12:46:47.296498	\N	f	\N
459	3c70dd22-df28-4a50-a034-4a378507c5bf	PINSZZWVJF986VQ	HC176770359544315D	100.00	5.00	\N	Lalita Naiduish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6537182739", "txnid": "PINSZZWVJF986VQ", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695d042c43A34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695d042c43A34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695d042c43A34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695d042c43A34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_85695d042c43A34", "upi_tr": "pt_85695d042c43A34", "txnid": "ORDID6537182739", "orderid": "ORDID6537182739", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6537182739", "rrn": "637216621248"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695d042c43A34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695d042c43A34&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6537182739	f	2026-01-06 12:46:36.551131	2026-01-06 12:47:10.334765	637216621248	t	2026-01-06 12:47:07.689388+00
468	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNZV2MDFIWV47	HC1767703632567VQV	100.00	5.00	\N	Yogesh Singhish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6838572185", "txnid": "PINNZV2MDFIWV47", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695d04515f44c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695d04515f44c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695d04515f44c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695d04515f44c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e3695d04515f44c", "upi_tr": "pt_e3695d04515f44c", "txnid": "ORDID6838572185", "orderid": "ORDID6838572185", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695d04515f44c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e3695d04515f44c&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6838572185	f	2026-01-06 12:47:13.665296	2026-01-06 12:47:13.665299	\N	f	\N
471	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTHVCQ7V93GWN	HC17677036514440GA	100.00	5.00	\N	Chandan Rao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8047885102", "txnid": "PINTHVCQ7V93GWN", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_23695d0464481D8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_23695d0464481D8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_23695d0464481D8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_23695d0464481D8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_23695d0464481D8", "upi_tr": "pt_23695d0464481D8", "txnid": "ORDID8047885102", "orderid": "ORDID8047885102", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_23695d0464481D8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_23695d0464481D8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8047885102	f	2026-01-06 12:47:32.579808	2026-01-06 12:47:32.579811	\N	f	\N
465	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLYNVZZL7T81X	HC1767703614789RPW	100.00	5.00	\N	Rekha Vermababu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3249084629", "txnid": "PINLYNVZZL7T81X", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695d043F966c0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695d043F966c0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695d043F966c0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695d043F966c0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_9B695d043F966c0", "upi_tr": "pt_9B695d043F966c0", "txnid": "ORDID3249084629", "orderid": "ORDID3249084629", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695d043F966c0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_9B695d043F966c0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3249084629	f	2026-01-06 12:46:55.904994	2026-01-06 12:46:55.904998	\N	f	\N
464	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCDXCY17T3HEV	HC1767703610214SQV	100.00	5.00	\N	Tanya Dubeyesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3762427478", "txnid": "PINCDXCY17T3HEV", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695d043B07789&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695d043B07789&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695d043B07789&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695d043B07789&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5e695d043B07789", "upi_tr": "pt_5e695d043B07789", "txnid": "ORDID3762427478", "orderid": "ORDID3762427478", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3762427478", "rrn": "637207093802"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695d043B07789&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5e695d043B07789&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3762427478	f	2026-01-06 12:46:51.303699	2026-01-06 12:47:20.352611	637207093802	t	2026-01-06 12:47:20.066793+00
475	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNM44H24RXBKA	HC1767703661310X3X	100.00	5.00	\N	Vikas Yadavkar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5476310246", "txnid": "PINNM44H24RXBKA", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_67695D046E23d80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_67695D046E23d80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_67695D046E23d80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_67695D046E23d80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_67695D046E23d80", "upi_tr": "pt_67695D046E23d80", "txnid": "ORDID5476310246", "orderid": "ORDID5476310246", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_67695D046E23d80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_67695D046E23d80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5476310246	f	2026-01-06 12:47:42.431978	2026-01-06 12:47:42.431982	\N	f	\N
482	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3M1RM350XDZ9	HC1767703684591BO2	100.00	5.00	\N	Anil Mehtakar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4703952389", "txnid": "PIN3M1RM350XDZ9", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f2695d048578F55&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f2695d048578F55&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f2695d048578F55&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f2695d048578F55&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_f2695d048578F55", "upi_tr": "pt_f2695d048578F55", "txnid": "ORDID4703952389", "orderid": "ORDID4703952389", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f2695d048578F55&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f2695d048578F55&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4703952389	f	2026-01-06 12:48:05.8014	2026-01-06 12:48:05.801404	\N	f	\N
466	3c70dd22-df28-4a50-a034-4a378507c5bf	PINPJ5GGU6RCX9D	HC1767703625366Y4M	100.00	5.00	\N	Vijay Pandeyananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1944664386", "txnid": "PINPJ5GGU6RCX9D", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695d044a2D1AF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695d044a2D1AF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695d044a2D1AF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695d044a2D1AF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_94695d044a2D1AF", "upi_tr": "pt_94695d044a2D1AF", "txnid": "ORDID1944664386", "orderid": "ORDID1944664386", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695d044a2D1AF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_94695d044a2D1AF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1944664386	f	2026-01-06 12:47:06.467761	2026-01-06 12:47:06.467764	\N	f	\N
1578	3c70dd22-df28-4a50-a034-4a378507c5bf	PINW9030DUQBQHV	HC1767709433149XNE	100.00	5.00	\N	Lalita Chatterjeebabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5353733409", "txnid": "PINW9030DUQBQHV", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D1Af9D61c1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D1Af9D61c1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D1Af9D61c1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D1Af9D61c1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5d695D1Af9D61c1", "upi_tr": "pt_5d695D1Af9D61c1", "txnid": "ORDID5353733409", "orderid": "ORDID5353733409", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5353733409", "rrn": "500720790760"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D1Af9D61c1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5d695D1Af9D61c1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5353733409	f	2026-01-06 14:23:54.144109	2026-01-06 15:24:23.059454	500720790760	t	2026-01-06 15:24:21.456759+00
470	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5T9RWDHIIW9H	HC1767703641089INO	100.00	5.00	\N	Jaya Bhattacharya	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5086924366", "txnid": "PIN5T9RWDHIIW9H", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695D0459db1Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695D0459db1Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695D0459db1Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695D0459db1Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0F695D0459db1Ae", "upi_tr": "pt_0F695D0459db1Ae", "txnid": "ORDID5086924366", "orderid": "ORDID5086924366", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695D0459db1Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0F695D0459db1Ae&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5086924366	f	2026-01-06 12:47:22.165847	2026-01-06 12:47:22.16585	\N	f	\N
476	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2RXZWZMBURMK	HC1767703662398R4T	100.00	5.00	\N	Ashok Iyerish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3932138187", "txnid": "PIN2RXZWZMBURMK", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C0695D046F32a3C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C0695D046F32a3C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C0695D046F32a3C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C0695D046F32a3C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C0695D046F32a3C", "upi_tr": "pt_C0695D046F32a3C", "txnid": "ORDID3932138187", "orderid": "ORDID3932138187", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C0695D046F32a3C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C0695D046F32a3C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3932138187	f	2026-01-06 12:47:43.474765	2026-01-06 12:47:43.474769	\N	f	\N
473	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN8K3LIFZT170P	HC1767703656425A06	100.00	5.00	\N	Swati Vermaji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5132064415", "txnid": "PIN8K3LIFZT170P", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695d046943542&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695d046943542&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695d046943542&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695d046943542&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_87695d046943542", "upi_tr": "pt_87695d046943542", "txnid": "ORDID5132064415", "orderid": "ORDID5132064415", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5132064415", "rrn": "081469346941"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695d046943542&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695d046943542&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5132064415	f	2026-01-06 12:47:37.557181	2026-01-06 12:49:30.606894	081469346941	t	2026-01-06 12:49:27.629777+00
474	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNXDTQ4AMTO75	HC17677036577051BE	100.00	5.00	\N	Dinesh Verma	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5625847668", "txnid": "PINNXDTQ4AMTO75", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eE695d046A7A2b5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eE695d046A7A2b5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eE695d046A7A2b5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eE695d046A7A2b5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_eE695d046A7A2b5", "upi_tr": "pt_eE695d046A7A2b5", "txnid": "ORDID5625847668", "orderid": "ORDID5625847668", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eE695d046A7A2b5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_eE695d046A7A2b5&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5625847668	f	2026-01-06 12:47:38.782059	2026-01-06 12:47:38.782063	\N	f	\N
477	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV0ZMLVNB47GM	HC1767703665802OFA	100.00	5.00	\N	Asha Vermanath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8777280671", "txnid": "PINV0ZMLVNB47GM", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F7695D0472968A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F7695D0472968A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F7695D0472968A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F7695D0472968A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_F7695D0472968A3", "upi_tr": "pt_F7695D0472968A3", "txnid": "ORDID8777280671", "orderid": "ORDID8777280671", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F7695D0472968A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_F7695D0472968A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8777280671	f	2026-01-06 12:47:46.90259	2026-01-06 12:47:46.902594	\N	f	\N
478	3c70dd22-df28-4a50-a034-4a378507c5bf	PINPB9WETQHPZAI	HC1767703669479T08	100.00	5.00	\N	Alka Reddyananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1695125036", "txnid": "PINPB9WETQHPZAI", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695D0476471b9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695D0476471b9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695D0476471b9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695D0476471b9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_13695D0476471b9", "upi_tr": "pt_13695D0476471b9", "txnid": "ORDID1695125036", "orderid": "ORDID1695125036", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695D0476471b9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_13695D0476471b9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1695125036	f	2026-01-06 12:47:50.576572	2026-01-06 12:47:50.576576	\N	f	\N
479	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFQ6LHC4SVW76	HC1767703676662D4V	100.00	5.00	\N	Kailash Mathurendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1188379758", "txnid": "PINFQ6LHC4SVW76", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695D047d778e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695D047d778e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695D047d778e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695D047d778e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_25695D047d778e9", "upi_tr": "pt_25695D047d778e9", "txnid": "ORDID1188379758", "orderid": "ORDID1188379758", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695D047d778e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_25695D047d778e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1188379758	f	2026-01-06 12:47:57.762952	2026-01-06 12:47:57.762956	\N	f	\N
568	3c70dd22-df28-4a50-a034-4a378507c5bf	PINK8TK3530V4EE	HC1767704027245ZPH	100.00	5.00	\N	Sudhir Singhram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8791790940", "txnid": "PINK8TK3530V4EE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695d05DC09C94&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695d05DC09C94&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695d05DC09C94&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695d05DC09C94&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_98695d05DC09C94", "upi_tr": "pt_98695d05DC09C94", "txnid": "ORDID8791790940", "orderid": "ORDID8791790940", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695d05DC09C94&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_98695d05DC09C94&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8791790940	f	2026-01-06 12:53:48.306109	2026-01-06 12:53:48.306112	\N	f	\N
480	3c70dd22-df28-4a50-a034-4a378507c5bf	PINGMLVSPV144VE	HC17677036825406MQ	100.00	5.00	\N	Bharat Singhrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1322144243", "txnid": "PINGMLVSPV144VE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695d048377826&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695d048377826&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695d048377826&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695d048377826&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_CB695d048377826", "upi_tr": "pt_CB695d048377826", "txnid": "ORDID1322144243", "orderid": "ORDID1322144243", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695d048377826&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_CB695d048377826&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1322144243	f	2026-01-06 12:48:03.76534	2026-01-06 12:48:03.765344	\N	f	\N
767	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN58PHV407MFL5	HC1767705229187QTQ	100.00	5.00	\N	Vivek Trivediesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7997784315", "txnid": "PIN58PHV407MFL5", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0A8DE8A80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0A8DE8A80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0A8DE8A80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0A8DE8A80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0D695D0A8DE8A80", "upi_tr": "pt_0D695D0A8DE8A80", "txnid": "ORDID7997784315", "orderid": "ORDID7997784315", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0A8DE8A80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0A8DE8A80&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7997784315	f	2026-01-06 13:13:50.244471	2026-01-06 13:13:50.244474	\N	f	\N
567	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTHD8FW9N6WBF	HC17677040247971FI	100.00	5.00	\N	Nandini Patelrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2668234993", "txnid": "PINTHD8FW9N6WBF", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695d05D99C8Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695d05D99C8Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695d05D99C8Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695d05D99C8Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_EE695d05D99C8Cf", "upi_tr": "pt_EE695d05D99C8Cf", "txnid": "ORDID2668234993", "orderid": "ORDID2668234993", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695d05D99C8Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_EE695d05D99C8Cf&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2668234993	f	2026-01-06 12:53:45.918202	2026-01-06 12:53:45.918207	\N	f	\N
469	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQLW7QOP06NQB	HC1767703640480NIT	100.00	5.00	\N	Kailash Mathur	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1797663003", "txnid": "PINQLW7QOP06NQB", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695d045950740&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695d045950740&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695d045950740&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695d045950740&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4C695d045950740", "upi_tr": "pt_4C695d045950740", "txnid": "ORDID1797663003", "orderid": "ORDID1797663003", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1797663003", "rrn": "669400086362"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695d045950740&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4C695d045950740&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1797663003	f	2026-01-06 12:47:21.616069	2026-01-06 12:48:20.457564	669400086362	t	2026-01-06 12:48:16.341319+00
491	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNXVPDJ5313NP	HC1767703717218DMX	100.00	5.00	\N	Komal Aggarwalbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9729179072", "txnid": "PINNXVPDJ5313NP", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695D04A607D4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695D04A607D4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695D04A607D4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695D04A607D4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_58695D04A607D4d", "upi_tr": "pt_58695D04A607D4d", "txnid": "ORDID9729179072", "orderid": "ORDID9729179072", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695D04A607D4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_58695D04A607D4d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9729179072	f	2026-01-06 12:48:38.312221	2026-01-06 12:48:38.312225	\N	f	\N
483	3c70dd22-df28-4a50-a034-4a378507c5bf	PINM99RC36CW5AH	HC17677036878483ES	100.00	5.00	\N	Yogesh Shahendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6145565319", "txnid": "PINM99RC36CW5AH", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2E695D0488A7fd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2E695D0488A7fd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2E695D0488A7fd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2E695D0488A7fd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2E695D0488A7fd2", "upi_tr": "pt_2E695D0488A7fd2", "txnid": "ORDID6145565319", "orderid": "ORDID6145565319", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2E695D0488A7fd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2E695D0488A7fd2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6145565319	f	2026-01-06 12:48:08.960511	2026-01-06 12:48:08.960515	\N	f	\N
558	3c70dd22-df28-4a50-a034-4a378507c5bf	PINXS8UHV0KMHE5	HC1767703989703V25	100.00	5.00	\N	Geeta Menonnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2126622101", "txnid": "PINXS8UHV0KMHE5", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3e695d05B67ef6e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3e695d05B67ef6e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3e695d05B67ef6e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3e695d05B67ef6e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_3e695d05B67ef6e", "upi_tr": "pt_3e695d05B67ef6e", "txnid": "ORDID2126622101", "orderid": "ORDID2126622101", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2126622101", "rrn": "116778702769"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3e695d05B67ef6e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3e695d05B67ef6e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2126622101	f	2026-01-06 12:53:10.793711	2026-01-06 12:53:46.194421	116778702769	t	2026-01-06 12:53:42.421949+00
489	3c70dd22-df28-4a50-a034-4a378507c5bf	PINL3LX77FQOE9R	HC1767703707982O0I	100.00	5.00	\N	Geeta Trivediesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5423026693", "txnid": "PINL3LX77FQOE9R", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_92695d049CC326a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_92695d049CC326a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_92695d049CC326a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_92695d049CC326a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_92695d049CC326a", "upi_tr": "pt_92695d049CC326a", "txnid": "ORDID5423026693", "orderid": "ORDID5423026693", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_92695d049CC326a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_92695d049CC326a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5423026693	f	2026-01-06 12:48:29.073399	2026-01-06 12:48:29.073404	\N	f	\N
492	3c70dd22-df28-4a50-a034-4a378507c5bf	PINDNF2WYXA8LUJ	HC1767703719411NB6	100.00	5.00	\N	Jaya Kumarji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1957140894", "txnid": "PINDNF2WYXA8LUJ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2e695d04A839EEc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2e695d04A839EEc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2e695d04A839EEc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2e695d04A839EEc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2e695d04A839EEc", "upi_tr": "pt_2e695d04A839EEc", "txnid": "ORDID1957140894", "orderid": "ORDID1957140894", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2e695d04A839EEc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2e695d04A839EEc&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1957140894	f	2026-01-06 12:48:40.504595	2026-01-06 12:48:40.504599	\N	f	\N
490	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN10UROE5E7QVB	HC17677037136651VA	100.00	5.00	\N	Asha Pandeylal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2872174131", "txnid": "PIN10UROE5E7QVB", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695d04A27a6bB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695d04A27a6bB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695d04A27a6bB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695d04A27a6bB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_75695d04A27a6bB", "upi_tr": "pt_75695d04A27a6bB", "txnid": "ORDID2872174131", "orderid": "ORDID2872174131", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2872174131", "rrn": "658224353324"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695d04A27a6bB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_75695d04A27a6bB&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2872174131	f	2026-01-06 12:48:34.773953	2026-01-06 12:49:15.551587	658224353324	t	2026-01-06 12:49:12.083628+00
485	3c70dd22-df28-4a50-a034-4a378507c5bf	PINP2IMNMWTHAYX	HC17677036930578ST	100.00	5.00	\N	Tanya Chatterjeelal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4778418785", "txnid": "PINP2IMNMWTHAYX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d048DDFD84&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d048DDFD84&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d048DDFD84&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d048DDFD84&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_77695d048DDFD84", "upi_tr": "pt_77695d048DDFD84", "txnid": "ORDID4778418785", "orderid": "ORDID4778418785", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d048DDFD84&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d048DDFD84&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4778418785	f	2026-01-06 12:48:14.187812	2026-01-06 12:48:14.187817	\N	f	\N
1685	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCR6PCDTILGTW	HC17677095184808G0	100.00	5.00	\N	Ramesh Trivedilal	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8128540796", "txnid": "PINCR6PCDTILGTW", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695D1B4f36973&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695D1B4f36973&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695D1B4f36973&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695D1B4f36973&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_16695D1B4f36973", "upi_tr": "pt_16695D1B4f36973", "txnid": "ORDID8128540796", "orderid": "ORDID8128540796", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695D1B4f36973&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_16695D1B4f36973&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8128540796	f	2026-01-06 14:25:19.484279	2026-01-06 14:25:19.484285	\N	f	\N
774	3c70dd22-df28-4a50-a034-4a378507c5bf	PINSNFOUIT2ZOTD	HC1767705266841BAX	100.00	5.00	\N	Subhash Naidu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8358963436", "txnid": "PINSNFOUIT2ZOTD", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6D695d0AB3c4409&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6D695d0AB3c4409&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6D695d0AB3c4409&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6D695d0AB3c4409&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_6D695d0AB3c4409", "upi_tr": "pt_6D695d0AB3c4409", "txnid": "ORDID8358963436", "orderid": "ORDID8358963436", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6D695d0AB3c4409&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_6D695d0AB3c4409&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8358963436	f	2026-01-06 13:14:28.200961	2026-01-06 13:14:28.200965	\N	f	\N
481	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN849N5CK11JVV	HC1767703682734E5I	100.00	5.00	\N	Sunita Mishraesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9150895934", "txnid": "PIN849N5CK11JVV", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0483a6f89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0483a6f89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0483a6f89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0483a6f89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0D695D0483a6f89", "upi_tr": "pt_0D695D0483a6f89", "txnid": "ORDID9150895934", "orderid": "ORDID9150895934", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9150895934", "rrn": "600616274260"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0483a6f89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0D695D0483a6f89&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9150895934	f	2026-01-06 12:48:03.975734	2026-01-06 12:48:40.481649	600616274260	t	2026-01-06 12:48:38.649211+00
497	3c70dd22-df28-4a50-a034-4a378507c5bf	PINYYSJZU0QGO09	HC1767703742627FLK	100.00	5.00	\N	Lalit Thakuresh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8452312750", "txnid": "PINYYSJZU0QGO09", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dD695d04BfaF17d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dD695d04BfaF17d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dD695d04BfaF17d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dD695d04BfaF17d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_dD695d04BfaF17d", "upi_tr": "pt_dD695d04BfaF17d", "txnid": "ORDID8452312750", "orderid": "ORDID8452312750", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dD695d04BfaF17d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dD695d04BfaF17d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8452312750	f	2026-01-06 12:49:04.005874	2026-01-06 12:49:04.005879	\N	f	\N
493	3c70dd22-df28-4a50-a034-4a378507c5bf	PINVH087R0JLBGY	HC1767703719428KU0	100.00	5.00	\N	Arjun Chatterjeenath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1314572810", "txnid": "PINVH087R0JLBGY", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695d04a838AE6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695d04a838AE6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695d04a838AE6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695d04a838AE6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8C695d04a838AE6", "upi_tr": "pt_8C695d04a838AE6", "txnid": "ORDID1314572810", "orderid": "ORDID1314572810", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695d04a838AE6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8C695d04a838AE6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1314572810	f	2026-01-06 12:48:40.508941	2026-01-06 12:48:40.508943	\N	f	\N
556	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4XZJKHAI0PRT	HC1767703969589X12	100.00	5.00	\N	Swati Desaibabu	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2176686167", "txnid": "PIN4XZJKHAI0PRT", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d05A25Cf0a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d05A25Cf0a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d05A25Cf0a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d05A25Cf0a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_44695d05A25Cf0a", "upi_tr": "pt_44695d05A25Cf0a", "txnid": "ORDID2176686167", "orderid": "ORDID2176686167", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2176686167", "rrn": "698521406773"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d05A25Cf0a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d05A25Cf0a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2176686167	f	2026-01-06 12:52:50.660305	2026-01-06 12:53:56.213753	698521406773	t	2026-01-06 12:53:51.972072+00
495	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4GHE4LLDA4TI	HC1767703734468IT9	100.00	5.00	\N	Sheetal Kulkarniram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5085064061", "txnid": "PIN4GHE4LLDA4TI", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695d04B75559a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695d04B75559a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695d04B75559a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695d04B75559a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_26695d04B75559a", "upi_tr": "pt_26695d04B75559a", "txnid": "ORDID5085064061", "orderid": "ORDID5085064061", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695d04B75559a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_26695d04B75559a&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5085064061	f	2026-01-06 12:48:55.635245	2026-01-06 12:48:55.635247	\N	f	\N
484	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN9L5QSWUCXZMS	HC17677036901695RU	100.00	5.00	\N	Sanjay Naiduappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7672723532", "txnid": "PIN9L5QSWUCXZMS", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D048B0479f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D048B0479f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D048B0479f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D048B0479f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_29695D048B0479f", "upi_tr": "pt_29695D048B0479f", "txnid": "ORDID7672723532", "orderid": "ORDID7672723532", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7672723532", "rrn": "116778358636"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D048B0479f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_29695D048B0479f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7672723532	f	2026-01-06 12:48:11.315047	2026-01-06 12:49:05.512345	116778358636	t	2026-01-06 12:49:03.789301+00
498	3c70dd22-df28-4a50-a034-4a378507c5bf	PINM3SRHTUE04L5	HC17677037419991HI	100.00	5.00	\N	Ravi Iyer	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9065741482", "txnid": "PINM3SRHTUE04L5", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04bFaeA21&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04bFaeA21&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04bFaeA21&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04bFaeA21&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Cd695d04bFaeA21", "upi_tr": "pt_Cd695d04bFaeA21", "txnid": "ORDID9065741482", "orderid": "ORDID9065741482", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04bFaeA21&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04bFaeA21&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9065741482	f	2026-01-06 12:49:04.010188	2026-01-06 12:49:04.010193	\N	f	\N
499	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRJIVBMMMVPUU	HC1767703746072S8A	100.00	5.00	\N	Pooja Chauhanji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4890706503", "txnid": "PINRJIVBMMMVPUU", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695D04C2e6774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695D04C2e6774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695D04C2e6774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695D04C2e6774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_b6695D04C2e6774", "upi_tr": "pt_b6695D04C2e6774", "txnid": "ORDID4890706503", "orderid": "ORDID4890706503", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695D04C2e6774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_b6695D04C2e6774&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4890706503	f	2026-01-06 12:49:07.229672	2026-01-06 12:49:07.229676	\N	f	\N
570	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN5KB47KVSPS9L	HC1767704043408B5U	100.00	5.00	\N	Chitra Chauhanbabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5130705165", "txnid": "PIN5KB47KVSPS9L", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695d05ec47aad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695d05ec47aad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695d05ec47aad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695d05ec47aad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_22695d05ec47aad", "upi_tr": "pt_22695d05ec47aad", "txnid": "ORDID5130705165", "orderid": "ORDID5130705165", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695d05ec47aad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_22695d05ec47aad&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5130705165	f	2026-01-06 12:54:04.569542	2026-01-06 12:54:04.569547	\N	f	\N
573	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV9C2Z5PRVRSN	HC1767704062484H1Y	100.00	5.00	\N	Govind Dubey	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9590490198", "txnid": "PINV9C2Z5PRVRSN", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d05FF44eF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d05FF44eF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d05FF44eF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d05FF44eF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d1695d05FF44eF0", "upi_tr": "pt_d1695d05FF44eF0", "txnid": "ORDID9590490198", "orderid": "ORDID9590490198", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d05FF44eF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d05FF44eF0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9590490198	f	2026-01-06 12:54:23.56172	2026-01-06 12:54:23.561723	\N	f	\N
577	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKPNJAS59R64K	HC1767704068380SZN	100.00	5.00	\N	Ritika Bhattacharyaesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4015140433", "txnid": "PINKPNJAS59R64K", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695D06052b5e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695D06052b5e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695D06052b5e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695D06052b5e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e4695D06052b5e9", "upi_tr": "pt_e4695D06052b5e9", "txnid": "ORDID4015140433", "orderid": "ORDID4015140433", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695D06052b5e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e4695D06052b5e9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4015140433	f	2026-01-06 12:54:29.459438	2026-01-06 12:54:29.459441	\N	f	\N
486	3c70dd22-df28-4a50-a034-4a378507c5bf	PINTAZCNIEGFYWW	HC1767703701755G8B	100.00	5.00	\N	Naveen Shahnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5850654620", "txnid": "PINTAZCNIEGFYWW", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5a695d049687867&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5a695d049687867&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5a695d049687867&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5a695d049687867&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5a695d049687867", "upi_tr": "pt_5a695d049687867", "txnid": "ORDID5850654620", "orderid": "ORDID5850654620", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5850654620", "rrn": "062902620505"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5a695d049687867&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5a695d049687867&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5850654620	f	2026-01-06 12:48:22.836529	2026-01-06 12:49:10.532507	062902620505	t	2026-01-06 12:49:09.852422+00
560	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN1UT4IOT5MLN7	HC1767703995069BZ3	100.00	5.00	\N	Deepak Chauhanappa	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1912995315", "txnid": "PIN1UT4IOT5MLN7", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695D05BbD71b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695D05BbD71b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695D05BbD71b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695D05BbD71b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_87695D05BbD71b3", "upi_tr": "pt_87695D05BbD71b3", "txnid": "ORDID1912995315", "orderid": "ORDID1912995315", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1912995315", "rrn": "502210008681"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695D05BbD71b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_87695D05BbD71b3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1912995315	f	2026-01-06 12:53:16.161786	2026-01-06 12:54:06.243719	502210008681	t	2026-01-06 12:54:03.16227+00
578	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZ1GOQE6DZSG9	HC1767704069936ZU6	100.00	5.00	\N	Sunita Nairnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5732147626", "txnid": "PINZ1GOQE6DZSG9", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_21695D0606BdA8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_21695D0606BdA8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_21695D0606BdA8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_21695D0606BdA8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_21695D0606BdA8d", "upi_tr": "pt_21695D0606BdA8d", "txnid": "ORDID5732147626", "orderid": "ORDID5732147626", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5732147626", "rrn": "116778793944"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_21695D0606BdA8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_21695D0606BdA8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5732147626	f	2026-01-06 12:54:31.074204	2026-01-06 12:55:01.322939	116778793944	t	2026-01-06 12:55:00.827774+00
575	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3QNGE48PU00U	HC1767704065479W6F	100.00	5.00	\N	Vinod Thakurlal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6568283272", "txnid": "PIN3QNGE48PU00U", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E8695D06024B95D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E8695D06024B95D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E8695D06024B95D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E8695D06024B95D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E8695D06024B95D", "upi_tr": "pt_E8695D06024B95D", "txnid": "ORDID6568283272", "orderid": "ORDID6568283272", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6568283272", "rrn": "559258401532"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E8695D06024B95D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E8695D06024B95D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6568283272	f	2026-01-06 12:54:26.606848	2026-01-06 12:55:31.361133	559258401532	t	2026-01-06 12:55:29.850978+00
574	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV12KJEV16LRQ	HC1767704063690V9Y	100.00	5.00	\N	Rahul Mishraananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2033483630", "txnid": "PINV12KJEV16LRQ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D0600777A1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D0600777A1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D0600777A1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D0600777A1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_C5695D0600777A1", "upi_tr": "pt_C5695D0600777A1", "txnid": "ORDID2033483630", "orderid": "ORDID2033483630", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D0600777A1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_C5695D0600777A1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2033483630	f	2026-01-06 12:54:24.769726	2026-01-06 12:54:24.76973	\N	f	\N
576	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRLA3TNQRGORC	HC17677040655489OF	100.00	5.00	\N	Sudhir Singhji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5532443750", "txnid": "PINRLA3TNQRGORC", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695D060255AeC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695D060255AeC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695D060255AeC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695D060255AeC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_61695D060255AeC", "upi_tr": "pt_61695D060255AeC", "txnid": "ORDID5532443750", "orderid": "ORDID5532443750", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695D060255AeC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_61695D060255AeC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5532443750	f	2026-01-06 12:54:26.647548	2026-01-06 12:54:26.647552	\N	f	\N
501	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRFPVNQR803G6	HC17677037568131DJ	100.00	5.00	\N	Sudhir Goyalappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6509556125", "txnid": "PINRFPVNQR803G6", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d04cD96145&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d04cD96145&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d04cD96145&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d04cD96145&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_77695d04cD96145", "upi_tr": "pt_77695d04cD96145", "txnid": "ORDID6509556125", "orderid": "ORDID6509556125", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d04cD96145&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_77695d04cD96145&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6509556125	f	2026-01-06 12:49:17.88606	2026-01-06 12:49:17.886064	\N	f	\N
502	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNRD058MIJ3Y6	HC1767703757030B2R	100.00	5.00	\N	Vijay Gupta	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7927996862", "txnid": "PINNRD058MIJ3Y6", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D04cdd646e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D04cdd646e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D04cdd646e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D04cdd646e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_64695D04cdd646e", "upi_tr": "pt_64695D04cdd646e", "txnid": "ORDID7927996862", "orderid": "ORDID7927996862", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D04cdd646e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D04cdd646e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7927996862	f	2026-01-06 12:49:18.159715	2026-01-06 12:49:18.159719	\N	f	\N
500	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN41ZNG7HU9233	HC176770375090762C	100.00	5.00	\N	Arun Chatterjeeananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6722879116", "txnid": "PIN41ZNG7HU9233", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695D04c7A91A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695D04c7A91A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695D04c7A91A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695D04c7A91A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_39695D04c7A91A9", "upi_tr": "pt_39695D04c7A91A9", "txnid": "ORDID6722879116", "orderid": "ORDID6722879116", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6722879116", "rrn": "729441604511"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695D04c7A91A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_39695D04c7A91A9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6722879116	f	2026-01-06 12:49:11.961783	2026-01-06 12:49:55.636516	729441604511	t	2026-01-06 12:49:52.592574+00
504	3c70dd22-df28-4a50-a034-4a378507c5bf	PINXEMLXZY8Q50N	HC1767703758724QXJ	100.00	5.00	\N	Vivek Bhattacharyababu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1823401879", "txnid": "PINXEMLXZY8Q50N", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f4695d04cF84e87&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f4695d04cF84e87&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f4695d04cF84e87&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f4695d04cF84e87&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_f4695d04cF84e87", "upi_tr": "pt_f4695d04cF84e87", "txnid": "ORDID1823401879", "orderid": "ORDID1823401879", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f4695d04cF84e87&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_f4695d04cF84e87&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1823401879	f	2026-01-06 12:49:19.833751	2026-01-06 12:49:19.833755	\N	f	\N
494	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKMB0QEQAXDXE	HC1767703720714B9N	100.00	5.00	\N	Kiran Bhatiaish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5621183804", "txnid": "PINKMB0QEQAXDXE", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695D04a9832E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695D04a9832E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695D04a9832E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695D04a9832E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_7d695D04a9832E8", "upi_tr": "pt_7d695D04a9832E8", "txnid": "ORDID5621183804", "orderid": "ORDID5621183804", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5621183804", "rrn": "600685519084"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695D04a9832E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_7d695D04a9832E8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5621183804	f	2026-01-06 12:48:41.851023	2026-01-06 12:49:20.570218	600685519084	t	2026-01-06 12:49:16.538819+00
505	3c70dd22-df28-4a50-a034-4a378507c5bf	PINVW8QR7UWTNKU	HC1767703763716QS8	100.00	5.00	\N	Savita Goyalish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8680203817", "txnid": "PINVW8QR7UWTNKU", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8B695D04D480F33&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8B695D04D480F33&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8B695D04D480F33&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8B695D04D480F33&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8B695D04D480F33", "upi_tr": "pt_8B695D04D480F33", "txnid": "ORDID8680203817", "orderid": "ORDID8680203817", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8B695D04D480F33&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8B695D04D480F33&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8680203817	f	2026-01-06 12:49:24.836463	2026-01-06 12:49:24.836466	\N	f	\N
582	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2A8JY1YN1DF8	HC1767704103480H4M	100.00	5.00	\N	Anjali Duttaananda	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4581142518", "txnid": "PIN2A8JY1YN1DF8", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1d695d06284996b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1d695d06284996b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1d695d06284996b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1d695d06284996b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1d695d06284996b", "upi_tr": "pt_1d695d06284996b", "txnid": "ORDID4581142518", "orderid": "ORDID4581142518", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1d695d06284996b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1d695d06284996b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4581142518	f	2026-01-06 12:55:04.576221	2026-01-06 12:55:04.576223	\N	f	\N
488	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN7VNWOD83J53W	HC1767703706769GMZ	100.00	5.00	\N	Anil Mehta	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2483236884", "txnid": "PIN7VNWOD83J53W", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fc695D049B98F7b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fc695D049B98F7b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fc695D049B98F7b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fc695D049B98F7b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_fc695D049B98F7b", "upi_tr": "pt_fc695D049B98F7b", "txnid": "ORDID2483236884", "orderid": "ORDID2483236884", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2483236884", "rrn": "696914628642"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fc695D049B98F7b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_fc695D049B98F7b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2483236884	f	2026-01-06 12:48:27.894564	2026-01-06 12:49:30.59233	696914628642	t	2026-01-06 12:49:25.922048+00
769	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZVQ4JD99ENFZ	HC1767705234234VX1	100.00	5.00	\N	Rani Pillaikar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9327985930", "txnid": "PINZVQ4JD99ENFZ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695d0A92f01F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695d0A92f01F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695d0A92f01F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695d0A92f01F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_18695d0A92f01F2", "upi_tr": "pt_18695d0A92f01F2", "txnid": "ORDID9327985930", "orderid": "ORDID9327985930", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695d0A92f01F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_18695d0A92f01F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9327985930	f	2026-01-06 13:13:55.261967	2026-01-06 13:13:55.261971	\N	f	\N
510	3c70dd22-df28-4a50-a034-4a378507c5bf	PINAFBNGRAZDPZ9	HC17677037809703RQ	100.00	5.00	\N	Chitra Chatterjeeappa	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2718658790", "txnid": "PINAFBNGRAZDPZ9", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695D04E5C71f9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695D04E5C71f9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695D04E5C71f9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695D04E5C71f9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E5695D04E5C71f9", "upi_tr": "pt_E5695D04E5C71f9", "txnid": "ORDID2718658790", "orderid": "ORDID2718658790", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695D04E5C71f9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695D04E5C71f9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2718658790	f	2026-01-06 12:49:42.084811	2026-01-06 12:49:42.084816	\N	f	\N
512	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJBKENGSR4DMF	HC1767703791948KN8	100.00	5.00	\N	Chandan Malhotraram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID4234915993", "txnid": "PINJBKENGSR4DMF", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ea695D04f0BE47b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ea695D04f0BE47b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ea695D04f0BE47b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ea695D04f0BE47b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_ea695D04f0BE47b", "upi_tr": "pt_ea695D04f0BE47b", "txnid": "ORDID4234915993", "orderid": "ORDID4234915993", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ea695D04f0BE47b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ea695D04f0BE47b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4234915993	f	2026-01-06 12:49:53.042748	2026-01-06 12:49:53.042753	\N	f	\N
515	3c70dd22-df28-4a50-a034-4a378507c5bf	PINT0CY4PB5GVE5	HC17677037955289I6	100.00	5.00	\N	Anil Chauhanji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7368459344", "txnid": "PINT0CY4PB5GVE5", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_73695D04f45BFfF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_73695D04f45BFfF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_73695D04f45BFfF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_73695D04f45BFfF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_73695D04f45BFfF", "upi_tr": "pt_73695D04f45BFfF", "txnid": "ORDID7368459344", "orderid": "ORDID7368459344", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_73695D04f45BFfF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_73695D04f45BFfF&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7368459344	f	2026-01-06 12:49:56.6693	2026-01-06 12:49:56.669304	\N	f	\N
520	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIMCNZ4NM9IO8	HC1767703822201QB9	100.00	5.00	\N	Tanya Iyerram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7748045188", "txnid": "PINIMCNZ4NM9IO8", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D050F034d8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D050F034d8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D050F034d8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D050F034d8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_2b695D050F034d8", "upi_tr": "pt_2b695D050F034d8", "txnid": "ORDID7748045188", "orderid": "ORDID7748045188", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D050F034d8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_2b695D050F034d8&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7748045188	f	2026-01-06 12:50:23.31796	2026-01-06 12:50:23.317964	\N	f	\N
770	3c70dd22-df28-4a50-a034-4a378507c5bf	PINY15HW68L63AX	HC1767705253096E3O	100.00	5.00	\N	Geeta Chopraram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5485735825", "txnid": "PINY15HW68L63AX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695D0aA5cD3A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695D0aA5cD3A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695D0aA5cD3A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695D0aA5cD3A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_42695D0aA5cD3A3", "upi_tr": "pt_42695D0aA5cD3A3", "txnid": "ORDID5485735825", "orderid": "ORDID5485735825", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695D0aA5cD3A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_42695D0aA5cD3A3&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5485735825	f	2026-01-06 13:14:14.136254	2026-01-06 13:14:14.136258	\N	f	\N
571	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN6UQJDE8ZB4EN	HC1767704052005BCU	100.00	5.00	\N	Pooja Bhattacharyaananda	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2088020087", "txnid": "PIN6UQJDE8ZB4EN", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ab695d05f4cAa8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ab695d05f4cAa8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ab695d05f4cAa8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ab695d05f4cAa8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_ab695d05f4cAa8d", "upi_tr": "pt_ab695d05f4cAa8d", "txnid": "ORDID2088020087", "orderid": "ORDID2088020087", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2088020087", "rrn": "554978830012"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ab695d05f4cAa8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ab695d05f4cAa8d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2088020087	f	2026-01-06 12:54:13.113047	2026-01-06 12:54:46.283505	554978830012	t	2026-01-06 12:54:42.849375+00
513	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3993ZR47F3Y6	HC1767703792287YEC	100.00	5.00	\N	Vivek Shahendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9015110311", "txnid": "PIN3993ZR47F3Y6", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4c695D04F11062f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4c695D04F11062f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4c695D04F11062f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4c695D04F11062f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_4c695D04F11062f", "upi_tr": "pt_4c695D04F11062f", "txnid": "ORDID9015110311", "orderid": "ORDID9015110311", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4c695D04F11062f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_4c695D04F11062f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9015110311	f	2026-01-06 12:49:53.346422	2026-01-06 12:49:53.346425	\N	f	\N
507	3c70dd22-df28-4a50-a034-4a378507c5bf	PINU4718HQ8E4YX	HC17677037718744U0	100.00	5.00	\N	Asha Shahendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7948915996", "txnid": "PINU4718HQ8E4YX", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0e695D04DCa2b82&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0e695D04DCa2b82&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0e695D04DCa2b82&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0e695D04DCa2b82&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_0e695D04DCa2b82", "upi_tr": "pt_0e695D04DCa2b82", "txnid": "ORDID7948915996", "orderid": "ORDID7948915996", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7948915996", "rrn": "937298303995"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0e695D04DCa2b82&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_0e695D04DCa2b82&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7948915996	f	2026-01-06 12:49:32.945191	2026-01-06 12:50:20.751454	937298303995	t	2026-01-06 12:50:16.049195+00
580	3c70dd22-df28-4a50-a034-4a378507c5bf	PINJSVOUIC9Z99W	HC17677040977932I4	100.00	5.00	\N	Nikhil Dasesh	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5007274102", "txnid": "PINJSVOUIC9Z99W", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695D06228D1f6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695D06228D1f6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695D06228D1f6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695D06228D1f6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5D695D06228D1f6", "upi_tr": "pt_5D695D06228D1f6", "txnid": "ORDID5007274102", "orderid": "ORDID5007274102", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695D06228D1f6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5D695D06228D1f6&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5007274102	f	2026-01-06 12:54:58.844603	2026-01-06 12:54:58.844607	\N	f	\N
514	3c70dd22-df28-4a50-a034-4a378507c5bf	PINLS6E9T82SBHV	HC17677037934224E6	100.00	5.00	\N	Harish Sharmaram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7100613038", "txnid": "PINLS6E9T82SBHV", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04f2414Da&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04f2414Da&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04f2414Da&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04f2414Da&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Cd695d04f2414Da", "upi_tr": "pt_Cd695d04f2414Da", "txnid": "ORDID7100613038", "orderid": "ORDID7100613038", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04f2414Da&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Cd695d04f2414Da&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7100613038	f	2026-01-06 12:49:54.539187	2026-01-06 12:49:54.539192	\N	f	\N
509	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN4X5X6JSD0D2C	HC1767703773264ZCO	100.00	5.00	\N	Govind Joshiendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2136032230", "txnid": "PIN4X5X6JSD0D2C", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695d04de1AaE4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695d04de1AaE4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695d04de1AaE4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695d04de1AaE4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_55695d04de1AaE4", "upi_tr": "pt_55695d04de1AaE4", "txnid": "ORDID2136032230", "orderid": "ORDID2136032230", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2136032230", "rrn": "527226818632"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695d04de1AaE4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_55695d04de1AaE4&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2136032230	f	2026-01-06 12:49:34.387445	2026-01-06 12:50:00.683268	527226818632	t	2026-01-06 12:50:00.381351+00
517	3c70dd22-df28-4a50-a034-4a378507c5bf	PINWX3O24VYHXQT	HC17677038116060F4	100.00	5.00	\N	Priya Guptaji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2987136628", "txnid": "PINWX3O24VYHXQT", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ba695d05047050A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ba695d05047050A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ba695d05047050A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ba695d05047050A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_ba695d05047050A", "upi_tr": "pt_ba695d05047050A", "txnid": "ORDID2987136628", "orderid": "ORDID2987136628", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ba695d05047050A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_ba695d05047050A&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2987136628	f	2026-01-06 12:50:12.758349	2026-01-06 12:50:12.758353	\N	f	\N
581	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN2PXRKQM966EP	HC1767704100759ZCU	100.00	5.00	\N	Suresh Shahram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5966311745", "txnid": "PIN2PXRKQM966EP", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695D0625c16a1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695D0625c16a1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695D0625c16a1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695D0625c16a1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_86695D0625c16a1", "upi_tr": "pt_86695D0625c16a1", "txnid": "ORDID5966311745", "orderid": "ORDID5966311745", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695D0625c16a1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_86695D0625c16a1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5966311745	f	2026-01-06 12:55:02.075679	2026-01-06 12:55:02.075685	\N	f	\N
487	3c70dd22-df28-4a50-a034-4a378507c5bf	PINI7J726WEILM7	HC176770370316545U	100.00	5.00	\N	Ankita Kulkarniesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1938789901", "txnid": "PINI7J726WEILM7", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695d0497f024F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695d0497f024F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695d0497f024F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695d0497f024F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_68695d0497f024F", "upi_tr": "pt_68695d0497f024F", "txnid": "ORDID1938789901", "orderid": "ORDID1938789901", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1938789901", "rrn": "806238718379"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695d0497f024F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_68695d0497f024F&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1938789901	f	2026-01-06 12:48:24.263697	2026-01-06 12:49:55.654959	806238718379	t	2026-01-06 12:49:53.15318+00
496	3c70dd22-df28-4a50-a034-4a378507c5bf	PINODI25YUHM9UR	HC1767703735454Z8M	100.00	5.00	\N	Omkar Sharmaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID3075177448", "txnid": "PINODI25YUHM9UR", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d04B83daf9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d04B83daf9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d04B83daf9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d04B83daf9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d1695d04B83daf9", "upi_tr": "pt_d1695d04B83daf9", "txnid": "ORDID3075177448", "orderid": "ORDID3075177448", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID3075177448", "rrn": "696914693248"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d04B83daf9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d1695d04B83daf9&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3075177448	f	2026-01-06 12:48:56.543207	2026-01-06 12:50:10.712038	696914693248	t	2026-01-06 12:50:06.567819+00
508	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFC5R6P9B1UU8	HC176770377301919G	100.00	5.00	\N	Chitra Dwivedilal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID1900009150", "txnid": "PINFC5R6P9B1UU8", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695D04dDD2610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695D04dDD2610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695D04dDD2610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695D04dDD2610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_43695D04dDD2610", "upi_tr": "pt_43695D04dDD2610", "txnid": "ORDID1900009150", "orderid": "ORDID1900009150", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID1900009150", "rrn": "429627957162"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695D04dDD2610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_43695D04dDD2610&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1900009150	f	2026-01-06 12:49:34.150647	2026-01-06 12:50:15.731699	429627957162	t	2026-01-06 12:50:13.43586+00
506	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCH0TBRHFU8H2	HC176770376750670M	100.00	5.00	\N	Prakash Bhattacharyaram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4178304784", "txnid": "PINCH0TBRHFU8H2", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695D04d84Bb2E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695D04d84Bb2E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695D04d84Bb2E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695D04d84Bb2E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_66695D04d84Bb2E", "upi_tr": "pt_66695D04d84Bb2E", "txnid": "ORDID4178304784", "orderid": "ORDID4178304784", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4178304784", "rrn": "765249246220"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695D04d84Bb2E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_66695D04d84Bb2E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4178304784	f	2026-01-06 12:49:28.595504	2026-01-06 12:50:20.767537	765249246220	t	2026-01-06 12:50:17.559823+00
1144	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN3D2R7A0DPCJN	HC1767709157678CK6	100.00	5.00	\N	Kajal Choprakar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1182987713", "txnid": "PIN3D2R7A0DPCJN", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d19e6749d0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d19e6749d0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d19e6749d0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d19e6749d0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_44695d19e6749d0", "upi_tr": "pt_44695d19e6749d0", "txnid": "ORDID1182987713", "orderid": "ORDID1182987713", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d19e6749d0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_44695d19e6749d0&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1182987713	f	2026-01-06 14:19:18.767598	2026-01-06 14:19:18.767602	\N	f	\N
529	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZPVNP3O3WSHT	HC1767703868055NZM	100.00	5.00	\N	Asha Trivediji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6496940213", "txnid": "PINZPVNP3O3WSHT", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8b695d053CdEE8e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8b695d053CdEE8e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8b695d053CdEE8e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8b695d053CdEE8e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8b695d053CdEE8e", "upi_tr": "pt_8b695d053CdEE8e", "txnid": "ORDID6496940213", "orderid": "ORDID6496940213", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8b695d053CdEE8e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8b695d053CdEE8e&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6496940213	f	2026-01-06 12:51:09.226482	2026-01-06 12:51:09.226485	\N	f	\N
523	3c70dd22-df28-4a50-a034-4a378507c5bf	PINMV2L9RSX7QYU	HC1767703837594S9A	100.00	5.00	\N	Kajal Yadavnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID4182713676", "txnid": "PINMV2L9RSX7QYU", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d051E64Cab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d051E64Cab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d051E64Cab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d051E64Cab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_54695d051E64Cab", "upi_tr": "pt_54695d051E64Cab", "txnid": "ORDID4182713676", "orderid": "ORDID4182713676", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID4182713676", "rrn": "805502712169"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d051E64Cab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_54695d051E64Cab&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID4182713676	f	2026-01-06 12:50:38.716454	2026-01-06 12:51:10.863772	805502712169	t	2026-01-06 12:51:09.356452+00
534	3c70dd22-df28-4a50-a034-4a378507c5bf	PINEY3Q0DN9514N	HC1767703882254E4O	100.00	5.00	\N	Monika Pillaibabu	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7110286417", "txnid": "PINEY3Q0DN9514N", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dc695d054b112F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dc695d054b112F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dc695d054b112F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dc695d054b112F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_dc695d054b112F2", "upi_tr": "pt_dc695d054b112F2", "txnid": "ORDID7110286417", "orderid": "ORDID7110286417", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dc695d054b112F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_dc695d054b112F2&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7110286417	f	2026-01-06 12:51:23.349782	2026-01-06 12:51:23.349787	\N	f	\N
536	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKGOZT5TTGLGQ	HC17677038920612HD	100.00	5.00	\N	Pooja Goyalish	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9777685222", "txnid": "PINKGOZT5TTGLGQ", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d0554e4592&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d0554e4592&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d0554e4592&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d0554e4592&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_52695d0554e4592", "upi_tr": "pt_52695d0554e4592", "txnid": "ORDID9777685222", "orderid": "ORDID9777685222", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d0554e4592&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_52695d0554e4592&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9777685222	f	2026-01-06 12:51:33.227205	2026-01-06 12:51:33.227209	\N	f	\N
1686	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN82XGXAXSIGGU	HC1767709519500TWN	100.00	5.00	\N	Mohan Dubeyji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7565891226", "txnid": "PIN82XGXAXSIGGU", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695D1B5034885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695D1B5034885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695D1B5034885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695D1B5034885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_09695D1B5034885", "upi_tr": "pt_09695D1B5034885", "txnid": "ORDID7565891226", "orderid": "ORDID7565891226", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695D1B5034885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_09695D1B5034885&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7565891226	f	2026-01-06 14:25:20.470159	2026-01-06 14:25:20.470163	\N	f	\N
525	3c70dd22-df28-4a50-a034-4a378507c5bf	PINUF08TUMARW20	HC1767703847175YVG	100.00	5.00	\N	Amit Guptakar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8277124525", "txnid": "PINUF08TUMARW20", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695D05280134E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695D05280134E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695D05280134E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695D05280134E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_85695D05280134E", "upi_tr": "pt_85695D05280134E", "txnid": "ORDID8277124525", "orderid": "ORDID8277124525", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695D05280134E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_85695D05280134E&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8277124525	f	2026-01-06 12:50:48.292282	2026-01-06 12:50:48.292286	\N	f	\N
528	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBNV0M51YZEPX	HC1767703864839M6G	100.00	5.00	\N	Tanvi Kulkarni	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7278004199", "txnid": "PINBNV0M51YZEPX", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D05399F739&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D05399F739&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D05399F739&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D05399F739&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_30695D05399F739", "upi_tr": "pt_30695D05399F739", "txnid": "ORDID7278004199", "orderid": "ORDID7278004199", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D05399F739&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D05399F739&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7278004199	f	2026-01-06 12:51:05.928212	2026-01-06 12:51:05.928217	\N	f	\N
522	3c70dd22-df28-4a50-a034-4a378507c5bf	PINV8UOQKONU1FC	HC1767703828343G6W	100.00	5.00	\N	Anjali Dasish	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7967095765", "txnid": "PINV8UOQKONU1FC", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d0695D05152Fd9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d0695D05152Fd9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d0695D05152Fd9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d0695D05152Fd9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_d0695D05152Fd9b", "upi_tr": "pt_d0695D05152Fd9b", "txnid": "ORDID7967095765", "orderid": "ORDID7967095765", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7967095765", "rrn": "850957359796"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d0695D05152Fd9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_d0695D05152Fd9b&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7967095765	f	2026-01-06 12:50:29.515589	2026-01-06 12:51:20.928775	850957359796	t	2026-01-06 12:51:19.117102+00
535	3c70dd22-df28-4a50-a034-4a378507c5bf	PINZLQJMJUI7WI7	HC1767703882463X5Z	100.00	5.00	\N	Omkar Guptaendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID5708143546", "txnid": "PINZLQJMJUI7WI7", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695d054b4f376&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695d054b4f376&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695d054b4f376&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695d054b4f376&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_3c695d054b4f376", "upi_tr": "pt_3c695d054b4f376", "txnid": "ORDID5708143546", "orderid": "ORDID5708143546", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695d054b4f376&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_3c695d054b4f376&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5708143546	f	2026-01-06 12:51:23.613685	2026-01-06 12:51:23.613688	\N	f	\N
511	3c70dd22-df28-4a50-a034-4a378507c5bf	PINIWXCA7CB6SGT	HC1767703791242FSL	100.00	5.00	\N	Ankita Bhatiaji	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8517754894", "txnid": "PINIWXCA7CB6SGT", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ba695D04F010016&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ba695D04F010016&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ba695D04F010016&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ba695D04F010016&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_Ba695D04F010016", "upi_tr": "pt_Ba695D04F010016", "txnid": "ORDID8517754894", "orderid": "ORDID8517754894", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8517754894", "rrn": "242478588138"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ba695D04F010016&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_Ba695D04F010016&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8517754894	f	2026-01-06 12:49:52.337452	2026-01-06 12:50:30.795246	242478588138	t	2026-01-06 12:50:25.814646+00
503	3c70dd22-df28-4a50-a034-4a378507c5bf	PINRJ87YKF2A12D	HC1767703758336W71	100.00	5.00	\N	Kumar Malhotrakar	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID8477439122", "txnid": "PINRJ87YKF2A12D", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695d04cf2C209&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695d04cf2C209&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695d04cf2C209&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695d04cf2C209&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_49695d04cf2C209", "upi_tr": "pt_49695d04cf2C209", "txnid": "ORDID8477439122", "orderid": "ORDID8477439122", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID8477439122", "rrn": "600685549847"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695d04cf2C209&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_49695d04cf2C209&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8477439122	f	2026-01-06 12:49:19.471626	2026-01-06 12:50:40.816377	600685549847	t	2026-01-06 12:50:37.594781+00
516	3c70dd22-df28-4a50-a034-4a378507c5bf	PINOXNLFVPA6ITF	HC1767703810111GBN	100.00	5.00	\N	Vaishali Shahram	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9076678301", "txnid": "PINOXNLFVPA6ITF", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D0502e8BB1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D0502e8BB1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D0502e8BB1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D0502e8BB1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_30695D0502e8BB1", "upi_tr": "pt_30695D0502e8BB1", "txnid": "ORDID9076678301", "orderid": "ORDID9076678301", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID9076678301", "rrn": "116778498950"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D0502e8BB1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_30695D0502e8BB1&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9076678301	f	2026-01-06 12:50:11.246879	2026-01-06 12:51:05.845366	116778498950	t	2026-01-06 12:51:01.126206+00
519	3c70dd22-df28-4a50-a034-4a378507c5bf	PINKGOLXGWDYG19	HC1767703819721M7Q	100.00	5.00	\N	Swati Guptalal	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID2539948373", "txnid": "PINKGOLXGWDYG19", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695D050c8891d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695D050c8891d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695D050c8891d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695D050c8891d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_79695D050c8891d", "upi_tr": "pt_79695D050c8891d", "txnid": "ORDID2539948373", "orderid": "ORDID2539948373", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID2539948373", "rrn": "924449235166"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695D050c8891d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695D050c8891d&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2539948373	f	2026-01-06 12:50:20.842739	2026-01-06 12:51:10.875723	924449235166	t	2026-01-06 12:51:09.909887+00
524	3c70dd22-df28-4a50-a034-4a378507c5bf	PINI6063SU46C6W	HC17677038435972IE	100.00	5.00	\N	Anjali Banerjeeendra	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID2772982080", "txnid": "PINI6063SU46C6W", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_40695D05246ECCA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_40695D05246ECCA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_40695D05246ECCA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_40695D05246ECCA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_40695D05246ECCA", "upi_tr": "pt_40695D05246ECCA", "txnid": "ORDID2772982080", "orderid": "ORDID2772982080", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_40695D05246ECCA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_40695D05246ECCA&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID2772982080	f	2026-01-06 12:50:44.758433	2026-01-06 12:50:44.758436	\N	f	\N
584	3c70dd22-df28-4a50-a034-4a378507c5bf	PINW252EVEABW4R	HC17677041097708KC	100.00	5.00	\N	Chitra Yadavji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8292243953", "txnid": "PINW252EVEABW4R", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5C695D062E9Bb9f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5C695D062E9Bb9f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5C695D062E9Bb9f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5C695D062E9Bb9f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_5C695D062E9Bb9f", "upi_tr": "pt_5C695D062E9Bb9f", "txnid": "ORDID8292243953", "orderid": "ORDID8292243953", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5C695D062E9Bb9f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_5C695D062E9Bb9f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8292243953	f	2026-01-06 12:55:10.916631	2026-01-06 12:55:10.916635	\N	f	\N
527	3c70dd22-df28-4a50-a034-4a378507c5bf	PINQB9XJXPN1W55	HC1767703855974KKL	100.00	5.00	\N	Mohan Chandrasekar	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9569050463", "txnid": "PINQB9XJXPN1W55", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695d0530bD11D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695d0530bD11D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695d0530bD11D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695d0530bD11D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_E5695d0530bD11D", "upi_tr": "pt_E5695d0530bD11D", "txnid": "ORDID9569050463", "orderid": "ORDID9569050463", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695d0530bD11D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_E5695d0530bD11D&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9569050463	f	2026-01-06 12:50:57.047115	2026-01-06 12:50:57.04712	\N	f	\N
530	3c70dd22-df28-4a50-a034-4a378507c5bf	PINA6BNT0MEKNTS	HC1767703874373G1C	100.00	5.00	\N	Geeta Dubeyrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID1597725993", "txnid": "PINA6BNT0MEKNTS", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695d05432bCAd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695d05432bCAd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695d05432bCAd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695d05432bCAd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_79695d05432bCAd", "upi_tr": "pt_79695d05432bCAd", "txnid": "ORDID1597725993", "orderid": "ORDID1597725993", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695d05432bCAd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_79695d05432bCAd&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID1597725993	f	2026-01-06 12:51:15.456148	2026-01-06 12:51:15.456152	\N	f	\N
533	3c70dd22-df28-4a50-a034-4a378507c5bf	PINBL3BWMAEWQWE	HC1767703881569DG8	100.00	5.00	\N	Pooja Jainrao	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID8535561585", "txnid": "PINBL3BWMAEWQWE", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D054A65f05&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D054A65f05&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D054A65f05&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D054A65f05&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_64695D054A65f05", "upi_tr": "pt_64695D054A65f05", "txnid": "ORDID8535561585", "orderid": "ORDID8535561585", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D054A65f05&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_64695D054A65f05&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID8535561585	f	2026-01-06 12:51:22.684535	2026-01-06 12:51:22.684544	\N	f	\N
521	3c70dd22-df28-4a50-a034-4a378507c5bf	PINNNOPFGOUYKYX	HC17677038241212AK	100.00	5.00	\N	Ganesh Menonendra	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID5932044980", "txnid": "PINNNOPFGOUYKYX", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_15695D0510E8a91&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_15695D0510E8a91&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_15695D0510E8a91&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_15695D0510E8a91&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_15695D0510E8a91", "upi_tr": "pt_15695D0510E8a91", "txnid": "ORDID5932044980", "orderid": "ORDID5932044980", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID5932044980", "rrn": "750141416113"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_15695D0510E8a91&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_15695D0510E8a91&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID5932044980	f	2026-01-06 12:50:25.232975	2026-01-06 12:51:15.892236	750141416113	t	2026-01-06 12:51:11.854106+00
518	3c70dd22-df28-4a50-a034-4a378507c5bf	PINCC1WVHOF0LSX	HC1767703817379OFG	100.00	5.00	\N	Manisha Mehtarao	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID6606621630", "txnid": "PINCC1WVHOF0LSX", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cf695d050A31bbC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cf695d050A31bbC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cf695d050A31bbC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cf695d050A31bbC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_cf695d050A31bbC", "upi_tr": "pt_cf695d050A31bbC", "txnid": "ORDID6606621630", "orderid": "ORDID6606621630", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID6606621630", "rrn": "410632141563"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cf695d050A31bbC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_cf695d050A31bbC&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6606621630	f	2026-01-06 12:50:18.495409	2026-01-06 12:51:20.910461	410632141563	t	2026-01-06 12:51:18.588783+00
532	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN51ENDFURTXKE	HC1767703878836UKY	100.00	5.00	\N	Shankar Menonnath	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID7969870248", "txnid": "PIN51ENDFURTXKE", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DF695D0547A5A43&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DF695D0547A5A43&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DF695D0547A5A43&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DF695D0547A5A43&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_DF695D0547A5A43", "upi_tr": "pt_DF695D0547A5A43", "txnid": "ORDID7969870248", "orderid": "ORDID7969870248", "bankutr": "pending"}, "webhook_received": true, "orderId": "ORDID7969870248", "rrn": "120993636114"}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DF695D0547A5A43&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_DF695D0547A5A43&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7969870248	f	2026-01-06 12:51:19.937076	2026-01-06 12:51:55.996446	120993636114	t	2026-01-06 12:51:53.655939+00
585	3c70dd22-df28-4a50-a034-4a378507c5bf	PINU8FGA4RGPSKU	HC1767704111863QK6	100.00	5.00	\N	Sunita Dasnath	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID9648106569", "txnid": "PINU8FGA4RGPSKU", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d0630A92C7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d0630A92C7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d0630A92C7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d0630A92C7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_1E695d0630A92C7", "upi_tr": "pt_1E695d0630A92C7", "txnid": "ORDID9648106569", "orderid": "ORDID9648106569", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d0630A92C7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_1E695d0630A92C7&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID9648106569	f	2026-01-06 12:55:12.980645	2026-01-06 12:55:12.980649	\N	f	\N
537	3c70dd22-df28-4a50-a034-4a378507c5bf	PINFCCSY874JUPV	HC1767703897724RAR	100.00	5.00	\N	Sudhir Guptaram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID6878657284", "txnid": "PINFCCSY874JUPV", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695d055a7c036&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695d055a7c036&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695d055a7c036&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695d055a7c036&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_38695d055a7c036", "upi_tr": "pt_38695d055a7c036", "txnid": "ORDID6878657284", "orderid": "ORDID6878657284", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695d055a7c036&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_38695d055a7c036&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID6878657284	f	2026-01-06 12:51:38.769942	2026-01-06 12:51:38.769945	\N	f	\N
772	3c70dd22-df28-4a50-a034-4a378507c5bf	PINF0N53M344EED	HC1767705262961ENK	100.00	5.00	\N	Nandini Mishraji	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID3782111146", "txnid": "PINF0N53M344EED", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695D0aAFB156C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695D0aAFB156C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695D0aAFB156C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695D0aAFB156C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_8D695D0aAFB156C", "upi_tr": "pt_8D695D0aAFB156C", "txnid": "ORDID3782111146", "orderid": "ORDID3782111146", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695D0aAFB156C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_8D695D0aAFB156C&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID3782111146	f	2026-01-06 13:14:24.010959	2026-01-06 13:14:24.010963	\N	f	\N
587	3c70dd22-df28-4a50-a034-4a378507c5bf	PIN29XDEVPEPTM8	HC1767704136619TMJ	100.00	5.00	\N	Deepak Iyerram	pending	{"status": "success", "message": "Transaction Successfull", "reference_id": "ORDID7576077928", "txnid": "PIN29XDEVPEPTM8", "amount": "100.00", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e9695D06496E35f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e9695D06496E35f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "raw_response": {"statuscode": "TXN", "message": "Transaction Successfull", "upi_string": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e9695D06496E35f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e9695D06496E35f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "apitxnid": "pt_e9695D06496E35f", "upi_tr": "pt_e9695D06496E35f", "txnid": "ORDID7576077928", "orderid": "ORDID7576077928", "bankutr": "pending"}}	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e9695D06496E35f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_e9695D06496E35f&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372	unitpay	ORDID7576077928	f	2026-01-06 12:55:37.733393	2026-01-06 12:55:37.733397	\N	f	\N
526	3c70dd22-df28-4a50-a034-4a378507c5bf	PINAYHLIPFC5BO4	HC1767703847826A0O	100.00	5.00	\N	Amit Mishraesh	success	{"status": "SUCCESS", "message": "Transaction Successfull", "reference_id": "ORDID9375260536", "txnid": "PINAYHLIPFC5BO4", "amount": "100", "payment_url": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695D05289aA77&am=100.00&cu=INR&tn=UPI%20Intent%20Transaction&mc=7372", "qr_text": "upi://pay?pa=open9420234283635@yesbank&pn=NEXJEUX%20STUDIOS%20PRIVATE%20LIMITED&tr=int_pt_24695D05289aA77&am=100.00&cu=INR&tn=UPI%20Intent%20Tran