#!/bin/bash

# Nginx Setup Script for api.gompay.in (with Cloudflare)
# This script sets up Nginx reverse proxy for the FastAPI application

set -e

echo "=================================="
echo "Nginx Setup for api.gompay.in"
echo "=================================="

# Check if running as root or with sudo
if [ "$EUID" -ne 0 ]; then 
    echo "Please run this script with sudo"
    exit 1
fi

# Check if Nginx is installed
if ! command -v nginx &> /dev/null; then
    echo "Nginx is not installed. Installing..."
    apt-get update
    apt-get install -y nginx
else
    echo "Nginx is already installed"
fi

# Copy Nginx configuration
echo "Setting up Nginx configuration..."
cp /home/ubuntu/projects/fintech/nginx.conf /etc/nginx/sites-available/api.gompay.in

# Remove default site if it exists
if [ -L /etc/nginx/sites-enabled/default ]; then
    echo "Removing default Nginx site..."
    rm /etc/nginx/sites-enabled/default
fi

# Enable the site
if [ ! -L /etc/nginx/sites-enabled/api.gompay.in ]; then
    ln -s /etc/nginx/sites-available/api.gompay.in /etc/nginx/sites-enabled/
    echo "Site configuration enabled"
else
    echo "Site is already enabled"
fi

# Test Nginx configuration
echo "Testing Nginx configuration..."
nginx -t

# Restart Nginx
echo "Restarting Nginx..."
systemctl restart nginx
systemctl enable nginx

echo ""
echo "=================================="
echo "Nginx Setup Complete!"
echo "=================================="
echo ""
echo "Next steps:"
echo "1. Make sure your FastAPI app is running on port 8002"
echo "2. Configure Cloudflare DNS to point api.gompay.in to this server's IP"
echo "3. Set Cloudflare SSL/TLS mode to 'Flexible' or 'Full'"
echo "4. Test the setup by visiting: http://api.gompay.in/health"
echo ""

